#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup, find_packages
import os
import re
import subprocess

name = 'pylacrosse'
version_py = os.path.join(os.path.dirname(__file__), name, 'version.py')
try:
    version = subprocess.check_output(
            ['git', 'describe', '--tags', '--always', '--dirty'],
            stderr=subprocess.STDOUT).rstrip().decode('ascii')
    with open(version_py, 'w') as f:
        f.write('# This file was autogenerated by setup.py\n')
        f.write('__version__ = \'%s\'\n' % (version,))
except (OSError, subprocess.CalledProcessError, IOError) as e:
    try:
        with open(version_py, 'r') as f:
            for line in f.readlines():
                val = re.findall("__version__ = '([^']+)'", line)
            version = val[0]
    except IOError:
        version = 'unknown'

with open('README.rst') as f:
    readme = f.read()

setup(name = name,
        version = version,
        description = 'LaCrosse sensor library',
        long_description = readme,
        author = 'Heiko Thiery',
        author_email = 'heiko.thiery@gmail.com',
        packages = find_packages(),
        url = 'http://github.com/hthiery/python-lacrosse',
        license = 'LGPLv2+',
        classifiers = [
            'Development Status :: 3 - Alpha',
            'Environment :: Console',
            'License :: OSI Approved :: GNU Lesser General Public License v2 or later (LGPLv2+)',
            'Natural Language :: English',
            'Operating System :: OS Independent',
            'Programming Language :: Python :: 2',
            'Programming Language :: Python :: 2.7',
            'Programming Language :: Python :: 3',
            'Programming Language :: Python :: 3.4',
            'Programming Language :: Python :: 3.5',
            'Topic :: Software Development :: Libraries :: Python Modules',
        ],
        entry_points = {
            'console_scripts': [
                'pylacrosse= pylacrosse.cli_tool:main',
            ]
        },
        test_suite = 'tests',
        include_package_data = True,
        install_requires=['pyserial'],
)
