"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlpsGraphQL = void 0;
// import { join } from 'path';
const fs = require("fs");
const appsync = require("@aws-cdk/aws-appsync");
const cdk = require("@aws-cdk/core");
const alps_unified_ts_1 = require("alps-unified-ts");
/**
 * @stability stable
 */
class AlpsGraphQL extends appsync.GraphqlApi {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        // convert ALPS yaml to graph ql schema file in tmp/schema.graphql
        const sdl = alps_unified_ts_1.Alps.unified(alps_unified_ts_1.Alps.loadYaml(props.alpsSpecFile), { formatType: alps_unified_ts_1.FormatType.SDL });
        fs.writeFileSync('tmp/schema.graphql', sdl);
        super(scope, id, {
            ...props,
            schema: appsync.Schema.fromAsset('tmp/schema.graphql'),
        });
        new cdk.CfnOutput(this, 'GraphQlUrl', { value: this.graphqlUrl });
    }
}
exports.AlpsGraphQL = AlpsGraphQL;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBQy9CLHlCQUF5QjtBQUN6QixnREFBZ0Q7QUFDaEQscUNBQXFDO0FBQ3JDLHFEQUFtRDs7OztBQVFuRCxNQUFhLFdBQVksU0FBUSxPQUFPLENBQUMsVUFBVTs7OztJQUVqRCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQ25FLGtFQUFrRTtRQUNsRSxNQUFNLEdBQUcsR0FBRyxzQkFBSSxDQUFDLE9BQU8sQ0FBQyxzQkFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEVBQUUsRUFBRSxVQUFVLEVBQUUsNEJBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1FBQzVGLEVBQUUsQ0FBQyxhQUFhLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDNUMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixHQUFHLEtBQUs7WUFDUixNQUFNLEVBQUUsT0FBTyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsb0JBQW9CLENBQUM7U0FDdkQsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7SUFDcEUsQ0FBQztDQUNGO0FBYkQsa0NBYUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBpbXBvcnQgeyBqb2luIH0gZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgKiBhcyBhcHBzeW5jIGZyb20gJ0Bhd3MtY2RrL2F3cy1hcHBzeW5jJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEFscHMsIEZvcm1hdFR5cGUgfSBmcm9tICdhbHBzLXVuaWZpZWQtdHMnO1xuZXhwb3J0IGludGVyZmFjZSBBbHBzR3JhcGhRTFByb3BzIGV4dGVuZHMgYXBwc3luYy5HcmFwaHFsQXBpUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhbHBzU3BlY0ZpbGU6IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIEFscHNHcmFwaFFMIGV4dGVuZHMgYXBwc3luYy5HcmFwaHFsQXBpIHtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFscHNHcmFwaFFMUHJvcHMpIHtcbiAgICAvLyBjb252ZXJ0IEFMUFMgeWFtbCB0byBncmFwaCBxbCBzY2hlbWEgZmlsZSBpbiB0bXAvc2NoZW1hLmdyYXBocWxcbiAgICBjb25zdCBzZGwgPSBBbHBzLnVuaWZpZWQoQWxwcy5sb2FkWWFtbChwcm9wcy5hbHBzU3BlY0ZpbGUpLCB7IGZvcm1hdFR5cGU6IEZvcm1hdFR5cGUuU0RMIH0pO1xuICAgIGZzLndyaXRlRmlsZVN5bmMoJ3RtcC9zY2hlbWEuZ3JhcGhxbCcsIHNkbCk7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHNjaGVtYTogYXBwc3luYy5TY2hlbWEuZnJvbUFzc2V0KCd0bXAvc2NoZW1hLmdyYXBocWwnKSxcbiAgICB9KTtcblxuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsICdHcmFwaFFsVXJsJywgeyB2YWx1ZTogdGhpcy5ncmFwaHFsVXJsIH0pO1xuICB9XG59Il19