# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SamlArgs', 'Saml']

@pulumi.input_type
class SamlArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 acs_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 assertion_signed: Optional[pulumi.Input[bool]] = None,
                 attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authn_context_class_ref: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 default_relay_state: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 digest_algorithm: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 honor_force_authn: Optional[pulumi.Input[bool]] = None,
                 idp_issuer: Optional[pulumi.Input[str]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 inline_hook_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_years_valid: Optional[pulumi.Input[int]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 request_compressed: Optional[pulumi.Input[bool]] = None,
                 response_signed: Optional[pulumi.Input[bool]] = None,
                 saml_version: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 single_logout_certificate: Optional[pulumi.Input[str]] = None,
                 single_logout_issuer: Optional[pulumi.Input[str]] = None,
                 single_logout_url: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 sp_issuer: Optional[pulumi.Input[str]] = None,
                 sso_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_name_id_format: Optional[pulumi.Input[str]] = None,
                 subject_name_id_template: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]] = None):
        """
        The set of arguments for constructing a Saml resource.
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page for this application.
        :param pulumi.Input[bool] accessibility_self_service: Enable self-service. Default is: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acs_endpoints: An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar. Default is: `false`
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled. Notice: you can't currently configure provisioning features via the API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application.
               - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app. Default is: `false`
        :param pulumi.Input[bool] hide_web: Do not display application icon to users. Default is: `false`
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it. Default is: `false`
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        :param pulumi.Input[str] inline_hook_id: Saml Inline Hook associated with the application.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid (2 - 10 years).
        :param pulumi.Input[str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.  
               If not provided the following arguments are required:
               - `sso_url`
               - `recipient`
               - `destination`
               - `audience`
               - `subject_name_id_template`
               - `subject_name_id_format`
               - `signature_algorithm`
               - `digest_algorithm`
               - `authn_context_class_ref`
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] saml_version: SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] single_logout_certificate: x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
               Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        :param pulumi.Input[str] single_logout_issuer: The issuer of the Service Provider that generates the Single Logout request.
        :param pulumi.Input[str] single_logout_url: The location where the logout response is sent.
        :param pulumi.Input[bool] skip_groups: Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[bool] skip_users: Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign-on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template. Default is: `"${source.login}"`
        :param pulumi.Input[str] user_name_template_push_status: Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type. Default is: `"BUILT_IN"`.
        :param pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]] users: Users associated with the application.
               - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        pulumi.set(__self__, "label", label)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if acs_endpoints is not None:
            pulumi.set(__self__, "acs_endpoints", acs_endpoints)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if app_settings_json is not None:
            pulumi.set(__self__, "app_settings_json", app_settings_json)
        if assertion_signed is not None:
            pulumi.set(__self__, "assertion_signed", assertion_signed)
        if attribute_statements is not None:
            pulumi.set(__self__, "attribute_statements", attribute_statements)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if default_relay_state is not None:
            pulumi.set(__self__, "default_relay_state", default_relay_state)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if honor_force_authn is not None:
            pulumi.set(__self__, "honor_force_authn", honor_force_authn)
        if idp_issuer is not None:
            pulumi.set(__self__, "idp_issuer", idp_issuer)
        if implicit_assignment is not None:
            pulumi.set(__self__, "implicit_assignment", implicit_assignment)
        if inline_hook_id is not None:
            pulumi.set(__self__, "inline_hook_id", inline_hook_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_years_valid is not None:
            pulumi.set(__self__, "key_years_valid", key_years_valid)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if preconfigured_app is not None:
            pulumi.set(__self__, "preconfigured_app", preconfigured_app)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if request_compressed is not None:
            pulumi.set(__self__, "request_compressed", request_compressed)
        if response_signed is not None:
            pulumi.set(__self__, "response_signed", response_signed)
        if saml_version is not None:
            pulumi.set(__self__, "saml_version", saml_version)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if single_logout_certificate is not None:
            pulumi.set(__self__, "single_logout_certificate", single_logout_certificate)
        if single_logout_issuer is not None:
            pulumi.set(__self__, "single_logout_issuer", single_logout_issuer)
        if single_logout_url is not None:
            pulumi.set(__self__, "single_logout_url", single_logout_url)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if sp_issuer is not None:
            pulumi.set(__self__, "sp_issuer", sp_issuer)
        if sso_url is not None:
            pulumi.set(__self__, "sso_url", sso_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_name_id_format is not None:
            pulumi.set(__self__, "subject_name_id_format", subject_name_id_format)
        if subject_name_id_template is not None:
            pulumi.set(__self__, "subject_name_id_template", subject_name_id_template)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        label of application.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL.
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page for this application.
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self-service. Default is: `false`.
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="acsEndpoints")
    def acs_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        """
        return pulumi.get(self, "acs_endpoints")

    @acs_endpoints.setter
    def acs_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acs_endpoints", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "app_settings_json")

    @app_settings_json.setter
    def app_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_settings_json", value)

    @property
    @pulumi.getter(name="assertionSigned")
    def assertion_signed(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the SAML assertion is digitally signed.
        """
        return pulumi.get(self, "assertion_signed")

    @assertion_signed.setter
    def assertion_signed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assertion_signed", value)

    @property
    @pulumi.getter(name="attributeStatements")
    def attribute_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]]:
        """
        List of SAML Attribute statements.
        """
        return pulumi.get(self, "attribute_statements")

    @attribute_statements.setter
    def attribute_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]]):
        pulumi.set(self, "attribute_statements", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience restriction.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the SAML authentication context class for the assertion’s authentication statement.
        """
        return pulumi.get(self, "authn_context_class_ref")

    @authn_context_class_ref.setter
    def authn_context_class_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_context_class_ref", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar. Default is: `false`
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter(name="defaultRelayState")
    def default_relay_state(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies a specific application resource in an IDP initiated SSO scenario.
        """
        return pulumi.get(self, "default_relay_state")

    @default_relay_state.setter
    def default_relay_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_relay_state", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the digest algorithm used to digitally sign the SAML assertion and response.
        """
        return pulumi.get(self, "digest_algorithm")

    @digest_algorithm.setter
    def digest_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digest_algorithm", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        features enabled. Notice: you can't currently configure provisioning features via the API.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application.
        - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app. Default is: `false`
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users. Default is: `false`
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter(name="honorForceAuthn")
    def honor_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        Prompt user to re-authenticate if SP asks for it. Default is: `false`
        """
        return pulumi.get(self, "honor_force_authn")

    @honor_force_authn.setter
    def honor_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "honor_force_authn", value)

    @property
    @pulumi.getter(name="idpIssuer")
    def idp_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        SAML issuer ID.
        """
        return pulumi.get(self, "idp_issuer")

    @idp_issuer.setter
    def idp_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_issuer", value)

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> Optional[pulumi.Input[bool]]:
        """
        *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        """
        return pulumi.get(self, "implicit_assignment")

    @implicit_assignment.setter
    def implicit_assignment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_assignment", value)

    @property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> Optional[pulumi.Input[str]]:
        """
        Saml Inline Hook associated with the application.
        """
        return pulumi.get(self, "inline_hook_id")

    @inline_hook_id.setter
    def inline_hook_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inline_hook_id", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyYearsValid")
    def key_years_valid(self) -> Optional[pulumi.Input[int]]:
        """
        Number of years the certificate is valid (2 - 10 years).
        """
        return pulumi.get(self, "key_years_valid")

    @key_years_valid.setter
    def key_years_valid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_years_valid", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="preconfiguredApp")
    def preconfigured_app(self) -> Optional[pulumi.Input[str]]:
        """
        name of application from the Okta Integration Network, if not included a custom app will be created.  
        If not provided the following arguments are required:
        - `sso_url`
        - `recipient`
        - `destination`
        - `audience`
        - `subject_name_id_template`
        - `subject_name_id_format`
        - `signature_algorithm`
        - `digest_algorithm`
        - `authn_context_class_ref`
        """
        return pulumi.get(self, "preconfigured_app")

    @preconfigured_app.setter
    def preconfigured_app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preconfigured_app", value)

    @property
    @pulumi.getter
    def recipient(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the app may present the SAML assertion.
        """
        return pulumi.get(self, "recipient")

    @recipient.setter
    def recipient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipient", value)

    @property
    @pulumi.getter(name="requestCompressed")
    def request_compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether the request is compressed or not.
        """
        return pulumi.get(self, "request_compressed")

    @request_compressed.setter
    def request_compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_compressed", value)

    @property
    @pulumi.getter(name="responseSigned")
    def response_signed(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the SAML auth response message is digitally signed.
        """
        return pulumi.get(self, "response_signed")

    @response_signed.setter
    def response_signed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "response_signed", value)

    @property
    @pulumi.getter(name="samlVersion")
    def saml_version(self) -> Optional[pulumi.Input[str]]:
        """
        SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        """
        return pulumi.get(self, "saml_version")

    @saml_version.setter
    def saml_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml_version", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Signature algorithm used ot digitally sign the assertion and response.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)

    @property
    @pulumi.getter(name="singleLogoutCertificate")
    def single_logout_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
        Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        """
        return pulumi.get(self, "single_logout_certificate")

    @single_logout_certificate.setter
    def single_logout_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_certificate", value)

    @property
    @pulumi.getter(name="singleLogoutIssuer")
    def single_logout_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Provider that generates the Single Logout request.
        """
        return pulumi.get(self, "single_logout_issuer")

    @single_logout_issuer.setter
    def single_logout_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_issuer", value)

    @property
    @pulumi.getter(name="singleLogoutUrl")
    def single_logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the logout response is sent.
        """
        return pulumi.get(self, "single_logout_url")

    @single_logout_url.setter
    def single_logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_url", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter(name="spIssuer")
    def sp_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        SAML service provider issuer.
        """
        return pulumi.get(self, "sp_issuer")

    @sp_issuer.setter
    def sp_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sp_issuer", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> Optional[pulumi.Input[str]]:
        """
        Single Sign-on Url.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectNameIdFormat")
    def subject_name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the SAML processing rules.
        """
        return pulumi.get(self, "subject_name_id_format")

    @subject_name_id_format.setter
    def subject_name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_name_id_format", value)

    @property
    @pulumi.getter(name="subjectNameIdTemplate")
    def subject_name_id_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for app user's username when a user is assigned to the app.
        """
        return pulumi.get(self, "subject_name_id_template")

    @subject_name_id_template.setter
    def subject_name_id_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_name_id_template", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template. Default is: `"${source.login}"`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix.
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type. Default is: `"BUILT_IN"`.
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]]:
        """
        Users associated with the application.
        - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _SamlState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 acs_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 assertion_signed: Optional[pulumi.Input[bool]] = None,
                 attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authn_context_class_ref: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 default_relay_state: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 digest_algorithm: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 entity_key: Optional[pulumi.Input[str]] = None,
                 entity_url: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 honor_force_authn: Optional[pulumi.Input[bool]] = None,
                 http_post_binding: Optional[pulumi.Input[str]] = None,
                 http_redirect_binding: Optional[pulumi.Input[str]] = None,
                 idp_issuer: Optional[pulumi.Input[str]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 inline_hook_id: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_years_valid: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 logo_url: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 metadata_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 request_compressed: Optional[pulumi.Input[bool]] = None,
                 response_signed: Optional[pulumi.Input[bool]] = None,
                 saml_version: Optional[pulumi.Input[str]] = None,
                 sign_on_mode: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 single_logout_certificate: Optional[pulumi.Input[str]] = None,
                 single_logout_issuer: Optional[pulumi.Input[str]] = None,
                 single_logout_url: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 sp_issuer: Optional[pulumi.Input[str]] = None,
                 sso_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_name_id_format: Optional[pulumi.Input[str]] = None,
                 subject_name_id_template: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering Saml resources.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page for this application.
        :param pulumi.Input[bool] accessibility_self_service: Enable self-service. Default is: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acs_endpoints: An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar. Default is: `false`
        :param pulumi.Input[str] certificate: The raw signing certificate.
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[str] entity_key: Entity ID, the ID portion of the `entity_url`.
        :param pulumi.Input[str] entity_url: Entity URL for instance [http://www.okta.com/exk1fcia6d6EMsf331d8](http://www.okta.com/exk1fcia6d6EMsf331d8).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled. Notice: you can't currently configure provisioning features via the API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application.
               - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app. Default is: `false`
        :param pulumi.Input[bool] hide_web: Do not display application icon to users. Default is: `false`
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it. Default is: `false`
        :param pulumi.Input[str] http_post_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        :param pulumi.Input[str] http_redirect_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        :param pulumi.Input[str] inline_hook_id: Saml Inline Hook associated with the application.
        :param pulumi.Input[str] key_id: Certificate key ID.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid (2 - 10 years).
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[str] logo_url: Direct link of application logo.
        :param pulumi.Input[str] metadata: The raw SAML metadata in XML.
        :param pulumi.Input[str] metadata_url: SAML xml metadata URL.
        :param pulumi.Input[str] name: The name of the attribute statement.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.  
               If not provided the following arguments are required:
               - `sso_url`
               - `recipient`
               - `destination`
               - `audience`
               - `subject_name_id_template`
               - `subject_name_id_format`
               - `signature_algorithm`
               - `digest_algorithm`
               - `authn_context_class_ref`
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] saml_version: SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        :param pulumi.Input[str] sign_on_mode: Sign-on mode of application.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] single_logout_certificate: x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
               Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        :param pulumi.Input[str] single_logout_issuer: The issuer of the Service Provider that generates the Single Logout request.
        :param pulumi.Input[str] single_logout_url: The location where the logout response is sent.
        :param pulumi.Input[bool] skip_groups: Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[bool] skip_users: Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign-on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template. Default is: `"${source.login}"`
        :param pulumi.Input[str] user_name_template_push_status: Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type. Default is: `"BUILT_IN"`.
        :param pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]] users: Users associated with the application.
               - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if acs_endpoints is not None:
            pulumi.set(__self__, "acs_endpoints", acs_endpoints)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if app_settings_json is not None:
            pulumi.set(__self__, "app_settings_json", app_settings_json)
        if assertion_signed is not None:
            pulumi.set(__self__, "assertion_signed", assertion_signed)
        if attribute_statements is not None:
            pulumi.set(__self__, "attribute_statements", attribute_statements)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if default_relay_state is not None:
            pulumi.set(__self__, "default_relay_state", default_relay_state)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if entity_key is not None:
            pulumi.set(__self__, "entity_key", entity_key)
        if entity_url is not None:
            pulumi.set(__self__, "entity_url", entity_url)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if groups is not None:
            warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if honor_force_authn is not None:
            pulumi.set(__self__, "honor_force_authn", honor_force_authn)
        if http_post_binding is not None:
            pulumi.set(__self__, "http_post_binding", http_post_binding)
        if http_redirect_binding is not None:
            pulumi.set(__self__, "http_redirect_binding", http_redirect_binding)
        if idp_issuer is not None:
            pulumi.set(__self__, "idp_issuer", idp_issuer)
        if implicit_assignment is not None:
            pulumi.set(__self__, "implicit_assignment", implicit_assignment)
        if inline_hook_id is not None:
            pulumi.set(__self__, "inline_hook_id", inline_hook_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_years_valid is not None:
            pulumi.set(__self__, "key_years_valid", key_years_valid)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_url is not None:
            pulumi.set(__self__, "metadata_url", metadata_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preconfigured_app is not None:
            pulumi.set(__self__, "preconfigured_app", preconfigured_app)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if request_compressed is not None:
            pulumi.set(__self__, "request_compressed", request_compressed)
        if response_signed is not None:
            pulumi.set(__self__, "response_signed", response_signed)
        if saml_version is not None:
            pulumi.set(__self__, "saml_version", saml_version)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if single_logout_certificate is not None:
            pulumi.set(__self__, "single_logout_certificate", single_logout_certificate)
        if single_logout_issuer is not None:
            pulumi.set(__self__, "single_logout_issuer", single_logout_issuer)
        if single_logout_url is not None:
            pulumi.set(__self__, "single_logout_url", single_logout_url)
        if skip_groups is not None:
            pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if sp_issuer is not None:
            pulumi.set(__self__, "sp_issuer", sp_issuer)
        if sso_url is not None:
            pulumi.set(__self__, "sso_url", sso_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_name_id_format is not None:
            pulumi.set(__self__, "subject_name_id_format", subject_name_id_format)
        if subject_name_id_template is not None:
            pulumi.set(__self__, "subject_name_id_template", subject_name_id_template)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if users is not None:
            warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom error page URL.
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom login page for this application.
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable self-service. Default is: `false`.
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @property
    @pulumi.getter(name="acsEndpoints")
    def acs_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        """
        return pulumi.get(self, "acs_endpoints")

    @acs_endpoints.setter
    def acs_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acs_endpoints", value)

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_note", value)

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_links_json", value)

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "app_settings_json")

    @app_settings_json.setter
    def app_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_settings_json", value)

    @property
    @pulumi.getter(name="assertionSigned")
    def assertion_signed(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the SAML assertion is digitally signed.
        """
        return pulumi.get(self, "assertion_signed")

    @assertion_signed.setter
    def assertion_signed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assertion_signed", value)

    @property
    @pulumi.getter(name="attributeStatements")
    def attribute_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]]:
        """
        List of SAML Attribute statements.
        """
        return pulumi.get(self, "attribute_statements")

    @attribute_statements.setter
    def attribute_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlAttributeStatementArgs']]]]):
        pulumi.set(self, "attribute_statements", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience restriction.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the SAML authentication context class for the assertion’s authentication statement.
        """
        return pulumi.get(self, "authn_context_class_ref")

    @authn_context_class_ref.setter
    def authn_context_class_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_context_class_ref", value)

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[bool]]:
        """
        Display auto submit toolbar. Default is: `false`
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The raw signing certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="defaultRelayState")
    def default_relay_state(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies a specific application resource in an IDP initiated SSO scenario.
        """
        return pulumi.get(self, "default_relay_state")

    @default_relay_state.setter
    def default_relay_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_relay_state", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the digest algorithm used to digitally sign the SAML assertion and response.
        """
        return pulumi.get(self, "digest_algorithm")

    @digest_algorithm.setter
    def digest_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digest_algorithm", value)

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enduser_note", value)

    @property
    @pulumi.getter(name="entityKey")
    def entity_key(self) -> Optional[pulumi.Input[str]]:
        """
        Entity ID, the ID portion of the `entity_url`.
        """
        return pulumi.get(self, "entity_key")

    @entity_key.setter
    def entity_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_key", value)

    @property
    @pulumi.getter(name="entityUrl")
    def entity_url(self) -> Optional[pulumi.Input[str]]:
        """
        Entity URL for instance [http://www.okta.com/exk1fcia6d6EMsf331d8](http://www.okta.com/exk1fcia6d6EMsf331d8).
        """
        return pulumi.get(self, "entity_url")

    @entity_url.setter
    def entity_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_url", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        features enabled. Notice: you can't currently configure provisioning features via the API.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Groups associated with the application.
        - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon on mobile app. Default is: `false`
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ios", value)

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not display application icon to users. Default is: `false`
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_web", value)

    @property
    @pulumi.getter(name="honorForceAuthn")
    def honor_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        Prompt user to re-authenticate if SP asks for it. Default is: `false`
        """
        return pulumi.get(self, "honor_force_authn")

    @honor_force_authn.setter
    def honor_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "honor_force_authn", value)

    @property
    @pulumi.getter(name="httpPostBinding")
    def http_post_binding(self) -> Optional[pulumi.Input[str]]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        """
        return pulumi.get(self, "http_post_binding")

    @http_post_binding.setter
    def http_post_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_post_binding", value)

    @property
    @pulumi.getter(name="httpRedirectBinding")
    def http_redirect_binding(self) -> Optional[pulumi.Input[str]]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        """
        return pulumi.get(self, "http_redirect_binding")

    @http_redirect_binding.setter
    def http_redirect_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_redirect_binding", value)

    @property
    @pulumi.getter(name="idpIssuer")
    def idp_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        SAML issuer ID.
        """
        return pulumi.get(self, "idp_issuer")

    @idp_issuer.setter
    def idp_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_issuer", value)

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> Optional[pulumi.Input[bool]]:
        """
        *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        """
        return pulumi.get(self, "implicit_assignment")

    @implicit_assignment.setter
    def implicit_assignment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_assignment", value)

    @property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> Optional[pulumi.Input[str]]:
        """
        Saml Inline Hook associated with the application.
        """
        return pulumi.get(self, "inline_hook_id")

    @inline_hook_id.setter
    def inline_hook_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inline_hook_id", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate key ID.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyYearsValid")
    def key_years_valid(self) -> Optional[pulumi.Input[int]]:
        """
        Number of years the certificate is valid (2 - 10 years).
        """
        return pulumi.get(self, "key_years_valid")

    @key_years_valid.setter
    def key_years_valid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_years_valid", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        label of application.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        Direct link of application logo.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        The raw SAML metadata in XML.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataUrl")
    def metadata_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAML xml metadata URL.
        """
        return pulumi.get(self, "metadata_url")

    @metadata_url.setter
    def metadata_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the attribute statement.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="preconfiguredApp")
    def preconfigured_app(self) -> Optional[pulumi.Input[str]]:
        """
        name of application from the Okta Integration Network, if not included a custom app will be created.  
        If not provided the following arguments are required:
        - `sso_url`
        - `recipient`
        - `destination`
        - `audience`
        - `subject_name_id_template`
        - `subject_name_id_format`
        - `signature_algorithm`
        - `digest_algorithm`
        - `authn_context_class_ref`
        """
        return pulumi.get(self, "preconfigured_app")

    @preconfigured_app.setter
    def preconfigured_app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preconfigured_app", value)

    @property
    @pulumi.getter
    def recipient(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the app may present the SAML assertion.
        """
        return pulumi.get(self, "recipient")

    @recipient.setter
    def recipient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipient", value)

    @property
    @pulumi.getter(name="requestCompressed")
    def request_compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether the request is compressed or not.
        """
        return pulumi.get(self, "request_compressed")

    @request_compressed.setter
    def request_compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_compressed", value)

    @property
    @pulumi.getter(name="responseSigned")
    def response_signed(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the SAML auth response message is digitally signed.
        """
        return pulumi.get(self, "response_signed")

    @response_signed.setter
    def response_signed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "response_signed", value)

    @property
    @pulumi.getter(name="samlVersion")
    def saml_version(self) -> Optional[pulumi.Input[str]]:
        """
        SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        """
        return pulumi.get(self, "saml_version")

    @saml_version.setter
    def saml_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml_version", value)

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Sign-on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sign_on_mode", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Signature algorithm used ot digitally sign the assertion and response.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)

    @property
    @pulumi.getter(name="singleLogoutCertificate")
    def single_logout_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
        Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        """
        return pulumi.get(self, "single_logout_certificate")

    @single_logout_certificate.setter
    def single_logout_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_certificate", value)

    @property
    @pulumi.getter(name="singleLogoutIssuer")
    def single_logout_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the Service Provider that generates the Single Logout request.
        """
        return pulumi.get(self, "single_logout_issuer")

    @single_logout_issuer.setter
    def single_logout_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_issuer", value)

    @property
    @pulumi.getter(name="singleLogoutUrl")
    def single_logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the logout response is sent.
        """
        return pulumi.get(self, "single_logout_url")

    @single_logout_url.setter
    def single_logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_logout_url", value)

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_groups")

    @skip_groups.setter
    def skip_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_groups", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter(name="spIssuer")
    def sp_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        SAML service provider issuer.
        """
        return pulumi.get(self, "sp_issuer")

    @sp_issuer.setter
    def sp_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sp_issuer", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> Optional[pulumi.Input[str]]:
        """
        Single Sign-on Url.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subjectNameIdFormat")
    def subject_name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the SAML processing rules.
        """
        return pulumi.get(self, "subject_name_id_format")

    @subject_name_id_format.setter
    def subject_name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_name_id_format", value)

    @property
    @pulumi.getter(name="subjectNameIdTemplate")
    def subject_name_id_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for app user's username when a user is assigned to the app.
        """
        return pulumi.get(self, "subject_name_id_template")

    @subject_name_id_template.setter
    def subject_name_id_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_name_id_template", value)

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template. Default is: `"${source.login}"`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template", value)

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[str]]:
        """
        Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Username template suffix.
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Username template type. Default is: `"BUILT_IN"`.
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name_template_type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]]:
        """
        Users associated with the application.
        - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlUserArgs']]]]):
        pulumi.set(self, "users", value)


class Saml(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 acs_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 assertion_signed: Optional[pulumi.Input[bool]] = None,
                 attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authn_context_class_ref: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 default_relay_state: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 digest_algorithm: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 honor_force_authn: Optional[pulumi.Input[bool]] = None,
                 idp_issuer: Optional[pulumi.Input[str]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 inline_hook_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_years_valid: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 request_compressed: Optional[pulumi.Input[bool]] = None,
                 response_signed: Optional[pulumi.Input[bool]] = None,
                 saml_version: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 single_logout_certificate: Optional[pulumi.Input[str]] = None,
                 single_logout_issuer: Optional[pulumi.Input[str]] = None,
                 single_logout_url: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 sp_issuer: Optional[pulumi.Input[str]] = None,
                 sso_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_name_id_format: Optional[pulumi.Input[str]] = None,
                 subject_name_id_template: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]]] = None,
                 __props__=None):
        """
        This resource allows you to create and configure a SAML Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.Saml("example",
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                filter_type="REGEX",
                filter_value=".*",
                name="groups",
                type="GROUP",
            )],
            audience="https://example.com/audience",
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            destination="https://example.com",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            label="example",
            recipient="https://example.com",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            sso_url="https://example.com",
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            subject_name_id_template=user["userName"])
        ```
        ### With inline hook

        ```python
        import pulumi
        import pulumi_okta as okta

        test_hook = okta.inline.Hook("testHook",
            status="ACTIVE",
            type="com.okta.saml.tokens.transform",
            version="1.0.2",
            channel={
                "type": "HTTP",
                "version": "1.0.0",
                "uri": "https://example.com/test1",
                "method": "POST",
            },
            auth={
                "key": "Authorization",
                "type": "HEADER",
                "value": "secret",
            })
        test_saml = okta.app.Saml("testSaml",
            label="testAcc_replace_with_uuid",
            sso_url="https://google.com",
            recipient="https://here.com",
            destination="https://its-about-the-journey.com",
            audience="https://audience.com",
            subject_name_id_template=user["userName"],
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            inline_hook_id=test_hook.id,
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                type="GROUP",
                name="groups",
                filter_type="REGEX",
                filter_value=".*",
            )],
            opts=pulumi.ResourceOptions(depends_on=[test_hook]))
        ```
        ### Pre-configured app with SAML 1.1 sign-on mode

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.app.Saml("test",
            app_settings_json=\"\"\"{
            "groupFilter": "app1.*",
            "siteURL": "https://www.okta.com"
        }

        \"\"\",
            label="SharePoint (On-Premise)",
            preconfigured_app="sharepoint_onpremise",
            saml_version="1.1",
            status="ACTIVE",
            user_name_template=source["login"],
            user_name_template_type="BUILT_IN")
        ```
        ### Pre-configured app with SAML 1.1 sign-on mode, `app_settings_json` and `app_links_json`

        ```python
        import pulumi
        import pulumi_okta as okta

        office365 = okta.app.Saml("office365",
            app_links_json=\"\"\"  {
              "calendar": false,
              "crm": false,
              "delve": false,
              "excel": false,
              "forms": false,
              "mail": false,
              "newsfeed": false,
              "onedrive": false,
              "people": false,
              "planner": false,
              "powerbi": false,
              "powerpoint": false,
              "sites": false,
              "sway": false,
              "tasks": false,
              "teams": false,
              "video": false,
              "word": false,
              "yammer": false,
              "login": true
          }

        \"\"\",
            app_settings_json=\"\"\"    {
               "wsFedConfigureType": "AUTO",
               "windowsTransportEnabled": false,
               "domain": "okta.com",
               "msftTenant": "okta",
               "domains": [],
               "requireAdminConsent": false
            }

        \"\"\",
            label="Microsoft Office 365",
            preconfigured_app="office365",
            saml_version="1.1",
            status="ACTIVE")
        ```

        ## Import

        A SAML App can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;
        ```

         It's also possible to import app without groups or/and users. In this case ID may look like this

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_users
        ```

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_users/skip_groups
        ```

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_groups
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page for this application.
        :param pulumi.Input[bool] accessibility_self_service: Enable self-service. Default is: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acs_endpoints: An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar. Default is: `false`
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled. Notice: you can't currently configure provisioning features via the API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application.
               - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app. Default is: `false`
        :param pulumi.Input[bool] hide_web: Do not display application icon to users. Default is: `false`
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it. Default is: `false`
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        :param pulumi.Input[str] inline_hook_id: Saml Inline Hook associated with the application.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid (2 - 10 years).
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.  
               If not provided the following arguments are required:
               - `sso_url`
               - `recipient`
               - `destination`
               - `audience`
               - `subject_name_id_template`
               - `subject_name_id_format`
               - `signature_algorithm`
               - `digest_algorithm`
               - `authn_context_class_ref`
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] saml_version: SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] single_logout_certificate: x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
               Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        :param pulumi.Input[str] single_logout_issuer: The issuer of the Service Provider that generates the Single Logout request.
        :param pulumi.Input[str] single_logout_url: The location where the logout response is sent.
        :param pulumi.Input[bool] skip_groups: Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[bool] skip_users: Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign-on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template. Default is: `"${source.login}"`
        :param pulumi.Input[str] user_name_template_push_status: Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type. Default is: `"BUILT_IN"`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]] users: Users associated with the application.
               - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and configure a SAML Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.Saml("example",
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                filter_type="REGEX",
                filter_value=".*",
                name="groups",
                type="GROUP",
            )],
            audience="https://example.com/audience",
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            destination="https://example.com",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            label="example",
            recipient="https://example.com",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            sso_url="https://example.com",
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            subject_name_id_template=user["userName"])
        ```
        ### With inline hook

        ```python
        import pulumi
        import pulumi_okta as okta

        test_hook = okta.inline.Hook("testHook",
            status="ACTIVE",
            type="com.okta.saml.tokens.transform",
            version="1.0.2",
            channel={
                "type": "HTTP",
                "version": "1.0.0",
                "uri": "https://example.com/test1",
                "method": "POST",
            },
            auth={
                "key": "Authorization",
                "type": "HEADER",
                "value": "secret",
            })
        test_saml = okta.app.Saml("testSaml",
            label="testAcc_replace_with_uuid",
            sso_url="https://google.com",
            recipient="https://here.com",
            destination="https://its-about-the-journey.com",
            audience="https://audience.com",
            subject_name_id_template=user["userName"],
            subject_name_id_format="urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
            response_signed=True,
            signature_algorithm="RSA_SHA256",
            digest_algorithm="SHA256",
            honor_force_authn=False,
            authn_context_class_ref="urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport",
            inline_hook_id=test_hook.id,
            attribute_statements=[okta.app.SamlAttributeStatementArgs(
                type="GROUP",
                name="groups",
                filter_type="REGEX",
                filter_value=".*",
            )],
            opts=pulumi.ResourceOptions(depends_on=[test_hook]))
        ```
        ### Pre-configured app with SAML 1.1 sign-on mode

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.app.Saml("test",
            app_settings_json=\"\"\"{
            "groupFilter": "app1.*",
            "siteURL": "https://www.okta.com"
        }

        \"\"\",
            label="SharePoint (On-Premise)",
            preconfigured_app="sharepoint_onpremise",
            saml_version="1.1",
            status="ACTIVE",
            user_name_template=source["login"],
            user_name_template_type="BUILT_IN")
        ```
        ### Pre-configured app with SAML 1.1 sign-on mode, `app_settings_json` and `app_links_json`

        ```python
        import pulumi
        import pulumi_okta as okta

        office365 = okta.app.Saml("office365",
            app_links_json=\"\"\"  {
              "calendar": false,
              "crm": false,
              "delve": false,
              "excel": false,
              "forms": false,
              "mail": false,
              "newsfeed": false,
              "onedrive": false,
              "people": false,
              "planner": false,
              "powerbi": false,
              "powerpoint": false,
              "sites": false,
              "sway": false,
              "tasks": false,
              "teams": false,
              "video": false,
              "word": false,
              "yammer": false,
              "login": true
          }

        \"\"\",
            app_settings_json=\"\"\"    {
               "wsFedConfigureType": "AUTO",
               "windowsTransportEnabled": false,
               "domain": "okta.com",
               "msftTenant": "okta",
               "domains": [],
               "requireAdminConsent": false
            }

        \"\"\",
            label="Microsoft Office 365",
            preconfigured_app="office365",
            saml_version="1.1",
            status="ACTIVE")
        ```

        ## Import

        A SAML App can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;
        ```

         It's also possible to import app without groups or/and users. In this case ID may look like this

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_users
        ```

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_users/skip_groups
        ```

        ```sh
         $ pulumi import okta:app/saml:Saml example &#60;app id&#62;/skip_groups
        ```

        :param str resource_name: The name of the resource.
        :param SamlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[bool]] = None,
                 acs_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 admin_note: Optional[pulumi.Input[str]] = None,
                 app_links_json: Optional[pulumi.Input[str]] = None,
                 app_settings_json: Optional[pulumi.Input[str]] = None,
                 assertion_signed: Optional[pulumi.Input[bool]] = None,
                 attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authn_context_class_ref: Optional[pulumi.Input[str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
                 default_relay_state: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 digest_algorithm: Optional[pulumi.Input[str]] = None,
                 enduser_note: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hide_ios: Optional[pulumi.Input[bool]] = None,
                 hide_web: Optional[pulumi.Input[bool]] = None,
                 honor_force_authn: Optional[pulumi.Input[bool]] = None,
                 idp_issuer: Optional[pulumi.Input[str]] = None,
                 implicit_assignment: Optional[pulumi.Input[bool]] = None,
                 inline_hook_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_years_valid: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 preconfigured_app: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 request_compressed: Optional[pulumi.Input[bool]] = None,
                 response_signed: Optional[pulumi.Input[bool]] = None,
                 saml_version: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 single_logout_certificate: Optional[pulumi.Input[str]] = None,
                 single_logout_issuer: Optional[pulumi.Input[str]] = None,
                 single_logout_url: Optional[pulumi.Input[str]] = None,
                 skip_groups: Optional[pulumi.Input[bool]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 sp_issuer: Optional[pulumi.Input[str]] = None,
                 sso_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subject_name_id_format: Optional[pulumi.Input[str]] = None,
                 subject_name_id_template: Optional[pulumi.Input[str]] = None,
                 user_name_template: Optional[pulumi.Input[str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[str]] = None,
                 user_name_template_type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlArgs.__new__(SamlArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["acs_endpoints"] = acs_endpoints
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["app_settings_json"] = app_settings_json
            __props__.__dict__["assertion_signed"] = assertion_signed
            __props__.__dict__["attribute_statements"] = attribute_statements
            __props__.__dict__["audience"] = audience
            __props__.__dict__["authn_context_class_ref"] = authn_context_class_ref
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            __props__.__dict__["default_relay_state"] = default_relay_state
            __props__.__dict__["destination"] = destination
            __props__.__dict__["digest_algorithm"] = digest_algorithm
            __props__.__dict__["enduser_note"] = enduser_note
            __props__.__dict__["features"] = features
            if groups is not None and not opts.urn:
                warnings.warn("""The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""groups is deprecated: The direct configuration of groups in this app resource is deprecated, please ensure you use the resource `okta_app_group_assignments` for this functionality.""")
            __props__.__dict__["groups"] = groups
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            __props__.__dict__["honor_force_authn"] = honor_force_authn
            __props__.__dict__["idp_issuer"] = idp_issuer
            __props__.__dict__["implicit_assignment"] = implicit_assignment
            __props__.__dict__["inline_hook_id"] = inline_hook_id
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["key_years_valid"] = key_years_valid
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["logo"] = logo
            __props__.__dict__["preconfigured_app"] = preconfigured_app
            __props__.__dict__["recipient"] = recipient
            __props__.__dict__["request_compressed"] = request_compressed
            __props__.__dict__["response_signed"] = response_signed
            __props__.__dict__["saml_version"] = saml_version
            __props__.__dict__["signature_algorithm"] = signature_algorithm
            __props__.__dict__["single_logout_certificate"] = single_logout_certificate
            __props__.__dict__["single_logout_issuer"] = single_logout_issuer
            __props__.__dict__["single_logout_url"] = single_logout_url
            __props__.__dict__["skip_groups"] = skip_groups
            __props__.__dict__["skip_users"] = skip_users
            __props__.__dict__["sp_issuer"] = sp_issuer
            __props__.__dict__["sso_url"] = sso_url
            __props__.__dict__["status"] = status
            __props__.__dict__["subject_name_id_format"] = subject_name_id_format
            __props__.__dict__["subject_name_id_template"] = subject_name_id_template
            __props__.__dict__["user_name_template"] = user_name_template
            __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
            __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
            __props__.__dict__["user_name_template_type"] = user_name_template_type
            if users is not None and not opts.urn:
                warnings.warn("""The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""users is deprecated: The direct configuration of users in this app resource is deprecated, please ensure you use the resource `okta_app_user` for this functionality.""")
            __props__.__dict__["users"] = users
            __props__.__dict__["certificate"] = None
            __props__.__dict__["entity_key"] = None
            __props__.__dict__["entity_url"] = None
            __props__.__dict__["http_post_binding"] = None
            __props__.__dict__["http_redirect_binding"] = None
            __props__.__dict__["key_id"] = None
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["metadata_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(Saml, __self__).__init__(
            'okta:app/saml:Saml',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[str]] = None,
            accessibility_self_service: Optional[pulumi.Input[bool]] = None,
            acs_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            admin_note: Optional[pulumi.Input[str]] = None,
            app_links_json: Optional[pulumi.Input[str]] = None,
            app_settings_json: Optional[pulumi.Input[str]] = None,
            assertion_signed: Optional[pulumi.Input[bool]] = None,
            attribute_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]]] = None,
            audience: Optional[pulumi.Input[str]] = None,
            authn_context_class_ref: Optional[pulumi.Input[str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[bool]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            default_relay_state: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            digest_algorithm: Optional[pulumi.Input[str]] = None,
            enduser_note: Optional[pulumi.Input[str]] = None,
            entity_key: Optional[pulumi.Input[str]] = None,
            entity_url: Optional[pulumi.Input[str]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hide_ios: Optional[pulumi.Input[bool]] = None,
            hide_web: Optional[pulumi.Input[bool]] = None,
            honor_force_authn: Optional[pulumi.Input[bool]] = None,
            http_post_binding: Optional[pulumi.Input[str]] = None,
            http_redirect_binding: Optional[pulumi.Input[str]] = None,
            idp_issuer: Optional[pulumi.Input[str]] = None,
            implicit_assignment: Optional[pulumi.Input[bool]] = None,
            inline_hook_id: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            key_years_valid: Optional[pulumi.Input[int]] = None,
            label: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            logo_url: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            metadata_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            preconfigured_app: Optional[pulumi.Input[str]] = None,
            recipient: Optional[pulumi.Input[str]] = None,
            request_compressed: Optional[pulumi.Input[bool]] = None,
            response_signed: Optional[pulumi.Input[bool]] = None,
            saml_version: Optional[pulumi.Input[str]] = None,
            sign_on_mode: Optional[pulumi.Input[str]] = None,
            signature_algorithm: Optional[pulumi.Input[str]] = None,
            single_logout_certificate: Optional[pulumi.Input[str]] = None,
            single_logout_issuer: Optional[pulumi.Input[str]] = None,
            single_logout_url: Optional[pulumi.Input[str]] = None,
            skip_groups: Optional[pulumi.Input[bool]] = None,
            skip_users: Optional[pulumi.Input[bool]] = None,
            sp_issuer: Optional[pulumi.Input[str]] = None,
            sso_url: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subject_name_id_format: Optional[pulumi.Input[str]] = None,
            subject_name_id_template: Optional[pulumi.Input[str]] = None,
            user_name_template: Optional[pulumi.Input[str]] = None,
            user_name_template_push_status: Optional[pulumi.Input[str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[str]] = None,
            user_name_template_type: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]]] = None) -> 'Saml':
        """
        Get an existing Saml resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessibility_error_redirect_url: Custom error page URL.
        :param pulumi.Input[str] accessibility_login_redirect_url: Custom login page for this application.
        :param pulumi.Input[bool] accessibility_self_service: Enable self-service. Default is: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acs_endpoints: An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        :param pulumi.Input[str] admin_note: Application notes for admins.
        :param pulumi.Input[str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[str] app_settings_json: Application settings in JSON format.
        :param pulumi.Input[bool] assertion_signed: Determines whether the SAML assertion is digitally signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlAttributeStatementArgs']]]] attribute_statements: List of SAML Attribute statements.
        :param pulumi.Input[str] audience: Audience restriction.
        :param pulumi.Input[str] authn_context_class_ref: Identifies the SAML authentication context class for the assertion’s authentication statement.
        :param pulumi.Input[bool] auto_submit_toolbar: Display auto submit toolbar. Default is: `false`
        :param pulumi.Input[str] certificate: The raw signing certificate.
        :param pulumi.Input[str] default_relay_state: Identifies a specific application resource in an IDP initiated SSO scenario.
        :param pulumi.Input[str] destination: Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        :param pulumi.Input[str] digest_algorithm: Determines the digest algorithm used to digitally sign the SAML assertion and response.
        :param pulumi.Input[str] enduser_note: Application notes for end users.
        :param pulumi.Input[str] entity_key: Entity ID, the ID portion of the `entity_url`.
        :param pulumi.Input[str] entity_url: Entity URL for instance [http://www.okta.com/exk1fcia6d6EMsf331d8](http://www.okta.com/exk1fcia6d6EMsf331d8).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: features enabled. Notice: you can't currently configure provisioning features via the API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: Groups associated with the application.
               - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        :param pulumi.Input[bool] hide_ios: Do not display application icon on mobile app. Default is: `false`
        :param pulumi.Input[bool] hide_web: Do not display application icon to users. Default is: `false`
        :param pulumi.Input[bool] honor_force_authn: Prompt user to re-authenticate if SP asks for it. Default is: `false`
        :param pulumi.Input[str] http_post_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        :param pulumi.Input[str] http_redirect_binding: `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        :param pulumi.Input[str] idp_issuer: SAML issuer ID.
        :param pulumi.Input[bool] implicit_assignment: *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        :param pulumi.Input[str] inline_hook_id: Saml Inline Hook associated with the application.
        :param pulumi.Input[str] key_id: Certificate key ID.
        :param pulumi.Input[str] key_name: Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        :param pulumi.Input[int] key_years_valid: Number of years the certificate is valid (2 - 10 years).
        :param pulumi.Input[str] label: label of application.
        :param pulumi.Input[str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[str] logo_url: Direct link of application logo.
        :param pulumi.Input[str] metadata: The raw SAML metadata in XML.
        :param pulumi.Input[str] metadata_url: SAML xml metadata URL.
        :param pulumi.Input[str] name: The name of the attribute statement.
        :param pulumi.Input[str] preconfigured_app: name of application from the Okta Integration Network, if not included a custom app will be created.  
               If not provided the following arguments are required:
               - `sso_url`
               - `recipient`
               - `destination`
               - `audience`
               - `subject_name_id_template`
               - `subject_name_id_format`
               - `signature_algorithm`
               - `digest_algorithm`
               - `authn_context_class_ref`
        :param pulumi.Input[str] recipient: The location where the app may present the SAML assertion.
        :param pulumi.Input[bool] request_compressed: Denotes whether the request is compressed or not.
        :param pulumi.Input[bool] response_signed: Determines whether the SAML auth response message is digitally signed.
        :param pulumi.Input[str] saml_version: SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        :param pulumi.Input[str] sign_on_mode: Sign-on mode of application.
        :param pulumi.Input[str] signature_algorithm: Signature algorithm used ot digitally sign the assertion and response.
        :param pulumi.Input[str] single_logout_certificate: x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
               Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        :param pulumi.Input[str] single_logout_issuer: The issuer of the Service Provider that generates the Single Logout request.
        :param pulumi.Input[str] single_logout_url: The location where the logout response is sent.
        :param pulumi.Input[bool] skip_groups: Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[bool] skip_users: Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        :param pulumi.Input[str] sp_issuer: SAML service provider issuer.
        :param pulumi.Input[str] sso_url: Single Sign-on Url.
        :param pulumi.Input[str] status: status of application.
        :param pulumi.Input[str] subject_name_id_format: Identifies the SAML processing rules.
        :param pulumi.Input[str] subject_name_id_template: Template for app user's username when a user is assigned to the app.
        :param pulumi.Input[str] user_name_template: Username template. Default is: `"${source.login}"`
        :param pulumi.Input[str] user_name_template_push_status: Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        :param pulumi.Input[str] user_name_template_suffix: Username template suffix.
        :param pulumi.Input[str] user_name_template_type: Username template type. Default is: `"BUILT_IN"`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SamlUserArgs']]]] users: Users associated with the application.
               - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlState.__new__(_SamlState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["acs_endpoints"] = acs_endpoints
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["app_settings_json"] = app_settings_json
        __props__.__dict__["assertion_signed"] = assertion_signed
        __props__.__dict__["attribute_statements"] = attribute_statements
        __props__.__dict__["audience"] = audience
        __props__.__dict__["authn_context_class_ref"] = authn_context_class_ref
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["default_relay_state"] = default_relay_state
        __props__.__dict__["destination"] = destination
        __props__.__dict__["digest_algorithm"] = digest_algorithm
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["entity_key"] = entity_key
        __props__.__dict__["entity_url"] = entity_url
        __props__.__dict__["features"] = features
        __props__.__dict__["groups"] = groups
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["honor_force_authn"] = honor_force_authn
        __props__.__dict__["http_post_binding"] = http_post_binding
        __props__.__dict__["http_redirect_binding"] = http_redirect_binding
        __props__.__dict__["idp_issuer"] = idp_issuer
        __props__.__dict__["implicit_assignment"] = implicit_assignment
        __props__.__dict__["inline_hook_id"] = inline_hook_id
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_years_valid"] = key_years_valid
        __props__.__dict__["label"] = label
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_url"] = metadata_url
        __props__.__dict__["name"] = name
        __props__.__dict__["preconfigured_app"] = preconfigured_app
        __props__.__dict__["recipient"] = recipient
        __props__.__dict__["request_compressed"] = request_compressed
        __props__.__dict__["response_signed"] = response_signed
        __props__.__dict__["saml_version"] = saml_version
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["single_logout_certificate"] = single_logout_certificate
        __props__.__dict__["single_logout_issuer"] = single_logout_issuer
        __props__.__dict__["single_logout_url"] = single_logout_url
        __props__.__dict__["skip_groups"] = skip_groups
        __props__.__dict__["skip_users"] = skip_users
        __props__.__dict__["sp_issuer"] = sp_issuer
        __props__.__dict__["sso_url"] = sso_url
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_name_id_format"] = subject_name_id_format
        __props__.__dict__["subject_name_id_template"] = subject_name_id_template
        __props__.__dict__["user_name_template"] = user_name_template
        __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
        __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
        __props__.__dict__["user_name_template_type"] = user_name_template_type
        __props__.__dict__["users"] = users
        return Saml(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom error page URL.
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Custom login page for this application.
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable self-service. Default is: `false`.
        """
        return pulumi.get(self, "accessibility_self_service")

    @property
    @pulumi.getter(name="acsEndpoints")
    def acs_endpoints(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of ACS endpoints. You can configure a maximum of 100 endpoints.
        """
        return pulumi.get(self, "acs_endpoints")

    @property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @property
    @pulumi.getter(name="appSettingsJson")
    def app_settings_json(self) -> pulumi.Output[Optional[str]]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "app_settings_json")

    @property
    @pulumi.getter(name="assertionSigned")
    def assertion_signed(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether the SAML assertion is digitally signed.
        """
        return pulumi.get(self, "assertion_signed")

    @property
    @pulumi.getter(name="attributeStatements")
    def attribute_statements(self) -> pulumi.Output[Optional[Sequence['outputs.SamlAttributeStatement']]]:
        """
        List of SAML Attribute statements.
        """
        return pulumi.get(self, "attribute_statements")

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[str]]:
        """
        Audience restriction.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the SAML authentication context class for the assertion’s authentication statement.
        """
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[bool]]:
        """
        Display auto submit toolbar. Default is: `false`
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The raw signing certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="defaultRelayState")
    def default_relay_state(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies a specific application resource in an IDP initiated SSO scenario.
        """
        return pulumi.get(self, "default_relay_state")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the location where the SAML response is intended to be sent inside the SAML assertion.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Determines the digest algorithm used to digitally sign the SAML assertion and response.
        """
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @property
    @pulumi.getter(name="entityKey")
    def entity_key(self) -> pulumi.Output[str]:
        """
        Entity ID, the ID portion of the `entity_url`.
        """
        return pulumi.get(self, "entity_key")

    @property
    @pulumi.getter(name="entityUrl")
    def entity_url(self) -> pulumi.Output[str]:
        """
        Entity URL for instance [http://www.okta.com/exk1fcia6d6EMsf331d8](http://www.okta.com/exk1fcia6d6EMsf331d8).
        """
        return pulumi.get(self, "entity_url")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        features enabled. Notice: you can't currently configure provisioning features via the API.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Groups associated with the application.
        - `DEPRECATED`: Please replace usage with the `AppGroupAssignments` (or `app.GroupAssignment`) resource.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon on mobile app. Default is: `false`
        """
        return pulumi.get(self, "hide_ios")

    @property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not display application icon to users. Default is: `false`
        """
        return pulumi.get(self, "hide_web")

    @property
    @pulumi.getter(name="honorForceAuthn")
    def honor_force_authn(self) -> pulumi.Output[Optional[bool]]:
        """
        Prompt user to re-authenticate if SP asks for it. Default is: `false`
        """
        return pulumi.get(self, "honor_force_authn")

    @property
    @pulumi.getter(name="httpPostBinding")
    def http_post_binding(self) -> pulumi.Output[str]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post` location from the SAML metadata.
        """
        return pulumi.get(self, "http_post_binding")

    @property
    @pulumi.getter(name="httpRedirectBinding")
    def http_redirect_binding(self) -> pulumi.Output[str]:
        """
        `urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect` location from the SAML metadata.
        """
        return pulumi.get(self, "http_redirect_binding")

    @property
    @pulumi.getter(name="idpIssuer")
    def idp_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        SAML issuer ID.
        """
        return pulumi.get(self, "idp_issuer")

    @property
    @pulumi.getter(name="implicitAssignment")
    def implicit_assignment(self) -> pulumi.Output[Optional[bool]]:
        """
        *Early Access Property*. Enables Federation Broker Mode. When this mode is enabled, `users` and `groups` arguments are ignored.
        """
        return pulumi.get(self, "implicit_assignment")

    @property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> pulumi.Output[Optional[str]]:
        """
        Saml Inline Hook associated with the application.
        """
        return pulumi.get(self, "inline_hook_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        Certificate key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate name. This modulates the rotation of keys. New name == new key. Required to be set with `key_years_valid`.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyYearsValid")
    def key_years_valid(self) -> pulumi.Output[Optional[int]]:
        """
        Number of years the certificate is valid (2 - 10 years).
        """
        return pulumi.get(self, "key_years_valid")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        label of application.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[str]:
        """
        Direct link of application logo.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        The raw SAML metadata in XML.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataUrl")
    def metadata_url(self) -> pulumi.Output[str]:
        """
        SAML xml metadata URL.
        """
        return pulumi.get(self, "metadata_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the attribute statement.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preconfiguredApp")
    def preconfigured_app(self) -> pulumi.Output[Optional[str]]:
        """
        name of application from the Okta Integration Network, if not included a custom app will be created.  
        If not provided the following arguments are required:
        - `sso_url`
        - `recipient`
        - `destination`
        - `audience`
        - `subject_name_id_template`
        - `subject_name_id_format`
        - `signature_algorithm`
        - `digest_algorithm`
        - `authn_context_class_ref`
        """
        return pulumi.get(self, "preconfigured_app")

    @property
    @pulumi.getter
    def recipient(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the app may present the SAML assertion.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="requestCompressed")
    def request_compressed(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes whether the request is compressed or not.
        """
        return pulumi.get(self, "request_compressed")

    @property
    @pulumi.getter(name="responseSigned")
    def response_signed(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether the SAML auth response message is digitally signed.
        """
        return pulumi.get(self, "response_signed")

    @property
    @pulumi.getter(name="samlVersion")
    def saml_version(self) -> pulumi.Output[Optional[str]]:
        """
        SAML version for the app's sign-on mode. Valid values are: `"2.0"` or `"1.1"`. Default is `"2.0"`.
        """
        return pulumi.get(self, "saml_version")

    @property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[str]:
        """
        Sign-on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Signature algorithm used ot digitally sign the assertion and response.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="singleLogoutCertificate")
    def single_logout_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
        Note: should be provided without `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`, see [official documentation](https://developer.okta.com/docs/reference/api/apps/#service-provider-certificate).
        """
        return pulumi.get(self, "single_logout_certificate")

    @property
    @pulumi.getter(name="singleLogoutIssuer")
    def single_logout_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        The issuer of the Service Provider that generates the Single Logout request.
        """
        return pulumi.get(self, "single_logout_issuer")

    @property
    @pulumi.getter(name="singleLogoutUrl")
    def single_logout_url(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the logout response is sent.
        """
        return pulumi.get(self, "single_logout_url")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that allows the app to skip `groups` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that allows the app to skip `users` sync (it can also be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter(name="spIssuer")
    def sp_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        SAML service provider issuer.
        """
        return pulumi.get(self, "sp_issuer")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Output[Optional[str]]:
        """
        Single Sign-on Url.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subjectNameIdFormat")
    def subject_name_id_format(self) -> pulumi.Output[Optional[str]]:
        """
        Identifies the SAML processing rules.
        """
        return pulumi.get(self, "subject_name_id_format")

    @property
    @pulumi.getter(name="subjectNameIdTemplate")
    def subject_name_id_template(self) -> pulumi.Output[Optional[str]]:
        """
        Template for app user's username when a user is assigned to the app.
        """
        return pulumi.get(self, "subject_name_id_template")

    @property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[str]]:
        """
        Username template. Default is: `"${source.login}"`
        """
        return pulumi.get(self, "user_name_template")

    @property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> pulumi.Output[Optional[str]]:
        """
        Push username on update. Valid values: `"PUSH"` and `"DONT_PUSH"`.
        """
        return pulumi.get(self, "user_name_template_push_status")

    @property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Username template suffix.
        """
        return pulumi.get(self, "user_name_template_suffix")

    @property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[str]]:
        """
        Username template type. Default is: `"BUILT_IN"`.
        """
        return pulumi.get(self, "user_name_template_type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.SamlUser']]]:
        """
        Users associated with the application.
        - `DEPRECATED`: Please replace usage with the `app.User` resource.
        """
        return pulumi.get(self, "users")

