# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AppSamlAppSettingsArgs', 'AppSamlAppSettings']

@pulumi.input_type
class AppSamlAppSettingsArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 settings: pulumi.Input[str]):
        """
        The set of arguments for constructing a AppSamlAppSettings resource.
        :param pulumi.Input[str] app_id: ID of the application.
        :param pulumi.Input[str] settings: Application settings in JSON format.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        ID of the application.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Input[str]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: pulumi.Input[str]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _AppSamlAppSettingsState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppSamlAppSettings resources.
        :param pulumi.Input[str] app_id: ID of the application.
        :param pulumi.Input[str] settings: Application settings in JSON format.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the application.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[str]]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings", value)


class AppSamlAppSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to manage app settings of the SAML Application . It's basically the same as
        `app_settings_json` field in `app.Saml` resource and can be used in cases where settings require to be managed separately.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test_saml = okta.app.Saml("testSaml",
            preconfigured_app="amazon_aws",
            label="Amazon AWS",
            status="ACTIVE")
        test_app_saml_app_settings = okta.AppSamlAppSettings("testAppSamlAppSettings",
            app_id=test_saml.id,
            settings=json.dumps({
                "appFilter": "okta",
                "awsEnvironmentType": "aws.amazon",
                "groupFilter": "aws_(?{{accountid}}\\\\d+)_(?{{role}}[a-zA-Z0-9+=,.@\\\\-_]+)",
                "joinAllRoles": False,
                "loginURL": "https://console.aws.amazon.com/ec2/home",
                "roleValuePattern": f"arn:aws:iam::{accountid}:saml-provider/OKTA,arn:aws:iam::{accountid}:role/{role}",
                "sessionDuration": 3200,
                "useGroupMapping": False,
            }))
        ```

        ## Import

        A settings for the SAML App can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/appSamlAppSettings:AppSamlAppSettings example &#60;app id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: ID of the application.
        :param pulumi.Input[str] settings: Application settings in JSON format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSamlAppSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage app settings of the SAML Application . It's basically the same as
        `app_settings_json` field in `app.Saml` resource and can be used in cases where settings require to be managed separately.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test_saml = okta.app.Saml("testSaml",
            preconfigured_app="amazon_aws",
            label="Amazon AWS",
            status="ACTIVE")
        test_app_saml_app_settings = okta.AppSamlAppSettings("testAppSamlAppSettings",
            app_id=test_saml.id,
            settings=json.dumps({
                "appFilter": "okta",
                "awsEnvironmentType": "aws.amazon",
                "groupFilter": "aws_(?{{accountid}}\\\\d+)_(?{{role}}[a-zA-Z0-9+=,.@\\\\-_]+)",
                "joinAllRoles": False,
                "loginURL": "https://console.aws.amazon.com/ec2/home",
                "roleValuePattern": f"arn:aws:iam::{accountid}:saml-provider/OKTA,arn:aws:iam::{accountid}:role/{role}",
                "sessionDuration": 3200,
                "useGroupMapping": False,
            }))
        ```

        ## Import

        A settings for the SAML App can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/appSamlAppSettings:AppSamlAppSettings example &#60;app id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param AppSamlAppSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSamlAppSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSamlAppSettingsArgs.__new__(AppSamlAppSettingsArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if settings is None and not opts.urn:
                raise TypeError("Missing required property 'settings'")
            __props__.__dict__["settings"] = settings
        super(AppSamlAppSettings, __self__).__init__(
            'okta:index/appSamlAppSettings:AppSamlAppSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[str]] = None) -> 'AppSamlAppSettings':
        """
        Get an existing AppSamlAppSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: ID of the application.
        :param pulumi.Input[str] settings: Application settings in JSON format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSamlAppSettingsState.__new__(_AppSamlAppSettingsState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["settings"] = settings
        return AppSamlAppSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        ID of the application.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[str]:
        """
        Application settings in JSON format.
        """
        return pulumi.get(self, "settings")

