# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAppGroupAssignmentsResult',
    'AwaitableGetAppGroupAssignmentsResult',
    'get_app_group_assignments',
    'get_app_group_assignments_output',
]

@pulumi.output_type
class GetAppGroupAssignmentsResult:
    """
    A collection of values returned by getAppGroupAssignments.
    """
    def __init__(__self__, groups=None, id=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def groups(self) -> Sequence[str]:
        """
        List of groups IDs assigned to the application.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of application.
        """
        return pulumi.get(self, "id")


class AwaitableGetAppGroupAssignmentsResult(GetAppGroupAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppGroupAssignmentsResult(
            groups=self.groups,
            id=self.id)


def get_app_group_assignments(id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppGroupAssignmentsResult:
    """
    Use this data source to retrieve the list of groups assigned to the given Okta application (by ID).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_app_group_assignments(id=okta_app_oauth["test"]["id"])
    ```


    :param str id: The ID of the Okta application you want to retrieve the groups for.
    """
    __args__ = dict()
    __args__['id'] = id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:index/getAppGroupAssignments:getAppGroupAssignments', __args__, opts=opts, typ=GetAppGroupAssignmentsResult).value

    return AwaitableGetAppGroupAssignmentsResult(
        groups=__ret__.groups,
        id=__ret__.id)


@_utilities.lift_output_func(get_app_group_assignments)
def get_app_group_assignments_output(id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppGroupAssignmentsResult]:
    """
    Use this data source to retrieve the list of groups assigned to the given Okta application (by ID).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_app_group_assignments(id=okta_app_oauth["test"]["id"])
    ```


    :param str id: The ID of the Okta application you want to retrieve the groups for.
    """
    ...
