# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetThemesResult',
    'AwaitableGetThemesResult',
    'get_themes',
    'get_themes_output',
]

@pulumi.output_type
class GetThemesResult:
    """
    A collection of values returned by getThemes.
    """
    def __init__(__self__, brand_id=None, id=None, themes=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if themes and not isinstance(themes, list):
            raise TypeError("Expected argument 'themes' to be a list")
        pulumi.set(__self__, "themes", themes)

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> str:
        return pulumi.get(self, "brand_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def themes(self) -> Sequence['outputs.GetThemesThemeResult']:
        """
        List of `Theme` belonging to the brand.
        """
        return pulumi.get(self, "themes")


class AwaitableGetThemesResult(GetThemesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThemesResult(
            brand_id=self.brand_id,
            id=self.id,
            themes=self.themes)


def get_themes(brand_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThemesResult:
    """
    Use this data source to retrieve
    [Themes](https://developer.okta.com/docs/reference/api/brands/#theme-response-object)
    of a brand for an Okta orgnanization.


    :param str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:index/getThemes:getThemes', __args__, opts=opts, typ=GetThemesResult).value

    return AwaitableGetThemesResult(
        brand_id=__ret__.brand_id,
        id=__ret__.id,
        themes=__ret__.themes)


@_utilities.lift_output_func(get_themes)
def get_themes_output(brand_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetThemesResult]:
    """
    Use this data source to retrieve
    [Themes](https://developer.okta.com/docs/reference/api/brands/#theme-response-object)
    of a brand for an Okta orgnanization.


    :param str brand_id: Brand ID
    """
    ...
