# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 custom_profile_attributes: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[str] custom_profile_attributes: raw JSON containing all custom profile attributes.
        :param pulumi.Input[str] description: The description of the Okta Group.
        :param pulumi.Input[str] name: The name of the Okta Group.
        :param pulumi.Input[bool] skip_users: Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The users associated with the group. This can also be done per user.
               `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        if custom_profile_attributes is not None:
            pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if users is not None:
            warnings.warn("""The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> Optional[pulumi.Input[str]]:
        """
        raw JSON containing all custom profile attributes.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @custom_profile_attributes.setter
    def custom_profile_attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_profile_attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Okta Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Okta Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The users associated with the group. This can also be done per user.
        `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 custom_profile_attributes: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[str] custom_profile_attributes: raw JSON containing all custom profile attributes.
        :param pulumi.Input[str] description: The description of the Okta Group.
        :param pulumi.Input[str] name: The name of the Okta Group.
        :param pulumi.Input[bool] skip_users: Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The users associated with the group. This can also be done per user.
               `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        if custom_profile_attributes is not None:
            pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_users is not None:
            pulumi.set(__self__, "skip_users", skip_users)
        if users is not None:
            warnings.warn("""The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> Optional[pulumi.Input[str]]:
        """
        raw JSON containing all custom profile attributes.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @custom_profile_attributes.setter
    def custom_profile_attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_profile_attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Okta Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Okta Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @skip_users.setter
    def skip_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_users", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The users associated with the group. This can also be done per user.
        `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_profile_attributes: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates an Okta Group.

        This resource allows you to create and configure an Okta Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.group.Group("example", description="My Example Group")
        ```

        Ignore users sync
        ```python
        import pulumi
        import pulumi_okta as okta

        example_skip = okta.group.Group("exampleSkip",
            description="My Example Group",
            skip_users=True)
        ```

        Custom profile attributes
        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.group.Group("example",
            description="My Example Group",
            custom_profile_attributes=json.dumps({
                "example1": "testing1234",
                "example2": True,
                "example3": 54321,
            }))
        ```

        ## Import

        An Okta Group can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:group/group:Group example &#60;group id&#62;
        ```

         It's also possible to import group without users. In this case ID will look like this

        ```sh
         $ pulumi import okta:group/group:Group example &#60;group id&#62;/skip_users
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_profile_attributes: raw JSON containing all custom profile attributes.
        :param pulumi.Input[str] description: The description of the Okta Group.
        :param pulumi.Input[str] name: The name of the Okta Group.
        :param pulumi.Input[bool] skip_users: Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The users associated with the group. This can also be done per user.
               `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Okta Group.

        This resource allows you to create and configure an Okta Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.group.Group("example", description="My Example Group")
        ```

        Ignore users sync
        ```python
        import pulumi
        import pulumi_okta as okta

        example_skip = okta.group.Group("exampleSkip",
            description="My Example Group",
            skip_users=True)
        ```

        Custom profile attributes
        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.group.Group("example",
            description="My Example Group",
            custom_profile_attributes=json.dumps({
                "example1": "testing1234",
                "example2": True,
                "example3": 54321,
            }))
        ```

        ## Import

        An Okta Group can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:group/group:Group example &#60;group id&#62;
        ```

         It's also possible to import group without users. In this case ID will look like this

        ```sh
         $ pulumi import okta:group/group:Group example &#60;group id&#62;/skip_users
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_profile_attributes: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_users: Optional[pulumi.Input[bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["custom_profile_attributes"] = custom_profile_attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["skip_users"] = skip_users
            if users is not None and not opts.urn:
                warnings.warn("""The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""", DeprecationWarning)
                pulumi.log.warn("""users is deprecated: The `users` field is now deprecated for the resource `okta_group`, please replace all uses of this with: `okta_group_memberships`""")
            __props__.__dict__["users"] = users
        super(Group, __self__).__init__(
            'okta:group/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_profile_attributes: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            skip_users: Optional[pulumi.Input[bool]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_profile_attributes: raw JSON containing all custom profile attributes.
        :param pulumi.Input[str] description: The description of the Okta Group.
        :param pulumi.Input[str] name: The name of the Okta Group.
        :param pulumi.Input[bool] skip_users: Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The users associated with the group. This can also be done per user.
               `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["custom_profile_attributes"] = custom_profile_attributes
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["skip_users"] = skip_users
        __props__.__dict__["users"] = users
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> pulumi.Output[Optional[str]]:
        """
        raw JSON containing all custom profile attributes.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Okta Group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Okta Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that allows a group to skip `users` sync (it's also can be provided during import). Default is `false`.
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The users associated with the group. This can also be done per user.
        `DEPRECATED`: Please replace usage with the `GroupMemberships` resource.
        """
        return pulumi.get(self, "users")

