# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleSignonArgs', 'RuleSignon']

@pulumi.input_type
class RuleSignonArgs:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RuleSignon resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        :param pulumi.Input[str] authtype: Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs.
        :param pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]] factor_sequences: Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        :param pulumi.Input[str] identity_provider: Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge.
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device. The default `false`.
        :param pulumi.Input[bool] mfa_required: Require MFA. By default is `false`.
        :param pulumi.Input[str] name: Policy Rule Name.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The network zones to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The network zones to include. Conflicts with `network_excludes`.
        :param pulumi.Input[str] policy_id: Policy ID.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[str] primary_factor: Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
               `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
               set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.,
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        :param pulumi.Input[str] status: Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if authtype is not None:
            pulumi.set(__self__, "authtype", authtype)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if factor_sequences is not None:
            pulumi.set(__self__, "factor_sequences", factor_sequences)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if identity_provider_ids is not None:
            pulumi.set(__self__, "identity_provider_ids", identity_provider_ids)
        if mfa_lifetime is not None:
            pulumi.set(__self__, "mfa_lifetime", mfa_lifetime)
        if mfa_prompt is not None:
            pulumi.set(__self__, "mfa_prompt", mfa_prompt)
        if mfa_remember_device is not None:
            pulumi.set(__self__, "mfa_remember_device", mfa_remember_device)
        if mfa_required is not None:
            pulumi.set(__self__, "mfa_required", mfa_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policyid is not None:
            warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
            pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
        if policyid is not None:
            pulumi.set(__self__, "policyid", policyid)
        if primary_factor is not None:
            pulumi.set(__self__, "primary_factor", primary_factor)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if risc_level is not None:
            pulumi.set(__self__, "risc_level", risc_level)
        if session_idle is not None:
            pulumi.set(__self__, "session_idle", session_idle)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if session_persistent is not None:
            pulumi.set(__self__, "session_persistent", session_persistent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def authtype(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        """
        return pulumi.get(self, "authtype")

    @authtype.setter
    def authtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authtype", value)

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of behavior IDs.
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "behaviors", value)

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]]:
        """
        Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        """
        return pulumi.get(self, "factor_sequences")

    @factor_sequences.setter
    def factor_sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]]):
        pulumi.set(self, "factor_sequences", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        """
        return pulumi.get(self, "identity_provider_ids")

    @identity_provider_ids.setter
    def identity_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identity_provider_ids", value)

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Elapsed time before the next MFA challenge.
        """
        return pulumi.get(self, "mfa_lifetime")

    @mfa_lifetime.setter
    def mfa_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mfa_lifetime", value)

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        """
        return pulumi.get(self, "mfa_prompt")

    @mfa_prompt.setter
    def mfa_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_prompt", value)

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Remember MFA device. The default `false`.
        """
        return pulumi.get(self, "mfa_remember_device")

    @mfa_remember_device.setter
    def mfa_remember_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_remember_device", value)

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require MFA. By default is `false`.
        """
        return pulumi.get(self, "mfa_required")

    @mfa_required.setter
    def mfa_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network zones to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network zones to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def policyid(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policyid")

    @policyid.setter
    def policyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policyid", value)

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> Optional[pulumi.Input[str]]:
        """
        Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
        `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        """
        return pulumi.get(self, "primary_factor")

    @primary_factor.setter
    def primary_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_factor", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> Optional[pulumi.Input[str]]:
        """
        Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
        set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        """
        return pulumi.get(self, "risc_level")

    @risc_level.setter
    def risc_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risc_level", value)

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session can be idle.,
        """
        return pulumi.get(self, "session_idle")

    @session_idle.setter
    def session_idle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_idle", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        """
        return pulumi.get(self, "session_persistent")

    @session_persistent.setter
    def session_persistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_persistent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


@pulumi.input_type
class _RuleSignonState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering RuleSignon resources.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        :param pulumi.Input[str] authtype: Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs.
        :param pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]] factor_sequences: Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        :param pulumi.Input[str] identity_provider: Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge.
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device. The default `false`.
        :param pulumi.Input[bool] mfa_required: Require MFA. By default is `false`.
        :param pulumi.Input[str] name: Policy Rule Name.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The network zones to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The network zones to include. Conflicts with `network_excludes`.
        :param pulumi.Input[str] policy_id: Policy ID.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[str] primary_factor: Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
               `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
               set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.,
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        :param pulumi.Input[str] status: Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if authtype is not None:
            pulumi.set(__self__, "authtype", authtype)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if factor_sequences is not None:
            pulumi.set(__self__, "factor_sequences", factor_sequences)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if identity_provider_ids is not None:
            pulumi.set(__self__, "identity_provider_ids", identity_provider_ids)
        if mfa_lifetime is not None:
            pulumi.set(__self__, "mfa_lifetime", mfa_lifetime)
        if mfa_prompt is not None:
            pulumi.set(__self__, "mfa_prompt", mfa_prompt)
        if mfa_remember_device is not None:
            pulumi.set(__self__, "mfa_remember_device", mfa_remember_device)
        if mfa_required is not None:
            pulumi.set(__self__, "mfa_required", mfa_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policyid is not None:
            warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
            pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
        if policyid is not None:
            pulumi.set(__self__, "policyid", policyid)
        if primary_factor is not None:
            pulumi.set(__self__, "primary_factor", primary_factor)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if risc_level is not None:
            pulumi.set(__self__, "risc_level", risc_level)
        if session_idle is not None:
            pulumi.set(__self__, "session_idle", session_idle)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if session_persistent is not None:
            pulumi.set(__self__, "session_persistent", session_persistent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def authtype(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        """
        return pulumi.get(self, "authtype")

    @authtype.setter
    def authtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authtype", value)

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of behavior IDs.
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "behaviors", value)

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]]:
        """
        Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        """
        return pulumi.get(self, "factor_sequences")

    @factor_sequences.setter
    def factor_sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSignonFactorSequenceArgs']]]]):
        pulumi.set(self, "factor_sequences", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        """
        return pulumi.get(self, "identity_provider_ids")

    @identity_provider_ids.setter
    def identity_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identity_provider_ids", value)

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Elapsed time before the next MFA challenge.
        """
        return pulumi.get(self, "mfa_lifetime")

    @mfa_lifetime.setter
    def mfa_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mfa_lifetime", value)

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        """
        return pulumi.get(self, "mfa_prompt")

    @mfa_prompt.setter
    def mfa_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_prompt", value)

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Remember MFA device. The default `false`.
        """
        return pulumi.get(self, "mfa_remember_device")

    @mfa_remember_device.setter
    def mfa_remember_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_remember_device", value)

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require MFA. By default is `false`.
        """
        return pulumi.get(self, "mfa_required")

    @mfa_required.setter
    def mfa_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network zones to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network zones to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def policyid(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policyid")

    @policyid.setter
    def policyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policyid", value)

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> Optional[pulumi.Input[str]]:
        """
        Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
        `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        """
        return pulumi.get(self, "primary_factor")

    @primary_factor.setter
    def primary_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_factor", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> Optional[pulumi.Input[str]]:
        """
        Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
        set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        """
        return pulumi.get(self, "risc_level")

    @risc_level.setter
    def risc_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risc_level", value)

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session can be idle.,
        """
        return pulumi.get(self, "session_idle")

    @session_idle.setter
    def session_idle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_idle", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        """
        return pulumi.get(self, "session_persistent")

    @session_persistent.setter
    def session_persistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_persistent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


class RuleSignon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleSignonFactorSequenceArgs']]]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a Sign On Policy Rule. In case `Invalid condition type specified: riskScore.` error is thrown, set `risc_level`
        to an empty string, since this feature is not enabled.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.policy.Signon("test",
            status="ACTIVE",
            description="Example Policy")
        new_city = okta.get_behaviour(name="New City")
        example = okta.policy.RuleSignon("example",
            access="CHALLENGE",
            authtype="RADIUS",
            network_connection="ANYWHERE",
            policy_id=okta_policy_signon["example"]["id"],
            status="ACTIVE",
            risc_level="HIGH",
            behaviors=[new_city.id],
            factor_sequences=[
                okta.policy.RuleSignonFactorSequenceArgs(
                    primary_criteria_factor_type="token:hotp",
                    primary_criteria_provider="CUSTOM",
                    secondary_criterias=[
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token:software:totp",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="push",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="password",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="question",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="sms",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token:software:totp",
                            provider="GOOGLE",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="email",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="call",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="webauthn",
                            provider="FIDO",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token",
                            provider="RSA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token",
                            provider="SYMANTEC",
                        ),
                    ],
                ),
                okta.policy.RuleSignonFactorSequenceArgs(
                    primary_criteria_factor_type="token:software:totp",
                    primary_criteria_provider="OKTA",
                ),
            ])
        ```

        ## Import

        A Policy Rule can be imported via the Policy and Rule ID.

        ```sh
         $ pulumi import okta:policy/ruleSignon:RuleSignon example &#60;policy id&#62;/&#60;rule id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        :param pulumi.Input[str] authtype: Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleSignonFactorSequenceArgs']]]] factor_sequences: Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        :param pulumi.Input[str] identity_provider: Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge.
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device. The default `false`.
        :param pulumi.Input[bool] mfa_required: Require MFA. By default is `false`.
        :param pulumi.Input[str] name: Policy Rule Name.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The network zones to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The network zones to include. Conflicts with `network_excludes`.
        :param pulumi.Input[str] policy_id: Policy ID.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[str] primary_factor: Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
               `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
               set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.,
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        :param pulumi.Input[str] status: Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RuleSignonArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Sign On Policy Rule. In case `Invalid condition type specified: riskScore.` error is thrown, set `risc_level`
        to an empty string, since this feature is not enabled.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.policy.Signon("test",
            status="ACTIVE",
            description="Example Policy")
        new_city = okta.get_behaviour(name="New City")
        example = okta.policy.RuleSignon("example",
            access="CHALLENGE",
            authtype="RADIUS",
            network_connection="ANYWHERE",
            policy_id=okta_policy_signon["example"]["id"],
            status="ACTIVE",
            risc_level="HIGH",
            behaviors=[new_city.id],
            factor_sequences=[
                okta.policy.RuleSignonFactorSequenceArgs(
                    primary_criteria_factor_type="token:hotp",
                    primary_criteria_provider="CUSTOM",
                    secondary_criterias=[
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token:software:totp",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="push",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="password",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="question",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="sms",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token:software:totp",
                            provider="GOOGLE",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="email",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="call",
                            provider="OKTA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="webauthn",
                            provider="FIDO",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token",
                            provider="RSA",
                        ),
                        okta.policy.RuleSignonFactorSequenceSecondaryCriteriaArgs(
                            factor_type="token",
                            provider="SYMANTEC",
                        ),
                    ],
                ),
                okta.policy.RuleSignonFactorSequenceArgs(
                    primary_criteria_factor_type="token:software:totp",
                    primary_criteria_provider="OKTA",
                ),
            ])
        ```

        ## Import

        A Policy Rule can be imported via the Policy and Rule ID.

        ```sh
         $ pulumi import okta:policy/ruleSignon:RuleSignon example &#60;policy id&#62;/&#60;rule id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param RuleSignonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleSignonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleSignonFactorSequenceArgs']]]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleSignonArgs.__new__(RuleSignonArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["authtype"] = authtype
            __props__.__dict__["behaviors"] = behaviors
            __props__.__dict__["factor_sequences"] = factor_sequences
            __props__.__dict__["identity_provider"] = identity_provider
            __props__.__dict__["identity_provider_ids"] = identity_provider_ids
            __props__.__dict__["mfa_lifetime"] = mfa_lifetime
            __props__.__dict__["mfa_prompt"] = mfa_prompt
            __props__.__dict__["mfa_remember_device"] = mfa_remember_device
            __props__.__dict__["mfa_required"] = mfa_required
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connection"] = network_connection
            __props__.__dict__["network_excludes"] = network_excludes
            __props__.__dict__["network_includes"] = network_includes
            __props__.__dict__["policy_id"] = policy_id
            if policyid is not None and not opts.urn:
                warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
                pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
            __props__.__dict__["policyid"] = policyid
            __props__.__dict__["primary_factor"] = primary_factor
            __props__.__dict__["priority"] = priority
            __props__.__dict__["risc_level"] = risc_level
            __props__.__dict__["session_idle"] = session_idle
            __props__.__dict__["session_lifetime"] = session_lifetime
            __props__.__dict__["session_persistent"] = session_persistent
            __props__.__dict__["status"] = status
            __props__.__dict__["users_excludeds"] = users_excludeds
        super(RuleSignon, __self__).__init__(
            'okta:policy/ruleSignon:RuleSignon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            authtype: Optional[pulumi.Input[str]] = None,
            behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleSignonFactorSequenceArgs']]]]] = None,
            identity_provider: Optional[pulumi.Input[str]] = None,
            identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mfa_lifetime: Optional[pulumi.Input[int]] = None,
            mfa_prompt: Optional[pulumi.Input[str]] = None,
            mfa_remember_device: Optional[pulumi.Input[bool]] = None,
            mfa_required: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_connection: Optional[pulumi.Input[str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            policyid: Optional[pulumi.Input[str]] = None,
            primary_factor: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            risc_level: Optional[pulumi.Input[str]] = None,
            session_idle: Optional[pulumi.Input[int]] = None,
            session_lifetime: Optional[pulumi.Input[int]] = None,
            session_persistent: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'RuleSignon':
        """
        Get an existing RuleSignon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        :param pulumi.Input[str] authtype: Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleSignonFactorSequenceArgs']]]] factor_sequences: Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        :param pulumi.Input[str] identity_provider: Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge.
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device. The default `false`.
        :param pulumi.Input[bool] mfa_required: Require MFA. By default is `false`.
        :param pulumi.Input[str] name: Policy Rule Name.
        :param pulumi.Input[str] network_connection: Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The network zones to exclude. Conflicts with `network_includes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The network zones to include. Conflicts with `network_excludes`.
        :param pulumi.Input[str] policy_id: Policy ID.
        :param pulumi.Input[str] policyid: Policy ID.
        :param pulumi.Input[str] primary_factor: Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
               `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
               set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.,
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        :param pulumi.Input[str] status: Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleSignonState.__new__(_RuleSignonState)

        __props__.__dict__["access"] = access
        __props__.__dict__["authtype"] = authtype
        __props__.__dict__["behaviors"] = behaviors
        __props__.__dict__["factor_sequences"] = factor_sequences
        __props__.__dict__["identity_provider"] = identity_provider
        __props__.__dict__["identity_provider_ids"] = identity_provider_ids
        __props__.__dict__["mfa_lifetime"] = mfa_lifetime
        __props__.__dict__["mfa_prompt"] = mfa_prompt
        __props__.__dict__["mfa_remember_device"] = mfa_remember_device
        __props__.__dict__["mfa_required"] = mfa_required
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connection"] = network_connection
        __props__.__dict__["network_excludes"] = network_excludes
        __props__.__dict__["network_includes"] = network_includes
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policyid"] = policyid
        __props__.__dict__["primary_factor"] = primary_factor
        __props__.__dict__["priority"] = priority
        __props__.__dict__["risc_level"] = risc_level
        __props__.__dict__["session_idle"] = session_idle
        __props__.__dict__["session_lifetime"] = session_lifetime
        __props__.__dict__["session_persistent"] = session_persistent
        __props__.__dict__["status"] = status
        __props__.__dict__["users_excludeds"] = users_excludeds
        return RuleSignon(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[Optional[str]]:
        """
        Allow or deny access based on the rule conditions: `"ALLOW"`, `"DENY"` or `"CHALLENGE"`. The default is `"ALLOW"`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def authtype(self) -> pulumi.Output[Optional[str]]:
        """
        Authentication entrypoint: `"ANY"`, `"LDAP_INTERFACE"` or `"RADIUS"`.
        """
        return pulumi.get(self, "authtype")

    @property
    @pulumi.getter
    def behaviors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of behavior IDs.
        """
        return pulumi.get(self, "behaviors")

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> pulumi.Output[Optional[Sequence['outputs.RuleSignonFactorSequence']]]:
        """
        Auth factor sequences. Should be set if `access = "CHALLENGE"`.
        """
        return pulumi.get(self, "factor_sequences")

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the identity provider for this rule. Valid values are `"ANY"`, `"OKTA"`, and `"SPECIFIC_IDP"`.
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        When identity_provider is `"SPECIFIC_IDP"` then this is the list of IdP IDs to apply the rule on.
        """
        return pulumi.get(self, "identity_provider_ids")

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Elapsed time before the next MFA challenge.
        """
        return pulumi.get(self, "mfa_lifetime")

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> pulumi.Output[Optional[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: `"DEVICE"`, `"SESSION"` or `"ALWAYS"`.
        """
        return pulumi.get(self, "mfa_prompt")

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> pulumi.Output[Optional[bool]]:
        """
        Remember MFA device. The default `false`.
        """
        return pulumi.get(self, "mfa_remember_device")

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Require MFA. By default is `false`.
        """
        return pulumi.get(self, "mfa_required")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Policy Rule Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[str]]:
        """
        Network selection mode: `"ANYWHERE"`, `"ZONE"`, `"ON_NETWORK"`, or `"OFF_NETWORK"`.
        """
        return pulumi.get(self, "network_connection")

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The network zones to exclude. Conflicts with `network_includes`.
        """
        return pulumi.get(self, "network_excludes")

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The network zones to include. Conflicts with `network_excludes`.
        """
        return pulumi.get(self, "network_includes")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def policyid(self) -> pulumi.Output[Optional[str]]:
        """
        Policy ID.
        """
        return pulumi.get(self, "policyid")

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> pulumi.Output[str]:
        """
        Rule's primary factor. **WARNING** Ony works as a part of the Identity Engine. Valid values: 
        `"PASSWORD_IDP_ANY_FACTOR"`, `"PASSWORD_IDP"`.
        """
        return pulumi.get(self, "primary_factor")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> pulumi.Output[Optional[str]]:
        """
        Risc level: `"ANY"`, `"LOW"`, `"MEDIUM"` or `"HIGH"`. Default is `"ANY"`. It can be also 
        set to an empty string in case `RISC_SCORING` org feature flag is disabled.
        """
        return pulumi.get(self, "risc_level")

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> pulumi.Output[Optional[int]]:
        """
        Max minutes a session can be idle.,
        """
        return pulumi.get(self, "session_idle")

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
        """
        return pulumi.get(self, "session_persistent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Policy Rule Status: `"ACTIVE"` or `"INACTIVE"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

