import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#id ContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#location ContainerRegistry#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#name ContainerRegistry#name}
    */
    readonly name: string;
    /**
    * garbage_collection_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#garbage_collection_schedule ContainerRegistry#garbage_collection_schedule}
    */
    readonly garbageCollectionSchedule?: ContainerRegistryGarbageCollectionSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#timeouts ContainerRegistry#timeouts}
    */
    readonly timeouts?: ContainerRegistryTimeouts;
}
export interface ContainerRegistryStorageUsage {
}
export declare function containerRegistryStorageUsageToTerraform(struct?: ContainerRegistryStorageUsage): any;
export declare class ContainerRegistryStorageUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryStorageUsage | undefined;
    set internalValue(value: ContainerRegistryStorageUsage | undefined);
    get bytes(): number;
    get updatedAt(): string;
}
export declare class ContainerRegistryStorageUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryStorageUsageOutputReference;
}
export interface ContainerRegistryGarbageCollectionSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#days ContainerRegistry#days}
    */
    readonly days: string[];
    /**
    * UTC time of day e.g. 01:00:00 - as defined by partial-time - RFC3339
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#time ContainerRegistry#time}
    */
    readonly time: string;
}
export declare function containerRegistryGarbageCollectionScheduleToTerraform(struct?: ContainerRegistryGarbageCollectionScheduleOutputReference | ContainerRegistryGarbageCollectionSchedule): any;
export declare class ContainerRegistryGarbageCollectionScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryGarbageCollectionSchedule | undefined;
    set internalValue(value: ContainerRegistryGarbageCollectionSchedule | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface ContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#create ContainerRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#default ContainerRegistry#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#delete ContainerRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry#update ContainerRegistry#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTimeoutsToTerraform(struct?: ContainerRegistryTimeoutsOutputReference | ContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry ionoscloud_container_registry}
*/
export declare class ContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/container_registry ionoscloud_container_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryConfig);
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageUsage;
    get storageUsage(): ContainerRegistryStorageUsageList;
    private _garbageCollectionSchedule;
    get garbageCollectionSchedule(): ContainerRegistryGarbageCollectionScheduleOutputReference;
    putGarbageCollectionSchedule(value: ContainerRegistryGarbageCollectionSchedule): void;
    resetGarbageCollectionSchedule(): void;
    get garbageCollectionScheduleInput(): ContainerRegistryGarbageCollectionSchedule | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
