import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CubeServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#availability_zone CubeServer#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#boot_cdrom CubeServer#boot_cdrom}
    */
    readonly bootCdrom?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#boot_image CubeServer#boot_image}
    */
    readonly bootImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#datacenter_id CubeServer#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#id CubeServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#image_name CubeServer#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#image_password CubeServer#image_password}
    */
    readonly imagePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#name CubeServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#ssh_key_path CubeServer#ssh_key_path}
    */
    readonly sshKeyPath?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#template_uuid CubeServer#template_uuid}
    */
    readonly templateUuid: string;
    /**
    * nic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#nic CubeServer#nic}
    */
    readonly nic: CubeServerNic;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#timeouts CubeServer#timeouts}
    */
    readonly timeouts?: CubeServerTimeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#volume CubeServer#volume}
    */
    readonly volume: CubeServerVolume;
}
export interface CubeServerNicFirewall {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#icmp_code CubeServer#icmp_code}
    */
    readonly icmpCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#icmp_type CubeServer#icmp_type}
    */
    readonly icmpType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#name CubeServer#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#port_range_end CubeServer#port_range_end}
    */
    readonly portRangeEnd?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#port_range_start CubeServer#port_range_start}
    */
    readonly portRangeStart?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#protocol CubeServer#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#source_ip CubeServer#source_ip}
    */
    readonly sourceIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#source_mac CubeServer#source_mac}
    */
    readonly sourceMac?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#target_ip CubeServer#target_ip}
    */
    readonly targetIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#type CubeServer#type}
    */
    readonly type?: string;
}
export declare function cubeServerNicFirewallToTerraform(struct?: CubeServerNicFirewallOutputReference | CubeServerNicFirewall): any;
export declare class CubeServerNicFirewallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CubeServerNicFirewall | undefined;
    set internalValue(value: CubeServerNicFirewall | undefined);
    private _icmpCode?;
    get icmpCode(): string;
    set icmpCode(value: string);
    resetIcmpCode(): void;
    get icmpCodeInput(): string | undefined;
    private _icmpType?;
    get icmpType(): string;
    set icmpType(value: string);
    resetIcmpType(): void;
    get icmpTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _portRangeEnd?;
    get portRangeEnd(): number;
    set portRangeEnd(value: number);
    resetPortRangeEnd(): void;
    get portRangeEndInput(): number | undefined;
    private _portRangeStart?;
    get portRangeStart(): number;
    set portRangeStart(value: number);
    resetPortRangeStart(): void;
    get portRangeStartInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourceIp?;
    get sourceIp(): string;
    set sourceIp(value: string);
    resetSourceIp(): void;
    get sourceIpInput(): string | undefined;
    private _sourceMac?;
    get sourceMac(): string;
    set sourceMac(value: string);
    resetSourceMac(): void;
    get sourceMacInput(): string | undefined;
    private _targetIp?;
    get targetIp(): string;
    set targetIp(value: string);
    resetTargetIp(): void;
    get targetIpInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface CubeServerNic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#dhcp CubeServer#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#firewall_active CubeServer#firewall_active}
    */
    readonly firewallActive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#firewall_type CubeServer#firewall_type}
    */
    readonly firewallType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#ips CubeServer#ips}
    */
    readonly ips?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#lan CubeServer#lan}
    */
    readonly lan: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#name CubeServer#name}
    */
    readonly name?: string;
    /**
    * firewall block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#firewall CubeServer#firewall}
    */
    readonly firewall?: CubeServerNicFirewall;
}
export declare function cubeServerNicToTerraform(struct?: CubeServerNicOutputReference | CubeServerNic): any;
export declare class CubeServerNicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CubeServerNic | undefined;
    set internalValue(value: CubeServerNic | undefined);
    get deviceNumber(): number;
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    resetDhcp(): void;
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallActive?;
    get firewallActive(): boolean | cdktf.IResolvable;
    set firewallActive(value: boolean | cdktf.IResolvable);
    resetFirewallActive(): void;
    get firewallActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallType?;
    get firewallType(): string;
    set firewallType(value: string);
    resetFirewallType(): void;
    get firewallTypeInput(): string | undefined;
    private _ips?;
    get ips(): string[];
    set ips(value: string[]);
    resetIps(): void;
    get ipsInput(): string[] | undefined;
    private _lan?;
    get lan(): number;
    set lan(value: number);
    get lanInput(): number | undefined;
    get mac(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get pciSlot(): number;
    private _firewall;
    get firewall(): CubeServerNicFirewallOutputReference;
    putFirewall(value: CubeServerNicFirewall): void;
    resetFirewall(): void;
    get firewallInput(): CubeServerNicFirewall | undefined;
}
export interface CubeServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#create CubeServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#default CubeServer#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#delete CubeServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#update CubeServer#update}
    */
    readonly update?: string;
}
export declare function cubeServerTimeoutsToTerraform(struct?: CubeServerTimeoutsOutputReference | CubeServerTimeouts | cdktf.IResolvable): any;
export declare class CubeServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CubeServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CubeServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CubeServerVolume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#availability_zone CubeServer#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * The uuid of the Backup Unit that user has access to. The property is immutable and is only allowed to be set on a new volume creation. It is mandatory to provide either 'public image' or 'imageAlias' in conjunction with this property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#backup_unit_id CubeServer#backup_unit_id}
    */
    readonly backupUnitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#bus CubeServer#bus}
    */
    readonly bus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#disk_type CubeServer#disk_type}
    */
    readonly diskType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#image_password CubeServer#image_password}
    */
    readonly imagePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#licence_type CubeServer#licence_type}
    */
    readonly licenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#name CubeServer#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#ssh_key_path CubeServer#ssh_key_path}
    */
    readonly sshKeyPath?: string[];
    /**
    * The cloud-init configuration for the volume as base64 encoded string. The property is immutable and is only allowed to be set on a new volume creation. It is mandatory to provide either 'public image' or 'imageAlias' that has cloud-init compatibility in conjunction with this property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server#user_data CubeServer#user_data}
    */
    readonly userData?: string;
}
export declare function cubeServerVolumeToTerraform(struct?: CubeServerVolumeOutputReference | CubeServerVolume): any;
export declare class CubeServerVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CubeServerVolume | undefined;
    set internalValue(value: CubeServerVolume | undefined);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _backupUnitId?;
    get backupUnitId(): string;
    set backupUnitId(value: string);
    resetBackupUnitId(): void;
    get backupUnitIdInput(): string | undefined;
    get bootServer(): string;
    private _bus?;
    get bus(): string;
    set bus(value: string);
    resetBus(): void;
    get busInput(): string | undefined;
    get cpuHotPlug(): cdktf.IResolvable;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    get diskTypeInput(): string | undefined;
    private _imagePassword?;
    get imagePassword(): string;
    set imagePassword(value: string);
    resetImagePassword(): void;
    get imagePasswordInput(): string | undefined;
    private _licenceType?;
    get licenceType(): string;
    set licenceType(value: string);
    resetLicenceType(): void;
    get licenceTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    private _sshKeyPath?;
    get sshKeyPath(): string[];
    set sshKeyPath(value: string[]);
    resetSshKeyPath(): void;
    get sshKeyPathInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server ionoscloud_cube_server}
*/
export declare class CubeServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_cube_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/cube_server ionoscloud_cube_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CubeServerConfig
    */
    constructor(scope: Construct, id: string, config: CubeServerConfig);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _bootCdrom?;
    get bootCdrom(): string;
    set bootCdrom(value: string);
    resetBootCdrom(): void;
    get bootCdromInput(): string | undefined;
    private _bootImage?;
    get bootImage(): string;
    set bootImage(value: string);
    resetBootImage(): void;
    get bootImageInput(): string | undefined;
    get bootVolume(): string;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get firewallruleId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _imagePassword?;
    get imagePassword(): string;
    set imagePassword(value: string);
    resetImagePassword(): void;
    get imagePasswordInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryIp(): string;
    get primaryNic(): string;
    private _sshKeyPath?;
    get sshKeyPath(): string[];
    set sshKeyPath(value: string[]);
    resetSshKeyPath(): void;
    get sshKeyPathInput(): string[] | undefined;
    private _templateUuid?;
    get templateUuid(): string;
    set templateUuid(value: string);
    get templateUuidInput(): string | undefined;
    private _nic;
    get nic(): CubeServerNicOutputReference;
    putNic(value: CubeServerNic): void;
    get nicInput(): CubeServerNic | undefined;
    private _timeouts;
    get timeouts(): CubeServerTimeoutsOutputReference;
    putTimeouts(value: CubeServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CubeServerTimeouts | undefined;
    private _volume;
    get volume(): CubeServerVolumeOutputReference;
    putVolume(value: CubeServerVolume): void;
    get volumeInput(): CubeServerVolume | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
