import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudContainerRegistryLocationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#id DataIonoscloudContainerRegistryLocations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#timeouts DataIonoscloudContainerRegistryLocations#timeouts}
    */
    readonly timeouts?: DataIonoscloudContainerRegistryLocationsTimeouts;
}
export interface DataIonoscloudContainerRegistryLocationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#create DataIonoscloudContainerRegistryLocations#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#default DataIonoscloudContainerRegistryLocations#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#delete DataIonoscloudContainerRegistryLocations#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations#update DataIonoscloudContainerRegistryLocations#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudContainerRegistryLocationsTimeoutsToTerraform(struct?: DataIonoscloudContainerRegistryLocationsTimeoutsOutputReference | DataIonoscloudContainerRegistryLocationsTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudContainerRegistryLocationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudContainerRegistryLocationsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryLocationsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations ionoscloud_container_registry_locations}
*/
export declare class DataIonoscloudContainerRegistryLocations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_container_registry_locations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_locations ionoscloud_container_registry_locations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudContainerRegistryLocationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudContainerRegistryLocationsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get locations(): string[];
    private _timeouts;
    get timeouts(): DataIonoscloudContainerRegistryLocationsTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudContainerRegistryLocationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudContainerRegistryLocationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
