import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudContainerRegistryTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#id DataIonoscloudContainerRegistryToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#name DataIonoscloudContainerRegistryToken#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#partial_match DataIonoscloudContainerRegistryToken#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#registry_id DataIonoscloudContainerRegistryToken#registry_id}
    */
    readonly registryId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#timeouts DataIonoscloudContainerRegistryToken#timeouts}
    */
    readonly timeouts?: DataIonoscloudContainerRegistryTokenTimeouts;
}
export interface DataIonoscloudContainerRegistryTokenCredentials {
}
export declare function dataIonoscloudContainerRegistryTokenCredentialsToTerraform(struct?: DataIonoscloudContainerRegistryTokenCredentials): any;
export declare class DataIonoscloudContainerRegistryTokenCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudContainerRegistryTokenCredentials | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryTokenCredentials | undefined);
    get username(): string;
}
export declare class DataIonoscloudContainerRegistryTokenCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudContainerRegistryTokenCredentialsOutputReference;
}
export interface DataIonoscloudContainerRegistryTokenScopes {
}
export declare function dataIonoscloudContainerRegistryTokenScopesToTerraform(struct?: DataIonoscloudContainerRegistryTokenScopes): any;
export declare class DataIonoscloudContainerRegistryTokenScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudContainerRegistryTokenScopes | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryTokenScopes | undefined);
    get actions(): string[];
    get name(): string;
    get type(): string;
}
export declare class DataIonoscloudContainerRegistryTokenScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudContainerRegistryTokenScopesOutputReference;
}
export interface DataIonoscloudContainerRegistryTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#create DataIonoscloudContainerRegistryToken#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#default DataIonoscloudContainerRegistryToken#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#delete DataIonoscloudContainerRegistryToken#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token#update DataIonoscloudContainerRegistryToken#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudContainerRegistryTokenTimeoutsToTerraform(struct?: DataIonoscloudContainerRegistryTokenTimeoutsOutputReference | DataIonoscloudContainerRegistryTokenTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudContainerRegistryTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudContainerRegistryTokenTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryTokenTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token ionoscloud_container_registry_token}
*/
export declare class DataIonoscloudContainerRegistryToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_container_registry_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry_token ionoscloud_container_registry_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudContainerRegistryTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudContainerRegistryTokenConfig);
    private _credentials;
    get credentials(): DataIonoscloudContainerRegistryTokenCredentialsList;
    get expiryDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _registryId?;
    get registryId(): string;
    set registryId(value: string);
    get registryIdInput(): string | undefined;
    private _scopes;
    get scopes(): DataIonoscloudContainerRegistryTokenScopesList;
    get status(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudContainerRegistryTokenTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudContainerRegistryTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudContainerRegistryTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
