import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#id DataIonoscloudContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#location DataIonoscloudContainerRegistry#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#name DataIonoscloudContainerRegistry#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#partial_match DataIonoscloudContainerRegistry#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#timeouts DataIonoscloudContainerRegistry#timeouts}
    */
    readonly timeouts?: DataIonoscloudContainerRegistryTimeouts;
}
export interface DataIonoscloudContainerRegistryGarbageCollectionSchedule {
}
export declare function dataIonoscloudContainerRegistryGarbageCollectionScheduleToTerraform(struct?: DataIonoscloudContainerRegistryGarbageCollectionSchedule): any;
export declare class DataIonoscloudContainerRegistryGarbageCollectionScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudContainerRegistryGarbageCollectionSchedule | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryGarbageCollectionSchedule | undefined);
    get days(): string[];
    get time(): string;
}
export declare class DataIonoscloudContainerRegistryGarbageCollectionScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudContainerRegistryGarbageCollectionScheduleOutputReference;
}
export interface DataIonoscloudContainerRegistryMaintenanceWindow {
}
export declare function dataIonoscloudContainerRegistryMaintenanceWindowToTerraform(struct?: DataIonoscloudContainerRegistryMaintenanceWindow): any;
export declare class DataIonoscloudContainerRegistryMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudContainerRegistryMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryMaintenanceWindow | undefined);
    get days(): string[];
    get time(): string;
}
export declare class DataIonoscloudContainerRegistryMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudContainerRegistryMaintenanceWindowOutputReference;
}
export interface DataIonoscloudContainerRegistryStorageUsage {
}
export declare function dataIonoscloudContainerRegistryStorageUsageToTerraform(struct?: DataIonoscloudContainerRegistryStorageUsage): any;
export declare class DataIonoscloudContainerRegistryStorageUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudContainerRegistryStorageUsage | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryStorageUsage | undefined);
    get bytes(): number;
    get updatedAt(): string;
}
export declare class DataIonoscloudContainerRegistryStorageUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudContainerRegistryStorageUsageOutputReference;
}
export interface DataIonoscloudContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#create DataIonoscloudContainerRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#default DataIonoscloudContainerRegistry#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#delete DataIonoscloudContainerRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry#update DataIonoscloudContainerRegistry#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudContainerRegistryTimeoutsToTerraform(struct?: DataIonoscloudContainerRegistryTimeoutsOutputReference | DataIonoscloudContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudContainerRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudContainerRegistryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry ionoscloud_container_registry}
*/
export declare class DataIonoscloudContainerRegistry extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/container_registry ionoscloud_container_registry} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudContainerRegistryConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudContainerRegistryConfig);
    private _garbageCollectionSchedule;
    get garbageCollectionSchedule(): DataIonoscloudContainerRegistryGarbageCollectionScheduleList;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudContainerRegistryMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUsage;
    get storageUsage(): DataIonoscloudContainerRegistryStorageUsageList;
    private _timeouts;
    get timeouts(): DataIonoscloudContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
