import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudCubeServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#datacenter_id DataIonoscloudCubeServer#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#id DataIonoscloudCubeServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#name DataIonoscloudCubeServer#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#template_uuid DataIonoscloudCubeServer#template_uuid}
    */
    readonly templateUuid?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#timeouts DataIonoscloudCubeServer#timeouts}
    */
    readonly timeouts?: DataIonoscloudCubeServerTimeouts;
}
export interface DataIonoscloudCubeServerCdroms {
}
export declare function dataIonoscloudCubeServerCdromsToTerraform(struct?: DataIonoscloudCubeServerCdroms): any;
export declare class DataIonoscloudCubeServerCdromsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudCubeServerCdroms | undefined;
    set internalValue(value: DataIonoscloudCubeServerCdroms | undefined);
    get cloudInit(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get cpuHotUnplug(): cdktf.IResolvable;
    get description(): string;
    get discScsiHotPlug(): cdktf.IResolvable;
    get discScsiHotUnplug(): cdktf.IResolvable;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get id(): string;
    get imageAliases(): string[];
    get imageType(): string;
    get licenceType(): string;
    get location(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get public(): cdktf.IResolvable;
    get ramHotPlug(): cdktf.IResolvable;
    get ramHotUnplug(): cdktf.IResolvable;
    get size(): number;
}
export declare class DataIonoscloudCubeServerCdromsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudCubeServerCdromsOutputReference;
}
export interface DataIonoscloudCubeServerNicsFirewallRules {
}
export declare function dataIonoscloudCubeServerNicsFirewallRulesToTerraform(struct?: DataIonoscloudCubeServerNicsFirewallRules): any;
export declare class DataIonoscloudCubeServerNicsFirewallRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudCubeServerNicsFirewallRules | undefined;
    set internalValue(value: DataIonoscloudCubeServerNicsFirewallRules | undefined);
    get icmpCode(): number;
    get icmpType(): number;
    get id(): string;
    get name(): string;
    get portRangeEnd(): number;
    get portRangeStart(): number;
    get protocol(): string;
    get sourceIp(): string;
    get sourceMac(): string;
    get targetIp(): string;
    get type(): string;
}
export declare class DataIonoscloudCubeServerNicsFirewallRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudCubeServerNicsFirewallRulesOutputReference;
}
export interface DataIonoscloudCubeServerNics {
}
export declare function dataIonoscloudCubeServerNicsToTerraform(struct?: DataIonoscloudCubeServerNics): any;
export declare class DataIonoscloudCubeServerNicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudCubeServerNics | undefined;
    set internalValue(value: DataIonoscloudCubeServerNics | undefined);
    get deviceNumber(): number;
    get dhcp(): cdktf.IResolvable;
    get firewallActive(): cdktf.IResolvable;
    private _firewallRules;
    get firewallRules(): DataIonoscloudCubeServerNicsFirewallRulesList;
    get firewallType(): string;
    get id(): string;
    get ips(): string[];
    get lan(): number;
    get mac(): string;
    get name(): string;
    get pciSlot(): number;
}
export declare class DataIonoscloudCubeServerNicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudCubeServerNicsOutputReference;
}
export interface DataIonoscloudCubeServerVolumes {
}
export declare function dataIonoscloudCubeServerVolumesToTerraform(struct?: DataIonoscloudCubeServerVolumes): any;
export declare class DataIonoscloudCubeServerVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudCubeServerVolumes | undefined;
    set internalValue(value: DataIonoscloudCubeServerVolumes | undefined);
    get availabilityZone(): string;
    get backupUnitId(): string;
    get bootServer(): string;
    get bus(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get id(): string;
    get imageName(): string;
    get imagePassword(): string;
    get licenceType(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    get sshKeys(): string[];
    get type(): string;
    get userData(): string;
}
export declare class DataIonoscloudCubeServerVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudCubeServerVolumesOutputReference;
}
export interface DataIonoscloudCubeServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#create DataIonoscloudCubeServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#default DataIonoscloudCubeServer#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#delete DataIonoscloudCubeServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server#update DataIonoscloudCubeServer#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudCubeServerTimeoutsToTerraform(struct?: DataIonoscloudCubeServerTimeoutsOutputReference | DataIonoscloudCubeServerTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudCubeServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudCubeServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudCubeServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server ionoscloud_cube_server}
*/
export declare class DataIonoscloudCubeServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_cube_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/cube_server ionoscloud_cube_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudCubeServerConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudCubeServerConfig);
    get availabilityZone(): string;
    get bootCdrom(): string;
    get bootImage(): string;
    get bootVolume(): string;
    private _cdroms;
    get cdroms(): DataIonoscloudCubeServerCdromsList;
    get cpuFamily(): string;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nics;
    get nics(): DataIonoscloudCubeServerNicsList;
    private _templateUuid?;
    get templateUuid(): string;
    set templateUuid(value: string);
    resetTemplateUuid(): void;
    get templateUuidInput(): string | undefined;
    get token(): string;
    get vmState(): string;
    private _volumes;
    get volumes(): DataIonoscloudCubeServerVolumesList;
    private _timeouts;
    get timeouts(): DataIonoscloudCubeServerTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudCubeServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudCubeServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
