import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudDataplatformClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#id DataIonoscloudDataplatformCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#name DataIonoscloudDataplatformCluster#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#partial_match DataIonoscloudDataplatformCluster#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#timeouts DataIonoscloudDataplatformCluster#timeouts}
    */
    readonly timeouts?: DataIonoscloudDataplatformClusterTimeouts;
}
export interface DataIonoscloudDataplatformClusterConfigClusters {
}
export declare function dataIonoscloudDataplatformClusterConfigClustersToTerraform(struct?: DataIonoscloudDataplatformClusterConfigClusters): any;
export declare class DataIonoscloudDataplatformClusterConfigClustersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformClusterConfigClusters | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterConfigClusters | undefined);
    private _cluster;
    get cluster(): cdktf.StringMap;
    get name(): string;
}
export declare class DataIonoscloudDataplatformClusterConfigClustersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformClusterConfigClustersOutputReference;
}
export interface DataIonoscloudDataplatformClusterConfigContexts {
}
export declare function dataIonoscloudDataplatformClusterConfigContextsToTerraform(struct?: DataIonoscloudDataplatformClusterConfigContexts): any;
export declare class DataIonoscloudDataplatformClusterConfigContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformClusterConfigContexts | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterConfigContexts | undefined);
    private _context;
    get context(): cdktf.StringMap;
    get name(): string;
}
export declare class DataIonoscloudDataplatformClusterConfigContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformClusterConfigContextsOutputReference;
}
export interface DataIonoscloudDataplatformClusterConfigUsers {
}
export declare function dataIonoscloudDataplatformClusterConfigUsersToTerraform(struct?: DataIonoscloudDataplatformClusterConfigUsers): any;
export declare class DataIonoscloudDataplatformClusterConfigUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformClusterConfigUsers | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterConfigUsers | undefined);
    get name(): string;
    private _user;
    get user(): cdktf.StringMap;
}
export declare class DataIonoscloudDataplatformClusterConfigUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformClusterConfigUsersOutputReference;
}
export interface DataIonoscloudDataplatformClusterConfigA {
}
export declare function dataIonoscloudDataplatformClusterConfigAToTerraform(struct?: DataIonoscloudDataplatformClusterConfigA): any;
export declare class DataIonoscloudDataplatformClusterConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformClusterConfigA | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterConfigA | undefined);
    get apiVersion(): string;
    private _clusters;
    get clusters(): DataIonoscloudDataplatformClusterConfigClustersList;
    private _contexts;
    get contexts(): DataIonoscloudDataplatformClusterConfigContextsList;
    get currentContext(): string;
    get kind(): string;
    private _users;
    get users(): DataIonoscloudDataplatformClusterConfigUsersList;
}
export declare class DataIonoscloudDataplatformClusterConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformClusterConfigAOutputReference;
}
export interface DataIonoscloudDataplatformClusterMaintenanceWindow {
}
export declare function dataIonoscloudDataplatformClusterMaintenanceWindowToTerraform(struct?: DataIonoscloudDataplatformClusterMaintenanceWindow): any;
export declare class DataIonoscloudDataplatformClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformClusterMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudDataplatformClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformClusterMaintenanceWindowOutputReference;
}
export interface DataIonoscloudDataplatformClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#create DataIonoscloudDataplatformCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#default DataIonoscloudDataplatformCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#delete DataIonoscloudDataplatformCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster#update DataIonoscloudDataplatformCluster#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudDataplatformClusterTimeoutsToTerraform(struct?: DataIonoscloudDataplatformClusterTimeoutsOutputReference | DataIonoscloudDataplatformClusterTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudDataplatformClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudDataplatformClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudDataplatformClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster ionoscloud_dataplatform_cluster}
*/
export declare class DataIonoscloudDataplatformCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_dataplatform_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_cluster ionoscloud_dataplatform_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudDataplatformClusterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudDataplatformClusterConfig);
    get caCrt(): string;
    private _config;
    get config(): DataIonoscloudDataplatformClusterConfigAList;
    get datacenterId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kubeConfig(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudDataplatformClusterMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get server(): string;
    private _userTokens;
    get userTokens(): cdktf.StringMap;
    get version(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudDataplatformClusterTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudDataplatformClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudDataplatformClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
