import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudDataplatformNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * The UUID of an existing Dataplatform cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#cluster_id DataIonoscloudDataplatformNodePool#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#id DataIonoscloudDataplatformNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of your node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#name DataIonoscloudDataplatformNodePool#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#partial_match DataIonoscloudDataplatformNodePool#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#timeouts DataIonoscloudDataplatformNodePool#timeouts}
    */
    readonly timeouts?: DataIonoscloudDataplatformNodePoolTimeouts;
}
export interface DataIonoscloudDataplatformNodePoolMaintenanceWindow {
}
export declare function dataIonoscloudDataplatformNodePoolMaintenanceWindowToTerraform(struct?: DataIonoscloudDataplatformNodePoolMaintenanceWindow): any;
export declare class DataIonoscloudDataplatformNodePoolMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformNodePoolMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudDataplatformNodePoolMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudDataplatformNodePoolMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformNodePoolMaintenanceWindowOutputReference;
}
export interface DataIonoscloudDataplatformNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#create DataIonoscloudDataplatformNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#default DataIonoscloudDataplatformNodePool#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#delete DataIonoscloudDataplatformNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool#update DataIonoscloudDataplatformNodePool#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudDataplatformNodePoolTimeoutsToTerraform(struct?: DataIonoscloudDataplatformNodePoolTimeoutsOutputReference | DataIonoscloudDataplatformNodePoolTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudDataplatformNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudDataplatformNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudDataplatformNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool ionoscloud_dataplatform_node_pool}
*/
export declare class DataIonoscloudDataplatformNodePool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_dataplatform_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pool ionoscloud_dataplatform_node_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudDataplatformNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudDataplatformNodePoolConfig);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get availabilityZone(): string;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get coresCount(): number;
    get cpuFamily(): string;
    get datacenterId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudDataplatformNodePoolMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nodeCount(): number;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get ramSize(): number;
    get storageSize(): number;
    get storageType(): string;
    get version(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudDataplatformNodePoolTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudDataplatformNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudDataplatformNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
