import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudDataplatformNodePoolsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The UUID of an existing Dataplatform cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#cluster_id DataIonoscloudDataplatformNodePools#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#id DataIonoscloudDataplatformNodePools#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of your node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#name DataIonoscloudDataplatformNodePools#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#partial_match DataIonoscloudDataplatformNodePools#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#timeouts DataIonoscloudDataplatformNodePools#timeouts}
    */
    readonly timeouts?: DataIonoscloudDataplatformNodePoolsTimeouts;
}
export interface DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindow {
}
export declare function dataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindowToTerraform(struct?: DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindow): any;
export declare class DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindowOutputReference;
}
export interface DataIonoscloudDataplatformNodePoolsNodePools {
}
export declare function dataIonoscloudDataplatformNodePoolsNodePoolsToTerraform(struct?: DataIonoscloudDataplatformNodePoolsNodePools): any;
export declare class DataIonoscloudDataplatformNodePoolsNodePoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDataplatformNodePoolsNodePools | undefined;
    set internalValue(value: DataIonoscloudDataplatformNodePoolsNodePools | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get availabilityZone(): string;
    get coresCount(): number;
    get cpuFamily(): string;
    get datacenterId(): string;
    get id(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudDataplatformNodePoolsNodePoolsMaintenanceWindowList;
    get name(): string;
    get nodeCount(): number;
    get ramSize(): number;
    get storageSize(): number;
    get storageType(): string;
    get version(): string;
}
export declare class DataIonoscloudDataplatformNodePoolsNodePoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDataplatformNodePoolsNodePoolsOutputReference;
}
export interface DataIonoscloudDataplatformNodePoolsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#create DataIonoscloudDataplatformNodePools#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#default DataIonoscloudDataplatformNodePools#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#delete DataIonoscloudDataplatformNodePools#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools#update DataIonoscloudDataplatformNodePools#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudDataplatformNodePoolsTimeoutsToTerraform(struct?: DataIonoscloudDataplatformNodePoolsTimeoutsOutputReference | DataIonoscloudDataplatformNodePoolsTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudDataplatformNodePoolsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudDataplatformNodePoolsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudDataplatformNodePoolsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools ionoscloud_dataplatform_node_pools}
*/
export declare class DataIonoscloudDataplatformNodePools extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_dataplatform_node_pools";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_node_pools ionoscloud_dataplatform_node_pools} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudDataplatformNodePoolsConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudDataplatformNodePoolsConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodePools;
    get nodePools(): DataIonoscloudDataplatformNodePoolsNodePoolsList;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudDataplatformNodePoolsTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudDataplatformNodePoolsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudDataplatformNodePoolsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
