import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudDataplatformVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#id DataIonoscloudDataplatformVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#timeouts DataIonoscloudDataplatformVersions#timeouts}
    */
    readonly timeouts?: DataIonoscloudDataplatformVersionsTimeouts;
}
export interface DataIonoscloudDataplatformVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#create DataIonoscloudDataplatformVersions#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#default DataIonoscloudDataplatformVersions#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#delete DataIonoscloudDataplatformVersions#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions#update DataIonoscloudDataplatformVersions#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudDataplatformVersionsTimeoutsToTerraform(struct?: DataIonoscloudDataplatformVersionsTimeoutsOutputReference | DataIonoscloudDataplatformVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudDataplatformVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudDataplatformVersionsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudDataplatformVersionsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions ionoscloud_dataplatform_versions}
*/
export declare class DataIonoscloudDataplatformVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_dataplatform_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/dataplatform_versions ionoscloud_dataplatform_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudDataplatformVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudDataplatformVersionsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get versions(): string[];
    private _timeouts;
    get timeouts(): DataIonoscloudDataplatformVersionsTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudDataplatformVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudDataplatformVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
