import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudMongoTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique ID of the template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#id DataIonoscloudMongoTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#name DataIonoscloudMongoTemplate#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using the name filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#partial_match DataIonoscloudMongoTemplate#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#timeouts DataIonoscloudMongoTemplate#timeouts}
    */
    readonly timeouts?: DataIonoscloudMongoTemplateTimeouts;
}
export interface DataIonoscloudMongoTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#create DataIonoscloudMongoTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#default DataIonoscloudMongoTemplate#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#delete DataIonoscloudMongoTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template#update DataIonoscloudMongoTemplate#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudMongoTemplateTimeoutsToTerraform(struct?: DataIonoscloudMongoTemplateTimeoutsOutputReference | DataIonoscloudMongoTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudMongoTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudMongoTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudMongoTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template ionoscloud_mongo_template}
*/
export declare class DataIonoscloudMongoTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_mongo_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_template ionoscloud_mongo_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudMongoTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudMongoTemplateConfig);
    get cores(): number;
    get edition(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get ram(): number;
    get storageSize(): number;
    private _timeouts;
    get timeouts(): DataIonoscloudMongoTemplateTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudMongoTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudMongoTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
