import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudPgBackupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#cluster_id DataIonoscloudPgBackups#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#id DataIonoscloudPgBackups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#timeouts DataIonoscloudPgBackups#timeouts}
    */
    readonly timeouts?: DataIonoscloudPgBackupsTimeouts;
}
export interface DataIonoscloudPgBackupsClusterBackupsMetadata {
}
export declare function dataIonoscloudPgBackupsClusterBackupsMetadataToTerraform(struct?: DataIonoscloudPgBackupsClusterBackupsMetadata): any;
export declare class DataIonoscloudPgBackupsClusterBackupsMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgBackupsClusterBackupsMetadata | undefined;
    set internalValue(value: DataIonoscloudPgBackupsClusterBackupsMetadata | undefined);
    get createdDate(): string;
}
export declare class DataIonoscloudPgBackupsClusterBackupsMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgBackupsClusterBackupsMetadataOutputReference;
}
export interface DataIonoscloudPgBackupsClusterBackups {
}
export declare function dataIonoscloudPgBackupsClusterBackupsToTerraform(struct?: DataIonoscloudPgBackupsClusterBackups): any;
export declare class DataIonoscloudPgBackupsClusterBackupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgBackupsClusterBackups | undefined;
    set internalValue(value: DataIonoscloudPgBackupsClusterBackups | undefined);
    get clusterId(): string;
    get earliestRecoveryTargetTime(): string;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get location(): string;
    private _metadata;
    get metadata(): DataIonoscloudPgBackupsClusterBackupsMetadataList;
    get size(): number;
    get type(): string;
    get version(): string;
}
export declare class DataIonoscloudPgBackupsClusterBackupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgBackupsClusterBackupsOutputReference;
}
export interface DataIonoscloudPgBackupsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#create DataIonoscloudPgBackups#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#default DataIonoscloudPgBackups#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#delete DataIonoscloudPgBackups#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups#update DataIonoscloudPgBackups#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudPgBackupsTimeoutsToTerraform(struct?: DataIonoscloudPgBackupsTimeoutsOutputReference | DataIonoscloudPgBackupsTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudPgBackupsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudPgBackupsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudPgBackupsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups ionoscloud_pg_backups}
*/
export declare class DataIonoscloudPgBackups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_pg_backups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_backups ionoscloud_pg_backups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudPgBackupsConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudPgBackupsConfig);
    private _clusterBackups;
    get clusterBackups(): DataIonoscloudPgBackupsClusterBackupsList;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudPgBackupsTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudPgBackupsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudPgBackupsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
