import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#datacenter_id DataIonoscloudServer#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#id DataIonoscloudServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#name DataIonoscloudServer#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#template_uuid DataIonoscloudServer#template_uuid}
    */
    readonly templateUuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#type DataIonoscloudServer#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#timeouts DataIonoscloudServer#timeouts}
    */
    readonly timeouts?: DataIonoscloudServerTimeouts;
}
export interface DataIonoscloudServerCdroms {
}
export declare function dataIonoscloudServerCdromsToTerraform(struct?: DataIonoscloudServerCdroms): any;
export declare class DataIonoscloudServerCdromsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServerCdroms | undefined;
    set internalValue(value: DataIonoscloudServerCdroms | undefined);
    get cloudInit(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get cpuHotUnplug(): cdktf.IResolvable;
    get description(): string;
    get discScsiHotPlug(): cdktf.IResolvable;
    get discScsiHotUnplug(): cdktf.IResolvable;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get id(): string;
    get imageAliases(): string[];
    get imageType(): string;
    get licenceType(): string;
    get location(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get public(): cdktf.IResolvable;
    get ramHotPlug(): cdktf.IResolvable;
    get ramHotUnplug(): cdktf.IResolvable;
    get size(): number;
}
export declare class DataIonoscloudServerCdromsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServerCdromsOutputReference;
}
export interface DataIonoscloudServerLabels {
}
export declare function dataIonoscloudServerLabelsToTerraform(struct?: DataIonoscloudServerLabels): any;
export declare class DataIonoscloudServerLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServerLabels | undefined;
    set internalValue(value: DataIonoscloudServerLabels | undefined);
    get id(): string;
    get key(): string;
    get value(): string;
}
export declare class DataIonoscloudServerLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServerLabelsOutputReference;
}
export interface DataIonoscloudServerNicsFirewallRules {
}
export declare function dataIonoscloudServerNicsFirewallRulesToTerraform(struct?: DataIonoscloudServerNicsFirewallRules): any;
export declare class DataIonoscloudServerNicsFirewallRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServerNicsFirewallRules | undefined;
    set internalValue(value: DataIonoscloudServerNicsFirewallRules | undefined);
    get icmpCode(): number;
    get icmpType(): number;
    get id(): string;
    get name(): string;
    get portRangeEnd(): number;
    get portRangeStart(): number;
    get protocol(): string;
    get sourceIp(): string;
    get sourceMac(): string;
    get targetIp(): string;
    get type(): string;
}
export declare class DataIonoscloudServerNicsFirewallRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServerNicsFirewallRulesOutputReference;
}
export interface DataIonoscloudServerNics {
}
export declare function dataIonoscloudServerNicsToTerraform(struct?: DataIonoscloudServerNics): any;
export declare class DataIonoscloudServerNicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServerNics | undefined;
    set internalValue(value: DataIonoscloudServerNics | undefined);
    get deviceNumber(): number;
    get dhcp(): cdktf.IResolvable;
    get firewallActive(): cdktf.IResolvable;
    private _firewallRules;
    get firewallRules(): DataIonoscloudServerNicsFirewallRulesList;
    get firewallType(): string;
    get id(): string;
    get ips(): string[];
    get lan(): number;
    get mac(): string;
    get name(): string;
    get pciSlot(): number;
}
export declare class DataIonoscloudServerNicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServerNicsOutputReference;
}
export interface DataIonoscloudServerVolumes {
}
export declare function dataIonoscloudServerVolumesToTerraform(struct?: DataIonoscloudServerVolumes): any;
export declare class DataIonoscloudServerVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServerVolumes | undefined;
    set internalValue(value: DataIonoscloudServerVolumes | undefined);
    get availabilityZone(): string;
    get backupUnitId(): string;
    get bootServer(): string;
    get bus(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get id(): string;
    get imageName(): string;
    get imagePassword(): string;
    get licenceType(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    get size(): number;
    get sshKeys(): string[];
    get type(): string;
    get userData(): string;
}
export declare class DataIonoscloudServerVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServerVolumesOutputReference;
}
export interface DataIonoscloudServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#create DataIonoscloudServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#default DataIonoscloudServer#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#delete DataIonoscloudServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/server#update DataIonoscloudServer#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudServerTimeoutsToTerraform(struct?: DataIonoscloudServerTimeoutsOutputReference | DataIonoscloudServerTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/server ionoscloud_server}
*/
export declare class DataIonoscloudServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/server ionoscloud_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudServerConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudServerConfig);
    get availabilityZone(): string;
    get bootCdrom(): string;
    get bootImage(): string;
    get bootVolume(): string;
    private _cdroms;
    get cdroms(): DataIonoscloudServerCdromsList;
    get cores(): number;
    get cpuFamily(): string;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): DataIonoscloudServerLabelsList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nics;
    get nics(): DataIonoscloudServerNicsList;
    get ram(): number;
    private _templateUuid?;
    get templateUuid(): string;
    set templateUuid(value: string);
    resetTemplateUuid(): void;
    get templateUuidInput(): string | undefined;
    get token(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get vmState(): string;
    private _volumes;
    get volumes(): DataIonoscloudServerVolumesList;
    private _timeouts;
    get timeouts(): DataIonoscloudServerTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
