import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataplatformNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Key-value pairs attached to node pool resource as [Kubernetes annotations](https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#annotations DataplatformNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The availability zone of the virtual datacenter region where the node pool resources should be provisioned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#availability_zone DataplatformNodePool#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * The UUID of an existing Dataplatform cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#cluster_id DataplatformNodePool#cluster_id}
    */
    readonly clusterId: string;
    /**
    * The number of CPU cores per node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#cores_count DataplatformNodePool#cores_count}
    */
    readonly coresCount?: number;
    /**
    * A valid CPU family name or `AUTO` if the platform shall choose the best fitting option. Available CPU architectures can be retrieved from the datacenter resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#cpu_family DataplatformNodePool#cpu_family}
    */
    readonly cpuFamily?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#id DataplatformNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key-value pairs attached to the node pool resource as [Kubernetes labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#labels DataplatformNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of your cluster. Must be 63 characters or less and must be empty or begin and end with an alphanumeric character ([a-z0-9A-Z]). It can contain dashes (-), underscores (_), dots (.), and alphanumerics in-between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#name DataplatformNodePool#name}
    */
    readonly name: string;
    /**
    * The number of nodes that make up the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#node_count DataplatformNodePool#node_count}
    */
    readonly nodeCount: number;
    /**
    * The RAM size for one node in MB. Must be set in multiples of 1024 MB, with a minimum size is of 2048 MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#ram_size DataplatformNodePool#ram_size}
    */
    readonly ramSize?: number;
    /**
    * The size of the volume in GB. The size must be greater than 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#storage_size DataplatformNodePool#storage_size}
    */
    readonly storageSize?: number;
    /**
    * The type of hardware for the volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#storage_type DataplatformNodePool#storage_type}
    */
    readonly storageType?: string;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#maintenance_window DataplatformNodePool#maintenance_window}
    */
    readonly maintenanceWindow?: DataplatformNodePoolMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#timeouts DataplatformNodePool#timeouts}
    */
    readonly timeouts?: DataplatformNodePoolTimeouts;
}
export interface DataplatformNodePoolMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#day_of_the_week DataplatformNodePool#day_of_the_week}
    */
    readonly dayOfTheWeek: string;
    /**
    * Time at which the maintenance should start.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#time DataplatformNodePool#time}
    */
    readonly time: string;
}
export declare function dataplatformNodePoolMaintenanceWindowToTerraform(struct?: DataplatformNodePoolMaintenanceWindow | cdktf.IResolvable): any;
export declare class DataplatformNodePoolMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplatformNodePoolMaintenanceWindow | cdktf.IResolvable | undefined;
    set internalValue(value: DataplatformNodePoolMaintenanceWindow | cdktf.IResolvable | undefined);
    private _dayOfTheWeek?;
    get dayOfTheWeek(): string;
    set dayOfTheWeek(value: string);
    get dayOfTheWeekInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class DataplatformNodePoolMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataplatformNodePoolMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplatformNodePoolMaintenanceWindowOutputReference;
}
export interface DataplatformNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#create DataplatformNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#default DataplatformNodePool#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#delete DataplatformNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool#update DataplatformNodePool#update}
    */
    readonly update?: string;
}
export declare function dataplatformNodePoolTimeoutsToTerraform(struct?: DataplatformNodePoolTimeoutsOutputReference | DataplatformNodePoolTimeouts | cdktf.IResolvable): any;
export declare class DataplatformNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplatformNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataplatformNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool ionoscloud_dataplatform_node_pool}
*/
export declare class DataplatformNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_dataplatform_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/dataplatform_node_pool ionoscloud_dataplatform_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataplatformNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataplatformNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _coresCount?;
    get coresCount(): number;
    set coresCount(value: number);
    resetCoresCount(): void;
    get coresCountInput(): number | undefined;
    private _cpuFamily?;
    get cpuFamily(): string;
    set cpuFamily(value: string);
    resetCpuFamily(): void;
    get cpuFamilyInput(): string | undefined;
    get datacenterId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _ramSize?;
    get ramSize(): number;
    set ramSize(value: number);
    resetRamSize(): void;
    get ramSizeInput(): number | undefined;
    private _storageSize?;
    get storageSize(): number;
    set storageSize(value: number);
    resetStorageSize(): void;
    get storageSizeInput(): number | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    resetStorageType(): void;
    get storageTypeInput(): string | undefined;
    get version(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataplatformNodePoolMaintenanceWindowList;
    putMaintenanceWindow(value: DataplatformNodePoolMaintenanceWindow[] | cdktf.IResolvable): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): cdktf.IResolvable | DataplatformNodePoolMaintenanceWindow[] | undefined;
    private _timeouts;
    get timeouts(): DataplatformNodePoolTimeoutsOutputReference;
    putTimeouts(value: DataplatformNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataplatformNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
