import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface K8SClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access to the K8s API server is restricted to these CIDRs. Cluster-internal traffic is not affected by this restriction. If no allowlist is specified, access is not restricted. If an IP without subnet mask is provided, the default value will be used: 32 for IPv4 and 128 for IPv6.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#api_subnet_allow_list K8SCluster#api_subnet_allow_list}
    */
    readonly apiSubnetAllowList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#id K8SCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The desired kubernetes version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#k8s_version K8SCluster#k8s_version}
    */
    readonly k8SVersion?: string;
    /**
    * The desired name for the cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#name K8SCluster#name}
    */
    readonly name: string;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#maintenance_window K8SCluster#maintenance_window}
    */
    readonly maintenanceWindow?: K8SClusterMaintenanceWindow;
    /**
    * s3_buckets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#s3_buckets K8SCluster#s3_buckets}
    */
    readonly s3Buckets?: K8SClusterS3Buckets[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#timeouts K8SCluster#timeouts}
    */
    readonly timeouts?: K8SClusterTimeouts;
}
export interface K8SClusterMaintenanceWindow {
    /**
    * Day of the week when maintenance is allowed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#day_of_the_week K8SCluster#day_of_the_week}
    */
    readonly dayOfTheWeek: string;
    /**
    * A clock time in the day when maintenance is allowed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#time K8SCluster#time}
    */
    readonly time: string;
}
export declare function k8SClusterMaintenanceWindowToTerraform(struct?: K8SClusterMaintenanceWindowOutputReference | K8SClusterMaintenanceWindow): any;
export declare class K8SClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): K8SClusterMaintenanceWindow | undefined;
    set internalValue(value: K8SClusterMaintenanceWindow | undefined);
    private _dayOfTheWeek?;
    get dayOfTheWeek(): string;
    set dayOfTheWeek(value: string);
    get dayOfTheWeekInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface K8SClusterS3Buckets {
    /**
    * Name of the S3 bucket
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#name K8SCluster#name}
    */
    readonly name?: string;
}
export declare function k8SClusterS3BucketsToTerraform(struct?: K8SClusterS3Buckets | cdktf.IResolvable): any;
export declare class K8SClusterS3BucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): K8SClusterS3Buckets | cdktf.IResolvable | undefined;
    set internalValue(value: K8SClusterS3Buckets | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class K8SClusterS3BucketsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: K8SClusterS3Buckets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): K8SClusterS3BucketsOutputReference;
}
export interface K8SClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#create K8SCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#default K8SCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#delete K8SCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster#update K8SCluster#update}
    */
    readonly update?: string;
}
export declare function k8SClusterTimeoutsToTerraform(struct?: K8SClusterTimeoutsOutputReference | K8SClusterTimeouts | cdktf.IResolvable): any;
export declare class K8SClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): K8SClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: K8SClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster ionoscloud_k8s_cluster}
*/
export declare class K8SCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_k8s_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_cluster ionoscloud_k8s_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options K8SClusterConfig
    */
    constructor(scope: Construct, id: string, config: K8SClusterConfig);
    private _apiSubnetAllowList?;
    get apiSubnetAllowList(): string[];
    set apiSubnetAllowList(value: string[]);
    resetApiSubnetAllowList(): void;
    get apiSubnetAllowListInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SVersion?;
    get k8SVersion(): string;
    set k8SVersion(value: string);
    resetK8SVersion(): void;
    get k8SVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get viableNodePoolVersions(): string[];
    private _maintenanceWindow;
    get maintenanceWindow(): K8SClusterMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: K8SClusterMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): K8SClusterMaintenanceWindow | undefined;
    private _s3Buckets;
    get s3Buckets(): K8SClusterS3BucketsList;
    putS3Buckets(value: K8SClusterS3Buckets[] | cdktf.IResolvable): void;
    resetS3Buckets(): void;
    get s3BucketsInput(): cdktf.IResolvable | K8SClusterS3Buckets[] | undefined;
    private _timeouts;
    get timeouts(): K8SClusterTimeoutsOutputReference;
    putTimeouts(value: K8SClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | K8SClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
