import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MongoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#display_name MongoCluster#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#id MongoCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The total number of instances in the cluster (one master and n-1 standbys)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#instances MongoCluster#instances}
    */
    readonly instances: number;
    /**
    * The physical location where the cluster will be created. This will be where all of your instances live. Property cannot be modified after datacenter creation (disallowed in update requests). Available locations: de/txl, gb/lhr, es/vit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#location MongoCluster#location}
    */
    readonly location: string;
    /**
    * The MongoDB version of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#mongodb_version MongoCluster#mongodb_version}
    */
    readonly mongodbVersion: string;
    /**
    * The unique ID of the template, which specifies the number of cores, storage size, and memory. You cannot downgrade to a smaller template or minor edition (e.g. from business to playground).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#template_id MongoCluster#template_id}
    */
    readonly templateId: string;
    /**
    * connections block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#connections MongoCluster#connections}
    */
    readonly connections: MongoClusterConnections;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#credentials MongoCluster#credentials}
    */
    readonly credentials: MongoClusterCredentials;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#maintenance_window MongoCluster#maintenance_window}
    */
    readonly maintenanceWindow?: MongoClusterMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#timeouts MongoCluster#timeouts}
    */
    readonly timeouts?: MongoClusterTimeouts;
}
export interface MongoClusterConnections {
    /**
    * The list of IPs and subnet for your cluster.
            Note the following unavailable IP ranges:
            10.233.64.0/18
            10.233.0.0/18
            10.233.114.0/24
   example: [192.168.1.100/24, 192.168.1.101/24]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#cidr_list MongoCluster#cidr_list}
    */
    readonly cidrList: string[];
    /**
    * The datacenter to connect your cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#datacenter_id MongoCluster#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The LAN to connect your cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#lan_id MongoCluster#lan_id}
    */
    readonly lanId: string;
}
export declare function mongoClusterConnectionsToTerraform(struct?: MongoClusterConnectionsOutputReference | MongoClusterConnections): any;
export declare class MongoClusterConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoClusterConnections | undefined;
    set internalValue(value: MongoClusterConnections | undefined);
    private _cidrList?;
    get cidrList(): string[];
    set cidrList(value: string[]);
    get cidrListInput(): string[] | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _lanId?;
    get lanId(): string;
    set lanId(value: string);
    get lanIdInput(): string | undefined;
}
export interface MongoClusterCredentials {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#password MongoCluster#password}
    */
    readonly password: string;
    /**
    * the username for the initial mongoDB user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#username MongoCluster#username}
    */
    readonly username: string;
}
export declare function mongoClusterCredentialsToTerraform(struct?: MongoClusterCredentialsOutputReference | MongoClusterCredentials): any;
export declare class MongoClusterCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoClusterCredentials | undefined;
    set internalValue(value: MongoClusterCredentials | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface MongoClusterMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#day_of_the_week MongoCluster#day_of_the_week}
    */
    readonly dayOfTheWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#time MongoCluster#time}
    */
    readonly time: string;
}
export declare function mongoClusterMaintenanceWindowToTerraform(struct?: MongoClusterMaintenanceWindowOutputReference | MongoClusterMaintenanceWindow): any;
export declare class MongoClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoClusterMaintenanceWindow | undefined;
    set internalValue(value: MongoClusterMaintenanceWindow | undefined);
    private _dayOfTheWeek?;
    get dayOfTheWeek(): string;
    set dayOfTheWeek(value: string);
    get dayOfTheWeekInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface MongoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#create MongoCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#default MongoCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#delete MongoCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster#update MongoCluster#update}
    */
    readonly update?: string;
}
export declare function mongoClusterTimeoutsToTerraform(struct?: MongoClusterTimeoutsOutputReference | MongoClusterTimeouts | cdktf.IResolvable): any;
export declare class MongoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MongoClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster ionoscloud_mongo_cluster}
*/
export declare class MongoCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_mongo_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_cluster ionoscloud_mongo_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MongoClusterConfig
    */
    constructor(scope: Construct, id: string, config: MongoClusterConfig);
    get connectionString(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mongodbVersion?;
    get mongodbVersion(): string;
    set mongodbVersion(value: string);
    get mongodbVersionInput(): string | undefined;
    private _templateId?;
    get templateId(): string;
    set templateId(value: string);
    get templateIdInput(): string | undefined;
    private _connections;
    get connections(): MongoClusterConnectionsOutputReference;
    putConnections(value: MongoClusterConnections): void;
    get connectionsInput(): MongoClusterConnections | undefined;
    private _credentials;
    get credentials(): MongoClusterCredentialsOutputReference;
    putCredentials(value: MongoClusterCredentials): void;
    get credentialsInput(): MongoClusterCredentials | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): MongoClusterMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: MongoClusterMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): MongoClusterMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): MongoClusterTimeoutsOutputReference;
    putTimeouts(value: MongoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MongoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
