import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PgClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The S3 location where the backups will be stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#backup_location PgCluster#backup_location}
    */
    readonly backupLocation?: string;
    /**
    * The number of CPU cores per replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#cores PgCluster#cores}
    */
    readonly cores: number;
    /**
    * The friendly name of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#display_name PgCluster#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#id PgCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The total number of instances in the cluster (one master and n-1 standbys)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#instances PgCluster#instances}
    */
    readonly instances: number;
    /**
    * The physical location where the cluster will be created. This will be where all of your instances live. Property cannot be modified after datacenter creation (disallowed in update requests)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#location PgCluster#location}
    */
    readonly location: string;
    /**
    * The PostgreSQL version of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#postgres_version PgCluster#postgres_version}
    */
    readonly postgresVersion: string;
    /**
    * The amount of memory per instance in megabytes. Has to be a multiple of 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#ram PgCluster#ram}
    */
    readonly ram: number;
    /**
    * The amount of storage per instance in megabytes. Has to be a multiple of 2048.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#storage_size PgCluster#storage_size}
    */
    readonly storageSize: number;
    /**
    * The storage type used in your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#storage_type PgCluster#storage_type}
    */
    readonly storageType: string;
    /**
    * Represents different modes of replication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#synchronization_mode PgCluster#synchronization_mode}
    */
    readonly synchronizationMode: string;
    /**
    * connections block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#connections PgCluster#connections}
    */
    readonly connections?: PgClusterConnections;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#credentials PgCluster#credentials}
    */
    readonly credentials: PgClusterCredentials;
    /**
    * from_backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#from_backup PgCluster#from_backup}
    */
    readonly fromBackup?: PgClusterFromBackup;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#maintenance_window PgCluster#maintenance_window}
    */
    readonly maintenanceWindow?: PgClusterMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#timeouts PgCluster#timeouts}
    */
    readonly timeouts?: PgClusterTimeouts;
}
export interface PgClusterConnections {
    /**
    * The IP and subnet for the database.
            Note the following unavailable IP ranges:
            10.233.64.0/18
            10.233.0.0/18
            10.233.114.0/24
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#cidr PgCluster#cidr}
    */
    readonly cidr: string;
    /**
    * The datacenter to connect your cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#datacenter_id PgCluster#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The LAN to connect your cluster to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#lan_id PgCluster#lan_id}
    */
    readonly lanId: string;
}
export declare function pgClusterConnectionsToTerraform(struct?: PgClusterConnectionsOutputReference | PgClusterConnections): any;
export declare class PgClusterConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PgClusterConnections | undefined;
    set internalValue(value: PgClusterConnections | undefined);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    get cidrInput(): string | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _lanId?;
    get lanId(): string;
    set lanId(value: string);
    get lanIdInput(): string | undefined;
}
export interface PgClusterCredentials {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#password PgCluster#password}
    */
    readonly password: string;
    /**
    * the username for the initial postgres user. some system usernames are restricted (e.g. "postgres", "admin", "standby")
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#username PgCluster#username}
    */
    readonly username: string;
}
export declare function pgClusterCredentialsToTerraform(struct?: PgClusterCredentialsOutputReference | PgClusterCredentials): any;
export declare class PgClusterCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PgClusterCredentials | undefined;
    set internalValue(value: PgClusterCredentials | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface PgClusterFromBackup {
    /**
    * The unique ID of the backup you want to restore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#backup_id PgCluster#backup_id}
    */
    readonly backupId: string;
    /**
    *  If this value is supplied as ISO 8601 timestamp, the backup will be replayed up until the given timestamp. If empty, the backup will be applied completely.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#recovery_target_time PgCluster#recovery_target_time}
    */
    readonly recoveryTargetTime?: string;
}
export declare function pgClusterFromBackupToTerraform(struct?: PgClusterFromBackupOutputReference | PgClusterFromBackup): any;
export declare class PgClusterFromBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PgClusterFromBackup | undefined;
    set internalValue(value: PgClusterFromBackup | undefined);
    private _backupId?;
    get backupId(): string;
    set backupId(value: string);
    get backupIdInput(): string | undefined;
    private _recoveryTargetTime?;
    get recoveryTargetTime(): string;
    set recoveryTargetTime(value: string);
    resetRecoveryTargetTime(): void;
    get recoveryTargetTimeInput(): string | undefined;
}
export interface PgClusterMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#day_of_the_week PgCluster#day_of_the_week}
    */
    readonly dayOfTheWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#time PgCluster#time}
    */
    readonly time: string;
}
export declare function pgClusterMaintenanceWindowToTerraform(struct?: PgClusterMaintenanceWindowOutputReference | PgClusterMaintenanceWindow): any;
export declare class PgClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PgClusterMaintenanceWindow | undefined;
    set internalValue(value: PgClusterMaintenanceWindow | undefined);
    private _dayOfTheWeek?;
    get dayOfTheWeek(): string;
    set dayOfTheWeek(value: string);
    get dayOfTheWeekInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface PgClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#create PgCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#default PgCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#delete PgCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster#update PgCluster#update}
    */
    readonly update?: string;
}
export declare function pgClusterTimeoutsToTerraform(struct?: PgClusterTimeoutsOutputReference | PgClusterTimeouts | cdktf.IResolvable): any;
export declare class PgClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PgClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PgClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster ionoscloud_pg_cluster}
*/
export declare class PgCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_pg_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/pg_cluster ionoscloud_pg_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PgClusterConfig
    */
    constructor(scope: Construct, id: string, config: PgClusterConfig);
    private _backupLocation?;
    get backupLocation(): string;
    set backupLocation(value: string);
    resetBackupLocation(): void;
    get backupLocationInput(): string | undefined;
    private _cores?;
    get cores(): number;
    set cores(value: number);
    get coresInput(): number | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get dnsName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _postgresVersion?;
    get postgresVersion(): string;
    set postgresVersion(value: string);
    get postgresVersionInput(): string | undefined;
    private _ram?;
    get ram(): number;
    set ram(value: number);
    get ramInput(): number | undefined;
    private _storageSize?;
    get storageSize(): number;
    set storageSize(value: number);
    get storageSizeInput(): number | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    get storageTypeInput(): string | undefined;
    private _synchronizationMode?;
    get synchronizationMode(): string;
    set synchronizationMode(value: string);
    get synchronizationModeInput(): string | undefined;
    private _connections;
    get connections(): PgClusterConnectionsOutputReference;
    putConnections(value: PgClusterConnections): void;
    resetConnections(): void;
    get connectionsInput(): PgClusterConnections | undefined;
    private _credentials;
    get credentials(): PgClusterCredentialsOutputReference;
    putCredentials(value: PgClusterCredentials): void;
    get credentialsInput(): PgClusterCredentials | undefined;
    private _fromBackup;
    get fromBackup(): PgClusterFromBackupOutputReference;
    putFromBackup(value: PgClusterFromBackup): void;
    resetFromBackup(): void;
    get fromBackupInput(): PgClusterFromBackup | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): PgClusterMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: PgClusterMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): PgClusterMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): PgClusterTimeoutsOutputReference;
    putTimeouts(value: PgClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PgClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
