var Canopy;(()=>{var __webpack_modules__={978:module=>{eval("class BraidClient {\n  constructor (...endpoint) {\n    if (endpoint === '.') {\n      endpoint = window.location\n    }\n    this.endpoint = endpoint\n    this.initialReconnectDelay = 1000\n    this.currentReconnectDelay = this.initialReconnectDelay\n    this.maxReconnectDelay = 16000\n\n    this.subscribe = this.subscribe.bind(this)\n    this.publish = this.publish.bind(this)\n  }\n\n  currentState () {\n    return fetch(this.endpoint, {\n      credentials: 'same-origin',\n      headers: {\n        accept: 'application/json'\n      }\n    })\n      .then(response => response.json())\n      .then(data => {\n        return data\n      })\n  }\n\n  subscribe (handler) {\n    const reconnect = () => {\n      console.log(`Reconnecting to braid at: ${this.endpoint}`)\n      setTimeout(() => {\n        if (this.currentReconnectDelay < this.maxReconnectDelay) {\n          this.currentReconnectDelay *= 2\n        }\n        this.subscribe(handler)\n      }, this.currentReconnectDelay + Math.floor(Math.random() * 3000))\n    }\n\n    fetch(this.endpoint, {\n      headers: {\n        credentials: 'same-origin',\n        subscribe: 'keep-alive'\n      }\n    }).then(response => {\n      const reader = response.body.getReader()\n      const decoder = new TextDecoder('utf-8')\n      let buffer = ''\n      reader.read().then(function processText ({ done, value }) {\n        if (done) {\n          console.log('BRAID: end of stream')\n          return\n        }\n        buffer += decoder.decode(value)\n        const headers = {}\n        const patchParts = buffer.split('\\n\\n')\n        patchParts[0].split('\\n').forEach(header => {\n          const headerName = header.slice(0, header.indexOf(':')).toLowerCase()\n          const headerValue = header.slice(header.indexOf(':') + 1)\n          headers[headerName] = headerValue\n        })\n        if (Number(headers['content-length']) === patchParts[1].length) {\n          buffer = ''\n          const range = headers['content-range'].split('=')[1]\n          const body = JSON.parse(patchParts[1])\n          console.log('BRAID: patch received: ', range, body)\n          handler(range, body)\n        }\n        return reader.read().then(processText)\n      }).catch(err => {\n        console.error('BRAID:', err)\n        reconnect()\n      })\n    }).catch(err => {\n      console.error('BRAID:', err)\n      reconnect()\n    })\n  }\n\n  publish (range, body) {\n    const patch = JSON.stringify(body)\n    fetch(this.endpoint, {\n      method: 'PUT',\n      headers: {\n        credentials: 'same-origin',\n        patches: 1\n      },\n      body: `Content-Length: ${patch.length}\nContent-Range: json=${range}\n\n${patch}`\n    }).then(() => {\n      console.log('BRAID: patch sent: ', range, body)\n    })\n  }\n}\n\nmodule.exports = BraidClient\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9DYW5vcHkvLi4vQnJhaWQtY2xpZW50LmpzL2luZGV4LmpzP2FmN2MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQOztBQUVBO0FBQ0E7QUFDQSwrQ0FBK0MsY0FBYztBQUM3RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsZ0RBQWdELGNBQWM7QUFDOUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQSxPQUFPO0FBQ1AsS0FBSztBQUNMO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1AsK0JBQStCO0FBQy9CLHNCQUFzQjs7QUFFdEIsRUFBRSxNQUFNO0FBQ1IsS0FBSztBQUNMO0FBQ0EsS0FBSztBQUNMO0FBQ0E7O0FBRUEiLCJmaWxlIjoiOTc4LmpzIiwic291cmNlc0NvbnRlbnQiOlsiY2xhc3MgQnJhaWRDbGllbnQge1xuICBjb25zdHJ1Y3RvciAoLi4uZW5kcG9pbnQpIHtcbiAgICBpZiAoZW5kcG9pbnQgPT09ICcuJykge1xuICAgICAgZW5kcG9pbnQgPSB3aW5kb3cubG9jYXRpb25cbiAgICB9XG4gICAgdGhpcy5lbmRwb2ludCA9IGVuZHBvaW50XG4gICAgdGhpcy5pbml0aWFsUmVjb25uZWN0RGVsYXkgPSAxMDAwXG4gICAgdGhpcy5jdXJyZW50UmVjb25uZWN0RGVsYXkgPSB0aGlzLmluaXRpYWxSZWNvbm5lY3REZWxheVxuICAgIHRoaXMubWF4UmVjb25uZWN0RGVsYXkgPSAxNjAwMFxuXG4gICAgdGhpcy5zdWJzY3JpYmUgPSB0aGlzLnN1YnNjcmliZS5iaW5kKHRoaXMpXG4gICAgdGhpcy5wdWJsaXNoID0gdGhpcy5wdWJsaXNoLmJpbmQodGhpcylcbiAgfVxuXG4gIGN1cnJlbnRTdGF0ZSAoKSB7XG4gICAgcmV0dXJuIGZldGNoKHRoaXMuZW5kcG9pbnQsIHtcbiAgICAgIGNyZWRlbnRpYWxzOiAnc2FtZS1vcmlnaW4nLFxuICAgICAgaGVhZGVyczoge1xuICAgICAgICBhY2NlcHQ6ICdhcHBsaWNhdGlvbi9qc29uJ1xuICAgICAgfVxuICAgIH0pXG4gICAgICAudGhlbihyZXNwb25zZSA9PiByZXNwb25zZS5qc29uKCkpXG4gICAgICAudGhlbihkYXRhID0+IHtcbiAgICAgICAgcmV0dXJuIGRhdGFcbiAgICAgIH0pXG4gIH1cblxuICBzdWJzY3JpYmUgKGhhbmRsZXIpIHtcbiAgICBjb25zdCByZWNvbm5lY3QgPSAoKSA9PiB7XG4gICAgICBjb25zb2xlLmxvZyhgUmVjb25uZWN0aW5nIHRvIGJyYWlkIGF0OiAke3RoaXMuZW5kcG9pbnR9YClcbiAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICBpZiAodGhpcy5jdXJyZW50UmVjb25uZWN0RGVsYXkgPCB0aGlzLm1heFJlY29ubmVjdERlbGF5KSB7XG4gICAgICAgICAgdGhpcy5jdXJyZW50UmVjb25uZWN0RGVsYXkgKj0gMlxuICAgICAgICB9XG4gICAgICAgIHRoaXMuc3Vic2NyaWJlKGhhbmRsZXIpXG4gICAgICB9LCB0aGlzLmN1cnJlbnRSZWNvbm5lY3REZWxheSArIE1hdGguZmxvb3IoTWF0aC5yYW5kb20oKSAqIDMwMDApKVxuICAgIH1cblxuICAgIGZldGNoKHRoaXMuZW5kcG9pbnQsIHtcbiAgICAgIGhlYWRlcnM6IHtcbiAgICAgICAgY3JlZGVudGlhbHM6ICdzYW1lLW9yaWdpbicsXG4gICAgICAgIHN1YnNjcmliZTogJ2tlZXAtYWxpdmUnXG4gICAgICB9XG4gICAgfSkudGhlbihyZXNwb25zZSA9PiB7XG4gICAgICBjb25zdCByZWFkZXIgPSByZXNwb25zZS5ib2R5LmdldFJlYWRlcigpXG4gICAgICBjb25zdCBkZWNvZGVyID0gbmV3IFRleHREZWNvZGVyKCd1dGYtOCcpXG4gICAgICBsZXQgYnVmZmVyID0gJydcbiAgICAgIHJlYWRlci5yZWFkKCkudGhlbihmdW5jdGlvbiBwcm9jZXNzVGV4dCAoeyBkb25lLCB2YWx1ZSB9KSB7XG4gICAgICAgIGlmIChkb25lKSB7XG4gICAgICAgICAgY29uc29sZS5sb2coJ0JSQUlEOiBlbmQgb2Ygc3RyZWFtJylcbiAgICAgICAgICByZXR1cm5cbiAgICAgICAgfVxuICAgICAgICBidWZmZXIgKz0gZGVjb2Rlci5kZWNvZGUodmFsdWUpXG4gICAgICAgIGNvbnN0IGhlYWRlcnMgPSB7fVxuICAgICAgICBjb25zdCBwYXRjaFBhcnRzID0gYnVmZmVyLnNwbGl0KCdcXG5cXG4nKVxuICAgICAgICBwYXRjaFBhcnRzWzBdLnNwbGl0KCdcXG4nKS5mb3JFYWNoKGhlYWRlciA9PiB7XG4gICAgICAgICAgY29uc3QgaGVhZGVyTmFtZSA9IGhlYWRlci5zbGljZSgwLCBoZWFkZXIuaW5kZXhPZignOicpKS50b0xvd2VyQ2FzZSgpXG4gICAgICAgICAgY29uc3QgaGVhZGVyVmFsdWUgPSBoZWFkZXIuc2xpY2UoaGVhZGVyLmluZGV4T2YoJzonKSArIDEpXG4gICAgICAgICAgaGVhZGVyc1toZWFkZXJOYW1lXSA9IGhlYWRlclZhbHVlXG4gICAgICAgIH0pXG4gICAgICAgIGlmIChOdW1iZXIoaGVhZGVyc1snY29udGVudC1sZW5ndGgnXSkgPT09IHBhdGNoUGFydHNbMV0ubGVuZ3RoKSB7XG4gICAgICAgICAgYnVmZmVyID0gJydcbiAgICAgICAgICBjb25zdCByYW5nZSA9IGhlYWRlcnNbJ2NvbnRlbnQtcmFuZ2UnXS5zcGxpdCgnPScpWzFdXG4gICAgICAgICAgY29uc3QgYm9keSA9IEpTT04ucGFyc2UocGF0Y2hQYXJ0c1sxXSlcbiAgICAgICAgICBjb25zb2xlLmxvZygnQlJBSUQ6IHBhdGNoIHJlY2VpdmVkOiAnLCByYW5nZSwgYm9keSlcbiAgICAgICAgICBoYW5kbGVyKHJhbmdlLCBib2R5KVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiByZWFkZXIucmVhZCgpLnRoZW4ocHJvY2Vzc1RleHQpXG4gICAgICB9KS5jYXRjaChlcnIgPT4ge1xuICAgICAgICBjb25zb2xlLmVycm9yKCdCUkFJRDonLCBlcnIpXG4gICAgICAgIHJlY29ubmVjdCgpXG4gICAgICB9KVxuICAgIH0pLmNhdGNoKGVyciA9PiB7XG4gICAgICBjb25zb2xlLmVycm9yKCdCUkFJRDonLCBlcnIpXG4gICAgICByZWNvbm5lY3QoKVxuICAgIH0pXG4gIH1cblxuICBwdWJsaXNoIChyYW5nZSwgYm9keSkge1xuICAgIGNvbnN0IHBhdGNoID0gSlNPTi5zdHJpbmdpZnkoYm9keSlcbiAgICBmZXRjaCh0aGlzLmVuZHBvaW50LCB7XG4gICAgICBtZXRob2Q6ICdQVVQnLFxuICAgICAgaGVhZGVyczoge1xuICAgICAgICBjcmVkZW50aWFsczogJ3NhbWUtb3JpZ2luJyxcbiAgICAgICAgcGF0Y2hlczogMVxuICAgICAgfSxcbiAgICAgIGJvZHk6IGBDb250ZW50LUxlbmd0aDogJHtwYXRjaC5sZW5ndGh9XG5Db250ZW50LVJhbmdlOiBqc29uPSR7cmFuZ2V9XG5cbiR7cGF0Y2h9YFxuICAgIH0pLnRoZW4oKCkgPT4ge1xuICAgICAgY29uc29sZS5sb2coJ0JSQUlEOiBwYXRjaCBzZW50OiAnLCByYW5nZSwgYm9keSlcbiAgICB9KVxuICB9XG59XG5cbm1vZHVsZS5leHBvcnRzID0gQnJhaWRDbGllbnRcbiJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///978\n")},757:module=>{eval("class MicropubClient {\n  constructor (endpoint, token) {\n    this.endpoint = endpoint\n    this.token = token\n    this.config = this.config.bind(this)\n    this.create = this.create.bind(this)\n  }\n\n  config () {\n    return fetch(this.endpoint + '?q=config', {\n      headers: {\n        accept: 'application/json',\n        authorization: `Bearer ${this.token}`,\n        'content-type': 'application/json'\n      }\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        return response.json().then(data => {\n          return data\n        })\n      }\n    })\n  }\n\n  search (query) {\n    return fetch(this.endpoint + `?q=source&search=${query}`, {\n      headers: {\n        accept: 'application/json',\n        authorization: `Bearer ${this.token}`\n      }\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        return response.json().then(data => {\n          return data\n        })\n      }\n    })\n  }\n\n  create (payload) {\n    return fetch(this.endpoint, {\n      method: 'POST',\n      headers: {\n        accept: 'application/json',\n        authorization: `Bearer ${this.token}`,\n        'content-type': 'application/json'\n      },\n      body: JSON.stringify(payload)\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        let permalink = response.headers.get('location')\n        if (permalink.startsWith('/')) {\n          permalink = 'https://make_absolute/' + permalink\n        }\n        return permalink\n      }\n    })\n  }\n\n  update (url, payload) {\n    payload.action = 'update'\n    payload.url = url\n    return fetch(this.endpoint, {\n      method: 'POST',\n      headers: {\n        accept: 'application/json',\n        authorization: `Bearer ${this.token}`,\n        'content-type': 'application/json'\n      },\n      body: JSON.stringify(payload)\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        console.log('UPDATED!')\n      }\n    })\n  }\n}\n\nclass MicrosubClient {\n  constructor (endpoint, token) {\n    this.endpoint = endpoint\n    this.token = token\n    this.followers = this.followers.bind(this)\n    this.follow = this.follow.bind(this)\n  }\n\n  followers (...channel) {\n    let requestUrl = this.endpoint + 'action=follow'\n    if (channel.length) {\n      requestUrl += `&channel=${channel[0]}`\n    }\n    return fetch(requestUrl).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        return response.json().then(data => {\n          return data\n        })\n      }\n    })\n  }\n\n  follow (url, ...channel) {\n    let body = `action=follow&url=${url}`\n    if (channel.length) {\n      body += `&channel=${channel[0]}`\n    }\n    fetch(this.endpoint, {\n      method: 'POST',\n      headers: { 'content-type': 'application/x-www-form-urlencoded' },\n      body: body\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        return response.json().then(data => {\n          return data\n        })\n      }\n    })\n  }\n\n  search (query, ...channel) {\n    let body = `action=search&query=${query}`\n    if (channel.length) {\n      body += `&channel=${channel[0]}`\n    }\n    return fetch(this.endpoint, {\n      method: 'POST',\n      headers: { 'content-type': 'application/x-www-form-urlencoded' },\n      body: body\n    }).then(response => {\n      if (response.status === 200 || response.status === 201) {\n        return response.json().then(data => {\n          return data\n        })\n      }\n    })\n  }\n}\n\nmodule.exports = {\n  MicropubClient: MicropubClient,\n  MicrosubClient: MicrosubClient\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///757\n")},922:function(module,__unused_webpack_exports,__webpack_require__){eval("const { MicropubClient } = __webpack_require__(757)\nconst BraidClient = __webpack_require__(978)\n// const roots = require('roots')\nconst _ = __webpack_require__(722)\n\nlet owner\nconst init = (ownerName) => {\n  owner = { name: ownerName }\n  return _\n}\n\n_.Micropub = MicropubClient\n_.BraidClient = BraidClient\n\n// theme\nconst contrast = shade => {\n  _('html').el.setAttribute('class', shade)\n  _.cookies('shade', shade, { expires: 365, path: '/', secure: true })\n}\nconst shade = _.cookies('shade')\nshade ? contrast(shade) : contrast('dark')\n\n// fragmentions\nconst upgradeFragmention = (quote) => {\n  let last\n  _('*').each(() => {\n    if (!this.innerHTML) {\n      return\n    }\n    if (this.innerHTML.search(quote) !== -1) {\n      last = this\n    }\n  })\n  if (last) {\n    const fragmention = escape(quote.replace(/ /g, '-'))\n    last.innerHTML = last.innerHTML.replace(quote,\n      `<span class=fragmention id=\"#$${fragmention}\">$${quote}</span>`)\n    window.location.hash = '##' + fragmention\n  }\n}\n\n// turn a hyperlink into a button that loads the target page in-place\nconst handleLink = ev => {\n  let link = ev.target\n  while (link.tagName !== 'A') {\n    link = link.parentNode\n  }\n  const origin = window.location.href.split('/').splice(0, 3).join('/')\n  const url = link.href\n  // XXX console.log(link)\n  // XXX console.log(origin)\n  // XXX console.log(url)\n  if (url.indexOf(origin) === -1) { // different origin, use native\n    return\n  }\n  ev.preventDefault()\n  console.log('update pane')\n\n  // XXX if (url.indexOf('web+action') === 0) { // web actions\n  // XXX   this.addEventListener('click', ev => {\n  // XXX     if (ev.ctrlKey) {\n  // XXX       return\n  // XXX     }\n  // XXX     // ev.preventDefault()\n  // XXX     // WEBACTION = true\n  // XXX     return\n  // XXX   })\n  // XXX   return // use native\n  // XXX }\n\n  // if (url.indexOf('#') > -1) { // same origin, contains fragment identifier\n  //   const urlParts = url.split('#')\n  //   const currentUrlParts = window.location.href.split('#')\n  //   if (urlParts[0] === currentUrlParts[0]) { // same page\n  //     return // use native\n  //   }\n  //   // different page\n  //   // XXX console.log(url_parts, current_url_parts)\n  // }\n  // a.addEventListener('click', (ev) => {\n  //   alert('asd')\n  //   // if (ev.ctrlKey) {\n  //   //   return\n  //   // }\n  //   ev.preventDefault()\n  //   // history.replaceState({ scroll: window.pageYOffset }, 'title',\n  //   //   window.location)\n  //   // updateArticle(url, 0)\n  //   // history.pushState({ scroll: 0 }, 'title', url)\n  // })\n}\n\n// TODO back button when coming back from different origin or same page hash\n// TODO progress indicator\n// TODO timeouts, retries\nconst updateArticle = (url, scroll) => {\n  _('#loading').style.display = 'block'\n  fetch(url, {\n    'X-Chromeless': '1'\n  }).then(response => {\n    // TODO executeUnloadScripts()\n\n    const dom = new DOMParser().parseFromString(response.text(), 'text/html')\n    const newElement = dom.querySelector('body > article')\n    const currentElement = _('body > div > article').el\n    currentElement.height = 0\n    newElement.appendAfter(currentElement)\n    currentElement.remove()\n\n    document.body.scrollTop = document.documentElement.scrollTop = scroll\n\n    _('body > div > article a:not(.breakout)').each(handleLink)\n    _('body > div > article script').each(() => {\n      if (this.src !== '') {\n        document.getElementsByTagName('head')[0].appendChild(this)\n      } else {\n        // TODO XXX FIXME eval(this.innerHTML)  // TODO FIXME\n      }\n    })\n    // TODO executeLoadScripts()\n    _.upgradeTimestamps()\n    // XXX bindWebActions()\n\n    const h1 = newElement.querySelector('h1')\n    let title = owner.name\n    if (h1) {\n      title = h1.textContent + '\\u2009\\u2014\\u2009' + title\n    }\n    window.document.title = title\n    _('#loading').el.style.display = 'none'\n  })\n}\n\n_.load(() => {\n  // TODO history.pushState({scroll: 0}, 'title', window.location)\n\n  // _('a:not(.breakout)').click(handleLink)\n  _.upgradeTimestamps()\n\n  // XXX was window.navigator\n  if (navigator.standalone && _('#signout').n) {\n    _('#signout').el.style.display = 'none'\n  }\n\n  const url = window.location.href\n  const fragmention = url.split('##')[1]\n  if (fragmention) {\n    upgradeFragmention(unescape(fragmention.replace(/-/g, ' ')))\n  }\n  const fragment = url.split('#')[1]\n  if (fragment) {\n    setTimeout(() => { window.location.hash = '#' + fragment }, 1000)\n  }\n  // _.mouseup(() => {\n  //   const selection = window.getSelection().toString()\n  //   if (selection.length) {\n  //     upgradeFragmention(selection)\n  //   }\n  // })\n\n  // _('body').el.innerHTML +=\n  //   `<p id=status><span class=disconnected></span></p>\n  //    <p style='margin-top:1em;position:absolute;text-\n  //    align:right;right:1em;top:0;z-index:9;'><small><a\n  //     class=breakout style='border:0;'\n  //    id=stylesheet_switcher>\n  //    <svg class=contrast-icon style=\"height: 14px; width: 16px;\">\n  //    <use xlink:href=\"/icons.svg#contrast-icon\"></use>\n  //    <svg></a></small></p>`\n  // _('#stylesheet_switcher').el.addEventListener('click', () => {\n  //   contrast({ light: 'dark', dark: 'light' }[_.cookies('shade')])\n  //   // this.innerHTML = shade + ' mode'\n  // })\n\n  // const blackout = document.createElement('div')\n  // blackout.setAttribute('id', 'blackout')\n  // document.body.appendChild(blackout)\n  // _('#blackout').el.style.display = 'none'\n})\n\n_.popstate(ev => {\n  if (ev.state === null) {\n    return\n  }\n  console.log('popping', ev.state)\n  updateArticle(window.location, ev.state.scroll)\n})\n\n// offline-mode\nconst updateOnlineStatus = ev => {\n  console.log('Device is ' + (navigator.onLine ? 'online' : 'offline'))\n  if (navigator.onLine) {\n    _('body').el.addClass('online').removeClass('offline')\n    if (window.syncAllPosts) {\n      console.log('syncing posts')\n      // TODO refreshSavedPosts()\n      // TODO syncAllPosts()\n    }\n  } else {\n    _('body').el.addClass('offline').removeClass('online')\n    if (window.refreshSavedPosts) {\n      console.log('loading posts')\n      // TODO refreshSavedPosts()\n    }\n  }\n}\n\n_.online(updateOnlineStatus)\n_.offline(updateOnlineStatus)\n\n_.error(ev => {\n  const { message, filename, lineno, colno, error } = ev\n  console.error(message, filename, lineno, colno, error)\n  // const debugClient = new BraidClient('/debug')\n  // debugClient.publish('error', 'log[-1:-1]', {\n  //   message: message,\n  //   filename: filename,\n  //   lineno: lineno,\n  //   colno: colno,\n  //   error: error\n  // })\n})\n\nmodule.exports = init\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///922\n")},722:(module,__unused_webpack_exports,__webpack_require__)=>{eval("const Cookies = __webpack_require__(839)\nconst { DateTime } = __webpack_require__(481)\n// const { nb60encode, nb60decode } = require('NewMath')\n\nconst _ = (selector) => {\n  const results = typeof selector === 'string'\n    ? document.querySelectorAll(selector)\n    : [selector]\n  // const results = Array.prototype.slice.call(nodes)\n  const items = {}\n  for (let i = 0; i < results.length; i++) {\n    items[i] = results[i]\n  }\n  items.el = items[0]\n  items.n = results.length\n  // items.splice = [].splice() // simulates an array FIXME\n  // items.each = callback => { nodes.forEach(callback, ) }\n  items.each = callback => {\n    for (let i = 0; i < results.length; i++) {\n      callback(results[i])\n    }\n  }\n  // for (let i = 0; i < results.length; i++) {\n  //   console.log(results[i])\n  //   results[i].addEventListener('click', () => { console.log('er') })\n  // }\n  // items.click = callback => {\n  //   for (let i = 0; i < results.length; i++) {\n  //     console.log(this.results[i], this)\n  //     this.results[i].addEventListener('click', () => { console.log('er') })\n  //     // callback.bind(nodes[i])\n  //     // callback(nodes[i])\n  //   }\n  // }\n  items.append = html => {\n    items.each(item => item.appendChild(_.el(html)))\n  }\n  items.click = callback => {\n    items.each(item => {\n      item.addEventListener('click', callback)\n    })\n  }\n  return items\n}\n\n_.cookies = Cookies\n// _.nb60encode = nb60encode\n// _.nb60decode = nb60decode\n_.dt = DateTime\n\n_.el = html => {\n  const template = document.createElement('template')\n  template.innerHTML = html.trim()\n  return template.content.firstChild\n}\n\n_.els = html => {\n  const template = document.createElement('template')\n  template.innerHTML = html\n  return template.content.childNodes\n}\n\nconst loadScripts = []\nconst unloadScripts = []\n_.load = handler => loadScripts.push(handler)\n_.unload = handler => unloadScripts.push(handler)\nconst executeLoadScripts = () => {\n  loadScripts.forEach(handler => handler())\n  loadScripts.length = 0\n}\nconst executeUnloadScripts = () => {\n  unloadScripts.forEach(handler => handler())\n  unloadScripts.length = 0\n}\ndocument.addEventListener('DOMContentLoaded', () => executeLoadScripts())\nwindow.addEventListener('beforeunload', () => {\n  executeUnloadScripts()\n})\n\n_.mouseup = handler => document.addEventListener('mouseup', handler)\n_.popstate = handler => window.addEventListener('popstate', handler)\n_.online = handler => window.addEventListener('online', handler)\n_.offline = handler => window.addEventListener('offline', handler)\n_.error = handler => window.addEventListener('error', handler)\n\n_.upgradeTimestamps = () => {\n  const pageLoad = DateTime.now()\n  _('time').each(item => {\n    item.setAttribute('title', item.innerHTML)\n    item.innerHTML = DateTime.fromISO(item.attributes.datetime.value)\n      .toRelative({ base: pageLoad })\n  })\n}\n\nmodule.exports = _\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///722\n")},839:(module,exports,__webpack_require__)=>{eval("var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!\n * JavaScript Cookie v2.2.1\n * https://github.com/js-cookie/js-cookie\n *\n * Copyright 2006, 2015 Klaus Hartl & Fagner Brack\n * Released under the MIT license\n */\n;(function (factory) {\n\tvar registeredInModuleLoader;\n\tif (true) {\n\t\t!(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?\n\t\t(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :\n\t\t__WEBPACK_AMD_DEFINE_FACTORY__),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n\t\tregisteredInModuleLoader = true;\n\t}\n\tif (true) {\n\t\tmodule.exports = factory();\n\t\tregisteredInModuleLoader = true;\n\t}\n\tif (!registeredInModuleLoader) {\n\t\tvar OldCookies = window.Cookies;\n\t\tvar api = window.Cookies = factory();\n\t\tapi.noConflict = function () {\n\t\t\twindow.Cookies = OldCookies;\n\t\t\treturn api;\n\t\t};\n\t}\n}(function () {\n\tfunction extend () {\n\t\tvar i = 0;\n\t\tvar result = {};\n\t\tfor (; i < arguments.length; i++) {\n\t\t\tvar attributes = arguments[ i ];\n\t\t\tfor (var key in attributes) {\n\t\t\t\tresult[key] = attributes[key];\n\t\t\t}\n\t\t}\n\t\treturn result;\n\t}\n\n\tfunction decode (s) {\n\t\treturn s.replace(/(%[0-9A-Z]{2})+/g, decodeURIComponent);\n\t}\n\n\tfunction init (converter) {\n\t\tfunction api() {}\n\n\t\tfunction set (key, value, attributes) {\n\t\t\tif (typeof document === 'undefined') {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tattributes = extend({\n\t\t\t\tpath: '/'\n\t\t\t}, api.defaults, attributes);\n\n\t\t\tif (typeof attributes.expires === 'number') {\n\t\t\t\tattributes.expires = new Date(new Date() * 1 + attributes.expires * 864e+5);\n\t\t\t}\n\n\t\t\t// We're using \"expires\" because \"max-age\" is not supported by IE\n\t\t\tattributes.expires = attributes.expires ? attributes.expires.toUTCString() : '';\n\n\t\t\ttry {\n\t\t\t\tvar result = JSON.stringify(value);\n\t\t\t\tif (/^[\\{\\[]/.test(result)) {\n\t\t\t\t\tvalue = result;\n\t\t\t\t}\n\t\t\t} catch (e) {}\n\n\t\t\tvalue = converter.write ?\n\t\t\t\tconverter.write(value, key) :\n\t\t\t\tencodeURIComponent(String(value))\n\t\t\t\t\t.replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g, decodeURIComponent);\n\n\t\t\tkey = encodeURIComponent(String(key))\n\t\t\t\t.replace(/%(23|24|26|2B|5E|60|7C)/g, decodeURIComponent)\n\t\t\t\t.replace(/[\\(\\)]/g, escape);\n\n\t\t\tvar stringifiedAttributes = '';\n\t\t\tfor (var attributeName in attributes) {\n\t\t\t\tif (!attributes[attributeName]) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t\tstringifiedAttributes += '; ' + attributeName;\n\t\t\t\tif (attributes[attributeName] === true) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// Considers RFC 6265 section 5.2:\n\t\t\t\t// ...\n\t\t\t\t// 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n\t\t\t\t//     character:\n\t\t\t\t// Consume the characters of the unparsed-attributes up to,\n\t\t\t\t// not including, the first %x3B (\";\") character.\n\t\t\t\t// ...\n\t\t\t\tstringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n\t\t\t}\n\n\t\t\treturn (document.cookie = key + '=' + value + stringifiedAttributes);\n\t\t}\n\n\t\tfunction get (key, json) {\n\t\t\tif (typeof document === 'undefined') {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar jar = {};\n\t\t\t// To prevent the for loop in the first place assign an empty array\n\t\t\t// in case there are no cookies at all.\n\t\t\tvar cookies = document.cookie ? document.cookie.split('; ') : [];\n\t\t\tvar i = 0;\n\n\t\t\tfor (; i < cookies.length; i++) {\n\t\t\t\tvar parts = cookies[i].split('=');\n\t\t\t\tvar cookie = parts.slice(1).join('=');\n\n\t\t\t\tif (!json && cookie.charAt(0) === '\"') {\n\t\t\t\t\tcookie = cookie.slice(1, -1);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tvar name = decode(parts[0]);\n\t\t\t\t\tcookie = (converter.read || converter)(cookie, name) ||\n\t\t\t\t\t\tdecode(cookie);\n\n\t\t\t\t\tif (json) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tcookie = JSON.parse(cookie);\n\t\t\t\t\t\t} catch (e) {}\n\t\t\t\t\t}\n\n\t\t\t\t\tjar[name] = cookie;\n\n\t\t\t\t\tif (key === name) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t} catch (e) {}\n\t\t\t}\n\n\t\t\treturn key ? jar[key] : jar;\n\t\t}\n\n\t\tapi.set = set;\n\t\tapi.get = function (key) {\n\t\t\treturn get(key, false /* read as raw */);\n\t\t};\n\t\tapi.getJSON = function (key) {\n\t\t\treturn get(key, true /* read as json */);\n\t\t};\n\t\tapi.remove = function (key, attributes) {\n\t\t\tset(key, '', extend(attributes, {\n\t\t\t\texpires: -1\n\t\t\t}));\n\t\t};\n\n\t\tapi.defaults = {};\n\n\t\tapi.withConverter = init;\n\n\t\treturn api;\n\t}\n\n\treturn init(function () {});\n}));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///839\n")},481:(__unused_webpack_module,exports)=>{"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", ({ value: true }));\n\nfunction _defineProperties(target, props) {\n  for (var i = 0; i < props.length; i++) {\n    var descriptor = props[i];\n    descriptor.enumerable = descriptor.enumerable || false;\n    descriptor.configurable = true;\n    if ("value" in descriptor) descriptor.writable = true;\n    Object.defineProperty(target, descriptor.key, descriptor);\n  }\n}\n\nfunction _createClass(Constructor, protoProps, staticProps) {\n  if (protoProps) _defineProperties(Constructor.prototype, protoProps);\n  if (staticProps) _defineProperties(Constructor, staticProps);\n  return Constructor;\n}\n\nfunction _inheritsLoose(subClass, superClass) {\n  subClass.prototype = Object.create(superClass.prototype);\n  subClass.prototype.constructor = subClass;\n  subClass.__proto__ = superClass;\n}\n\nfunction _getPrototypeOf(o) {\n  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {\n    return o.__proto__ || Object.getPrototypeOf(o);\n  };\n  return _getPrototypeOf(o);\n}\n\nfunction _setPrototypeOf(o, p) {\n  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {\n    o.__proto__ = p;\n    return o;\n  };\n\n  return _setPrototypeOf(o, p);\n}\n\nfunction _isNativeReflectConstruct() {\n  if (typeof Reflect === "undefined" || !Reflect.construct) return false;\n  if (Reflect.construct.sham) return false;\n  if (typeof Proxy === "function") return true;\n\n  try {\n    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));\n    return true;\n  } catch (e) {\n    return false;\n  }\n}\n\nfunction _construct(Parent, args, Class) {\n  if (_isNativeReflectConstruct()) {\n    _construct = Reflect.construct;\n  } else {\n    _construct = function _construct(Parent, args, Class) {\n      var a = [null];\n      a.push.apply(a, args);\n      var Constructor = Function.bind.apply(Parent, a);\n      var instance = new Constructor();\n      if (Class) _setPrototypeOf(instance, Class.prototype);\n      return instance;\n    };\n  }\n\n  return _construct.apply(null, arguments);\n}\n\nfunction _isNativeFunction(fn) {\n  return Function.toString.call(fn).indexOf("[native code]") !== -1;\n}\n\nfunction _wrapNativeSuper(Class) {\n  var _cache = typeof Map === "function" ? new Map() : undefined;\n\n  _wrapNativeSuper = function _wrapNativeSuper(Class) {\n    if (Class === null || !_isNativeFunction(Class)) return Class;\n\n    if (typeof Class !== "function") {\n      throw new TypeError("Super expression must either be null or a function");\n    }\n\n    if (typeof _cache !== "undefined") {\n      if (_cache.has(Class)) return _cache.get(Class);\n\n      _cache.set(Class, Wrapper);\n    }\n\n    function Wrapper() {\n      return _construct(Class, arguments, _getPrototypeOf(this).constructor);\n    }\n\n    Wrapper.prototype = Object.create(Class.prototype, {\n      constructor: {\n        value: Wrapper,\n        enumerable: false,\n        writable: true,\n        configurable: true\n      }\n    });\n    return _setPrototypeOf(Wrapper, Class);\n  };\n\n  return _wrapNativeSuper(Class);\n}\n\nfunction _objectWithoutPropertiesLoose(source, excluded) {\n  if (source == null) return {};\n  var target = {};\n  var sourceKeys = Object.keys(source);\n  var key, i;\n\n  for (i = 0; i < sourceKeys.length; i++) {\n    key = sourceKeys[i];\n    if (excluded.indexOf(key) >= 0) continue;\n    target[key] = source[key];\n  }\n\n  return target;\n}\n\nfunction _unsupportedIterableToArray(o, minLen) {\n  if (!o) return;\n  if (typeof o === "string") return _arrayLikeToArray(o, minLen);\n  var n = Object.prototype.toString.call(o).slice(8, -1);\n  if (n === "Object" && o.constructor) n = o.constructor.name;\n  if (n === "Map" || n === "Set") return Array.from(n);\n  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);\n}\n\nfunction _arrayLikeToArray(arr, len) {\n  if (len == null || len > arr.length) len = arr.length;\n\n  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];\n\n  return arr2;\n}\n\nfunction _createForOfIteratorHelperLoose(o) {\n  var i = 0;\n\n  if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {\n    if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) return function () {\n      if (i >= o.length) return {\n        done: true\n      };\n      return {\n        done: false,\n        value: o[i++]\n      };\n    };\n    throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");\n  }\n\n  i = o[Symbol.iterator]();\n  return i.next.bind(i);\n}\n\n// these aren\'t really private, but nor are they really useful to document\n\n/**\n * @private\n */\nvar LuxonError = /*#__PURE__*/function (_Error) {\n  _inheritsLoose(LuxonError, _Error);\n\n  function LuxonError() {\n    return _Error.apply(this, arguments) || this;\n  }\n\n  return LuxonError;\n}( /*#__PURE__*/_wrapNativeSuper(Error));\n/**\n * @private\n */\n\n\nvar InvalidDateTimeError = /*#__PURE__*/function (_LuxonError) {\n  _inheritsLoose(InvalidDateTimeError, _LuxonError);\n\n  function InvalidDateTimeError(reason) {\n    return _LuxonError.call(this, "Invalid DateTime: " + reason.toMessage()) || this;\n  }\n\n  return InvalidDateTimeError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar InvalidIntervalError = /*#__PURE__*/function (_LuxonError2) {\n  _inheritsLoose(InvalidIntervalError, _LuxonError2);\n\n  function InvalidIntervalError(reason) {\n    return _LuxonError2.call(this, "Invalid Interval: " + reason.toMessage()) || this;\n  }\n\n  return InvalidIntervalError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar InvalidDurationError = /*#__PURE__*/function (_LuxonError3) {\n  _inheritsLoose(InvalidDurationError, _LuxonError3);\n\n  function InvalidDurationError(reason) {\n    return _LuxonError3.call(this, "Invalid Duration: " + reason.toMessage()) || this;\n  }\n\n  return InvalidDurationError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar ConflictingSpecificationError = /*#__PURE__*/function (_LuxonError4) {\n  _inheritsLoose(ConflictingSpecificationError, _LuxonError4);\n\n  function ConflictingSpecificationError() {\n    return _LuxonError4.apply(this, arguments) || this;\n  }\n\n  return ConflictingSpecificationError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar InvalidUnitError = /*#__PURE__*/function (_LuxonError5) {\n  _inheritsLoose(InvalidUnitError, _LuxonError5);\n\n  function InvalidUnitError(unit) {\n    return _LuxonError5.call(this, "Invalid unit " + unit) || this;\n  }\n\n  return InvalidUnitError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar InvalidArgumentError = /*#__PURE__*/function (_LuxonError6) {\n  _inheritsLoose(InvalidArgumentError, _LuxonError6);\n\n  function InvalidArgumentError() {\n    return _LuxonError6.apply(this, arguments) || this;\n  }\n\n  return InvalidArgumentError;\n}(LuxonError);\n/**\n * @private\n */\n\nvar ZoneIsAbstractError = /*#__PURE__*/function (_LuxonError7) {\n  _inheritsLoose(ZoneIsAbstractError, _LuxonError7);\n\n  function ZoneIsAbstractError() {\n    return _LuxonError7.call(this, "Zone is an abstract class") || this;\n  }\n\n  return ZoneIsAbstractError;\n}(LuxonError);\n\n/**\n * @private\n */\nvar n = "numeric",\n    s = "short",\n    l = "long";\nvar DATE_SHORT = {\n  year: n,\n  month: n,\n  day: n\n};\nvar DATE_MED = {\n  year: n,\n  month: s,\n  day: n\n};\nvar DATE_MED_WITH_WEEKDAY = {\n  year: n,\n  month: s,\n  day: n,\n  weekday: s\n};\nvar DATE_FULL = {\n  year: n,\n  month: l,\n  day: n\n};\nvar DATE_HUGE = {\n  year: n,\n  month: l,\n  day: n,\n  weekday: l\n};\nvar TIME_SIMPLE = {\n  hour: n,\n  minute: n\n};\nvar TIME_WITH_SECONDS = {\n  hour: n,\n  minute: n,\n  second: n\n};\nvar TIME_WITH_SHORT_OFFSET = {\n  hour: n,\n  minute: n,\n  second: n,\n  timeZoneName: s\n};\nvar TIME_WITH_LONG_OFFSET = {\n  hour: n,\n  minute: n,\n  second: n,\n  timeZoneName: l\n};\nvar TIME_24_SIMPLE = {\n  hour: n,\n  minute: n,\n  hour12: false\n};\n/**\n * {@link toLocaleString}; format like \'09:30:23\', always 24-hour.\n */\n\nvar TIME_24_WITH_SECONDS = {\n  hour: n,\n  minute: n,\n  second: n,\n  hour12: false\n};\n/**\n * {@link toLocaleString}; format like \'09:30:23 EDT\', always 24-hour.\n */\n\nvar TIME_24_WITH_SHORT_OFFSET = {\n  hour: n,\n  minute: n,\n  second: n,\n  hour12: false,\n  timeZoneName: s\n};\n/**\n * {@link toLocaleString}; format like \'09:30:23 Eastern Daylight Time\', always 24-hour.\n */\n\nvar TIME_24_WITH_LONG_OFFSET = {\n  hour: n,\n  minute: n,\n  second: n,\n  hour12: false,\n  timeZoneName: l\n};\n/**\n * {@link toLocaleString}; format like \'10/14/1983, 9:30 AM\'. Only 12-hour if the locale is.\n */\n\nvar DATETIME_SHORT = {\n  year: n,\n  month: n,\n  day: n,\n  hour: n,\n  minute: n\n};\n/**\n * {@link toLocaleString}; format like \'10/14/1983, 9:30:33 AM\'. Only 12-hour if the locale is.\n */\n\nvar DATETIME_SHORT_WITH_SECONDS = {\n  year: n,\n  month: n,\n  day: n,\n  hour: n,\n  minute: n,\n  second: n\n};\nvar DATETIME_MED = {\n  year: n,\n  month: s,\n  day: n,\n  hour: n,\n  minute: n\n};\nvar DATETIME_MED_WITH_SECONDS = {\n  year: n,\n  month: s,\n  day: n,\n  hour: n,\n  minute: n,\n  second: n\n};\nvar DATETIME_MED_WITH_WEEKDAY = {\n  year: n,\n  month: s,\n  day: n,\n  weekday: s,\n  hour: n,\n  minute: n\n};\nvar DATETIME_FULL = {\n  year: n,\n  month: l,\n  day: n,\n  hour: n,\n  minute: n,\n  timeZoneName: s\n};\nvar DATETIME_FULL_WITH_SECONDS = {\n  year: n,\n  month: l,\n  day: n,\n  hour: n,\n  minute: n,\n  second: n,\n  timeZoneName: s\n};\nvar DATETIME_HUGE = {\n  year: n,\n  month: l,\n  day: n,\n  weekday: l,\n  hour: n,\n  minute: n,\n  timeZoneName: l\n};\nvar DATETIME_HUGE_WITH_SECONDS = {\n  year: n,\n  month: l,\n  day: n,\n  weekday: l,\n  hour: n,\n  minute: n,\n  second: n,\n  timeZoneName: l\n};\n\n/*\n  This is just a junk drawer, containing anything used across multiple classes.\n  Because Luxon is small(ish), this should stay small and we won\'t worry about splitting\n  it up into, say, parsingUtil.js and basicUtil.js and so on. But they are divided up by feature area.\n*/\n/**\n * @private\n */\n// TYPES\n\nfunction isUndefined(o) {\n  return typeof o === "undefined";\n}\nfunction isNumber(o) {\n  return typeof o === "number";\n}\nfunction isInteger(o) {\n  return typeof o === "number" && o % 1 === 0;\n}\nfunction isString(o) {\n  return typeof o === "string";\n}\nfunction isDate(o) {\n  return Object.prototype.toString.call(o) === "[object Date]";\n} // CAPABILITIES\n\nfunction hasIntl() {\n  try {\n    return typeof Intl !== "undefined" && Intl.DateTimeFormat;\n  } catch (e) {\n    return false;\n  }\n}\nfunction hasFormatToParts() {\n  return !isUndefined(Intl.DateTimeFormat.prototype.formatToParts);\n}\nfunction hasRelative() {\n  try {\n    return typeof Intl !== "undefined" && !!Intl.RelativeTimeFormat;\n  } catch (e) {\n    return false;\n  }\n} // OBJECTS AND ARRAYS\n\nfunction maybeArray(thing) {\n  return Array.isArray(thing) ? thing : [thing];\n}\nfunction bestBy(arr, by, compare) {\n  if (arr.length === 0) {\n    return undefined;\n  }\n\n  return arr.reduce(function (best, next) {\n    var pair = [by(next), next];\n\n    if (!best) {\n      return pair;\n    } else if (compare(best[0], pair[0]) === best[0]) {\n      return best;\n    } else {\n      return pair;\n    }\n  }, null)[1];\n}\nfunction pick(obj, keys) {\n  return keys.reduce(function (a, k) {\n    a[k] = obj[k];\n    return a;\n  }, {});\n}\nfunction hasOwnProperty(obj, prop) {\n  return Object.prototype.hasOwnProperty.call(obj, prop);\n} // NUMBERS AND STRINGS\n\nfunction integerBetween(thing, bottom, top) {\n  return isInteger(thing) && thing >= bottom && thing <= top;\n} // x % n but takes the sign of n instead of x\n\nfunction floorMod(x, n) {\n  return x - n * Math.floor(x / n);\n}\nfunction padStart(input, n) {\n  if (n === void 0) {\n    n = 2;\n  }\n\n  var minus = input < 0 ? "-" : "";\n  var target = minus ? input * -1 : input;\n  var result;\n\n  if (target.toString().length < n) {\n    result = ("0".repeat(n) + target).slice(-n);\n  } else {\n    result = target.toString();\n  }\n\n  return "" + minus + result;\n}\nfunction parseInteger(string) {\n  if (isUndefined(string) || string === null || string === "") {\n    return undefined;\n  } else {\n    return parseInt(string, 10);\n  }\n}\nfunction parseMillis(fraction) {\n  // Return undefined (instead of 0) in these cases, where fraction is not set\n  if (isUndefined(fraction) || fraction === null || fraction === "") {\n    return undefined;\n  } else {\n    var f = parseFloat("0." + fraction) * 1000;\n    return Math.floor(f);\n  }\n}\nfunction roundTo(number, digits, towardZero) {\n  if (towardZero === void 0) {\n    towardZero = false;\n  }\n\n  var factor = Math.pow(10, digits),\n      rounder = towardZero ? Math.trunc : Math.round;\n  return rounder(number * factor) / factor;\n} // DATE BASICS\n\nfunction isLeapYear(year) {\n  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);\n}\nfunction daysInYear(year) {\n  return isLeapYear(year) ? 366 : 365;\n}\nfunction daysInMonth(year, month) {\n  var modMonth = floorMod(month - 1, 12) + 1,\n      modYear = year + (month - modMonth) / 12;\n\n  if (modMonth === 2) {\n    return isLeapYear(modYear) ? 29 : 28;\n  } else {\n    return [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][modMonth - 1];\n  }\n} // covert a calendar object to a local timestamp (epoch, but with the offset baked in)\n\nfunction objToLocalTS(obj) {\n  var d = Date.UTC(obj.year, obj.month - 1, obj.day, obj.hour, obj.minute, obj.second, obj.millisecond); // for legacy reasons, years between 0 and 99 are interpreted as 19XX; revert that\n\n  if (obj.year < 100 && obj.year >= 0) {\n    d = new Date(d);\n    d.setUTCFullYear(d.getUTCFullYear() - 1900);\n  }\n\n  return +d;\n}\nfunction weeksInWeekYear(weekYear) {\n  var p1 = (weekYear + Math.floor(weekYear / 4) - Math.floor(weekYear / 100) + Math.floor(weekYear / 400)) % 7,\n      last = weekYear - 1,\n      p2 = (last + Math.floor(last / 4) - Math.floor(last / 100) + Math.floor(last / 400)) % 7;\n  return p1 === 4 || p2 === 3 ? 53 : 52;\n}\nfunction untruncateYear(year) {\n  if (year > 99) {\n    return year;\n  } else return year > 60 ? 1900 + year : 2000 + year;\n} // PARSING\n\nfunction parseZoneInfo(ts, offsetFormat, locale, timeZone) {\n  if (timeZone === void 0) {\n    timeZone = null;\n  }\n\n  var date = new Date(ts),\n      intlOpts = {\n    hour12: false,\n    year: "numeric",\n    month: "2-digit",\n    day: "2-digit",\n    hour: "2-digit",\n    minute: "2-digit"\n  };\n\n  if (timeZone) {\n    intlOpts.timeZone = timeZone;\n  }\n\n  var modified = Object.assign({\n    timeZoneName: offsetFormat\n  }, intlOpts),\n      intl = hasIntl();\n\n  if (intl && hasFormatToParts()) {\n    var parsed = new Intl.DateTimeFormat(locale, modified).formatToParts(date).find(function (m) {\n      return m.type.toLowerCase() === "timezonename";\n    });\n    return parsed ? parsed.value : null;\n  } else if (intl) {\n    // this probably doesn\'t work for all locales\n    var without = new Intl.DateTimeFormat(locale, intlOpts).format(date),\n        included = new Intl.DateTimeFormat(locale, modified).format(date),\n        diffed = included.substring(without.length),\n        trimmed = diffed.replace(/^[, \\u200e]+/, "");\n    return trimmed;\n  } else {\n    return null;\n  }\n} // signedOffset(\'-5\', \'30\') -> -330\n\nfunction signedOffset(offHourStr, offMinuteStr) {\n  var offHour = parseInt(offHourStr, 10); // don\'t || this because we want to preserve -0\n\n  if (Number.isNaN(offHour)) {\n    offHour = 0;\n  }\n\n  var offMin = parseInt(offMinuteStr, 10) || 0,\n      offMinSigned = offHour < 0 || Object.is(offHour, -0) ? -offMin : offMin;\n  return offHour * 60 + offMinSigned;\n} // COERCION\n\nfunction asNumber(value) {\n  var numericValue = Number(value);\n  if (typeof value === "boolean" || value === "" || Number.isNaN(numericValue)) throw new InvalidArgumentError("Invalid unit value " + value);\n  return numericValue;\n}\nfunction normalizeObject(obj, normalizer, nonUnitKeys) {\n  var normalized = {};\n\n  for (var u in obj) {\n    if (hasOwnProperty(obj, u)) {\n      if (nonUnitKeys.indexOf(u) >= 0) continue;\n      var v = obj[u];\n      if (v === undefined || v === null) continue;\n      normalized[normalizer(u)] = asNumber(v);\n    }\n  }\n\n  return normalized;\n}\nfunction formatOffset(offset, format) {\n  var hours = Math.trunc(Math.abs(offset / 60)),\n      minutes = Math.trunc(Math.abs(offset % 60)),\n      sign = offset >= 0 ? "+" : "-";\n\n  switch (format) {\n    case "short":\n      return "" + sign + padStart(hours, 2) + ":" + padStart(minutes, 2);\n\n    case "narrow":\n      return "" + sign + hours + (minutes > 0 ? ":" + minutes : "");\n\n    case "techie":\n      return "" + sign + padStart(hours, 2) + padStart(minutes, 2);\n\n    default:\n      throw new RangeError("Value format " + format + " is out of range for property format");\n  }\n}\nfunction timeObject(obj) {\n  return pick(obj, ["hour", "minute", "second", "millisecond"]);\n}\nvar ianaRegex = /[A-Za-z_+-]{1,256}(:?\\/[A-Za-z_+-]{1,256}(\\/[A-Za-z_+-]{1,256})?)?/;\n\nfunction stringify(obj) {\n  return JSON.stringify(obj, Object.keys(obj).sort());\n}\n/**\n * @private\n */\n\n\nvar monthsLong = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];\nvar monthsShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];\nvar monthsNarrow = ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"];\nfunction months(length) {\n  switch (length) {\n    case "narrow":\n      return monthsNarrow;\n\n    case "short":\n      return monthsShort;\n\n    case "long":\n      return monthsLong;\n\n    case "numeric":\n      return ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];\n\n    case "2-digit":\n      return ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];\n\n    default:\n      return null;\n  }\n}\nvar weekdaysLong = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];\nvar weekdaysShort = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];\nvar weekdaysNarrow = ["M", "T", "W", "T", "F", "S", "S"];\nfunction weekdays(length) {\n  switch (length) {\n    case "narrow":\n      return weekdaysNarrow;\n\n    case "short":\n      return weekdaysShort;\n\n    case "long":\n      return weekdaysLong;\n\n    case "numeric":\n      return ["1", "2", "3", "4", "5", "6", "7"];\n\n    default:\n      return null;\n  }\n}\nvar meridiems = ["AM", "PM"];\nvar erasLong = ["Before Christ", "Anno Domini"];\nvar erasShort = ["BC", "AD"];\nvar erasNarrow = ["B", "A"];\nfunction eras(length) {\n  switch (length) {\n    case "narrow":\n      return erasNarrow;\n\n    case "short":\n      return erasShort;\n\n    case "long":\n      return erasLong;\n\n    default:\n      return null;\n  }\n}\nfunction meridiemForDateTime(dt) {\n  return meridiems[dt.hour < 12 ? 0 : 1];\n}\nfunction weekdayForDateTime(dt, length) {\n  return weekdays(length)[dt.weekday - 1];\n}\nfunction monthForDateTime(dt, length) {\n  return months(length)[dt.month - 1];\n}\nfunction eraForDateTime(dt, length) {\n  return eras(length)[dt.year < 0 ? 0 : 1];\n}\nfunction formatRelativeTime(unit, count, numeric, narrow) {\n  if (numeric === void 0) {\n    numeric = "always";\n  }\n\n  if (narrow === void 0) {\n    narrow = false;\n  }\n\n  var units = {\n    years: ["year", "yr."],\n    quarters: ["quarter", "qtr."],\n    months: ["month", "mo."],\n    weeks: ["week", "wk."],\n    days: ["day", "day", "days"],\n    hours: ["hour", "hr."],\n    minutes: ["minute", "min."],\n    seconds: ["second", "sec."]\n  };\n  var lastable = ["hours", "minutes", "seconds"].indexOf(unit) === -1;\n\n  if (numeric === "auto" && lastable) {\n    var isDay = unit === "days";\n\n    switch (count) {\n      case 1:\n        return isDay ? "tomorrow" : "next " + units[unit][0];\n\n      case -1:\n        return isDay ? "yesterday" : "last " + units[unit][0];\n\n      case 0:\n        return isDay ? "today" : "this " + units[unit][0];\n\n    }\n  }\n\n  var isInPast = Object.is(count, -0) || count < 0,\n      fmtValue = Math.abs(count),\n      singular = fmtValue === 1,\n      lilUnits = units[unit],\n      fmtUnit = narrow ? singular ? lilUnits[1] : lilUnits[2] || lilUnits[1] : singular ? units[unit][0] : unit;\n  return isInPast ? fmtValue + " " + fmtUnit + " ago" : "in " + fmtValue + " " + fmtUnit;\n}\nfunction formatString(knownFormat) {\n  // these all have the offsets removed because we don\'t have access to them\n  // without all the intl stuff this is backfilling\n  var filtered = pick(knownFormat, ["weekday", "era", "year", "month", "day", "hour", "minute", "second", "timeZoneName", "hour12"]),\n      key = stringify(filtered),\n      dateTimeHuge = "EEEE, LLLL d, yyyy, h:mm a";\n\n  switch (key) {\n    case stringify(DATE_SHORT):\n      return "M/d/yyyy";\n\n    case stringify(DATE_MED):\n      return "LLL d, yyyy";\n\n    case stringify(DATE_MED_WITH_WEEKDAY):\n      return "EEE, LLL d, yyyy";\n\n    case stringify(DATE_FULL):\n      return "LLLL d, yyyy";\n\n    case stringify(DATE_HUGE):\n      return "EEEE, LLLL d, yyyy";\n\n    case stringify(TIME_SIMPLE):\n      return "h:mm a";\n\n    case stringify(TIME_WITH_SECONDS):\n      return "h:mm:ss a";\n\n    case stringify(TIME_WITH_SHORT_OFFSET):\n      return "h:mm a";\n\n    case stringify(TIME_WITH_LONG_OFFSET):\n      return "h:mm a";\n\n    case stringify(TIME_24_SIMPLE):\n      return "HH:mm";\n\n    case stringify(TIME_24_WITH_SECONDS):\n      return "HH:mm:ss";\n\n    case stringify(TIME_24_WITH_SHORT_OFFSET):\n      return "HH:mm";\n\n    case stringify(TIME_24_WITH_LONG_OFFSET):\n      return "HH:mm";\n\n    case stringify(DATETIME_SHORT):\n      return "M/d/yyyy, h:mm a";\n\n    case stringify(DATETIME_MED):\n      return "LLL d, yyyy, h:mm a";\n\n    case stringify(DATETIME_FULL):\n      return "LLLL d, yyyy, h:mm a";\n\n    case stringify(DATETIME_HUGE):\n      return dateTimeHuge;\n\n    case stringify(DATETIME_SHORT_WITH_SECONDS):\n      return "M/d/yyyy, h:mm:ss a";\n\n    case stringify(DATETIME_MED_WITH_SECONDS):\n      return "LLL d, yyyy, h:mm:ss a";\n\n    case stringify(DATETIME_MED_WITH_WEEKDAY):\n      return "EEE, d LLL yyyy, h:mm a";\n\n    case stringify(DATETIME_FULL_WITH_SECONDS):\n      return "LLLL d, yyyy, h:mm:ss a";\n\n    case stringify(DATETIME_HUGE_WITH_SECONDS):\n      return "EEEE, LLLL d, yyyy, h:mm:ss a";\n\n    default:\n      return dateTimeHuge;\n  }\n}\n\nfunction stringifyTokens(splits, tokenToString) {\n  var s = "";\n\n  for (var _iterator = _createForOfIteratorHelperLoose(splits), _step; !(_step = _iterator()).done;) {\n    var token = _step.value;\n\n    if (token.literal) {\n      s += token.val;\n    } else {\n      s += tokenToString(token.val);\n    }\n  }\n\n  return s;\n}\n\nvar _macroTokenToFormatOpts = {\n  D: DATE_SHORT,\n  DD: DATE_MED,\n  DDD: DATE_FULL,\n  DDDD: DATE_HUGE,\n  t: TIME_SIMPLE,\n  tt: TIME_WITH_SECONDS,\n  ttt: TIME_WITH_SHORT_OFFSET,\n  tttt: TIME_WITH_LONG_OFFSET,\n  T: TIME_24_SIMPLE,\n  TT: TIME_24_WITH_SECONDS,\n  TTT: TIME_24_WITH_SHORT_OFFSET,\n  TTTT: TIME_24_WITH_LONG_OFFSET,\n  f: DATETIME_SHORT,\n  ff: DATETIME_MED,\n  fff: DATETIME_FULL,\n  ffff: DATETIME_HUGE,\n  F: DATETIME_SHORT_WITH_SECONDS,\n  FF: DATETIME_MED_WITH_SECONDS,\n  FFF: DATETIME_FULL_WITH_SECONDS,\n  FFFF: DATETIME_HUGE_WITH_SECONDS\n};\n/**\n * @private\n */\n\nvar Formatter = /*#__PURE__*/function () {\n  Formatter.create = function create(locale, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return new Formatter(locale, opts);\n  };\n\n  Formatter.parseFormat = function parseFormat(fmt) {\n    var current = null,\n        currentFull = "",\n        bracketed = false;\n    var splits = [];\n\n    for (var i = 0; i < fmt.length; i++) {\n      var c = fmt.charAt(i);\n\n      if (c === "\'") {\n        if (currentFull.length > 0) {\n          splits.push({\n            literal: bracketed,\n            val: currentFull\n          });\n        }\n\n        current = null;\n        currentFull = "";\n        bracketed = !bracketed;\n      } else if (bracketed) {\n        currentFull += c;\n      } else if (c === current) {\n        currentFull += c;\n      } else {\n        if (currentFull.length > 0) {\n          splits.push({\n            literal: false,\n            val: currentFull\n          });\n        }\n\n        currentFull = c;\n        current = c;\n      }\n    }\n\n    if (currentFull.length > 0) {\n      splits.push({\n        literal: bracketed,\n        val: currentFull\n      });\n    }\n\n    return splits;\n  };\n\n  Formatter.macroTokenToFormatOpts = function macroTokenToFormatOpts(token) {\n    return _macroTokenToFormatOpts[token];\n  };\n\n  function Formatter(locale, formatOpts) {\n    this.opts = formatOpts;\n    this.loc = locale;\n    this.systemLoc = null;\n  }\n\n  var _proto = Formatter.prototype;\n\n  _proto.formatWithSystemDefault = function formatWithSystemDefault(dt, opts) {\n    if (this.systemLoc === null) {\n      this.systemLoc = this.loc.redefaultToSystem();\n    }\n\n    var df = this.systemLoc.dtFormatter(dt, Object.assign({}, this.opts, opts));\n    return df.format();\n  };\n\n  _proto.formatDateTime = function formatDateTime(dt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var df = this.loc.dtFormatter(dt, Object.assign({}, this.opts, opts));\n    return df.format();\n  };\n\n  _proto.formatDateTimeParts = function formatDateTimeParts(dt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var df = this.loc.dtFormatter(dt, Object.assign({}, this.opts, opts));\n    return df.formatToParts();\n  };\n\n  _proto.resolvedOptions = function resolvedOptions(dt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var df = this.loc.dtFormatter(dt, Object.assign({}, this.opts, opts));\n    return df.resolvedOptions();\n  };\n\n  _proto.num = function num(n, p) {\n    if (p === void 0) {\n      p = 0;\n    }\n\n    // we get some perf out of doing this here, annoyingly\n    if (this.opts.forceSimple) {\n      return padStart(n, p);\n    }\n\n    var opts = Object.assign({}, this.opts);\n\n    if (p > 0) {\n      opts.padTo = p;\n    }\n\n    return this.loc.numberFormatter(opts).format(n);\n  };\n\n  _proto.formatDateTimeFromString = function formatDateTimeFromString(dt, fmt) {\n    var _this = this;\n\n    var knownEnglish = this.loc.listingMode() === "en",\n        useDateTimeFormatter = this.loc.outputCalendar && this.loc.outputCalendar !== "gregory" && hasFormatToParts(),\n        string = function string(opts, extract) {\n      return _this.loc.extract(dt, opts, extract);\n    },\n        formatOffset = function formatOffset(opts) {\n      if (dt.isOffsetFixed && dt.offset === 0 && opts.allowZ) {\n        return "Z";\n      }\n\n      return dt.isValid ? dt.zone.formatOffset(dt.ts, opts.format) : "";\n    },\n        meridiem = function meridiem() {\n      return knownEnglish ? meridiemForDateTime(dt) : string({\n        hour: "numeric",\n        hour12: true\n      }, "dayperiod");\n    },\n        month = function month(length, standalone) {\n      return knownEnglish ? monthForDateTime(dt, length) : string(standalone ? {\n        month: length\n      } : {\n        month: length,\n        day: "numeric"\n      }, "month");\n    },\n        weekday = function weekday(length, standalone) {\n      return knownEnglish ? weekdayForDateTime(dt, length) : string(standalone ? {\n        weekday: length\n      } : {\n        weekday: length,\n        month: "long",\n        day: "numeric"\n      }, "weekday");\n    },\n        maybeMacro = function maybeMacro(token) {\n      var formatOpts = Formatter.macroTokenToFormatOpts(token);\n\n      if (formatOpts) {\n        return _this.formatWithSystemDefault(dt, formatOpts);\n      } else {\n        return token;\n      }\n    },\n        era = function era(length) {\n      return knownEnglish ? eraForDateTime(dt, length) : string({\n        era: length\n      }, "era");\n    },\n        tokenToString = function tokenToString(token) {\n      // Where possible: http://cldr.unicode.org/translation/date-time-1/date-time#TOC-Standalone-vs.-Format-Styles\n      switch (token) {\n        // ms\n        case "S":\n          return _this.num(dt.millisecond);\n\n        case "u": // falls through\n\n        case "SSS":\n          return _this.num(dt.millisecond, 3);\n        // seconds\n\n        case "s":\n          return _this.num(dt.second);\n\n        case "ss":\n          return _this.num(dt.second, 2);\n        // minutes\n\n        case "m":\n          return _this.num(dt.minute);\n\n        case "mm":\n          return _this.num(dt.minute, 2);\n        // hours\n\n        case "h":\n          return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12);\n\n        case "hh":\n          return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12, 2);\n\n        case "H":\n          return _this.num(dt.hour);\n\n        case "HH":\n          return _this.num(dt.hour, 2);\n        // offset\n\n        case "Z":\n          // like +6\n          return formatOffset({\n            format: "narrow",\n            allowZ: _this.opts.allowZ\n          });\n\n        case "ZZ":\n          // like +06:00\n          return formatOffset({\n            format: "short",\n            allowZ: _this.opts.allowZ\n          });\n\n        case "ZZZ":\n          // like +0600\n          return formatOffset({\n            format: "techie",\n            allowZ: _this.opts.allowZ\n          });\n\n        case "ZZZZ":\n          // like EST\n          return dt.zone.offsetName(dt.ts, {\n            format: "short",\n            locale: _this.loc.locale\n          });\n\n        case "ZZZZZ":\n          // like Eastern Standard Time\n          return dt.zone.offsetName(dt.ts, {\n            format: "long",\n            locale: _this.loc.locale\n          });\n        // zone\n\n        case "z":\n          // like America/New_York\n          return dt.zoneName;\n        // meridiems\n\n        case "a":\n          return meridiem();\n        // dates\n\n        case "d":\n          return useDateTimeFormatter ? string({\n            day: "numeric"\n          }, "day") : _this.num(dt.day);\n\n        case "dd":\n          return useDateTimeFormatter ? string({\n            day: "2-digit"\n          }, "day") : _this.num(dt.day, 2);\n        // weekdays - standalone\n\n        case "c":\n          // like 1\n          return _this.num(dt.weekday);\n\n        case "ccc":\n          // like \'Tues\'\n          return weekday("short", true);\n\n        case "cccc":\n          // like \'Tuesday\'\n          return weekday("long", true);\n\n        case "ccccc":\n          // like \'T\'\n          return weekday("narrow", true);\n        // weekdays - format\n\n        case "E":\n          // like 1\n          return _this.num(dt.weekday);\n\n        case "EEE":\n          // like \'Tues\'\n          return weekday("short", false);\n\n        case "EEEE":\n          // like \'Tuesday\'\n          return weekday("long", false);\n\n        case "EEEEE":\n          // like \'T\'\n          return weekday("narrow", false);\n        // months - standalone\n\n        case "L":\n          // like 1\n          return useDateTimeFormatter ? string({\n            month: "numeric",\n            day: "numeric"\n          }, "month") : _this.num(dt.month);\n\n        case "LL":\n          // like 01, doesn\'t seem to work\n          return useDateTimeFormatter ? string({\n            month: "2-digit",\n            day: "numeric"\n          }, "month") : _this.num(dt.month, 2);\n\n        case "LLL":\n          // like Jan\n          return month("short", true);\n\n        case "LLLL":\n          // like January\n          return month("long", true);\n\n        case "LLLLL":\n          // like J\n          return month("narrow", true);\n        // months - format\n\n        case "M":\n          // like 1\n          return useDateTimeFormatter ? string({\n            month: "numeric"\n          }, "month") : _this.num(dt.month);\n\n        case "MM":\n          // like 01\n          return useDateTimeFormatter ? string({\n            month: "2-digit"\n          }, "month") : _this.num(dt.month, 2);\n\n        case "MMM":\n          // like Jan\n          return month("short", false);\n\n        case "MMMM":\n          // like January\n          return month("long", false);\n\n        case "MMMMM":\n          // like J\n          return month("narrow", false);\n        // years\n\n        case "y":\n          // like 2014\n          return useDateTimeFormatter ? string({\n            year: "numeric"\n          }, "year") : _this.num(dt.year);\n\n        case "yy":\n          // like 14\n          return useDateTimeFormatter ? string({\n            year: "2-digit"\n          }, "year") : _this.num(dt.year.toString().slice(-2), 2);\n\n        case "yyyy":\n          // like 0012\n          return useDateTimeFormatter ? string({\n            year: "numeric"\n          }, "year") : _this.num(dt.year, 4);\n\n        case "yyyyyy":\n          // like 000012\n          return useDateTimeFormatter ? string({\n            year: "numeric"\n          }, "year") : _this.num(dt.year, 6);\n        // eras\n\n        case "G":\n          // like AD\n          return era("short");\n\n        case "GG":\n          // like Anno Domini\n          return era("long");\n\n        case "GGGGG":\n          return era("narrow");\n\n        case "kk":\n          return _this.num(dt.weekYear.toString().slice(-2), 2);\n\n        case "kkkk":\n          return _this.num(dt.weekYear, 4);\n\n        case "W":\n          return _this.num(dt.weekNumber);\n\n        case "WW":\n          return _this.num(dt.weekNumber, 2);\n\n        case "o":\n          return _this.num(dt.ordinal);\n\n        case "ooo":\n          return _this.num(dt.ordinal, 3);\n\n        case "q":\n          // like 1\n          return _this.num(dt.quarter);\n\n        case "qq":\n          // like 01\n          return _this.num(dt.quarter, 2);\n\n        case "X":\n          return _this.num(Math.floor(dt.ts / 1000));\n\n        case "x":\n          return _this.num(dt.ts);\n\n        default:\n          return maybeMacro(token);\n      }\n    };\n\n    return stringifyTokens(Formatter.parseFormat(fmt), tokenToString);\n  };\n\n  _proto.formatDurationFromString = function formatDurationFromString(dur, fmt) {\n    var _this2 = this;\n\n    var tokenToField = function tokenToField(token) {\n      switch (token[0]) {\n        case "S":\n          return "millisecond";\n\n        case "s":\n          return "second";\n\n        case "m":\n          return "minute";\n\n        case "h":\n          return "hour";\n\n        case "d":\n          return "day";\n\n        case "M":\n          return "month";\n\n        case "y":\n          return "year";\n\n        default:\n          return null;\n      }\n    },\n        tokenToString = function tokenToString(lildur) {\n      return function (token) {\n        var mapped = tokenToField(token);\n\n        if (mapped) {\n          return _this2.num(lildur.get(mapped), token.length);\n        } else {\n          return token;\n        }\n      };\n    },\n        tokens = Formatter.parseFormat(fmt),\n        realTokens = tokens.reduce(function (found, _ref) {\n      var literal = _ref.literal,\n          val = _ref.val;\n      return literal ? found : found.concat(val);\n    }, []),\n        collapsed = dur.shiftTo.apply(dur, realTokens.map(tokenToField).filter(function (t) {\n      return t;\n    }));\n\n    return stringifyTokens(tokens, tokenToString(collapsed));\n  };\n\n  return Formatter;\n}();\n\nvar Invalid = /*#__PURE__*/function () {\n  function Invalid(reason, explanation) {\n    this.reason = reason;\n    this.explanation = explanation;\n  }\n\n  var _proto = Invalid.prototype;\n\n  _proto.toMessage = function toMessage() {\n    if (this.explanation) {\n      return this.reason + ": " + this.explanation;\n    } else {\n      return this.reason;\n    }\n  };\n\n  return Invalid;\n}();\n\n/**\n * @interface\n */\n\nvar Zone = /*#__PURE__*/function () {\n  function Zone() {}\n\n  var _proto = Zone.prototype;\n\n  /**\n   * Returns the offset\'s common name (such as EST) at the specified timestamp\n   * @abstract\n   * @param {number} ts - Epoch milliseconds for which to get the name\n   * @param {Object} opts - Options to affect the format\n   * @param {string} opts.format - What style of offset to return. Accepts \'long\' or \'short\'.\n   * @param {string} opts.locale - What locale to return the offset name in.\n   * @return {string}\n   */\n  _proto.offsetName = function offsetName(ts, opts) {\n    throw new ZoneIsAbstractError();\n  }\n  /**\n   * Returns the offset\'s value as a string\n   * @abstract\n   * @param {number} ts - Epoch milliseconds for which to get the offset\n   * @param {string} format - What style of offset to return.\n   *                          Accepts \'narrow\', \'short\', or \'techie\'. Returning \'+6\', \'+06:00\', or \'+0600\' respectively\n   * @return {string}\n   */\n  ;\n\n  _proto.formatOffset = function formatOffset(ts, format) {\n    throw new ZoneIsAbstractError();\n  }\n  /**\n   * Return the offset in minutes for this zone at the specified timestamp.\n   * @abstract\n   * @param {number} ts - Epoch milliseconds for which to compute the offset\n   * @return {number}\n   */\n  ;\n\n  _proto.offset = function offset(ts) {\n    throw new ZoneIsAbstractError();\n  }\n  /**\n   * Return whether this Zone is equal to another zone\n   * @abstract\n   * @param {Zone} otherZone - the zone to compare\n   * @return {boolean}\n   */\n  ;\n\n  _proto.equals = function equals(otherZone) {\n    throw new ZoneIsAbstractError();\n  }\n  /**\n   * Return whether this Zone is valid.\n   * @abstract\n   * @type {boolean}\n   */\n  ;\n\n  _createClass(Zone, [{\n    key: "type",\n\n    /**\n     * The type of zone\n     * @abstract\n     * @type {string}\n     */\n    get: function get() {\n      throw new ZoneIsAbstractError();\n    }\n    /**\n     * The name of this zone.\n     * @abstract\n     * @type {string}\n     */\n\n  }, {\n    key: "name",\n    get: function get() {\n      throw new ZoneIsAbstractError();\n    }\n    /**\n     * Returns whether the offset is known to be fixed for the whole year.\n     * @abstract\n     * @type {boolean}\n     */\n\n  }, {\n    key: "universal",\n    get: function get() {\n      throw new ZoneIsAbstractError();\n    }\n  }, {\n    key: "isValid",\n    get: function get() {\n      throw new ZoneIsAbstractError();\n    }\n  }]);\n\n  return Zone;\n}();\n\nvar singleton = null;\n/**\n * Represents the local zone for this JavaScript environment.\n * @implements {Zone}\n */\n\nvar LocalZone = /*#__PURE__*/function (_Zone) {\n  _inheritsLoose(LocalZone, _Zone);\n\n  function LocalZone() {\n    return _Zone.apply(this, arguments) || this;\n  }\n\n  var _proto = LocalZone.prototype;\n\n  /** @override **/\n  _proto.offsetName = function offsetName(ts, _ref) {\n    var format = _ref.format,\n        locale = _ref.locale;\n    return parseZoneInfo(ts, format, locale);\n  }\n  /** @override **/\n  ;\n\n  _proto.formatOffset = function formatOffset$1(ts, format) {\n    return formatOffset(this.offset(ts), format);\n  }\n  /** @override **/\n  ;\n\n  _proto.offset = function offset(ts) {\n    return -new Date(ts).getTimezoneOffset();\n  }\n  /** @override **/\n  ;\n\n  _proto.equals = function equals(otherZone) {\n    return otherZone.type === "local";\n  }\n  /** @override **/\n  ;\n\n  _createClass(LocalZone, [{\n    key: "type",\n\n    /** @override **/\n    get: function get() {\n      return "local";\n    }\n    /** @override **/\n\n  }, {\n    key: "name",\n    get: function get() {\n      if (hasIntl()) {\n        return new Intl.DateTimeFormat().resolvedOptions().timeZone;\n      } else return "local";\n    }\n    /** @override **/\n\n  }, {\n    key: "universal",\n    get: function get() {\n      return false;\n    }\n  }, {\n    key: "isValid",\n    get: function get() {\n      return true;\n    }\n  }], [{\n    key: "instance",\n\n    /**\n     * Get a singleton instance of the local zone\n     * @return {LocalZone}\n     */\n    get: function get() {\n      if (singleton === null) {\n        singleton = new LocalZone();\n      }\n\n      return singleton;\n    }\n  }]);\n\n  return LocalZone;\n}(Zone);\n\nvar matchingRegex = RegExp("^" + ianaRegex.source + "$");\nvar dtfCache = {};\n\nfunction makeDTF(zone) {\n  if (!dtfCache[zone]) {\n    dtfCache[zone] = new Intl.DateTimeFormat("en-US", {\n      hour12: false,\n      timeZone: zone,\n      year: "numeric",\n      month: "2-digit",\n      day: "2-digit",\n      hour: "2-digit",\n      minute: "2-digit",\n      second: "2-digit"\n    });\n  }\n\n  return dtfCache[zone];\n}\n\nvar typeToPos = {\n  year: 0,\n  month: 1,\n  day: 2,\n  hour: 3,\n  minute: 4,\n  second: 5\n};\n\nfunction hackyOffset(dtf, date) {\n  var formatted = dtf.format(date).replace(/\\u200E/g, ""),\n      parsed = /(\\d+)\\/(\\d+)\\/(\\d+),? (\\d+):(\\d+):(\\d+)/.exec(formatted),\n      fMonth = parsed[1],\n      fDay = parsed[2],\n      fYear = parsed[3],\n      fHour = parsed[4],\n      fMinute = parsed[5],\n      fSecond = parsed[6];\n  return [fYear, fMonth, fDay, fHour, fMinute, fSecond];\n}\n\nfunction partsOffset(dtf, date) {\n  var formatted = dtf.formatToParts(date),\n      filled = [];\n\n  for (var i = 0; i < formatted.length; i++) {\n    var _formatted$i = formatted[i],\n        type = _formatted$i.type,\n        value = _formatted$i.value,\n        pos = typeToPos[type];\n\n    if (!isUndefined(pos)) {\n      filled[pos] = parseInt(value, 10);\n    }\n  }\n\n  return filled;\n}\n\nvar ianaZoneCache = {};\n/**\n * A zone identified by an IANA identifier, like America/New_York\n * @implements {Zone}\n */\n\nvar IANAZone = /*#__PURE__*/function (_Zone) {\n  _inheritsLoose(IANAZone, _Zone);\n\n  /**\n   * @param {string} name - Zone name\n   * @return {IANAZone}\n   */\n  IANAZone.create = function create(name) {\n    if (!ianaZoneCache[name]) {\n      ianaZoneCache[name] = new IANAZone(name);\n    }\n\n    return ianaZoneCache[name];\n  }\n  /**\n   * Reset local caches. Should only be necessary in testing scenarios.\n   * @return {void}\n   */\n  ;\n\n  IANAZone.resetCache = function resetCache() {\n    ianaZoneCache = {};\n    dtfCache = {};\n  }\n  /**\n   * Returns whether the provided string is a valid specifier. This only checks the string\'s format, not that the specifier identifies a known zone; see isValidZone for that.\n   * @param {string} s - The string to check validity on\n   * @example IANAZone.isValidSpecifier("America/New_York") //=> true\n   * @example IANAZone.isValidSpecifier("Fantasia/Castle") //=> true\n   * @example IANAZone.isValidSpecifier("Sport~~blorp") //=> false\n   * @return {boolean}\n   */\n  ;\n\n  IANAZone.isValidSpecifier = function isValidSpecifier(s) {\n    return !!(s && s.match(matchingRegex));\n  }\n  /**\n   * Returns whether the provided string identifies a real zone\n   * @param {string} zone - The string to check\n   * @example IANAZone.isValidZone("America/New_York") //=> true\n   * @example IANAZone.isValidZone("Fantasia/Castle") //=> false\n   * @example IANAZone.isValidZone("Sport~~blorp") //=> false\n   * @return {boolean}\n   */\n  ;\n\n  IANAZone.isValidZone = function isValidZone(zone) {\n    try {\n      new Intl.DateTimeFormat("en-US", {\n        timeZone: zone\n      }).format();\n      return true;\n    } catch (e) {\n      return false;\n    }\n  } // Etc/GMT+8 -> -480\n\n  /** @ignore */\n  ;\n\n  IANAZone.parseGMTOffset = function parseGMTOffset(specifier) {\n    if (specifier) {\n      var match = specifier.match(/^Etc\\/GMT([+-]\\d{1,2})$/i);\n\n      if (match) {\n        return -60 * parseInt(match[1]);\n      }\n    }\n\n    return null;\n  };\n\n  function IANAZone(name) {\n    var _this;\n\n    _this = _Zone.call(this) || this;\n    /** @private **/\n\n    _this.zoneName = name;\n    /** @private **/\n\n    _this.valid = IANAZone.isValidZone(name);\n    return _this;\n  }\n  /** @override **/\n\n\n  var _proto = IANAZone.prototype;\n\n  /** @override **/\n  _proto.offsetName = function offsetName(ts, _ref) {\n    var format = _ref.format,\n        locale = _ref.locale;\n    return parseZoneInfo(ts, format, locale, this.name);\n  }\n  /** @override **/\n  ;\n\n  _proto.formatOffset = function formatOffset$1(ts, format) {\n    return formatOffset(this.offset(ts), format);\n  }\n  /** @override **/\n  ;\n\n  _proto.offset = function offset(ts) {\n    var date = new Date(ts),\n        dtf = makeDTF(this.name),\n        _ref2 = dtf.formatToParts ? partsOffset(dtf, date) : hackyOffset(dtf, date),\n        year = _ref2[0],\n        month = _ref2[1],\n        day = _ref2[2],\n        hour = _ref2[3],\n        minute = _ref2[4],\n        second = _ref2[5],\n        adjustedHour = hour === 24 ? 0 : hour;\n\n    var asUTC = objToLocalTS({\n      year: year,\n      month: month,\n      day: day,\n      hour: adjustedHour,\n      minute: minute,\n      second: second,\n      millisecond: 0\n    });\n    var asTS = +date;\n    var over = asTS % 1000;\n    asTS -= over >= 0 ? over : 1000 + over;\n    return (asUTC - asTS) / (60 * 1000);\n  }\n  /** @override **/\n  ;\n\n  _proto.equals = function equals(otherZone) {\n    return otherZone.type === "iana" && otherZone.name === this.name;\n  }\n  /** @override **/\n  ;\n\n  _createClass(IANAZone, [{\n    key: "type",\n    get: function get() {\n      return "iana";\n    }\n    /** @override **/\n\n  }, {\n    key: "name",\n    get: function get() {\n      return this.zoneName;\n    }\n    /** @override **/\n\n  }, {\n    key: "universal",\n    get: function get() {\n      return false;\n    }\n  }, {\n    key: "isValid",\n    get: function get() {\n      return this.valid;\n    }\n  }]);\n\n  return IANAZone;\n}(Zone);\n\nvar singleton$1 = null;\n/**\n * A zone with a fixed offset (meaning no DST)\n * @implements {Zone}\n */\n\nvar FixedOffsetZone = /*#__PURE__*/function (_Zone) {\n  _inheritsLoose(FixedOffsetZone, _Zone);\n\n  /**\n   * Get an instance with a specified offset\n   * @param {number} offset - The offset in minutes\n   * @return {FixedOffsetZone}\n   */\n  FixedOffsetZone.instance = function instance(offset) {\n    return offset === 0 ? FixedOffsetZone.utcInstance : new FixedOffsetZone(offset);\n  }\n  /**\n   * Get an instance of FixedOffsetZone from a UTC offset string, like "UTC+6"\n   * @param {string} s - The offset string to parse\n   * @example FixedOffsetZone.parseSpecifier("UTC+6")\n   * @example FixedOffsetZone.parseSpecifier("UTC+06")\n   * @example FixedOffsetZone.parseSpecifier("UTC-6:00")\n   * @return {FixedOffsetZone}\n   */\n  ;\n\n  FixedOffsetZone.parseSpecifier = function parseSpecifier(s) {\n    if (s) {\n      var r = s.match(/^utc(?:([+-]\\d{1,2})(?::(\\d{2}))?)?$/i);\n\n      if (r) {\n        return new FixedOffsetZone(signedOffset(r[1], r[2]));\n      }\n    }\n\n    return null;\n  };\n\n  _createClass(FixedOffsetZone, null, [{\n    key: "utcInstance",\n\n    /**\n     * Get a singleton instance of UTC\n     * @return {FixedOffsetZone}\n     */\n    get: function get() {\n      if (singleton$1 === null) {\n        singleton$1 = new FixedOffsetZone(0);\n      }\n\n      return singleton$1;\n    }\n  }]);\n\n  function FixedOffsetZone(offset) {\n    var _this;\n\n    _this = _Zone.call(this) || this;\n    /** @private **/\n\n    _this.fixed = offset;\n    return _this;\n  }\n  /** @override **/\n\n\n  var _proto = FixedOffsetZone.prototype;\n\n  /** @override **/\n  _proto.offsetName = function offsetName() {\n    return this.name;\n  }\n  /** @override **/\n  ;\n\n  _proto.formatOffset = function formatOffset$1(ts, format) {\n    return formatOffset(this.fixed, format);\n  }\n  /** @override **/\n  ;\n\n  /** @override **/\n  _proto.offset = function offset() {\n    return this.fixed;\n  }\n  /** @override **/\n  ;\n\n  _proto.equals = function equals(otherZone) {\n    return otherZone.type === "fixed" && otherZone.fixed === this.fixed;\n  }\n  /** @override **/\n  ;\n\n  _createClass(FixedOffsetZone, [{\n    key: "type",\n    get: function get() {\n      return "fixed";\n    }\n    /** @override **/\n\n  }, {\n    key: "name",\n    get: function get() {\n      return this.fixed === 0 ? "UTC" : "UTC" + formatOffset(this.fixed, "narrow");\n    }\n  }, {\n    key: "universal",\n    get: function get() {\n      return true;\n    }\n  }, {\n    key: "isValid",\n    get: function get() {\n      return true;\n    }\n  }]);\n\n  return FixedOffsetZone;\n}(Zone);\n\n/**\n * A zone that failed to parse. You should never need to instantiate this.\n * @implements {Zone}\n */\n\nvar InvalidZone = /*#__PURE__*/function (_Zone) {\n  _inheritsLoose(InvalidZone, _Zone);\n\n  function InvalidZone(zoneName) {\n    var _this;\n\n    _this = _Zone.call(this) || this;\n    /**  @private */\n\n    _this.zoneName = zoneName;\n    return _this;\n  }\n  /** @override **/\n\n\n  var _proto = InvalidZone.prototype;\n\n  /** @override **/\n  _proto.offsetName = function offsetName() {\n    return null;\n  }\n  /** @override **/\n  ;\n\n  _proto.formatOffset = function formatOffset() {\n    return "";\n  }\n  /** @override **/\n  ;\n\n  _proto.offset = function offset() {\n    return NaN;\n  }\n  /** @override **/\n  ;\n\n  _proto.equals = function equals() {\n    return false;\n  }\n  /** @override **/\n  ;\n\n  _createClass(InvalidZone, [{\n    key: "type",\n    get: function get() {\n      return "invalid";\n    }\n    /** @override **/\n\n  }, {\n    key: "name",\n    get: function get() {\n      return this.zoneName;\n    }\n    /** @override **/\n\n  }, {\n    key: "universal",\n    get: function get() {\n      return false;\n    }\n  }, {\n    key: "isValid",\n    get: function get() {\n      return false;\n    }\n  }]);\n\n  return InvalidZone;\n}(Zone);\n\n/**\n * @private\n */\nfunction normalizeZone(input, defaultZone) {\n  var offset;\n\n  if (isUndefined(input) || input === null) {\n    return defaultZone;\n  } else if (input instanceof Zone) {\n    return input;\n  } else if (isString(input)) {\n    var lowered = input.toLowerCase();\n    if (lowered === "local") return defaultZone;else if (lowered === "utc" || lowered === "gmt") return FixedOffsetZone.utcInstance;else if ((offset = IANAZone.parseGMTOffset(input)) != null) {\n      // handle Etc/GMT-4, which V8 chokes on\n      return FixedOffsetZone.instance(offset);\n    } else if (IANAZone.isValidSpecifier(lowered)) return IANAZone.create(input);else return FixedOffsetZone.parseSpecifier(lowered) || new InvalidZone(input);\n  } else if (isNumber(input)) {\n    return FixedOffsetZone.instance(input);\n  } else if (typeof input === "object" && input.offset && typeof input.offset === "number") {\n    // This is dumb, but the instanceof check above doesn\'t seem to really work\n    // so we\'re duck checking it\n    return input;\n  } else {\n    return new InvalidZone(input);\n  }\n}\n\nvar now = function now() {\n  return Date.now();\n},\n    defaultZone = null,\n    // not setting this directly to LocalZone.instance bc loading order issues\ndefaultLocale = null,\n    defaultNumberingSystem = null,\n    defaultOutputCalendar = null,\n    throwOnInvalid = false;\n/**\n * Settings contains static getters and setters that control Luxon\'s overall behavior. Luxon is a simple library with few options, but the ones it does have live here.\n */\n\n\nvar Settings = /*#__PURE__*/function () {\n  function Settings() {}\n\n  /**\n   * Reset Luxon\'s global caches. Should only be necessary in testing scenarios.\n   * @return {void}\n   */\n  Settings.resetCaches = function resetCaches() {\n    Locale.resetCache();\n    IANAZone.resetCache();\n  };\n\n  _createClass(Settings, null, [{\n    key: "now",\n\n    /**\n     * Get the callback for returning the current timestamp.\n     * @type {function}\n     */\n    get: function get() {\n      return now;\n    }\n    /**\n     * Set the callback for returning the current timestamp.\n     * The function should return a number, which will be interpreted as an Epoch millisecond count\n     * @type {function}\n     * @example Settings.now = () => Date.now() + 3000 // pretend it is 3 seconds in the future\n     * @example Settings.now = () => 0 // always pretend it\'s Jan 1, 1970 at midnight in UTC time\n     */\n    ,\n    set: function set(n) {\n      now = n;\n    }\n    /**\n     * Get the default time zone to create DateTimes in.\n     * @type {string}\n     */\n\n  }, {\n    key: "defaultZoneName",\n    get: function get() {\n      return Settings.defaultZone.name;\n    }\n    /**\n     * Set the default time zone to create DateTimes in. Does not affect existing instances.\n     * @type {string}\n     */\n    ,\n    set: function set(z) {\n      if (!z) {\n        defaultZone = null;\n      } else {\n        defaultZone = normalizeZone(z);\n      }\n    }\n    /**\n     * Get the default time zone object to create DateTimes in. Does not affect existing instances.\n     * @type {Zone}\n     */\n\n  }, {\n    key: "defaultZone",\n    get: function get() {\n      return defaultZone || LocalZone.instance;\n    }\n    /**\n     * Get the default locale to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n\n  }, {\n    key: "defaultLocale",\n    get: function get() {\n      return defaultLocale;\n    }\n    /**\n     * Set the default locale to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n    ,\n    set: function set(locale) {\n      defaultLocale = locale;\n    }\n    /**\n     * Get the default numbering system to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n\n  }, {\n    key: "defaultNumberingSystem",\n    get: function get() {\n      return defaultNumberingSystem;\n    }\n    /**\n     * Set the default numbering system to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n    ,\n    set: function set(numberingSystem) {\n      defaultNumberingSystem = numberingSystem;\n    }\n    /**\n     * Get the default output calendar to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n\n  }, {\n    key: "defaultOutputCalendar",\n    get: function get() {\n      return defaultOutputCalendar;\n    }\n    /**\n     * Set the default output calendar to create DateTimes with. Does not affect existing instances.\n     * @type {string}\n     */\n    ,\n    set: function set(outputCalendar) {\n      defaultOutputCalendar = outputCalendar;\n    }\n    /**\n     * Get whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals\n     * @type {boolean}\n     */\n\n  }, {\n    key: "throwOnInvalid",\n    get: function get() {\n      return throwOnInvalid;\n    }\n    /**\n     * Set whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals\n     * @type {boolean}\n     */\n    ,\n    set: function set(t) {\n      throwOnInvalid = t;\n    }\n  }]);\n\n  return Settings;\n}();\n\nvar intlDTCache = {};\n\nfunction getCachedDTF(locString, opts) {\n  if (opts === void 0) {\n    opts = {};\n  }\n\n  var key = JSON.stringify([locString, opts]);\n  var dtf = intlDTCache[key];\n\n  if (!dtf) {\n    dtf = new Intl.DateTimeFormat(locString, opts);\n    intlDTCache[key] = dtf;\n  }\n\n  return dtf;\n}\n\nvar intlNumCache = {};\n\nfunction getCachedINF(locString, opts) {\n  if (opts === void 0) {\n    opts = {};\n  }\n\n  var key = JSON.stringify([locString, opts]);\n  var inf = intlNumCache[key];\n\n  if (!inf) {\n    inf = new Intl.NumberFormat(locString, opts);\n    intlNumCache[key] = inf;\n  }\n\n  return inf;\n}\n\nvar intlRelCache = {};\n\nfunction getCachedRTF(locString, opts) {\n  if (opts === void 0) {\n    opts = {};\n  }\n\n  var _opts = opts,\n      base = _opts.base,\n      cacheKeyOpts = _objectWithoutPropertiesLoose(_opts, ["base"]); // exclude `base` from the options\n\n\n  var key = JSON.stringify([locString, cacheKeyOpts]);\n  var inf = intlRelCache[key];\n\n  if (!inf) {\n    inf = new Intl.RelativeTimeFormat(locString, opts);\n    intlRelCache[key] = inf;\n  }\n\n  return inf;\n}\n\nvar sysLocaleCache = null;\n\nfunction systemLocale() {\n  if (sysLocaleCache) {\n    return sysLocaleCache;\n  } else if (hasIntl()) {\n    var computedSys = new Intl.DateTimeFormat().resolvedOptions().locale; // node sometimes defaults to "und". Override that because that is dumb\n\n    sysLocaleCache = !computedSys || computedSys === "und" ? "en-US" : computedSys;\n    return sysLocaleCache;\n  } else {\n    sysLocaleCache = "en-US";\n    return sysLocaleCache;\n  }\n}\n\nfunction parseLocaleString(localeStr) {\n  // I really want to avoid writing a BCP 47 parser\n  // see, e.g. https://github.com/wooorm/bcp-47\n  // Instead, we\'ll do this:\n  // a) if the string has no -u extensions, just leave it alone\n  // b) if it does, use Intl to resolve everything\n  // c) if Intl fails, try again without the -u\n  var uIndex = localeStr.indexOf("-u-");\n\n  if (uIndex === -1) {\n    return [localeStr];\n  } else {\n    var options;\n    var smaller = localeStr.substring(0, uIndex);\n\n    try {\n      options = getCachedDTF(localeStr).resolvedOptions();\n    } catch (e) {\n      options = getCachedDTF(smaller).resolvedOptions();\n    }\n\n    var _options = options,\n        numberingSystem = _options.numberingSystem,\n        calendar = _options.calendar; // return the smaller one so that we can append the calendar and numbering overrides to it\n\n    return [smaller, numberingSystem, calendar];\n  }\n}\n\nfunction intlConfigString(localeStr, numberingSystem, outputCalendar) {\n  if (hasIntl()) {\n    if (outputCalendar || numberingSystem) {\n      localeStr += "-u";\n\n      if (outputCalendar) {\n        localeStr += "-ca-" + outputCalendar;\n      }\n\n      if (numberingSystem) {\n        localeStr += "-nu-" + numberingSystem;\n      }\n\n      return localeStr;\n    } else {\n      return localeStr;\n    }\n  } else {\n    return [];\n  }\n}\n\nfunction mapMonths(f) {\n  var ms = [];\n\n  for (var i = 1; i <= 12; i++) {\n    var dt = DateTime.utc(2016, i, 1);\n    ms.push(f(dt));\n  }\n\n  return ms;\n}\n\nfunction mapWeekdays(f) {\n  var ms = [];\n\n  for (var i = 1; i <= 7; i++) {\n    var dt = DateTime.utc(2016, 11, 13 + i);\n    ms.push(f(dt));\n  }\n\n  return ms;\n}\n\nfunction listStuff(loc, length, defaultOK, englishFn, intlFn) {\n  var mode = loc.listingMode(defaultOK);\n\n  if (mode === "error") {\n    return null;\n  } else if (mode === "en") {\n    return englishFn(length);\n  } else {\n    return intlFn(length);\n  }\n}\n\nfunction supportsFastNumbers(loc) {\n  if (loc.numberingSystem && loc.numberingSystem !== "latn") {\n    return false;\n  } else {\n    return loc.numberingSystem === "latn" || !loc.locale || loc.locale.startsWith("en") || hasIntl() && new Intl.DateTimeFormat(loc.intl).resolvedOptions().numberingSystem === "latn";\n  }\n}\n/**\n * @private\n */\n\n\nvar PolyNumberFormatter = /*#__PURE__*/function () {\n  function PolyNumberFormatter(intl, forceSimple, opts) {\n    this.padTo = opts.padTo || 0;\n    this.floor = opts.floor || false;\n\n    if (!forceSimple && hasIntl()) {\n      var intlOpts = {\n        useGrouping: false\n      };\n      if (opts.padTo > 0) intlOpts.minimumIntegerDigits = opts.padTo;\n      this.inf = getCachedINF(intl, intlOpts);\n    }\n  }\n\n  var _proto = PolyNumberFormatter.prototype;\n\n  _proto.format = function format(i) {\n    if (this.inf) {\n      var fixed = this.floor ? Math.floor(i) : i;\n      return this.inf.format(fixed);\n    } else {\n      // to match the browser\'s numberformatter defaults\n      var _fixed = this.floor ? Math.floor(i) : roundTo(i, 3);\n\n      return padStart(_fixed, this.padTo);\n    }\n  };\n\n  return PolyNumberFormatter;\n}();\n/**\n * @private\n */\n\n\nvar PolyDateFormatter = /*#__PURE__*/function () {\n  function PolyDateFormatter(dt, intl, opts) {\n    this.opts = opts;\n    this.hasIntl = hasIntl();\n    var z;\n\n    if (dt.zone.universal && this.hasIntl) {\n      // UTC-8 or Etc/UTC-8 are not part of tzdata, only Etc/GMT+8 and the like.\n      // That is why fixed-offset TZ is set to that unless it is:\n      // 1. Outside of the supported range Etc/GMT-14 to Etc/GMT+12.\n      // 2. Not a whole hour, e.g. UTC+4:30.\n      var gmtOffset = -1 * (dt.offset / 60);\n\n      if (gmtOffset >= -14 && gmtOffset <= 12 && gmtOffset % 1 === 0) {\n        z = gmtOffset >= 0 ? "Etc/GMT+" + gmtOffset : "Etc/GMT" + gmtOffset;\n        this.dt = dt;\n      } else {\n        // Not all fixed-offset zones like Etc/+4:30 are present in tzdata.\n        // So we have to make do. Two cases:\n        // 1. The format options tell us to show the zone. We can\'t do that, so the best\n        // we can do is format the date in UTC.\n        // 2. The format options don\'t tell us to show the zone. Then we can adjust them\n        // the time and tell the formatter to show it to us in UTC, so that the time is right\n        // and the bad zone doesn\'t show up.\n        z = "UTC";\n\n        if (opts.timeZoneName) {\n          this.dt = dt;\n        } else {\n          this.dt = dt.offset === 0 ? dt : DateTime.fromMillis(dt.ts + dt.offset * 60 * 1000);\n        }\n      }\n    } else if (dt.zone.type === "local") {\n      this.dt = dt;\n    } else {\n      this.dt = dt;\n      z = dt.zone.name;\n    }\n\n    if (this.hasIntl) {\n      var intlOpts = Object.assign({}, this.opts);\n\n      if (z) {\n        intlOpts.timeZone = z;\n      }\n\n      this.dtf = getCachedDTF(intl, intlOpts);\n    }\n  }\n\n  var _proto2 = PolyDateFormatter.prototype;\n\n  _proto2.format = function format() {\n    if (this.hasIntl) {\n      return this.dtf.format(this.dt.toJSDate());\n    } else {\n      var tokenFormat = formatString(this.opts),\n          loc = Locale.create("en-US");\n      return Formatter.create(loc).formatDateTimeFromString(this.dt, tokenFormat);\n    }\n  };\n\n  _proto2.formatToParts = function formatToParts() {\n    if (this.hasIntl && hasFormatToParts()) {\n      return this.dtf.formatToParts(this.dt.toJSDate());\n    } else {\n      // This is kind of a cop out. We actually could do this for English. However, we couldn\'t do it for intl strings\n      // and IMO it\'s too weird to have an uncanny valley like that\n      return [];\n    }\n  };\n\n  _proto2.resolvedOptions = function resolvedOptions() {\n    if (this.hasIntl) {\n      return this.dtf.resolvedOptions();\n    } else {\n      return {\n        locale: "en-US",\n        numberingSystem: "latn",\n        outputCalendar: "gregory"\n      };\n    }\n  };\n\n  return PolyDateFormatter;\n}();\n/**\n * @private\n */\n\n\nvar PolyRelFormatter = /*#__PURE__*/function () {\n  function PolyRelFormatter(intl, isEnglish, opts) {\n    this.opts = Object.assign({\n      style: "long"\n    }, opts);\n\n    if (!isEnglish && hasRelative()) {\n      this.rtf = getCachedRTF(intl, opts);\n    }\n  }\n\n  var _proto3 = PolyRelFormatter.prototype;\n\n  _proto3.format = function format(count, unit) {\n    if (this.rtf) {\n      return this.rtf.format(count, unit);\n    } else {\n      return formatRelativeTime(unit, count, this.opts.numeric, this.opts.style !== "long");\n    }\n  };\n\n  _proto3.formatToParts = function formatToParts(count, unit) {\n    if (this.rtf) {\n      return this.rtf.formatToParts(count, unit);\n    } else {\n      return [];\n    }\n  };\n\n  return PolyRelFormatter;\n}();\n/**\n * @private\n */\n\n\nvar Locale = /*#__PURE__*/function () {\n  Locale.fromOpts = function fromOpts(opts) {\n    return Locale.create(opts.locale, opts.numberingSystem, opts.outputCalendar, opts.defaultToEN);\n  };\n\n  Locale.create = function create(locale, numberingSystem, outputCalendar, defaultToEN) {\n    if (defaultToEN === void 0) {\n      defaultToEN = false;\n    }\n\n    var specifiedLocale = locale || Settings.defaultLocale,\n        // the system locale is useful for human readable strings but annoying for parsing/formatting known formats\n    localeR = specifiedLocale || (defaultToEN ? "en-US" : systemLocale()),\n        numberingSystemR = numberingSystem || Settings.defaultNumberingSystem,\n        outputCalendarR = outputCalendar || Settings.defaultOutputCalendar;\n    return new Locale(localeR, numberingSystemR, outputCalendarR, specifiedLocale);\n  };\n\n  Locale.resetCache = function resetCache() {\n    sysLocaleCache = null;\n    intlDTCache = {};\n    intlNumCache = {};\n    intlRelCache = {};\n  };\n\n  Locale.fromObject = function fromObject(_temp) {\n    var _ref = _temp === void 0 ? {} : _temp,\n        locale = _ref.locale,\n        numberingSystem = _ref.numberingSystem,\n        outputCalendar = _ref.outputCalendar;\n\n    return Locale.create(locale, numberingSystem, outputCalendar);\n  };\n\n  function Locale(locale, numbering, outputCalendar, specifiedLocale) {\n    var _parseLocaleString = parseLocaleString(locale),\n        parsedLocale = _parseLocaleString[0],\n        parsedNumberingSystem = _parseLocaleString[1],\n        parsedOutputCalendar = _parseLocaleString[2];\n\n    this.locale = parsedLocale;\n    this.numberingSystem = numbering || parsedNumberingSystem || null;\n    this.outputCalendar = outputCalendar || parsedOutputCalendar || null;\n    this.intl = intlConfigString(this.locale, this.numberingSystem, this.outputCalendar);\n    this.weekdaysCache = {\n      format: {},\n      standalone: {}\n    };\n    this.monthsCache = {\n      format: {},\n      standalone: {}\n    };\n    this.meridiemCache = null;\n    this.eraCache = {};\n    this.specifiedLocale = specifiedLocale;\n    this.fastNumbersCached = null;\n  }\n\n  var _proto4 = Locale.prototype;\n\n  _proto4.listingMode = function listingMode(defaultOK) {\n    if (defaultOK === void 0) {\n      defaultOK = true;\n    }\n\n    var intl = hasIntl(),\n        hasFTP = intl && hasFormatToParts(),\n        isActuallyEn = this.isEnglish(),\n        hasNoWeirdness = (this.numberingSystem === null || this.numberingSystem === "latn") && (this.outputCalendar === null || this.outputCalendar === "gregory");\n\n    if (!hasFTP && !(isActuallyEn && hasNoWeirdness) && !defaultOK) {\n      return "error";\n    } else if (!hasFTP || isActuallyEn && hasNoWeirdness) {\n      return "en";\n    } else {\n      return "intl";\n    }\n  };\n\n  _proto4.clone = function clone(alts) {\n    if (!alts || Object.getOwnPropertyNames(alts).length === 0) {\n      return this;\n    } else {\n      return Locale.create(alts.locale || this.specifiedLocale, alts.numberingSystem || this.numberingSystem, alts.outputCalendar || this.outputCalendar, alts.defaultToEN || false);\n    }\n  };\n\n  _proto4.redefaultToEN = function redefaultToEN(alts) {\n    if (alts === void 0) {\n      alts = {};\n    }\n\n    return this.clone(Object.assign({}, alts, {\n      defaultToEN: true\n    }));\n  };\n\n  _proto4.redefaultToSystem = function redefaultToSystem(alts) {\n    if (alts === void 0) {\n      alts = {};\n    }\n\n    return this.clone(Object.assign({}, alts, {\n      defaultToEN: false\n    }));\n  };\n\n  _proto4.months = function months$1(length, format, defaultOK) {\n    var _this = this;\n\n    if (format === void 0) {\n      format = false;\n    }\n\n    if (defaultOK === void 0) {\n      defaultOK = true;\n    }\n\n    return listStuff(this, length, defaultOK, months, function () {\n      var intl = format ? {\n        month: length,\n        day: "numeric"\n      } : {\n        month: length\n      },\n          formatStr = format ? "format" : "standalone";\n\n      if (!_this.monthsCache[formatStr][length]) {\n        _this.monthsCache[formatStr][length] = mapMonths(function (dt) {\n          return _this.extract(dt, intl, "month");\n        });\n      }\n\n      return _this.monthsCache[formatStr][length];\n    });\n  };\n\n  _proto4.weekdays = function weekdays$1(length, format, defaultOK) {\n    var _this2 = this;\n\n    if (format === void 0) {\n      format = false;\n    }\n\n    if (defaultOK === void 0) {\n      defaultOK = true;\n    }\n\n    return listStuff(this, length, defaultOK, weekdays, function () {\n      var intl = format ? {\n        weekday: length,\n        year: "numeric",\n        month: "long",\n        day: "numeric"\n      } : {\n        weekday: length\n      },\n          formatStr = format ? "format" : "standalone";\n\n      if (!_this2.weekdaysCache[formatStr][length]) {\n        _this2.weekdaysCache[formatStr][length] = mapWeekdays(function (dt) {\n          return _this2.extract(dt, intl, "weekday");\n        });\n      }\n\n      return _this2.weekdaysCache[formatStr][length];\n    });\n  };\n\n  _proto4.meridiems = function meridiems$1(defaultOK) {\n    var _this3 = this;\n\n    if (defaultOK === void 0) {\n      defaultOK = true;\n    }\n\n    return listStuff(this, undefined, defaultOK, function () {\n      return meridiems;\n    }, function () {\n      // In theory there could be aribitrary day periods. We\'re gonna assume there are exactly two\n      // for AM and PM. This is probably wrong, but it\'s makes parsing way easier.\n      if (!_this3.meridiemCache) {\n        var intl = {\n          hour: "numeric",\n          hour12: true\n        };\n        _this3.meridiemCache = [DateTime.utc(2016, 11, 13, 9), DateTime.utc(2016, 11, 13, 19)].map(function (dt) {\n          return _this3.extract(dt, intl, "dayperiod");\n        });\n      }\n\n      return _this3.meridiemCache;\n    });\n  };\n\n  _proto4.eras = function eras$1(length, defaultOK) {\n    var _this4 = this;\n\n    if (defaultOK === void 0) {\n      defaultOK = true;\n    }\n\n    return listStuff(this, length, defaultOK, eras, function () {\n      var intl = {\n        era: length\n      }; // This is problematic. Different calendars are going to define eras totally differently. What I need is the minimum set of dates\n      // to definitely enumerate them.\n\n      if (!_this4.eraCache[length]) {\n        _this4.eraCache[length] = [DateTime.utc(-40, 1, 1), DateTime.utc(2017, 1, 1)].map(function (dt) {\n          return _this4.extract(dt, intl, "era");\n        });\n      }\n\n      return _this4.eraCache[length];\n    });\n  };\n\n  _proto4.extract = function extract(dt, intlOpts, field) {\n    var df = this.dtFormatter(dt, intlOpts),\n        results = df.formatToParts(),\n        matching = results.find(function (m) {\n      return m.type.toLowerCase() === field;\n    });\n    return matching ? matching.value : null;\n  };\n\n  _proto4.numberFormatter = function numberFormatter(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    // this forcesimple option is never used (the only caller short-circuits on it, but it seems safer to leave)\n    // (in contrast, the rest of the condition is used heavily)\n    return new PolyNumberFormatter(this.intl, opts.forceSimple || this.fastNumbers, opts);\n  };\n\n  _proto4.dtFormatter = function dtFormatter(dt, intlOpts) {\n    if (intlOpts === void 0) {\n      intlOpts = {};\n    }\n\n    return new PolyDateFormatter(dt, this.intl, intlOpts);\n  };\n\n  _proto4.relFormatter = function relFormatter(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return new PolyRelFormatter(this.intl, this.isEnglish(), opts);\n  };\n\n  _proto4.isEnglish = function isEnglish() {\n    return this.locale === "en" || this.locale.toLowerCase() === "en-us" || hasIntl() && new Intl.DateTimeFormat(this.intl).resolvedOptions().locale.startsWith("en-us");\n  };\n\n  _proto4.equals = function equals(other) {\n    return this.locale === other.locale && this.numberingSystem === other.numberingSystem && this.outputCalendar === other.outputCalendar;\n  };\n\n  _createClass(Locale, [{\n    key: "fastNumbers",\n    get: function get() {\n      if (this.fastNumbersCached == null) {\n        this.fastNumbersCached = supportsFastNumbers(this);\n      }\n\n      return this.fastNumbersCached;\n    }\n  }]);\n\n  return Locale;\n}();\n\n/*\n * This file handles parsing for well-specified formats. Here\'s how it works:\n * Two things go into parsing: a regex to match with and an extractor to take apart the groups in the match.\n * An extractor is just a function that takes a regex match array and returns a { year: ..., month: ... } object\n * parse() does the work of executing the regex and applying the extractor. It takes multiple regex/extractor pairs to try in sequence.\n * Extractors can take a "cursor" representing the offset in the match to look at. This makes it easy to combine extractors.\n * combineExtractors() does the work of combining them, keeping track of the cursor through multiple extractions.\n * Some extractions are super dumb and simpleParse and fromStrings help DRY them.\n */\n\nfunction combineRegexes() {\n  for (var _len = arguments.length, regexes = new Array(_len), _key = 0; _key < _len; _key++) {\n    regexes[_key] = arguments[_key];\n  }\n\n  var full = regexes.reduce(function (f, r) {\n    return f + r.source;\n  }, "");\n  return RegExp("^" + full + "$");\n}\n\nfunction combineExtractors() {\n  for (var _len2 = arguments.length, extractors = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n    extractors[_key2] = arguments[_key2];\n  }\n\n  return function (m) {\n    return extractors.reduce(function (_ref, ex) {\n      var mergedVals = _ref[0],\n          mergedZone = _ref[1],\n          cursor = _ref[2];\n\n      var _ex = ex(m, cursor),\n          val = _ex[0],\n          zone = _ex[1],\n          next = _ex[2];\n\n      return [Object.assign(mergedVals, val), mergedZone || zone, next];\n    }, [{}, null, 1]).slice(0, 2);\n  };\n}\n\nfunction parse(s) {\n  if (s == null) {\n    return [null, null];\n  }\n\n  for (var _len3 = arguments.length, patterns = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {\n    patterns[_key3 - 1] = arguments[_key3];\n  }\n\n  for (var _i = 0, _patterns = patterns; _i < _patterns.length; _i++) {\n    var _patterns$_i = _patterns[_i],\n        regex = _patterns$_i[0],\n        extractor = _patterns$_i[1];\n    var m = regex.exec(s);\n\n    if (m) {\n      return extractor(m);\n    }\n  }\n\n  return [null, null];\n}\n\nfunction simpleParse() {\n  for (var _len4 = arguments.length, keys = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {\n    keys[_key4] = arguments[_key4];\n  }\n\n  return function (match, cursor) {\n    var ret = {};\n    var i;\n\n    for (i = 0; i < keys.length; i++) {\n      ret[keys[i]] = parseInteger(match[cursor + i]);\n    }\n\n    return [ret, null, cursor + i];\n  };\n} // ISO and SQL parsing\n\n\nvar offsetRegex = /(?:(Z)|([+-]\\d\\d)(?::?(\\d\\d))?)/,\n    isoTimeBaseRegex = /(\\d\\d)(?::?(\\d\\d)(?::?(\\d\\d)(?:[.,](\\d{1,30}))?)?)?/,\n    isoTimeRegex = RegExp("" + isoTimeBaseRegex.source + offsetRegex.source + "?"),\n    isoTimeExtensionRegex = RegExp("(?:T" + isoTimeRegex.source + ")?"),\n    isoYmdRegex = /([+-]\\d{6}|\\d{4})(?:-?(\\d\\d)(?:-?(\\d\\d))?)?/,\n    isoWeekRegex = /(\\d{4})-?W(\\d\\d)(?:-?(\\d))?/,\n    isoOrdinalRegex = /(\\d{4})-?(\\d{3})/,\n    extractISOWeekData = simpleParse("weekYear", "weekNumber", "weekDay"),\n    extractISOOrdinalData = simpleParse("year", "ordinal"),\n    sqlYmdRegex = /(\\d{4})-(\\d\\d)-(\\d\\d)/,\n    // dumbed-down version of the ISO one\nsqlTimeRegex = RegExp(isoTimeBaseRegex.source + " ?(?:" + offsetRegex.source + "|(" + ianaRegex.source + "))?"),\n    sqlTimeExtensionRegex = RegExp("(?: " + sqlTimeRegex.source + ")?");\n\nfunction int(match, pos, fallback) {\n  var m = match[pos];\n  return isUndefined(m) ? fallback : parseInteger(m);\n}\n\nfunction extractISOYmd(match, cursor) {\n  var item = {\n    year: int(match, cursor),\n    month: int(match, cursor + 1, 1),\n    day: int(match, cursor + 2, 1)\n  };\n  return [item, null, cursor + 3];\n}\n\nfunction extractISOTime(match, cursor) {\n  var item = {\n    hours: int(match, cursor, 0),\n    minutes: int(match, cursor + 1, 0),\n    seconds: int(match, cursor + 2, 0),\n    milliseconds: parseMillis(match[cursor + 3])\n  };\n  return [item, null, cursor + 4];\n}\n\nfunction extractISOOffset(match, cursor) {\n  var local = !match[cursor] && !match[cursor + 1],\n      fullOffset = signedOffset(match[cursor + 1], match[cursor + 2]),\n      zone = local ? null : FixedOffsetZone.instance(fullOffset);\n  return [{}, zone, cursor + 3];\n}\n\nfunction extractIANAZone(match, cursor) {\n  var zone = match[cursor] ? IANAZone.create(match[cursor]) : null;\n  return [{}, zone, cursor + 1];\n} // ISO time parsing\n\n\nvar isoTimeOnly = RegExp("^T?" + isoTimeBaseRegex.source + "$"); // ISO duration parsing\n\nvar isoDuration = /^-?P(?:(?:(-?\\d{1,9})Y)?(?:(-?\\d{1,9})M)?(?:(-?\\d{1,9})W)?(?:(-?\\d{1,9})D)?(?:T(?:(-?\\d{1,9})H)?(?:(-?\\d{1,9})M)?(?:(-?\\d{1,20})(?:[.,](-?\\d{1,9}))?S)?)?)$/;\n\nfunction extractISODuration(match) {\n  var s = match[0],\n      yearStr = match[1],\n      monthStr = match[2],\n      weekStr = match[3],\n      dayStr = match[4],\n      hourStr = match[5],\n      minuteStr = match[6],\n      secondStr = match[7],\n      millisecondsStr = match[8];\n  var hasNegativePrefix = s[0] === "-";\n\n  var maybeNegate = function maybeNegate(num) {\n    return num && hasNegativePrefix ? -num : num;\n  };\n\n  return [{\n    years: maybeNegate(parseInteger(yearStr)),\n    months: maybeNegate(parseInteger(monthStr)),\n    weeks: maybeNegate(parseInteger(weekStr)),\n    days: maybeNegate(parseInteger(dayStr)),\n    hours: maybeNegate(parseInteger(hourStr)),\n    minutes: maybeNegate(parseInteger(minuteStr)),\n    seconds: maybeNegate(parseInteger(secondStr)),\n    milliseconds: maybeNegate(parseMillis(millisecondsStr))\n  }];\n} // These are a little braindead. EDT *should* tell us that we\'re in, say, America/New_York\n// and not just that we\'re in -240 *right now*. But since I don\'t think these are used that often\n// I\'m just going to ignore that\n\n\nvar obsOffsets = {\n  GMT: 0,\n  EDT: -4 * 60,\n  EST: -5 * 60,\n  CDT: -5 * 60,\n  CST: -6 * 60,\n  MDT: -6 * 60,\n  MST: -7 * 60,\n  PDT: -7 * 60,\n  PST: -8 * 60\n};\n\nfunction fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {\n  var result = {\n    year: yearStr.length === 2 ? untruncateYear(parseInteger(yearStr)) : parseInteger(yearStr),\n    month: monthsShort.indexOf(monthStr) + 1,\n    day: parseInteger(dayStr),\n    hour: parseInteger(hourStr),\n    minute: parseInteger(minuteStr)\n  };\n  if (secondStr) result.second = parseInteger(secondStr);\n\n  if (weekdayStr) {\n    result.weekday = weekdayStr.length > 3 ? weekdaysLong.indexOf(weekdayStr) + 1 : weekdaysShort.indexOf(weekdayStr) + 1;\n  }\n\n  return result;\n} // RFC 2822/5322\n\n\nvar rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\\s)?(\\d{1,2})\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2,4})\\s(\\d\\d):(\\d\\d)(?::(\\d\\d))?\\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|(?:([+-]\\d\\d)(\\d\\d)))$/;\n\nfunction extractRFC2822(match) {\n  var weekdayStr = match[1],\n      dayStr = match[2],\n      monthStr = match[3],\n      yearStr = match[4],\n      hourStr = match[5],\n      minuteStr = match[6],\n      secondStr = match[7],\n      obsOffset = match[8],\n      milOffset = match[9],\n      offHourStr = match[10],\n      offMinuteStr = match[11],\n      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);\n  var offset;\n\n  if (obsOffset) {\n    offset = obsOffsets[obsOffset];\n  } else if (milOffset) {\n    offset = 0;\n  } else {\n    offset = signedOffset(offHourStr, offMinuteStr);\n  }\n\n  return [result, new FixedOffsetZone(offset)];\n}\n\nfunction preprocessRFC2822(s) {\n  // Remove comments and folding whitespace and replace multiple-spaces with a single space\n  return s.replace(/\\([^)]*\\)|[\\n\\t]/g, " ").replace(/(\\s\\s+)/g, " ").trim();\n} // http date\n\n\nvar rfc1123 = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\\d\\d) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\\d{4}) (\\d\\d):(\\d\\d):(\\d\\d) GMT$/,\n    rfc850 = /^(Monday|Tuesday|Wedsday|Thursday|Friday|Saturday|Sunday), (\\d\\d)-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d) GMT$/,\n    ascii = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( \\d|\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d) (\\d{4})$/;\n\nfunction extractRFC1123Or850(match) {\n  var weekdayStr = match[1],\n      dayStr = match[2],\n      monthStr = match[3],\n      yearStr = match[4],\n      hourStr = match[5],\n      minuteStr = match[6],\n      secondStr = match[7],\n      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);\n  return [result, FixedOffsetZone.utcInstance];\n}\n\nfunction extractASCII(match) {\n  var weekdayStr = match[1],\n      monthStr = match[2],\n      dayStr = match[3],\n      hourStr = match[4],\n      minuteStr = match[5],\n      secondStr = match[6],\n      yearStr = match[7],\n      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);\n  return [result, FixedOffsetZone.utcInstance];\n}\n\nvar isoYmdWithTimeExtensionRegex = combineRegexes(isoYmdRegex, isoTimeExtensionRegex);\nvar isoWeekWithTimeExtensionRegex = combineRegexes(isoWeekRegex, isoTimeExtensionRegex);\nvar isoOrdinalWithTimeExtensionRegex = combineRegexes(isoOrdinalRegex, isoTimeExtensionRegex);\nvar isoTimeCombinedRegex = combineRegexes(isoTimeRegex);\nvar extractISOYmdTimeAndOffset = combineExtractors(extractISOYmd, extractISOTime, extractISOOffset);\nvar extractISOWeekTimeAndOffset = combineExtractors(extractISOWeekData, extractISOTime, extractISOOffset);\nvar extractISOOrdinalDataAndTime = combineExtractors(extractISOOrdinalData, extractISOTime);\nvar extractISOTimeAndOffset = combineExtractors(extractISOTime, extractISOOffset);\n/**\n * @private\n */\n\nfunction parseISODate(s) {\n  return parse(s, [isoYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset], [isoWeekWithTimeExtensionRegex, extractISOWeekTimeAndOffset], [isoOrdinalWithTimeExtensionRegex, extractISOOrdinalDataAndTime], [isoTimeCombinedRegex, extractISOTimeAndOffset]);\n}\nfunction parseRFC2822Date(s) {\n  return parse(preprocessRFC2822(s), [rfc2822, extractRFC2822]);\n}\nfunction parseHTTPDate(s) {\n  return parse(s, [rfc1123, extractRFC1123Or850], [rfc850, extractRFC1123Or850], [ascii, extractASCII]);\n}\nfunction parseISODuration(s) {\n  return parse(s, [isoDuration, extractISODuration]);\n}\nvar extractISOTimeOnly = combineExtractors(extractISOTime);\nfunction parseISOTimeOnly(s) {\n  return parse(s, [isoTimeOnly, extractISOTimeOnly]);\n}\nvar sqlYmdWithTimeExtensionRegex = combineRegexes(sqlYmdRegex, sqlTimeExtensionRegex);\nvar sqlTimeCombinedRegex = combineRegexes(sqlTimeRegex);\nvar extractISOYmdTimeOffsetAndIANAZone = combineExtractors(extractISOYmd, extractISOTime, extractISOOffset, extractIANAZone);\nvar extractISOTimeOffsetAndIANAZone = combineExtractors(extractISOTime, extractISOOffset, extractIANAZone);\nfunction parseSQL(s) {\n  return parse(s, [sqlYmdWithTimeExtensionRegex, extractISOYmdTimeOffsetAndIANAZone], [sqlTimeCombinedRegex, extractISOTimeOffsetAndIANAZone]);\n}\n\nvar INVALID = "Invalid Duration"; // unit conversion constants\n\nvar lowOrderMatrix = {\n  weeks: {\n    days: 7,\n    hours: 7 * 24,\n    minutes: 7 * 24 * 60,\n    seconds: 7 * 24 * 60 * 60,\n    milliseconds: 7 * 24 * 60 * 60 * 1000\n  },\n  days: {\n    hours: 24,\n    minutes: 24 * 60,\n    seconds: 24 * 60 * 60,\n    milliseconds: 24 * 60 * 60 * 1000\n  },\n  hours: {\n    minutes: 60,\n    seconds: 60 * 60,\n    milliseconds: 60 * 60 * 1000\n  },\n  minutes: {\n    seconds: 60,\n    milliseconds: 60 * 1000\n  },\n  seconds: {\n    milliseconds: 1000\n  }\n},\n    casualMatrix = Object.assign({\n  years: {\n    quarters: 4,\n    months: 12,\n    weeks: 52,\n    days: 365,\n    hours: 365 * 24,\n    minutes: 365 * 24 * 60,\n    seconds: 365 * 24 * 60 * 60,\n    milliseconds: 365 * 24 * 60 * 60 * 1000\n  },\n  quarters: {\n    months: 3,\n    weeks: 13,\n    days: 91,\n    hours: 91 * 24,\n    minutes: 91 * 24 * 60,\n    seconds: 91 * 24 * 60 * 60,\n    milliseconds: 91 * 24 * 60 * 60 * 1000\n  },\n  months: {\n    weeks: 4,\n    days: 30,\n    hours: 30 * 24,\n    minutes: 30 * 24 * 60,\n    seconds: 30 * 24 * 60 * 60,\n    milliseconds: 30 * 24 * 60 * 60 * 1000\n  }\n}, lowOrderMatrix),\n    daysInYearAccurate = 146097.0 / 400,\n    daysInMonthAccurate = 146097.0 / 4800,\n    accurateMatrix = Object.assign({\n  years: {\n    quarters: 4,\n    months: 12,\n    weeks: daysInYearAccurate / 7,\n    days: daysInYearAccurate,\n    hours: daysInYearAccurate * 24,\n    minutes: daysInYearAccurate * 24 * 60,\n    seconds: daysInYearAccurate * 24 * 60 * 60,\n    milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000\n  },\n  quarters: {\n    months: 3,\n    weeks: daysInYearAccurate / 28,\n    days: daysInYearAccurate / 4,\n    hours: daysInYearAccurate * 24 / 4,\n    minutes: daysInYearAccurate * 24 * 60 / 4,\n    seconds: daysInYearAccurate * 24 * 60 * 60 / 4,\n    milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000 / 4\n  },\n  months: {\n    weeks: daysInMonthAccurate / 7,\n    days: daysInMonthAccurate,\n    hours: daysInMonthAccurate * 24,\n    minutes: daysInMonthAccurate * 24 * 60,\n    seconds: daysInMonthAccurate * 24 * 60 * 60,\n    milliseconds: daysInMonthAccurate * 24 * 60 * 60 * 1000\n  }\n}, lowOrderMatrix); // units ordered by size\n\nvar orderedUnits = ["years", "quarters", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds"];\nvar reverseUnits = orderedUnits.slice(0).reverse(); // clone really means "create another instance just like this one, but with these changes"\n\nfunction clone(dur, alts, clear) {\n  if (clear === void 0) {\n    clear = false;\n  }\n\n  // deep merge for vals\n  var conf = {\n    values: clear ? alts.values : Object.assign({}, dur.values, alts.values || {}),\n    loc: dur.loc.clone(alts.loc),\n    conversionAccuracy: alts.conversionAccuracy || dur.conversionAccuracy\n  };\n  return new Duration(conf);\n}\n\nfunction antiTrunc(n) {\n  return n < 0 ? Math.floor(n) : Math.ceil(n);\n} // NB: mutates parameters\n\n\nfunction convert(matrix, fromMap, fromUnit, toMap, toUnit) {\n  var conv = matrix[toUnit][fromUnit],\n      raw = fromMap[fromUnit] / conv,\n      sameSign = Math.sign(raw) === Math.sign(toMap[toUnit]),\n      // ok, so this is wild, but see the matrix in the tests\n  added = !sameSign && toMap[toUnit] !== 0 && Math.abs(raw) <= 1 ? antiTrunc(raw) : Math.trunc(raw);\n  toMap[toUnit] += added;\n  fromMap[fromUnit] -= added * conv;\n} // NB: mutates parameters\n\n\nfunction normalizeValues(matrix, vals) {\n  reverseUnits.reduce(function (previous, current) {\n    if (!isUndefined(vals[current])) {\n      if (previous) {\n        convert(matrix, vals, previous, vals, current);\n      }\n\n      return current;\n    } else {\n      return previous;\n    }\n  }, null);\n}\n/**\n * A Duration object represents a period of time, like "2 months" or "1 day, 1 hour". Conceptually, it\'s just a map of units to their quantities, accompanied by some additional configuration and methods for creating, parsing, interrogating, transforming, and formatting them. They can be used on their own or in conjunction with other Luxon types; for example, you can use {@link DateTime.plus} to add a Duration object to a DateTime, producing another DateTime.\n *\n * Here is a brief overview of commonly used methods and getters in Duration:\n *\n * * **Creation** To create a Duration, use {@link Duration.fromMillis}, {@link Duration.fromObject}, or {@link Duration.fromISO}.\n * * **Unit values** See the {@link Duration.years}, {@link Duration.months}, {@link Duration.weeks}, {@link Duration.days}, {@link Duration.hours}, {@link Duration.minutes}, {@link Duration.seconds}, {@link Duration.milliseconds} accessors.\n * * **Configuration** See  {@link Duration.locale} and {@link Duration.numberingSystem} accessors.\n * * **Transformation** To create new Durations out of old ones use {@link Duration.plus}, {@link Duration.minus}, {@link Duration.normalize}, {@link Duration.set}, {@link Duration.reconfigure}, {@link Duration.shiftTo}, and {@link Duration.negate}.\n * * **Output** To convert the Duration into other representations, see {@link Duration.as}, {@link Duration.toISO}, {@link Duration.toFormat}, and {@link Duration.toJSON}\n *\n * There\'s are more methods documented below. In addition, for more information on subtler topics like internationalization and validity, see the external documentation.\n */\n\n\nvar Duration = /*#__PURE__*/function () {\n  /**\n   * @private\n   */\n  function Duration(config) {\n    var accurate = config.conversionAccuracy === "longterm" || false;\n    /**\n     * @access private\n     */\n\n    this.values = config.values;\n    /**\n     * @access private\n     */\n\n    this.loc = config.loc || Locale.create();\n    /**\n     * @access private\n     */\n\n    this.conversionAccuracy = accurate ? "longterm" : "casual";\n    /**\n     * @access private\n     */\n\n    this.invalid = config.invalid || null;\n    /**\n     * @access private\n     */\n\n    this.matrix = accurate ? accurateMatrix : casualMatrix;\n    /**\n     * @access private\n     */\n\n    this.isLuxonDuration = true;\n  }\n  /**\n   * Create Duration from a number of milliseconds.\n   * @param {number} count of milliseconds\n   * @param {Object} opts - options for parsing\n   * @param {string} [opts.locale=\'en-US\'] - the locale to use\n   * @param {string} opts.numberingSystem - the numbering system to use\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @return {Duration}\n   */\n\n\n  Duration.fromMillis = function fromMillis(count, opts) {\n    return Duration.fromObject(Object.assign({\n      milliseconds: count\n    }, opts));\n  }\n  /**\n   * Create a Duration from a JavaScript object with keys like \'years\' and \'hours.\n   * If this object is empty then a zero milliseconds duration is returned.\n   * @param {Object} obj - the object to create the DateTime from\n   * @param {number} obj.years\n   * @param {number} obj.quarters\n   * @param {number} obj.months\n   * @param {number} obj.weeks\n   * @param {number} obj.days\n   * @param {number} obj.hours\n   * @param {number} obj.minutes\n   * @param {number} obj.seconds\n   * @param {number} obj.milliseconds\n   * @param {string} [obj.locale=\'en-US\'] - the locale to use\n   * @param {string} obj.numberingSystem - the numbering system to use\n   * @param {string} [obj.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @return {Duration}\n   */\n  ;\n\n  Duration.fromObject = function fromObject(obj) {\n    if (obj == null || typeof obj !== "object") {\n      throw new InvalidArgumentError("Duration.fromObject: argument expected to be an object, got " + (obj === null ? "null" : typeof obj));\n    }\n\n    return new Duration({\n      values: normalizeObject(obj, Duration.normalizeUnit, ["locale", "numberingSystem", "conversionAccuracy", "zone" // a bit of debt; it\'s super inconvenient internally not to be able to blindly pass this\n      ]),\n      loc: Locale.fromObject(obj),\n      conversionAccuracy: obj.conversionAccuracy\n    });\n  }\n  /**\n   * Create a Duration from an ISO 8601 duration string.\n   * @param {string} text - text to parse\n   * @param {Object} opts - options for parsing\n   * @param {string} [opts.locale=\'en-US\'] - the locale to use\n   * @param {string} opts.numberingSystem - the numbering system to use\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations\n   * @example Duration.fromISO(\'P3Y6M1W4DT12H30M5S\').toObject() //=> { years: 3, months: 6, weeks: 1, days: 4, hours: 12, minutes: 30, seconds: 5 }\n   * @example Duration.fromISO(\'PT23H\').toObject() //=> { hours: 23 }\n   * @example Duration.fromISO(\'P5Y3M\').toObject() //=> { years: 5, months: 3 }\n   * @return {Duration}\n   */\n  ;\n\n  Duration.fromISO = function fromISO(text, opts) {\n    var _parseISODuration = parseISODuration(text),\n        parsed = _parseISODuration[0];\n\n    if (parsed) {\n      var obj = Object.assign(parsed, opts);\n      return Duration.fromObject(obj);\n    } else {\n      return Duration.invalid("unparsable", "the input \\"" + text + "\\" can\'t be parsed as ISO 8601");\n    }\n  }\n  /**\n   * Create a Duration from an ISO 8601 time string.\n   * @param {string} text - text to parse\n   * @param {Object} opts - options for parsing\n   * @param {string} [opts.locale=\'en-US\'] - the locale to use\n   * @param {string} opts.numberingSystem - the numbering system to use\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Times\n   * @example Duration.fromISOTime(\'11:22:33.444\').toObject() //=> { hours: 11, minutes: 22, seconds: 33, milliseconds: 444 }\n   * @example Duration.fromISOTime(\'11:00\').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }\n   * @example Duration.fromISOTime(\'T11:00\').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }\n   * @example Duration.fromISOTime(\'1100\').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }\n   * @example Duration.fromISOTime(\'T1100\').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }\n   * @return {Duration}\n   */\n  ;\n\n  Duration.fromISOTime = function fromISOTime(text, opts) {\n    var _parseISOTimeOnly = parseISOTimeOnly(text),\n        parsed = _parseISOTimeOnly[0];\n\n    if (parsed) {\n      var obj = Object.assign(parsed, opts);\n      return Duration.fromObject(obj);\n    } else {\n      return Duration.invalid("unparsable", "the input \\"" + text + "\\" can\'t be parsed as ISO 8601");\n    }\n  }\n  /**\n   * Create an invalid Duration.\n   * @param {string} reason - simple string of why this datetime is invalid. Should not contain parameters or anything else data-dependent\n   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information\n   * @return {Duration}\n   */\n  ;\n\n  Duration.invalid = function invalid(reason, explanation) {\n    if (explanation === void 0) {\n      explanation = null;\n    }\n\n    if (!reason) {\n      throw new InvalidArgumentError("need to specify a reason the Duration is invalid");\n    }\n\n    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);\n\n    if (Settings.throwOnInvalid) {\n      throw new InvalidDurationError(invalid);\n    } else {\n      return new Duration({\n        invalid: invalid\n      });\n    }\n  }\n  /**\n   * @private\n   */\n  ;\n\n  Duration.normalizeUnit = function normalizeUnit(unit) {\n    var normalized = {\n      year: "years",\n      years: "years",\n      quarter: "quarters",\n      quarters: "quarters",\n      month: "months",\n      months: "months",\n      week: "weeks",\n      weeks: "weeks",\n      day: "days",\n      days: "days",\n      hour: "hours",\n      hours: "hours",\n      minute: "minutes",\n      minutes: "minutes",\n      second: "seconds",\n      seconds: "seconds",\n      millisecond: "milliseconds",\n      milliseconds: "milliseconds"\n    }[unit ? unit.toLowerCase() : unit];\n    if (!normalized) throw new InvalidUnitError(unit);\n    return normalized;\n  }\n  /**\n   * Check if an object is a Duration. Works across context boundaries\n   * @param {object} o\n   * @return {boolean}\n   */\n  ;\n\n  Duration.isDuration = function isDuration(o) {\n    return o && o.isLuxonDuration || false;\n  }\n  /**\n   * Get  the locale of a Duration, such \'en-GB\'\n   * @type {string}\n   */\n  ;\n\n  var _proto = Duration.prototype;\n\n  /**\n   * Returns a string representation of this Duration formatted according to the specified format string. You may use these tokens:\n   * * `S` for milliseconds\n   * * `s` for seconds\n   * * `m` for minutes\n   * * `h` for hours\n   * * `d` for days\n   * * `M` for months\n   * * `y` for years\n   * Notes:\n   * * Add padding by repeating the token, e.g. "yy" pads the years to two digits, "hhhh" pads the hours out to four digits\n   * * The duration will be converted to the set of units in the format string using {@link Duration.shiftTo} and the Durations\'s conversion accuracy setting.\n   * @param {string} fmt - the format string\n   * @param {Object} opts - options\n   * @param {boolean} [opts.floor=true] - floor numerical values\n   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("y d s") //=> "1 6 2"\n   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("yy dd sss") //=> "01 06 002"\n   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("M S") //=> "12 518402000"\n   * @return {string}\n   */\n  _proto.toFormat = function toFormat(fmt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    // reverse-compat since 1.2; we always round down now, never up, and we do it by default\n    var fmtOpts = Object.assign({}, opts, {\n      floor: opts.round !== false && opts.floor !== false\n    });\n    return this.isValid ? Formatter.create(this.loc, fmtOpts).formatDurationFromString(this, fmt) : INVALID;\n  }\n  /**\n   * Returns a JavaScript object with this Duration\'s values.\n   * @param opts - options for generating the object\n   * @param {boolean} [opts.includeConfig=false] - include configuration attributes in the output\n   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toObject() //=> { years: 1, days: 6, seconds: 2 }\n   * @return {Object}\n   */\n  ;\n\n  _proto.toObject = function toObject(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid) return {};\n    var base = Object.assign({}, this.values);\n\n    if (opts.includeConfig) {\n      base.conversionAccuracy = this.conversionAccuracy;\n      base.numberingSystem = this.loc.numberingSystem;\n      base.locale = this.loc.locale;\n    }\n\n    return base;\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this Duration.\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations\n   * @example Duration.fromObject({ years: 3, seconds: 45 }).toISO() //=> \'P3YT45S\'\n   * @example Duration.fromObject({ months: 4, seconds: 45 }).toISO() //=> \'P4MT45S\'\n   * @example Duration.fromObject({ months: 5 }).toISO() //=> \'P5M\'\n   * @example Duration.fromObject({ minutes: 5 }).toISO() //=> \'PT5M\'\n   * @example Duration.fromObject({ milliseconds: 6 }).toISO() //=> \'PT0.006S\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISO = function toISO() {\n    // we could use the formatter, but this is an easier way to get the minimum string\n    if (!this.isValid) return null;\n    var s = "P";\n    if (this.years !== 0) s += this.years + "Y";\n    if (this.months !== 0 || this.quarters !== 0) s += this.months + this.quarters * 3 + "M";\n    if (this.weeks !== 0) s += this.weeks + "W";\n    if (this.days !== 0) s += this.days + "D";\n    if (this.hours !== 0 || this.minutes !== 0 || this.seconds !== 0 || this.milliseconds !== 0) s += "T";\n    if (this.hours !== 0) s += this.hours + "H";\n    if (this.minutes !== 0) s += this.minutes + "M";\n    if (this.seconds !== 0 || this.milliseconds !== 0) // this will handle "floating point madness" by removing extra decimal places\n      // https://stackoverflow.com/questions/588004/is-floating-point-math-broken\n      s += roundTo(this.seconds + this.milliseconds / 1000, 3) + "S";\n    if (s === "P") s += "T0S";\n    return s;\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this Duration, formatted as a time of day.\n   * Note that this will return null if the duration is invalid, negative, or equal to or greater than 24 hours.\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Times\n   * @param {Object} opts - options\n   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they\'re 0\n   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they\'re 0\n   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix\n   * @param {string} [opts.format=\'extended\'] - choose between the basic and extended format\n   * @example Duration.fromObject({ hours: 11 }).toISOTime() //=> \'11:00:00.000\'\n   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressMilliseconds: true }) //=> \'11:00:00\'\n   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressSeconds: true }) //=> \'11:00\'\n   * @example Duration.fromObject({ hours: 11 }).toISOTime({ includePrefix: true }) //=> \'T11:00:00.000\'\n   * @example Duration.fromObject({ hours: 11 }).toISOTime({ format: \'basic\' }) //=> \'110000.000\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISOTime = function toISOTime(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid) return null;\n    var millis = this.toMillis();\n    if (millis < 0 || millis >= 86400000) return null;\n    opts = Object.assign({\n      suppressMilliseconds: false,\n      suppressSeconds: false,\n      includePrefix: false,\n      format: "extended"\n    }, opts);\n    var value = this.shiftTo("hours", "minutes", "seconds", "milliseconds");\n    var fmt = opts.format === "basic" ? "hhmm" : "hh:mm";\n\n    if (!opts.suppressSeconds || value.seconds !== 0 || value.milliseconds !== 0) {\n      fmt += opts.format === "basic" ? "ss" : ":ss";\n\n      if (!opts.suppressMilliseconds || value.milliseconds !== 0) {\n        fmt += ".SSS";\n      }\n    }\n\n    var str = value.toFormat(fmt);\n\n    if (opts.includePrefix) {\n      str = "T" + str;\n    }\n\n    return str;\n  }\n  /**\n   * Returns an ISO 8601 representation of this Duration appropriate for use in JSON.\n   * @return {string}\n   */\n  ;\n\n  _proto.toJSON = function toJSON() {\n    return this.toISO();\n  }\n  /**\n   * Returns an ISO 8601 representation of this Duration appropriate for use in debugging.\n   * @return {string}\n   */\n  ;\n\n  _proto.toString = function toString() {\n    return this.toISO();\n  }\n  /**\n   * Returns an milliseconds value of this Duration.\n   * @return {number}\n   */\n  ;\n\n  _proto.toMillis = function toMillis() {\n    return this.as("milliseconds");\n  }\n  /**\n   * Returns an milliseconds value of this Duration. Alias of {@link toMillis}\n   * @return {number}\n   */\n  ;\n\n  _proto.valueOf = function valueOf() {\n    return this.toMillis();\n  }\n  /**\n   * Make this Duration longer by the specified amount. Return a newly-constructed Duration.\n   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()\n   * @return {Duration}\n   */\n  ;\n\n  _proto.plus = function plus(duration) {\n    if (!this.isValid) return this;\n    var dur = friendlyDuration(duration),\n        result = {};\n\n    for (var _iterator = _createForOfIteratorHelperLoose(orderedUnits), _step; !(_step = _iterator()).done;) {\n      var k = _step.value;\n\n      if (hasOwnProperty(dur.values, k) || hasOwnProperty(this.values, k)) {\n        result[k] = dur.get(k) + this.get(k);\n      }\n    }\n\n    return clone(this, {\n      values: result\n    }, true);\n  }\n  /**\n   * Make this Duration shorter by the specified amount. Return a newly-constructed Duration.\n   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()\n   * @return {Duration}\n   */\n  ;\n\n  _proto.minus = function minus(duration) {\n    if (!this.isValid) return this;\n    var dur = friendlyDuration(duration);\n    return this.plus(dur.negate());\n  }\n  /**\n   * Scale this Duration by the specified amount. Return a newly-constructed Duration.\n   * @param {function} fn - The function to apply to each unit. Arity is 1 or 2: the value of the unit and, optionally, the unit name. Must return a number.\n   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnit(x => x * 2) //=> { hours: 2, minutes: 60 }\n   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnit((x, u) => u === "hour" ? x * 2 : x) //=> { hours: 2, minutes: 30 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.mapUnits = function mapUnits(fn) {\n    if (!this.isValid) return this;\n    var result = {};\n\n    for (var _i = 0, _Object$keys = Object.keys(this.values); _i < _Object$keys.length; _i++) {\n      var k = _Object$keys[_i];\n      result[k] = asNumber(fn(this.values[k], k));\n    }\n\n    return clone(this, {\n      values: result\n    }, true);\n  }\n  /**\n   * Get the value of unit.\n   * @param {string} unit - a unit such as \'minute\' or \'day\'\n   * @example Duration.fromObject({years: 2, days: 3}).years //=> 2\n   * @example Duration.fromObject({years: 2, days: 3}).months //=> 0\n   * @example Duration.fromObject({years: 2, days: 3}).days //=> 3\n   * @return {number}\n   */\n  ;\n\n  _proto.get = function get(unit) {\n    return this[Duration.normalizeUnit(unit)];\n  }\n  /**\n   * "Set" the values of specified units. Return a newly-constructed Duration.\n   * @param {Object} values - a mapping of units to numbers\n   * @example dur.set({ years: 2017 })\n   * @example dur.set({ hours: 8, minutes: 30 })\n   * @return {Duration}\n   */\n  ;\n\n  _proto.set = function set(values) {\n    if (!this.isValid) return this;\n    var mixed = Object.assign(this.values, normalizeObject(values, Duration.normalizeUnit, []));\n    return clone(this, {\n      values: mixed\n    });\n  }\n  /**\n   * "Set" the locale and/or numberingSystem.  Returns a newly-constructed Duration.\n   * @example dur.reconfigure({ locale: \'en-GB\' })\n   * @return {Duration}\n   */\n  ;\n\n  _proto.reconfigure = function reconfigure(_temp) {\n    var _ref = _temp === void 0 ? {} : _temp,\n        locale = _ref.locale,\n        numberingSystem = _ref.numberingSystem,\n        conversionAccuracy = _ref.conversionAccuracy;\n\n    var loc = this.loc.clone({\n      locale: locale,\n      numberingSystem: numberingSystem\n    }),\n        opts = {\n      loc: loc\n    };\n\n    if (conversionAccuracy) {\n      opts.conversionAccuracy = conversionAccuracy;\n    }\n\n    return clone(this, opts);\n  }\n  /**\n   * Return the length of the duration in the specified unit.\n   * @param {string} unit - a unit such as \'minutes\' or \'days\'\n   * @example Duration.fromObject({years: 1}).as(\'days\') //=> 365\n   * @example Duration.fromObject({years: 1}).as(\'months\') //=> 12\n   * @example Duration.fromObject({hours: 60}).as(\'days\') //=> 2.5\n   * @return {number}\n   */\n  ;\n\n  _proto.as = function as(unit) {\n    return this.isValid ? this.shiftTo(unit).get(unit) : NaN;\n  }\n  /**\n   * Reduce this Duration to its canonical representation in its current units.\n   * @example Duration.fromObject({ years: 2, days: 5000 }).normalize().toObject() //=> { years: 15, days: 255 }\n   * @example Duration.fromObject({ hours: 12, minutes: -45 }).normalize().toObject() //=> { hours: 11, minutes: 15 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.normalize = function normalize() {\n    if (!this.isValid) return this;\n    var vals = this.toObject();\n    normalizeValues(this.matrix, vals);\n    return clone(this, {\n      values: vals\n    }, true);\n  }\n  /**\n   * Convert this Duration into its representation in a different set of units.\n   * @example Duration.fromObject({ hours: 1, seconds: 30 }).shiftTo(\'minutes\', \'milliseconds\').toObject() //=> { minutes: 60, milliseconds: 30000 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.shiftTo = function shiftTo() {\n    for (var _len = arguments.length, units = new Array(_len), _key = 0; _key < _len; _key++) {\n      units[_key] = arguments[_key];\n    }\n\n    if (!this.isValid) return this;\n\n    if (units.length === 0) {\n      return this;\n    }\n\n    units = units.map(function (u) {\n      return Duration.normalizeUnit(u);\n    });\n    var built = {},\n        accumulated = {},\n        vals = this.toObject();\n    var lastUnit;\n\n    for (var _iterator2 = _createForOfIteratorHelperLoose(orderedUnits), _step2; !(_step2 = _iterator2()).done;) {\n      var k = _step2.value;\n\n      if (units.indexOf(k) >= 0) {\n        lastUnit = k;\n        var own = 0; // anything we haven\'t boiled down yet should get boiled to this unit\n\n        for (var ak in accumulated) {\n          own += this.matrix[ak][k] * accumulated[ak];\n          accumulated[ak] = 0;\n        } // plus anything that\'s already in this unit\n\n\n        if (isNumber(vals[k])) {\n          own += vals[k];\n        }\n\n        var i = Math.trunc(own);\n        built[k] = i;\n        accumulated[k] = own - i; // we\'d like to absorb these fractions in another unit\n        // plus anything further down the chain that should be rolled up in to this\n\n        for (var down in vals) {\n          if (orderedUnits.indexOf(down) > orderedUnits.indexOf(k)) {\n            convert(this.matrix, vals, down, built, k);\n          }\n        } // otherwise, keep it in the wings to boil it later\n\n      } else if (isNumber(vals[k])) {\n        accumulated[k] = vals[k];\n      }\n    } // anything leftover becomes the decimal for the last unit\n    // lastUnit must be defined since units is not empty\n\n\n    for (var key in accumulated) {\n      if (accumulated[key] !== 0) {\n        built[lastUnit] += key === lastUnit ? accumulated[key] : accumulated[key] / this.matrix[lastUnit][key];\n      }\n    }\n\n    return clone(this, {\n      values: built\n    }, true).normalize();\n  }\n  /**\n   * Return the negative of this Duration.\n   * @example Duration.fromObject({ hours: 1, seconds: 30 }).negate().toObject() //=> { hours: -1, seconds: -30 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.negate = function negate() {\n    if (!this.isValid) return this;\n    var negated = {};\n\n    for (var _i2 = 0, _Object$keys2 = Object.keys(this.values); _i2 < _Object$keys2.length; _i2++) {\n      var k = _Object$keys2[_i2];\n      negated[k] = -this.values[k];\n    }\n\n    return clone(this, {\n      values: negated\n    }, true);\n  }\n  /**\n   * Get the years.\n   * @type {number}\n   */\n  ;\n\n  /**\n   * Equality check\n   * Two Durations are equal iff they have the same units and the same values for each unit.\n   * @param {Duration} other\n   * @return {boolean}\n   */\n  _proto.equals = function equals(other) {\n    if (!this.isValid || !other.isValid) {\n      return false;\n    }\n\n    if (!this.loc.equals(other.loc)) {\n      return false;\n    }\n\n    function eq(v1, v2) {\n      // Consider 0 and undefined as equal\n      if (v1 === undefined || v1 === 0) return v2 === undefined || v2 === 0;\n      return v1 === v2;\n    }\n\n    for (var _iterator3 = _createForOfIteratorHelperLoose(orderedUnits), _step3; !(_step3 = _iterator3()).done;) {\n      var u = _step3.value;\n\n      if (!eq(this.values[u], other.values[u])) {\n        return false;\n      }\n    }\n\n    return true;\n  };\n\n  _createClass(Duration, [{\n    key: "locale",\n    get: function get() {\n      return this.isValid ? this.loc.locale : null;\n    }\n    /**\n     * Get the numbering system of a Duration, such \'beng\'. The numbering system is used when formatting the Duration\n     *\n     * @type {string}\n     */\n\n  }, {\n    key: "numberingSystem",\n    get: function get() {\n      return this.isValid ? this.loc.numberingSystem : null;\n    }\n  }, {\n    key: "years",\n    get: function get() {\n      return this.isValid ? this.values.years || 0 : NaN;\n    }\n    /**\n     * Get the quarters.\n     * @type {number}\n     */\n\n  }, {\n    key: "quarters",\n    get: function get() {\n      return this.isValid ? this.values.quarters || 0 : NaN;\n    }\n    /**\n     * Get the months.\n     * @type {number}\n     */\n\n  }, {\n    key: "months",\n    get: function get() {\n      return this.isValid ? this.values.months || 0 : NaN;\n    }\n    /**\n     * Get the weeks\n     * @type {number}\n     */\n\n  }, {\n    key: "weeks",\n    get: function get() {\n      return this.isValid ? this.values.weeks || 0 : NaN;\n    }\n    /**\n     * Get the days.\n     * @type {number}\n     */\n\n  }, {\n    key: "days",\n    get: function get() {\n      return this.isValid ? this.values.days || 0 : NaN;\n    }\n    /**\n     * Get the hours.\n     * @type {number}\n     */\n\n  }, {\n    key: "hours",\n    get: function get() {\n      return this.isValid ? this.values.hours || 0 : NaN;\n    }\n    /**\n     * Get the minutes.\n     * @type {number}\n     */\n\n  }, {\n    key: "minutes",\n    get: function get() {\n      return this.isValid ? this.values.minutes || 0 : NaN;\n    }\n    /**\n     * Get the seconds.\n     * @return {number}\n     */\n\n  }, {\n    key: "seconds",\n    get: function get() {\n      return this.isValid ? this.values.seconds || 0 : NaN;\n    }\n    /**\n     * Get the milliseconds.\n     * @return {number}\n     */\n\n  }, {\n    key: "milliseconds",\n    get: function get() {\n      return this.isValid ? this.values.milliseconds || 0 : NaN;\n    }\n    /**\n     * Returns whether the Duration is invalid. Invalid durations are returned by diff operations\n     * on invalid DateTimes or Intervals.\n     * @return {boolean}\n     */\n\n  }, {\n    key: "isValid",\n    get: function get() {\n      return this.invalid === null;\n    }\n    /**\n     * Returns an error code if this Duration became invalid, or null if the Duration is valid\n     * @return {string}\n     */\n\n  }, {\n    key: "invalidReason",\n    get: function get() {\n      return this.invalid ? this.invalid.reason : null;\n    }\n    /**\n     * Returns an explanation of why this Duration became invalid, or null if the Duration is valid\n     * @type {string}\n     */\n\n  }, {\n    key: "invalidExplanation",\n    get: function get() {\n      return this.invalid ? this.invalid.explanation : null;\n    }\n  }]);\n\n  return Duration;\n}();\nfunction friendlyDuration(durationish) {\n  if (isNumber(durationish)) {\n    return Duration.fromMillis(durationish);\n  } else if (Duration.isDuration(durationish)) {\n    return durationish;\n  } else if (typeof durationish === "object") {\n    return Duration.fromObject(durationish);\n  } else {\n    throw new InvalidArgumentError("Unknown duration argument " + durationish + " of type " + typeof durationish);\n  }\n}\n\nvar INVALID$1 = "Invalid Interval"; // checks if the start is equal to or before the end\n\nfunction validateStartEnd(start, end) {\n  if (!start || !start.isValid) {\n    return Interval.invalid("missing or invalid start");\n  } else if (!end || !end.isValid) {\n    return Interval.invalid("missing or invalid end");\n  } else if (end < start) {\n    return Interval.invalid("end before start", "The end of an interval must be after its start, but you had start=" + start.toISO() + " and end=" + end.toISO());\n  } else {\n    return null;\n  }\n}\n/**\n * An Interval object represents a half-open interval of time, where each endpoint is a {@link DateTime}. Conceptually, it\'s a container for those two endpoints, accompanied by methods for creating, parsing, interrogating, comparing, transforming, and formatting them.\n *\n * Here is a brief overview of the most commonly used methods and getters in Interval:\n *\n * * **Creation** To create an Interval, use {@link fromDateTimes}, {@link after}, {@link before}, or {@link fromISO}.\n * * **Accessors** Use {@link start} and {@link end} to get the start and end.\n * * **Interrogation** To analyze the Interval, use {@link count}, {@link length}, {@link hasSame}, {@link contains}, {@link isAfter}, or {@link isBefore}.\n * * **Transformation** To create other Intervals out of this one, use {@link set}, {@link splitAt}, {@link splitBy}, {@link divideEqually}, {@link merge}, {@link xor}, {@link union}, {@link intersection}, or {@link difference}.\n * * **Comparison** To compare this Interval to another one, use {@link equals}, {@link overlaps}, {@link abutsStart}, {@link abutsEnd}, {@link engulfs}.\n * * **Output** To convert the Interval into other representations, see {@link toString}, {@link toISO}, {@link toISODate}, {@link toISOTime}, {@link toFormat}, and {@link toDuration}.\n */\n\n\nvar Interval = /*#__PURE__*/function () {\n  /**\n   * @private\n   */\n  function Interval(config) {\n    /**\n     * @access private\n     */\n    this.s = config.start;\n    /**\n     * @access private\n     */\n\n    this.e = config.end;\n    /**\n     * @access private\n     */\n\n    this.invalid = config.invalid || null;\n    /**\n     * @access private\n     */\n\n    this.isLuxonInterval = true;\n  }\n  /**\n   * Create an invalid Interval.\n   * @param {string} reason - simple string of why this Interval is invalid. Should not contain parameters or anything else data-dependent\n   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information\n   * @return {Interval}\n   */\n\n\n  Interval.invalid = function invalid(reason, explanation) {\n    if (explanation === void 0) {\n      explanation = null;\n    }\n\n    if (!reason) {\n      throw new InvalidArgumentError("need to specify a reason the Interval is invalid");\n    }\n\n    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);\n\n    if (Settings.throwOnInvalid) {\n      throw new InvalidIntervalError(invalid);\n    } else {\n      return new Interval({\n        invalid: invalid\n      });\n    }\n  }\n  /**\n   * Create an Interval from a start DateTime and an end DateTime. Inclusive of the start but not the end.\n   * @param {DateTime|Date|Object} start\n   * @param {DateTime|Date|Object} end\n   * @return {Interval}\n   */\n  ;\n\n  Interval.fromDateTimes = function fromDateTimes(start, end) {\n    var builtStart = friendlyDateTime(start),\n        builtEnd = friendlyDateTime(end);\n    var validateError = validateStartEnd(builtStart, builtEnd);\n\n    if (validateError == null) {\n      return new Interval({\n        start: builtStart,\n        end: builtEnd\n      });\n    } else {\n      return validateError;\n    }\n  }\n  /**\n   * Create an Interval from a start DateTime and a Duration to extend to.\n   * @param {DateTime|Date|Object} start\n   * @param {Duration|Object|number} duration - the length of the Interval.\n   * @return {Interval}\n   */\n  ;\n\n  Interval.after = function after(start, duration) {\n    var dur = friendlyDuration(duration),\n        dt = friendlyDateTime(start);\n    return Interval.fromDateTimes(dt, dt.plus(dur));\n  }\n  /**\n   * Create an Interval from an end DateTime and a Duration to extend backwards to.\n   * @param {DateTime|Date|Object} end\n   * @param {Duration|Object|number} duration - the length of the Interval.\n   * @return {Interval}\n   */\n  ;\n\n  Interval.before = function before(end, duration) {\n    var dur = friendlyDuration(duration),\n        dt = friendlyDateTime(end);\n    return Interval.fromDateTimes(dt.minus(dur), dt);\n  }\n  /**\n   * Create an Interval from an ISO 8601 string.\n   * Accepts `<start>/<end>`, `<start>/<duration>`, and `<duration>/<end>` formats.\n   * @param {string} text - the ISO string to parse\n   * @param {Object} [opts] - options to pass {@link DateTime.fromISO} and optionally {@link Duration.fromISO}\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals\n   * @return {Interval}\n   */\n  ;\n\n  Interval.fromISO = function fromISO(text, opts) {\n    var _split = (text || "").split("/", 2),\n        s = _split[0],\n        e = _split[1];\n\n    if (s && e) {\n      var start, startIsValid;\n\n      try {\n        start = DateTime.fromISO(s, opts);\n        startIsValid = start.isValid;\n      } catch (e) {\n        startIsValid = false;\n      }\n\n      var end, endIsValid;\n\n      try {\n        end = DateTime.fromISO(e, opts);\n        endIsValid = end.isValid;\n      } catch (e) {\n        endIsValid = false;\n      }\n\n      if (startIsValid && endIsValid) {\n        return Interval.fromDateTimes(start, end);\n      }\n\n      if (startIsValid) {\n        var dur = Duration.fromISO(e, opts);\n\n        if (dur.isValid) {\n          return Interval.after(start, dur);\n        }\n      } else if (endIsValid) {\n        var _dur = Duration.fromISO(s, opts);\n\n        if (_dur.isValid) {\n          return Interval.before(end, _dur);\n        }\n      }\n    }\n\n    return Interval.invalid("unparsable", "the input \\"" + text + "\\" can\'t be parsed as ISO 8601");\n  }\n  /**\n   * Check if an object is an Interval. Works across context boundaries\n   * @param {object} o\n   * @return {boolean}\n   */\n  ;\n\n  Interval.isInterval = function isInterval(o) {\n    return o && o.isLuxonInterval || false;\n  }\n  /**\n   * Returns the start of the Interval\n   * @type {DateTime}\n   */\n  ;\n\n  var _proto = Interval.prototype;\n\n  /**\n   * Returns the length of the Interval in the specified unit.\n   * @param {string} unit - the unit (such as \'hours\' or \'days\') to return the length in.\n   * @return {number}\n   */\n  _proto.length = function length(unit) {\n    if (unit === void 0) {\n      unit = "milliseconds";\n    }\n\n    return this.isValid ? this.toDuration.apply(this, [unit]).get(unit) : NaN;\n  }\n  /**\n   * Returns the count of minutes, hours, days, months, or years included in the Interval, even in part.\n   * Unlike {@link length} this counts sections of the calendar, not periods of time, e.g. specifying \'day\'\n   * asks \'what dates are included in this interval?\', not \'how many days long is this interval?\'\n   * @param {string} [unit=\'milliseconds\'] - the unit of time to count.\n   * @return {number}\n   */\n  ;\n\n  _proto.count = function count(unit) {\n    if (unit === void 0) {\n      unit = "milliseconds";\n    }\n\n    if (!this.isValid) return NaN;\n    var start = this.start.startOf(unit),\n        end = this.end.startOf(unit);\n    return Math.floor(end.diff(start, unit).get(unit)) + 1;\n  }\n  /**\n   * Returns whether this Interval\'s start and end are both in the same unit of time\n   * @param {string} unit - the unit of time to check sameness on\n   * @return {boolean}\n   */\n  ;\n\n  _proto.hasSame = function hasSame(unit) {\n    return this.isValid ? this.isEmpty() || this.e.minus(1).hasSame(this.s, unit) : false;\n  }\n  /**\n   * Return whether this Interval has the same start and end DateTimes.\n   * @return {boolean}\n   */\n  ;\n\n  _proto.isEmpty = function isEmpty() {\n    return this.s.valueOf() === this.e.valueOf();\n  }\n  /**\n   * Return whether this Interval\'s start is after the specified DateTime.\n   * @param {DateTime} dateTime\n   * @return {boolean}\n   */\n  ;\n\n  _proto.isAfter = function isAfter(dateTime) {\n    if (!this.isValid) return false;\n    return this.s > dateTime;\n  }\n  /**\n   * Return whether this Interval\'s end is before the specified DateTime.\n   * @param {DateTime} dateTime\n   * @return {boolean}\n   */\n  ;\n\n  _proto.isBefore = function isBefore(dateTime) {\n    if (!this.isValid) return false;\n    return this.e <= dateTime;\n  }\n  /**\n   * Return whether this Interval contains the specified DateTime.\n   * @param {DateTime} dateTime\n   * @return {boolean}\n   */\n  ;\n\n  _proto.contains = function contains(dateTime) {\n    if (!this.isValid) return false;\n    return this.s <= dateTime && this.e > dateTime;\n  }\n  /**\n   * "Sets" the start and/or end dates. Returns a newly-constructed Interval.\n   * @param {Object} values - the values to set\n   * @param {DateTime} values.start - the starting DateTime\n   * @param {DateTime} values.end - the ending DateTime\n   * @return {Interval}\n   */\n  ;\n\n  _proto.set = function set(_temp) {\n    var _ref = _temp === void 0 ? {} : _temp,\n        start = _ref.start,\n        end = _ref.end;\n\n    if (!this.isValid) return this;\n    return Interval.fromDateTimes(start || this.s, end || this.e);\n  }\n  /**\n   * Split this Interval at each of the specified DateTimes\n   * @param {...[DateTime]} dateTimes - the unit of time to count.\n   * @return {[Interval]}\n   */\n  ;\n\n  _proto.splitAt = function splitAt() {\n    var _this = this;\n\n    if (!this.isValid) return [];\n\n    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {\n      dateTimes[_key] = arguments[_key];\n    }\n\n    var sorted = dateTimes.map(friendlyDateTime).filter(function (d) {\n      return _this.contains(d);\n    }).sort(),\n        results = [];\n    var s = this.s,\n        i = 0;\n\n    while (s < this.e) {\n      var added = sorted[i] || this.e,\n          next = +added > +this.e ? this.e : added;\n      results.push(Interval.fromDateTimes(s, next));\n      s = next;\n      i += 1;\n    }\n\n    return results;\n  }\n  /**\n   * Split this Interval into smaller Intervals, each of the specified length.\n   * Left over time is grouped into a smaller interval\n   * @param {Duration|Object|number} duration - The length of each resulting interval.\n   * @return {[Interval]}\n   */\n  ;\n\n  _proto.splitBy = function splitBy(duration) {\n    var dur = friendlyDuration(duration);\n\n    if (!this.isValid || !dur.isValid || dur.as("milliseconds") === 0) {\n      return [];\n    }\n\n    var s = this.s,\n        added,\n        next;\n    var results = [];\n\n    while (s < this.e) {\n      added = s.plus(dur);\n      next = +added > +this.e ? this.e : added;\n      results.push(Interval.fromDateTimes(s, next));\n      s = next;\n    }\n\n    return results;\n  }\n  /**\n   * Split this Interval into the specified number of smaller intervals.\n   * @param {number} numberOfParts - The number of Intervals to divide the Interval into.\n   * @return {[Interval]}\n   */\n  ;\n\n  _proto.divideEqually = function divideEqually(numberOfParts) {\n    if (!this.isValid) return [];\n    return this.splitBy(this.length() / numberOfParts).slice(0, numberOfParts);\n  }\n  /**\n   * Return whether this Interval overlaps with the specified Interval\n   * @param {Interval} other\n   * @return {boolean}\n   */\n  ;\n\n  _proto.overlaps = function overlaps(other) {\n    return this.e > other.s && this.s < other.e;\n  }\n  /**\n   * Return whether this Interval\'s end is adjacent to the specified Interval\'s start.\n   * @param {Interval} other\n   * @return {boolean}\n   */\n  ;\n\n  _proto.abutsStart = function abutsStart(other) {\n    if (!this.isValid) return false;\n    return +this.e === +other.s;\n  }\n  /**\n   * Return whether this Interval\'s start is adjacent to the specified Interval\'s end.\n   * @param {Interval} other\n   * @return {boolean}\n   */\n  ;\n\n  _proto.abutsEnd = function abutsEnd(other) {\n    if (!this.isValid) return false;\n    return +other.e === +this.s;\n  }\n  /**\n   * Return whether this Interval engulfs the start and end of the specified Interval.\n   * @param {Interval} other\n   * @return {boolean}\n   */\n  ;\n\n  _proto.engulfs = function engulfs(other) {\n    if (!this.isValid) return false;\n    return this.s <= other.s && this.e >= other.e;\n  }\n  /**\n   * Return whether this Interval has the same start and end as the specified Interval.\n   * @param {Interval} other\n   * @return {boolean}\n   */\n  ;\n\n  _proto.equals = function equals(other) {\n    if (!this.isValid || !other.isValid) {\n      return false;\n    }\n\n    return this.s.equals(other.s) && this.e.equals(other.e);\n  }\n  /**\n   * Return an Interval representing the intersection of this Interval and the specified Interval.\n   * Specifically, the resulting Interval has the maximum start time and the minimum end time of the two Intervals.\n   * Returns null if the intersection is empty, meaning, the intervals don\'t intersect.\n   * @param {Interval} other\n   * @return {Interval}\n   */\n  ;\n\n  _proto.intersection = function intersection(other) {\n    if (!this.isValid) return this;\n    var s = this.s > other.s ? this.s : other.s,\n        e = this.e < other.e ? this.e : other.e;\n\n    if (s > e) {\n      return null;\n    } else {\n      return Interval.fromDateTimes(s, e);\n    }\n  }\n  /**\n   * Return an Interval representing the union of this Interval and the specified Interval.\n   * Specifically, the resulting Interval has the minimum start time and the maximum end time of the two Intervals.\n   * @param {Interval} other\n   * @return {Interval}\n   */\n  ;\n\n  _proto.union = function union(other) {\n    if (!this.isValid) return this;\n    var s = this.s < other.s ? this.s : other.s,\n        e = this.e > other.e ? this.e : other.e;\n    return Interval.fromDateTimes(s, e);\n  }\n  /**\n   * Merge an array of Intervals into a equivalent minimal set of Intervals.\n   * Combines overlapping and adjacent Intervals.\n   * @param {[Interval]} intervals\n   * @return {[Interval]}\n   */\n  ;\n\n  Interval.merge = function merge(intervals) {\n    var _intervals$sort$reduc = intervals.sort(function (a, b) {\n      return a.s - b.s;\n    }).reduce(function (_ref2, item) {\n      var sofar = _ref2[0],\n          current = _ref2[1];\n\n      if (!current) {\n        return [sofar, item];\n      } else if (current.overlaps(item) || current.abutsStart(item)) {\n        return [sofar, current.union(item)];\n      } else {\n        return [sofar.concat([current]), item];\n      }\n    }, [[], null]),\n        found = _intervals$sort$reduc[0],\n        final = _intervals$sort$reduc[1];\n\n    if (final) {\n      found.push(final);\n    }\n\n    return found;\n  }\n  /**\n   * Return an array of Intervals representing the spans of time that only appear in one of the specified Intervals.\n   * @param {[Interval]} intervals\n   * @return {[Interval]}\n   */\n  ;\n\n  Interval.xor = function xor(intervals) {\n    var _Array$prototype;\n\n    var start = null,\n        currentCount = 0;\n\n    var results = [],\n        ends = intervals.map(function (i) {\n      return [{\n        time: i.s,\n        type: "s"\n      }, {\n        time: i.e,\n        type: "e"\n      }];\n    }),\n        flattened = (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, ends),\n        arr = flattened.sort(function (a, b) {\n      return a.time - b.time;\n    });\n\n    for (var _iterator = _createForOfIteratorHelperLoose(arr), _step; !(_step = _iterator()).done;) {\n      var i = _step.value;\n      currentCount += i.type === "s" ? 1 : -1;\n\n      if (currentCount === 1) {\n        start = i.time;\n      } else {\n        if (start && +start !== +i.time) {\n          results.push(Interval.fromDateTimes(start, i.time));\n        }\n\n        start = null;\n      }\n    }\n\n    return Interval.merge(results);\n  }\n  /**\n   * Return an Interval representing the span of time in this Interval that doesn\'t overlap with any of the specified Intervals.\n   * @param {...Interval} intervals\n   * @return {[Interval]}\n   */\n  ;\n\n  _proto.difference = function difference() {\n    var _this2 = this;\n\n    for (var _len2 = arguments.length, intervals = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n      intervals[_key2] = arguments[_key2];\n    }\n\n    return Interval.xor([this].concat(intervals)).map(function (i) {\n      return _this2.intersection(i);\n    }).filter(function (i) {\n      return i && !i.isEmpty();\n    });\n  }\n  /**\n   * Returns a string representation of this Interval appropriate for debugging.\n   * @return {string}\n   */\n  ;\n\n  _proto.toString = function toString() {\n    if (!this.isValid) return INVALID$1;\n    return "[" + this.s.toISO() + " \\u2013 " + this.e.toISO() + ")";\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this Interval.\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals\n   * @param {Object} opts - The same options as {@link DateTime.toISO}\n   * @return {string}\n   */\n  ;\n\n  _proto.toISO = function toISO(opts) {\n    if (!this.isValid) return INVALID$1;\n    return this.s.toISO(opts) + "/" + this.e.toISO(opts);\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of date of this Interval.\n   * The time components are ignored.\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals\n   * @return {string}\n   */\n  ;\n\n  _proto.toISODate = function toISODate() {\n    if (!this.isValid) return INVALID$1;\n    return this.s.toISODate() + "/" + this.e.toISODate();\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of time of this Interval.\n   * The date components are ignored.\n   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals\n   * @param {Object} opts - The same options as {@link DateTime.toISO}\n   * @return {string}\n   */\n  ;\n\n  _proto.toISOTime = function toISOTime(opts) {\n    if (!this.isValid) return INVALID$1;\n    return this.s.toISOTime(opts) + "/" + this.e.toISOTime(opts);\n  }\n  /**\n   * Returns a string representation of this Interval formatted according to the specified format string.\n   * @param {string} dateFormat - the format string. This string formats the start and end time. See {@link DateTime.toFormat} for details.\n   * @param {Object} opts - options\n   * @param {string} [opts.separator =  \' – \'] - a separator to place between the start and end representations\n   * @return {string}\n   */\n  ;\n\n  _proto.toFormat = function toFormat(dateFormat, _temp2) {\n    var _ref3 = _temp2 === void 0 ? {} : _temp2,\n        _ref3$separator = _ref3.separator,\n        separator = _ref3$separator === void 0 ? " – " : _ref3$separator;\n\n    if (!this.isValid) return INVALID$1;\n    return "" + this.s.toFormat(dateFormat) + separator + this.e.toFormat(dateFormat);\n  }\n  /**\n   * Return a Duration representing the time spanned by this interval.\n   * @param {string|string[]} [unit=[\'milliseconds\']] - the unit or units (such as \'hours\' or \'days\') to include in the duration.\n   * @param {Object} opts - options that affect the creation of the Duration\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @example Interval.fromDateTimes(dt1, dt2).toDuration().toObject() //=> { milliseconds: 88489257 }\n   * @example Interval.fromDateTimes(dt1, dt2).toDuration(\'days\').toObject() //=> { days: 1.0241812152777778 }\n   * @example Interval.fromDateTimes(dt1, dt2).toDuration([\'hours\', \'minutes\']).toObject() //=> { hours: 24, minutes: 34.82095 }\n   * @example Interval.fromDateTimes(dt1, dt2).toDuration([\'hours\', \'minutes\', \'seconds\']).toObject() //=> { hours: 24, minutes: 34, seconds: 49.257 }\n   * @example Interval.fromDateTimes(dt1, dt2).toDuration(\'seconds\').toObject() //=> { seconds: 88489.257 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.toDuration = function toDuration(unit, opts) {\n    if (!this.isValid) {\n      return Duration.invalid(this.invalidReason);\n    }\n\n    return this.e.diff(this.s, unit, opts);\n  }\n  /**\n   * Run mapFn on the interval start and end, returning a new Interval from the resulting DateTimes\n   * @param {function} mapFn\n   * @return {Interval}\n   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.toUTC())\n   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.plus({ hours: 2 }))\n   */\n  ;\n\n  _proto.mapEndpoints = function mapEndpoints(mapFn) {\n    return Interval.fromDateTimes(mapFn(this.s), mapFn(this.e));\n  };\n\n  _createClass(Interval, [{\n    key: "start",\n    get: function get() {\n      return this.isValid ? this.s : null;\n    }\n    /**\n     * Returns the end of the Interval\n     * @type {DateTime}\n     */\n\n  }, {\n    key: "end",\n    get: function get() {\n      return this.isValid ? this.e : null;\n    }\n    /**\n     * Returns whether this Interval\'s end is at least its start, meaning that the Interval isn\'t \'backwards\'.\n     * @type {boolean}\n     */\n\n  }, {\n    key: "isValid",\n    get: function get() {\n      return this.invalidReason === null;\n    }\n    /**\n     * Returns an error code if this Interval is invalid, or null if the Interval is valid\n     * @type {string}\n     */\n\n  }, {\n    key: "invalidReason",\n    get: function get() {\n      return this.invalid ? this.invalid.reason : null;\n    }\n    /**\n     * Returns an explanation of why this Interval became invalid, or null if the Interval is valid\n     * @type {string}\n     */\n\n  }, {\n    key: "invalidExplanation",\n    get: function get() {\n      return this.invalid ? this.invalid.explanation : null;\n    }\n  }]);\n\n  return Interval;\n}();\n\n/**\n * The Info class contains static methods for retrieving general time and date related data. For example, it has methods for finding out if a time zone has a DST, for listing the months in any supported locale, and for discovering which of Luxon features are available in the current environment.\n */\n\nvar Info = /*#__PURE__*/function () {\n  function Info() {}\n\n  /**\n   * Return whether the specified zone contains a DST.\n   * @param {string|Zone} [zone=\'local\'] - Zone to check. Defaults to the environment\'s local zone.\n   * @return {boolean}\n   */\n  Info.hasDST = function hasDST(zone) {\n    if (zone === void 0) {\n      zone = Settings.defaultZone;\n    }\n\n    var proto = DateTime.now().setZone(zone).set({\n      month: 12\n    });\n    return !zone.universal && proto.offset !== proto.set({\n      month: 6\n    }).offset;\n  }\n  /**\n   * Return whether the specified zone is a valid IANA specifier.\n   * @param {string} zone - Zone to check\n   * @return {boolean}\n   */\n  ;\n\n  Info.isValidIANAZone = function isValidIANAZone(zone) {\n    return IANAZone.isValidSpecifier(zone) && IANAZone.isValidZone(zone);\n  }\n  /**\n   * Converts the input into a {@link Zone} instance.\n   *\n   * * If `input` is already a Zone instance, it is returned unchanged.\n   * * If `input` is a string containing a valid time zone name, a Zone instance\n   *   with that name is returned.\n   * * If `input` is a string that doesn\'t refer to a known time zone, a Zone\n   *   instance with {@link Zone.isValid} == false is returned.\n   * * If `input is a number, a Zone instance with the specified fixed offset\n   *   in minutes is returned.\n   * * If `input` is `null` or `undefined`, the default zone is returned.\n   * @param {string|Zone|number} [input] - the value to be converted\n   * @return {Zone}\n   */\n  ;\n\n  Info.normalizeZone = function normalizeZone$1(input) {\n    return normalizeZone(input, Settings.defaultZone);\n  }\n  /**\n   * Return an array of standalone month names.\n   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat\n   * @param {string} [length=\'long\'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"\n   * @param {Object} opts - options\n   * @param {string} [opts.locale] - the locale code\n   * @param {string} [opts.numberingSystem=null] - the numbering system\n   * @param {string} [opts.outputCalendar=\'gregory\'] - the calendar\n   * @example Info.months()[0] //=> \'January\'\n   * @example Info.months(\'short\')[0] //=> \'Jan\'\n   * @example Info.months(\'numeric\')[0] //=> \'1\'\n   * @example Info.months(\'short\', { locale: \'fr-CA\' } )[0] //=> \'janv.\'\n   * @example Info.months(\'numeric\', { locale: \'ar\' })[0] //=> \'١\'\n   * @example Info.months(\'long\', { outputCalendar: \'islamic\' })[0] //=> \'Rabiʻ I\'\n   * @return {[string]}\n   */\n  ;\n\n  Info.months = function months(length, _temp) {\n    if (length === void 0) {\n      length = "long";\n    }\n\n    var _ref = _temp === void 0 ? {} : _temp,\n        _ref$locale = _ref.locale,\n        locale = _ref$locale === void 0 ? null : _ref$locale,\n        _ref$numberingSystem = _ref.numberingSystem,\n        numberingSystem = _ref$numberingSystem === void 0 ? null : _ref$numberingSystem,\n        _ref$outputCalendar = _ref.outputCalendar,\n        outputCalendar = _ref$outputCalendar === void 0 ? "gregory" : _ref$outputCalendar;\n\n    return Locale.create(locale, numberingSystem, outputCalendar).months(length);\n  }\n  /**\n   * Return an array of format month names.\n   * Format months differ from standalone months in that they\'re meant to appear next to the day of the month. In some languages, that\n   * changes the string.\n   * See {@link months}\n   * @param {string} [length=\'long\'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"\n   * @param {Object} opts - options\n   * @param {string} [opts.locale] - the locale code\n   * @param {string} [opts.numberingSystem=null] - the numbering system\n   * @param {string} [opts.outputCalendar=\'gregory\'] - the calendar\n   * @return {[string]}\n   */\n  ;\n\n  Info.monthsFormat = function monthsFormat(length, _temp2) {\n    if (length === void 0) {\n      length = "long";\n    }\n\n    var _ref2 = _temp2 === void 0 ? {} : _temp2,\n        _ref2$locale = _ref2.locale,\n        locale = _ref2$locale === void 0 ? null : _ref2$locale,\n        _ref2$numberingSystem = _ref2.numberingSystem,\n        numberingSystem = _ref2$numberingSystem === void 0 ? null : _ref2$numberingSystem,\n        _ref2$outputCalendar = _ref2.outputCalendar,\n        outputCalendar = _ref2$outputCalendar === void 0 ? "gregory" : _ref2$outputCalendar;\n\n    return Locale.create(locale, numberingSystem, outputCalendar).months(length, true);\n  }\n  /**\n   * Return an array of standalone week names.\n   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat\n   * @param {string} [length=\'long\'] - the length of the weekday representation, such as "narrow", "short", "long".\n   * @param {Object} opts - options\n   * @param {string} [opts.locale] - the locale code\n   * @param {string} [opts.numberingSystem=null] - the numbering system\n   * @example Info.weekdays()[0] //=> \'Monday\'\n   * @example Info.weekdays(\'short\')[0] //=> \'Mon\'\n   * @example Info.weekdays(\'short\', { locale: \'fr-CA\' })[0] //=> \'lun.\'\n   * @example Info.weekdays(\'short\', { locale: \'ar\' })[0] //=> \'الاثنين\'\n   * @return {[string]}\n   */\n  ;\n\n  Info.weekdays = function weekdays(length, _temp3) {\n    if (length === void 0) {\n      length = "long";\n    }\n\n    var _ref3 = _temp3 === void 0 ? {} : _temp3,\n        _ref3$locale = _ref3.locale,\n        locale = _ref3$locale === void 0 ? null : _ref3$locale,\n        _ref3$numberingSystem = _ref3.numberingSystem,\n        numberingSystem = _ref3$numberingSystem === void 0 ? null : _ref3$numberingSystem;\n\n    return Locale.create(locale, numberingSystem, null).weekdays(length);\n  }\n  /**\n   * Return an array of format week names.\n   * Format weekdays differ from standalone weekdays in that they\'re meant to appear next to more date information. In some languages, that\n   * changes the string.\n   * See {@link weekdays}\n   * @param {string} [length=\'long\'] - the length of the weekday representation, such as "narrow", "short", "long".\n   * @param {Object} opts - options\n   * @param {string} [opts.locale=null] - the locale code\n   * @param {string} [opts.numberingSystem=null] - the numbering system\n   * @return {[string]}\n   */\n  ;\n\n  Info.weekdaysFormat = function weekdaysFormat(length, _temp4) {\n    if (length === void 0) {\n      length = "long";\n    }\n\n    var _ref4 = _temp4 === void 0 ? {} : _temp4,\n        _ref4$locale = _ref4.locale,\n        locale = _ref4$locale === void 0 ? null : _ref4$locale,\n        _ref4$numberingSystem = _ref4.numberingSystem,\n        numberingSystem = _ref4$numberingSystem === void 0 ? null : _ref4$numberingSystem;\n\n    return Locale.create(locale, numberingSystem, null).weekdays(length, true);\n  }\n  /**\n   * Return an array of meridiems.\n   * @param {Object} opts - options\n   * @param {string} [opts.locale] - the locale code\n   * @example Info.meridiems() //=> [ \'AM\', \'PM\' ]\n   * @example Info.meridiems({ locale: \'my\' }) //=> [ \'နံနက်\', \'ညနေ\' ]\n   * @return {[string]}\n   */\n  ;\n\n  Info.meridiems = function meridiems(_temp5) {\n    var _ref5 = _temp5 === void 0 ? {} : _temp5,\n        _ref5$locale = _ref5.locale,\n        locale = _ref5$locale === void 0 ? null : _ref5$locale;\n\n    return Locale.create(locale).meridiems();\n  }\n  /**\n   * Return an array of eras, such as [\'BC\', \'AD\']. The locale can be specified, but the calendar system is always Gregorian.\n   * @param {string} [length=\'short\'] - the length of the era representation, such as "short" or "long".\n   * @param {Object} opts - options\n   * @param {string} [opts.locale] - the locale code\n   * @example Info.eras() //=> [ \'BC\', \'AD\' ]\n   * @example Info.eras(\'long\') //=> [ \'Before Christ\', \'Anno Domini\' ]\n   * @example Info.eras(\'long\', { locale: \'fr\' }) //=> [ \'avant Jésus-Christ\', \'après Jésus-Christ\' ]\n   * @return {[string]}\n   */\n  ;\n\n  Info.eras = function eras(length, _temp6) {\n    if (length === void 0) {\n      length = "short";\n    }\n\n    var _ref6 = _temp6 === void 0 ? {} : _temp6,\n        _ref6$locale = _ref6.locale,\n        locale = _ref6$locale === void 0 ? null : _ref6$locale;\n\n    return Locale.create(locale, null, "gregory").eras(length);\n  }\n  /**\n   * Return the set of available features in this environment.\n   * Some features of Luxon are not available in all environments. For example, on older browsers, timezone support is not available. Use this function to figure out if that\'s the case.\n   * Keys:\n   * * `zones`: whether this environment supports IANA timezones\n   * * `intlTokens`: whether this environment supports internationalized token-based formatting/parsing\n   * * `intl`: whether this environment supports general internationalization\n   * * `relative`: whether this environment supports relative time formatting\n   * @example Info.features() //=> { intl: true, intlTokens: false, zones: true, relative: false }\n   * @return {Object}\n   */\n  ;\n\n  Info.features = function features() {\n    var intl = false,\n        intlTokens = false,\n        zones = false,\n        relative = false;\n\n    if (hasIntl()) {\n      intl = true;\n      intlTokens = hasFormatToParts();\n      relative = hasRelative();\n\n      try {\n        zones = new Intl.DateTimeFormat("en", {\n          timeZone: "America/New_York"\n        }).resolvedOptions().timeZone === "America/New_York";\n      } catch (e) {\n        zones = false;\n      }\n    }\n\n    return {\n      intl: intl,\n      intlTokens: intlTokens,\n      zones: zones,\n      relative: relative\n    };\n  };\n\n  return Info;\n}();\n\nfunction dayDiff(earlier, later) {\n  var utcDayStart = function utcDayStart(dt) {\n    return dt.toUTC(0, {\n      keepLocalTime: true\n    }).startOf("day").valueOf();\n  },\n      ms = utcDayStart(later) - utcDayStart(earlier);\n\n  return Math.floor(Duration.fromMillis(ms).as("days"));\n}\n\nfunction highOrderDiffs(cursor, later, units) {\n  var differs = [["years", function (a, b) {\n    return b.year - a.year;\n  }], ["quarters", function (a, b) {\n    return b.quarter - a.quarter;\n  }], ["months", function (a, b) {\n    return b.month - a.month + (b.year - a.year) * 12;\n  }], ["weeks", function (a, b) {\n    var days = dayDiff(a, b);\n    return (days - days % 7) / 7;\n  }], ["days", dayDiff]];\n  var results = {};\n  var lowestOrder, highWater;\n\n  for (var _i = 0, _differs = differs; _i < _differs.length; _i++) {\n    var _differs$_i = _differs[_i],\n        unit = _differs$_i[0],\n        differ = _differs$_i[1];\n\n    if (units.indexOf(unit) >= 0) {\n      var _cursor$plus;\n\n      lowestOrder = unit;\n      var delta = differ(cursor, later);\n      highWater = cursor.plus((_cursor$plus = {}, _cursor$plus[unit] = delta, _cursor$plus));\n\n      if (highWater > later) {\n        var _cursor$plus2;\n\n        cursor = cursor.plus((_cursor$plus2 = {}, _cursor$plus2[unit] = delta - 1, _cursor$plus2));\n        delta -= 1;\n      } else {\n        cursor = highWater;\n      }\n\n      results[unit] = delta;\n    }\n  }\n\n  return [cursor, results, highWater, lowestOrder];\n}\n\nfunction _diff (earlier, later, units, opts) {\n  var _highOrderDiffs = highOrderDiffs(earlier, later, units),\n      cursor = _highOrderDiffs[0],\n      results = _highOrderDiffs[1],\n      highWater = _highOrderDiffs[2],\n      lowestOrder = _highOrderDiffs[3];\n\n  var remainingMillis = later - cursor;\n  var lowerOrderUnits = units.filter(function (u) {\n    return ["hours", "minutes", "seconds", "milliseconds"].indexOf(u) >= 0;\n  });\n\n  if (lowerOrderUnits.length === 0) {\n    if (highWater < later) {\n      var _cursor$plus3;\n\n      highWater = cursor.plus((_cursor$plus3 = {}, _cursor$plus3[lowestOrder] = 1, _cursor$plus3));\n    }\n\n    if (highWater !== cursor) {\n      results[lowestOrder] = (results[lowestOrder] || 0) + remainingMillis / (highWater - cursor);\n    }\n  }\n\n  var duration = Duration.fromObject(Object.assign(results, opts));\n\n  if (lowerOrderUnits.length > 0) {\n    var _Duration$fromMillis;\n\n    return (_Duration$fromMillis = Duration.fromMillis(remainingMillis, opts)).shiftTo.apply(_Duration$fromMillis, lowerOrderUnits).plus(duration);\n  } else {\n    return duration;\n  }\n}\n\nvar numberingSystems = {\n  arab: "[\\u0660-\\u0669]",\n  arabext: "[\\u06F0-\\u06F9]",\n  bali: "[\\u1B50-\\u1B59]",\n  beng: "[\\u09E6-\\u09EF]",\n  deva: "[\\u0966-\\u096F]",\n  fullwide: "[\\uFF10-\\uFF19]",\n  gujr: "[\\u0AE6-\\u0AEF]",\n  hanidec: "[〇|一|二|三|四|五|六|七|八|九]",\n  khmr: "[\\u17E0-\\u17E9]",\n  knda: "[\\u0CE6-\\u0CEF]",\n  laoo: "[\\u0ED0-\\u0ED9]",\n  limb: "[\\u1946-\\u194F]",\n  mlym: "[\\u0D66-\\u0D6F]",\n  mong: "[\\u1810-\\u1819]",\n  mymr: "[\\u1040-\\u1049]",\n  orya: "[\\u0B66-\\u0B6F]",\n  tamldec: "[\\u0BE6-\\u0BEF]",\n  telu: "[\\u0C66-\\u0C6F]",\n  thai: "[\\u0E50-\\u0E59]",\n  tibt: "[\\u0F20-\\u0F29]",\n  latn: "\\\\d"\n};\nvar numberingSystemsUTF16 = {\n  arab: [1632, 1641],\n  arabext: [1776, 1785],\n  bali: [6992, 7001],\n  beng: [2534, 2543],\n  deva: [2406, 2415],\n  fullwide: [65296, 65303],\n  gujr: [2790, 2799],\n  khmr: [6112, 6121],\n  knda: [3302, 3311],\n  laoo: [3792, 3801],\n  limb: [6470, 6479],\n  mlym: [3430, 3439],\n  mong: [6160, 6169],\n  mymr: [4160, 4169],\n  orya: [2918, 2927],\n  tamldec: [3046, 3055],\n  telu: [3174, 3183],\n  thai: [3664, 3673],\n  tibt: [3872, 3881]\n}; // eslint-disable-next-line\n\nvar hanidecChars = numberingSystems.hanidec.replace(/[\\[|\\]]/g, "").split("");\nfunction parseDigits(str) {\n  var value = parseInt(str, 10);\n\n  if (isNaN(value)) {\n    value = "";\n\n    for (var i = 0; i < str.length; i++) {\n      var code = str.charCodeAt(i);\n\n      if (str[i].search(numberingSystems.hanidec) !== -1) {\n        value += hanidecChars.indexOf(str[i]);\n      } else {\n        for (var key in numberingSystemsUTF16) {\n          var _numberingSystemsUTF = numberingSystemsUTF16[key],\n              min = _numberingSystemsUTF[0],\n              max = _numberingSystemsUTF[1];\n\n          if (code >= min && code <= max) {\n            value += code - min;\n          }\n        }\n      }\n    }\n\n    return parseInt(value, 10);\n  } else {\n    return value;\n  }\n}\nfunction digitRegex(_ref, append) {\n  var numberingSystem = _ref.numberingSystem;\n\n  if (append === void 0) {\n    append = "";\n  }\n\n  return new RegExp("" + numberingSystems[numberingSystem || "latn"] + append);\n}\n\nvar MISSING_FTP = "missing Intl.DateTimeFormat.formatToParts support";\n\nfunction intUnit(regex, post) {\n  if (post === void 0) {\n    post = function post(i) {\n      return i;\n    };\n  }\n\n  return {\n    regex: regex,\n    deser: function deser(_ref) {\n      var s = _ref[0];\n      return post(parseDigits(s));\n    }\n  };\n}\n\nvar NBSP = String.fromCharCode(160);\nvar spaceOrNBSP = "( |" + NBSP + ")";\nvar spaceOrNBSPRegExp = new RegExp(spaceOrNBSP, "g");\n\nfunction fixListRegex(s) {\n  // make dots optional and also make them literal\n  // make space and non breakable space characters interchangeable\n  return s.replace(/\\./g, "\\\\.?").replace(spaceOrNBSPRegExp, spaceOrNBSP);\n}\n\nfunction stripInsensitivities(s) {\n  return s.replace(/\\./g, "") // ignore dots that were made optional\n  .replace(spaceOrNBSPRegExp, " ") // interchange space and nbsp\n  .toLowerCase();\n}\n\nfunction oneOf(strings, startIndex) {\n  if (strings === null) {\n    return null;\n  } else {\n    return {\n      regex: RegExp(strings.map(fixListRegex).join("|")),\n      deser: function deser(_ref2) {\n        var s = _ref2[0];\n        return strings.findIndex(function (i) {\n          return stripInsensitivities(s) === stripInsensitivities(i);\n        }) + startIndex;\n      }\n    };\n  }\n}\n\nfunction offset(regex, groups) {\n  return {\n    regex: regex,\n    deser: function deser(_ref3) {\n      var h = _ref3[1],\n          m = _ref3[2];\n      return signedOffset(h, m);\n    },\n    groups: groups\n  };\n}\n\nfunction simple(regex) {\n  return {\n    regex: regex,\n    deser: function deser(_ref4) {\n      var s = _ref4[0];\n      return s;\n    }\n  };\n}\n\nfunction escapeToken(value) {\n  // eslint-disable-next-line no-useless-escape\n  return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, "\\\\$&");\n}\n\nfunction unitForToken(token, loc) {\n  var one = digitRegex(loc),\n      two = digitRegex(loc, "{2}"),\n      three = digitRegex(loc, "{3}"),\n      four = digitRegex(loc, "{4}"),\n      six = digitRegex(loc, "{6}"),\n      oneOrTwo = digitRegex(loc, "{1,2}"),\n      oneToThree = digitRegex(loc, "{1,3}"),\n      oneToSix = digitRegex(loc, "{1,6}"),\n      oneToNine = digitRegex(loc, "{1,9}"),\n      twoToFour = digitRegex(loc, "{2,4}"),\n      fourToSix = digitRegex(loc, "{4,6}"),\n      literal = function literal(t) {\n    return {\n      regex: RegExp(escapeToken(t.val)),\n      deser: function deser(_ref5) {\n        var s = _ref5[0];\n        return s;\n      },\n      literal: true\n    };\n  },\n      unitate = function unitate(t) {\n    if (token.literal) {\n      return literal(t);\n    }\n\n    switch (t.val) {\n      // era\n      case "G":\n        return oneOf(loc.eras("short", false), 0);\n\n      case "GG":\n        return oneOf(loc.eras("long", false), 0);\n      // years\n\n      case "y":\n        return intUnit(oneToSix);\n\n      case "yy":\n        return intUnit(twoToFour, untruncateYear);\n\n      case "yyyy":\n        return intUnit(four);\n\n      case "yyyyy":\n        return intUnit(fourToSix);\n\n      case "yyyyyy":\n        return intUnit(six);\n      // months\n\n      case "M":\n        return intUnit(oneOrTwo);\n\n      case "MM":\n        return intUnit(two);\n\n      case "MMM":\n        return oneOf(loc.months("short", true, false), 1);\n\n      case "MMMM":\n        return oneOf(loc.months("long", true, false), 1);\n\n      case "L":\n        return intUnit(oneOrTwo);\n\n      case "LL":\n        return intUnit(two);\n\n      case "LLL":\n        return oneOf(loc.months("short", false, false), 1);\n\n      case "LLLL":\n        return oneOf(loc.months("long", false, false), 1);\n      // dates\n\n      case "d":\n        return intUnit(oneOrTwo);\n\n      case "dd":\n        return intUnit(two);\n      // ordinals\n\n      case "o":\n        return intUnit(oneToThree);\n\n      case "ooo":\n        return intUnit(three);\n      // time\n\n      case "HH":\n        return intUnit(two);\n\n      case "H":\n        return intUnit(oneOrTwo);\n\n      case "hh":\n        return intUnit(two);\n\n      case "h":\n        return intUnit(oneOrTwo);\n\n      case "mm":\n        return intUnit(two);\n\n      case "m":\n        return intUnit(oneOrTwo);\n\n      case "q":\n        return intUnit(oneOrTwo);\n\n      case "qq":\n        return intUnit(two);\n\n      case "s":\n        return intUnit(oneOrTwo);\n\n      case "ss":\n        return intUnit(two);\n\n      case "S":\n        return intUnit(oneToThree);\n\n      case "SSS":\n        return intUnit(three);\n\n      case "u":\n        return simple(oneToNine);\n      // meridiem\n\n      case "a":\n        return oneOf(loc.meridiems(), 0);\n      // weekYear (k)\n\n      case "kkkk":\n        return intUnit(four);\n\n      case "kk":\n        return intUnit(twoToFour, untruncateYear);\n      // weekNumber (W)\n\n      case "W":\n        return intUnit(oneOrTwo);\n\n      case "WW":\n        return intUnit(two);\n      // weekdays\n\n      case "E":\n      case "c":\n        return intUnit(one);\n\n      case "EEE":\n        return oneOf(loc.weekdays("short", false, false), 1);\n\n      case "EEEE":\n        return oneOf(loc.weekdays("long", false, false), 1);\n\n      case "ccc":\n        return oneOf(loc.weekdays("short", true, false), 1);\n\n      case "cccc":\n        return oneOf(loc.weekdays("long", true, false), 1);\n      // offset/zone\n\n      case "Z":\n      case "ZZ":\n        return offset(new RegExp("([+-]" + oneOrTwo.source + ")(?::(" + two.source + "))?"), 2);\n\n      case "ZZZ":\n        return offset(new RegExp("([+-]" + oneOrTwo.source + ")(" + two.source + ")?"), 2);\n      // we don\'t support ZZZZ (PST) or ZZZZZ (Pacific Standard Time) in parsing\n      // because we don\'t have any way to figure out what they are\n\n      case "z":\n        return simple(/[a-z_+-/]{1,256}?/i);\n\n      default:\n        return literal(t);\n    }\n  };\n\n  var unit = unitate(token) || {\n    invalidReason: MISSING_FTP\n  };\n  unit.token = token;\n  return unit;\n}\n\nvar partTypeStyleToTokenVal = {\n  year: {\n    "2-digit": "yy",\n    numeric: "yyyyy"\n  },\n  month: {\n    numeric: "M",\n    "2-digit": "MM",\n    short: "MMM",\n    long: "MMMM"\n  },\n  day: {\n    numeric: "d",\n    "2-digit": "dd"\n  },\n  weekday: {\n    short: "EEE",\n    long: "EEEE"\n  },\n  dayperiod: "a",\n  dayPeriod: "a",\n  hour: {\n    numeric: "h",\n    "2-digit": "hh"\n  },\n  minute: {\n    numeric: "m",\n    "2-digit": "mm"\n  },\n  second: {\n    numeric: "s",\n    "2-digit": "ss"\n  }\n};\n\nfunction tokenForPart(part, locale, formatOpts) {\n  var type = part.type,\n      value = part.value;\n\n  if (type === "literal") {\n    return {\n      literal: true,\n      val: value\n    };\n  }\n\n  var style = formatOpts[type];\n  var val = partTypeStyleToTokenVal[type];\n\n  if (typeof val === "object") {\n    val = val[style];\n  }\n\n  if (val) {\n    return {\n      literal: false,\n      val: val\n    };\n  }\n\n  return undefined;\n}\n\nfunction buildRegex(units) {\n  var re = units.map(function (u) {\n    return u.regex;\n  }).reduce(function (f, r) {\n    return f + "(" + r.source + ")";\n  }, "");\n  return ["^" + re + "$", units];\n}\n\nfunction match(input, regex, handlers) {\n  var matches = input.match(regex);\n\n  if (matches) {\n    var all = {};\n    var matchIndex = 1;\n\n    for (var i in handlers) {\n      if (hasOwnProperty(handlers, i)) {\n        var h = handlers[i],\n            groups = h.groups ? h.groups + 1 : 1;\n\n        if (!h.literal && h.token) {\n          all[h.token.val[0]] = h.deser(matches.slice(matchIndex, matchIndex + groups));\n        }\n\n        matchIndex += groups;\n      }\n    }\n\n    return [matches, all];\n  } else {\n    return [matches, {}];\n  }\n}\n\nfunction dateTimeFromMatches(matches) {\n  var toField = function toField(token) {\n    switch (token) {\n      case "S":\n        return "millisecond";\n\n      case "s":\n        return "second";\n\n      case "m":\n        return "minute";\n\n      case "h":\n      case "H":\n        return "hour";\n\n      case "d":\n        return "day";\n\n      case "o":\n        return "ordinal";\n\n      case "L":\n      case "M":\n        return "month";\n\n      case "y":\n        return "year";\n\n      case "E":\n      case "c":\n        return "weekday";\n\n      case "W":\n        return "weekNumber";\n\n      case "k":\n        return "weekYear";\n\n      case "q":\n        return "quarter";\n\n      default:\n        return null;\n    }\n  };\n\n  var zone;\n\n  if (!isUndefined(matches.Z)) {\n    zone = new FixedOffsetZone(matches.Z);\n  } else if (!isUndefined(matches.z)) {\n    zone = IANAZone.create(matches.z);\n  } else {\n    zone = null;\n  }\n\n  if (!isUndefined(matches.q)) {\n    matches.M = (matches.q - 1) * 3 + 1;\n  }\n\n  if (!isUndefined(matches.h)) {\n    if (matches.h < 12 && matches.a === 1) {\n      matches.h += 12;\n    } else if (matches.h === 12 && matches.a === 0) {\n      matches.h = 0;\n    }\n  }\n\n  if (matches.G === 0 && matches.y) {\n    matches.y = -matches.y;\n  }\n\n  if (!isUndefined(matches.u)) {\n    matches.S = parseMillis(matches.u);\n  }\n\n  var vals = Object.keys(matches).reduce(function (r, k) {\n    var f = toField(k);\n\n    if (f) {\n      r[f] = matches[k];\n    }\n\n    return r;\n  }, {});\n  return [vals, zone];\n}\n\nvar dummyDateTimeCache = null;\n\nfunction getDummyDateTime() {\n  if (!dummyDateTimeCache) {\n    dummyDateTimeCache = DateTime.fromMillis(1555555555555);\n  }\n\n  return dummyDateTimeCache;\n}\n\nfunction maybeExpandMacroToken(token, locale) {\n  if (token.literal) {\n    return token;\n  }\n\n  var formatOpts = Formatter.macroTokenToFormatOpts(token.val);\n\n  if (!formatOpts) {\n    return token;\n  }\n\n  var formatter = Formatter.create(locale, formatOpts);\n  var parts = formatter.formatDateTimeParts(getDummyDateTime());\n  var tokens = parts.map(function (p) {\n    return tokenForPart(p, locale, formatOpts);\n  });\n\n  if (tokens.includes(undefined)) {\n    return token;\n  }\n\n  return tokens;\n}\n\nfunction expandMacroTokens(tokens, locale) {\n  var _Array$prototype;\n\n  return (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, tokens.map(function (t) {\n    return maybeExpandMacroToken(t, locale);\n  }));\n}\n/**\n * @private\n */\n\n\nfunction explainFromTokens(locale, input, format) {\n  var tokens = expandMacroTokens(Formatter.parseFormat(format), locale),\n      units = tokens.map(function (t) {\n    return unitForToken(t, locale);\n  }),\n      disqualifyingUnit = units.find(function (t) {\n    return t.invalidReason;\n  });\n\n  if (disqualifyingUnit) {\n    return {\n      input: input,\n      tokens: tokens,\n      invalidReason: disqualifyingUnit.invalidReason\n    };\n  } else {\n    var _buildRegex = buildRegex(units),\n        regexString = _buildRegex[0],\n        handlers = _buildRegex[1],\n        regex = RegExp(regexString, "i"),\n        _match = match(input, regex, handlers),\n        rawMatches = _match[0],\n        matches = _match[1],\n        _ref6 = matches ? dateTimeFromMatches(matches) : [null, null],\n        result = _ref6[0],\n        zone = _ref6[1];\n\n    if (hasOwnProperty(matches, "a") && hasOwnProperty(matches, "H")) {\n      throw new ConflictingSpecificationError("Can\'t include meridiem when specifying 24-hour format");\n    }\n\n    return {\n      input: input,\n      tokens: tokens,\n      regex: regex,\n      rawMatches: rawMatches,\n      matches: matches,\n      result: result,\n      zone: zone\n    };\n  }\n}\nfunction parseFromTokens(locale, input, format) {\n  var _explainFromTokens = explainFromTokens(locale, input, format),\n      result = _explainFromTokens.result,\n      zone = _explainFromTokens.zone,\n      invalidReason = _explainFromTokens.invalidReason;\n\n  return [result, zone, invalidReason];\n}\n\nvar nonLeapLadder = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334],\n    leapLadder = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];\n\nfunction unitOutOfRange(unit, value) {\n  return new Invalid("unit out of range", "you specified " + value + " (of type " + typeof value + ") as a " + unit + ", which is invalid");\n}\n\nfunction dayOfWeek(year, month, day) {\n  var js = new Date(Date.UTC(year, month - 1, day)).getUTCDay();\n  return js === 0 ? 7 : js;\n}\n\nfunction computeOrdinal(year, month, day) {\n  return day + (isLeapYear(year) ? leapLadder : nonLeapLadder)[month - 1];\n}\n\nfunction uncomputeOrdinal(year, ordinal) {\n  var table = isLeapYear(year) ? leapLadder : nonLeapLadder,\n      month0 = table.findIndex(function (i) {\n    return i < ordinal;\n  }),\n      day = ordinal - table[month0];\n  return {\n    month: month0 + 1,\n    day: day\n  };\n}\n/**\n * @private\n */\n\n\nfunction gregorianToWeek(gregObj) {\n  var year = gregObj.year,\n      month = gregObj.month,\n      day = gregObj.day,\n      ordinal = computeOrdinal(year, month, day),\n      weekday = dayOfWeek(year, month, day);\n  var weekNumber = Math.floor((ordinal - weekday + 10) / 7),\n      weekYear;\n\n  if (weekNumber < 1) {\n    weekYear = year - 1;\n    weekNumber = weeksInWeekYear(weekYear);\n  } else if (weekNumber > weeksInWeekYear(year)) {\n    weekYear = year + 1;\n    weekNumber = 1;\n  } else {\n    weekYear = year;\n  }\n\n  return Object.assign({\n    weekYear: weekYear,\n    weekNumber: weekNumber,\n    weekday: weekday\n  }, timeObject(gregObj));\n}\nfunction weekToGregorian(weekData) {\n  var weekYear = weekData.weekYear,\n      weekNumber = weekData.weekNumber,\n      weekday = weekData.weekday,\n      weekdayOfJan4 = dayOfWeek(weekYear, 1, 4),\n      yearInDays = daysInYear(weekYear);\n  var ordinal = weekNumber * 7 + weekday - weekdayOfJan4 - 3,\n      year;\n\n  if (ordinal < 1) {\n    year = weekYear - 1;\n    ordinal += daysInYear(year);\n  } else if (ordinal > yearInDays) {\n    year = weekYear + 1;\n    ordinal -= daysInYear(weekYear);\n  } else {\n    year = weekYear;\n  }\n\n  var _uncomputeOrdinal = uncomputeOrdinal(year, ordinal),\n      month = _uncomputeOrdinal.month,\n      day = _uncomputeOrdinal.day;\n\n  return Object.assign({\n    year: year,\n    month: month,\n    day: day\n  }, timeObject(weekData));\n}\nfunction gregorianToOrdinal(gregData) {\n  var year = gregData.year,\n      month = gregData.month,\n      day = gregData.day,\n      ordinal = computeOrdinal(year, month, day);\n  return Object.assign({\n    year: year,\n    ordinal: ordinal\n  }, timeObject(gregData));\n}\nfunction ordinalToGregorian(ordinalData) {\n  var year = ordinalData.year,\n      ordinal = ordinalData.ordinal,\n      _uncomputeOrdinal2 = uncomputeOrdinal(year, ordinal),\n      month = _uncomputeOrdinal2.month,\n      day = _uncomputeOrdinal2.day;\n\n  return Object.assign({\n    year: year,\n    month: month,\n    day: day\n  }, timeObject(ordinalData));\n}\nfunction hasInvalidWeekData(obj) {\n  var validYear = isInteger(obj.weekYear),\n      validWeek = integerBetween(obj.weekNumber, 1, weeksInWeekYear(obj.weekYear)),\n      validWeekday = integerBetween(obj.weekday, 1, 7);\n\n  if (!validYear) {\n    return unitOutOfRange("weekYear", obj.weekYear);\n  } else if (!validWeek) {\n    return unitOutOfRange("week", obj.week);\n  } else if (!validWeekday) {\n    return unitOutOfRange("weekday", obj.weekday);\n  } else return false;\n}\nfunction hasInvalidOrdinalData(obj) {\n  var validYear = isInteger(obj.year),\n      validOrdinal = integerBetween(obj.ordinal, 1, daysInYear(obj.year));\n\n  if (!validYear) {\n    return unitOutOfRange("year", obj.year);\n  } else if (!validOrdinal) {\n    return unitOutOfRange("ordinal", obj.ordinal);\n  } else return false;\n}\nfunction hasInvalidGregorianData(obj) {\n  var validYear = isInteger(obj.year),\n      validMonth = integerBetween(obj.month, 1, 12),\n      validDay = integerBetween(obj.day, 1, daysInMonth(obj.year, obj.month));\n\n  if (!validYear) {\n    return unitOutOfRange("year", obj.year);\n  } else if (!validMonth) {\n    return unitOutOfRange("month", obj.month);\n  } else if (!validDay) {\n    return unitOutOfRange("day", obj.day);\n  } else return false;\n}\nfunction hasInvalidTimeData(obj) {\n  var hour = obj.hour,\n      minute = obj.minute,\n      second = obj.second,\n      millisecond = obj.millisecond;\n  var validHour = integerBetween(hour, 0, 23) || hour === 24 && minute === 0 && second === 0 && millisecond === 0,\n      validMinute = integerBetween(minute, 0, 59),\n      validSecond = integerBetween(second, 0, 59),\n      validMillisecond = integerBetween(millisecond, 0, 999);\n\n  if (!validHour) {\n    return unitOutOfRange("hour", hour);\n  } else if (!validMinute) {\n    return unitOutOfRange("minute", minute);\n  } else if (!validSecond) {\n    return unitOutOfRange("second", second);\n  } else if (!validMillisecond) {\n    return unitOutOfRange("millisecond", millisecond);\n  } else return false;\n}\n\nvar INVALID$2 = "Invalid DateTime";\nvar MAX_DATE = 8.64e15;\n\nfunction unsupportedZone(zone) {\n  return new Invalid("unsupported zone", "the zone \\"" + zone.name + "\\" is not supported");\n} // we cache week data on the DT object and this intermediates the cache\n\n\nfunction possiblyCachedWeekData(dt) {\n  if (dt.weekData === null) {\n    dt.weekData = gregorianToWeek(dt.c);\n  }\n\n  return dt.weekData;\n} // clone really means, "make a new object with these modifications". all "setters" really use this\n// to create a new object while only changing some of the properties\n\n\nfunction clone$1(inst, alts) {\n  var current = {\n    ts: inst.ts,\n    zone: inst.zone,\n    c: inst.c,\n    o: inst.o,\n    loc: inst.loc,\n    invalid: inst.invalid\n  };\n  return new DateTime(Object.assign({}, current, alts, {\n    old: current\n  }));\n} // find the right offset a given local time. The o input is our guess, which determines which\n// offset we\'ll pick in ambiguous cases (e.g. there are two 3 AMs b/c Fallback DST)\n\n\nfunction fixOffset(localTS, o, tz) {\n  // Our UTC time is just a guess because our offset is just a guess\n  var utcGuess = localTS - o * 60 * 1000; // Test whether the zone matches the offset for this ts\n\n  var o2 = tz.offset(utcGuess); // If so, offset didn\'t change and we\'re done\n\n  if (o === o2) {\n    return [utcGuess, o];\n  } // If not, change the ts by the difference in the offset\n\n\n  utcGuess -= (o2 - o) * 60 * 1000; // If that gives us the local time we want, we\'re done\n\n  var o3 = tz.offset(utcGuess);\n\n  if (o2 === o3) {\n    return [utcGuess, o2];\n  } // If it\'s different, we\'re in a hole time. The offset has changed, but the we don\'t adjust the time\n\n\n  return [localTS - Math.min(o2, o3) * 60 * 1000, Math.max(o2, o3)];\n} // convert an epoch timestamp into a calendar object with the given offset\n\n\nfunction tsToObj(ts, offset) {\n  ts += offset * 60 * 1000;\n  var d = new Date(ts);\n  return {\n    year: d.getUTCFullYear(),\n    month: d.getUTCMonth() + 1,\n    day: d.getUTCDate(),\n    hour: d.getUTCHours(),\n    minute: d.getUTCMinutes(),\n    second: d.getUTCSeconds(),\n    millisecond: d.getUTCMilliseconds()\n  };\n} // convert a calendar object to a epoch timestamp\n\n\nfunction objToTS(obj, offset, zone) {\n  return fixOffset(objToLocalTS(obj), offset, zone);\n} // create a new DT instance by adding a duration, adjusting for DSTs\n\n\nfunction adjustTime(inst, dur) {\n  var oPre = inst.o,\n      year = inst.c.year + Math.trunc(dur.years),\n      month = inst.c.month + Math.trunc(dur.months) + Math.trunc(dur.quarters) * 3,\n      c = Object.assign({}, inst.c, {\n    year: year,\n    month: month,\n    day: Math.min(inst.c.day, daysInMonth(year, month)) + Math.trunc(dur.days) + Math.trunc(dur.weeks) * 7\n  }),\n      millisToAdd = Duration.fromObject({\n    years: dur.years - Math.trunc(dur.years),\n    quarters: dur.quarters - Math.trunc(dur.quarters),\n    months: dur.months - Math.trunc(dur.months),\n    weeks: dur.weeks - Math.trunc(dur.weeks),\n    days: dur.days - Math.trunc(dur.days),\n    hours: dur.hours,\n    minutes: dur.minutes,\n    seconds: dur.seconds,\n    milliseconds: dur.milliseconds\n  }).as("milliseconds"),\n      localTS = objToLocalTS(c);\n\n  var _fixOffset = fixOffset(localTS, oPre, inst.zone),\n      ts = _fixOffset[0],\n      o = _fixOffset[1];\n\n  if (millisToAdd !== 0) {\n    ts += millisToAdd; // that could have changed the offset by going over a DST, but we want to keep the ts the same\n\n    o = inst.zone.offset(ts);\n  }\n\n  return {\n    ts: ts,\n    o: o\n  };\n} // helper useful in turning the results of parsing into real dates\n// by handling the zone options\n\n\nfunction parseDataToDateTime(parsed, parsedZone, opts, format, text) {\n  var setZone = opts.setZone,\n      zone = opts.zone;\n\n  if (parsed && Object.keys(parsed).length !== 0) {\n    var interpretationZone = parsedZone || zone,\n        inst = DateTime.fromObject(Object.assign(parsed, opts, {\n      zone: interpretationZone,\n      // setZone is a valid option in the calling methods, but not in fromObject\n      setZone: undefined\n    }));\n    return setZone ? inst : inst.setZone(zone);\n  } else {\n    return DateTime.invalid(new Invalid("unparsable", "the input \\"" + text + "\\" can\'t be parsed as " + format));\n  }\n} // if you want to output a technical format (e.g. RFC 2822), this helper\n// helps handle the details\n\n\nfunction toTechFormat(dt, format, allowZ) {\n  if (allowZ === void 0) {\n    allowZ = true;\n  }\n\n  return dt.isValid ? Formatter.create(Locale.create("en-US"), {\n    allowZ: allowZ,\n    forceSimple: true\n  }).formatDateTimeFromString(dt, format) : null;\n} // technical time formats (e.g. the time part of ISO 8601), take some options\n// and this commonizes their handling\n\n\nfunction toTechTimeFormat(dt, _ref) {\n  var _ref$suppressSeconds = _ref.suppressSeconds,\n      suppressSeconds = _ref$suppressSeconds === void 0 ? false : _ref$suppressSeconds,\n      _ref$suppressMillisec = _ref.suppressMilliseconds,\n      suppressMilliseconds = _ref$suppressMillisec === void 0 ? false : _ref$suppressMillisec,\n      includeOffset = _ref.includeOffset,\n      _ref$includePrefix = _ref.includePrefix,\n      includePrefix = _ref$includePrefix === void 0 ? false : _ref$includePrefix,\n      _ref$includeZone = _ref.includeZone,\n      includeZone = _ref$includeZone === void 0 ? false : _ref$includeZone,\n      _ref$spaceZone = _ref.spaceZone,\n      spaceZone = _ref$spaceZone === void 0 ? false : _ref$spaceZone,\n      _ref$format = _ref.format,\n      format = _ref$format === void 0 ? "extended" : _ref$format;\n  var fmt = format === "basic" ? "HHmm" : "HH:mm";\n\n  if (!suppressSeconds || dt.second !== 0 || dt.millisecond !== 0) {\n    fmt += format === "basic" ? "ss" : ":ss";\n\n    if (!suppressMilliseconds || dt.millisecond !== 0) {\n      fmt += ".SSS";\n    }\n  }\n\n  if ((includeZone || includeOffset) && spaceZone) {\n    fmt += " ";\n  }\n\n  if (includeZone) {\n    fmt += "z";\n  } else if (includeOffset) {\n    fmt += format === "basic" ? "ZZZ" : "ZZ";\n  }\n\n  var str = toTechFormat(dt, fmt);\n\n  if (includePrefix) {\n    str = "T" + str;\n  }\n\n  return str;\n} // defaults for unspecified units in the supported calendars\n\n\nvar defaultUnitValues = {\n  month: 1,\n  day: 1,\n  hour: 0,\n  minute: 0,\n  second: 0,\n  millisecond: 0\n},\n    defaultWeekUnitValues = {\n  weekNumber: 1,\n  weekday: 1,\n  hour: 0,\n  minute: 0,\n  second: 0,\n  millisecond: 0\n},\n    defaultOrdinalUnitValues = {\n  ordinal: 1,\n  hour: 0,\n  minute: 0,\n  second: 0,\n  millisecond: 0\n}; // Units in the supported calendars, sorted by bigness\n\nvar orderedUnits$1 = ["year", "month", "day", "hour", "minute", "second", "millisecond"],\n    orderedWeekUnits = ["weekYear", "weekNumber", "weekday", "hour", "minute", "second", "millisecond"],\n    orderedOrdinalUnits = ["year", "ordinal", "hour", "minute", "second", "millisecond"]; // standardize case and plurality in units\n\nfunction normalizeUnit(unit) {\n  var normalized = {\n    year: "year",\n    years: "year",\n    month: "month",\n    months: "month",\n    day: "day",\n    days: "day",\n    hour: "hour",\n    hours: "hour",\n    minute: "minute",\n    minutes: "minute",\n    quarter: "quarter",\n    quarters: "quarter",\n    second: "second",\n    seconds: "second",\n    millisecond: "millisecond",\n    milliseconds: "millisecond",\n    weekday: "weekday",\n    weekdays: "weekday",\n    weeknumber: "weekNumber",\n    weeksnumber: "weekNumber",\n    weeknumbers: "weekNumber",\n    weekyear: "weekYear",\n    weekyears: "weekYear",\n    ordinal: "ordinal"\n  }[unit.toLowerCase()];\n  if (!normalized) throw new InvalidUnitError(unit);\n  return normalized;\n} // this is a dumbed down version of fromObject() that runs about 60% faster\n// but doesn\'t do any validation, makes a bunch of assumptions about what units\n// are present, and so on.\n\n\nfunction quickDT(obj, zone) {\n  // assume we have the higher-order units\n  for (var _iterator = _createForOfIteratorHelperLoose(orderedUnits$1), _step; !(_step = _iterator()).done;) {\n    var u = _step.value;\n\n    if (isUndefined(obj[u])) {\n      obj[u] = defaultUnitValues[u];\n    }\n  }\n\n  var invalid = hasInvalidGregorianData(obj) || hasInvalidTimeData(obj);\n\n  if (invalid) {\n    return DateTime.invalid(invalid);\n  }\n\n  var tsNow = Settings.now(),\n      offsetProvis = zone.offset(tsNow),\n      _objToTS = objToTS(obj, offsetProvis, zone),\n      ts = _objToTS[0],\n      o = _objToTS[1];\n\n  return new DateTime({\n    ts: ts,\n    zone: zone,\n    o: o\n  });\n}\n\nfunction diffRelative(start, end, opts) {\n  var round = isUndefined(opts.round) ? true : opts.round,\n      format = function format(c, unit) {\n    c = roundTo(c, round || opts.calendary ? 0 : 2, true);\n    var formatter = end.loc.clone(opts).relFormatter(opts);\n    return formatter.format(c, unit);\n  },\n      differ = function differ(unit) {\n    if (opts.calendary) {\n      if (!end.hasSame(start, unit)) {\n        return end.startOf(unit).diff(start.startOf(unit), unit).get(unit);\n      } else return 0;\n    } else {\n      return end.diff(start, unit).get(unit);\n    }\n  };\n\n  if (opts.unit) {\n    return format(differ(opts.unit), opts.unit);\n  }\n\n  for (var _iterator2 = _createForOfIteratorHelperLoose(opts.units), _step2; !(_step2 = _iterator2()).done;) {\n    var unit = _step2.value;\n    var count = differ(unit);\n\n    if (Math.abs(count) >= 1) {\n      return format(count, unit);\n    }\n  }\n\n  return format(0, opts.units[opts.units.length - 1]);\n}\n/**\n * A DateTime is an immutable data structure representing a specific date and time and accompanying methods. It contains class and instance methods for creating, parsing, interrogating, transforming, and formatting them.\n *\n * A DateTime comprises of:\n * * A timestamp. Each DateTime instance refers to a specific millisecond of the Unix epoch.\n * * A time zone. Each instance is considered in the context of a specific zone (by default the local system\'s zone).\n * * Configuration properties that effect how output strings are formatted, such as `locale`, `numberingSystem`, and `outputCalendar`.\n *\n * Here is a brief overview of the most commonly used functionality it provides:\n *\n * * **Creation**: To create a DateTime from its components, use one of its factory class methods: {@link local}, {@link utc}, and (most flexibly) {@link fromObject}. To create one from a standard string format, use {@link fromISO}, {@link fromHTTP}, and {@link fromRFC2822}. To create one from a custom string format, use {@link fromFormat}. To create one from a native JS date, use {@link fromJSDate}.\n * * **Gregorian calendar and time**: To examine the Gregorian properties of a DateTime individually (i.e as opposed to collectively through {@link toObject}), use the {@link year}, {@link month},\n * {@link day}, {@link hour}, {@link minute}, {@link second}, {@link millisecond} accessors.\n * * **Week calendar**: For ISO week calendar attributes, see the {@link weekYear}, {@link weekNumber}, and {@link weekday} accessors.\n * * **Configuration** See the {@link locale} and {@link numberingSystem} accessors.\n * * **Transformation**: To transform the DateTime into other DateTimes, use {@link set}, {@link reconfigure}, {@link setZone}, {@link setLocale}, {@link plus}, {@link minus}, {@link endOf}, {@link startOf}, {@link toUTC}, and {@link toLocal}.\n * * **Output**: To convert the DateTime to other representations, use the {@link toRelative}, {@link toRelativeCalendar}, {@link toJSON}, {@link toISO}, {@link toHTTP}, {@link toObject}, {@link toRFC2822}, {@link toString}, {@link toLocaleString}, {@link toFormat}, {@link toMillis} and {@link toJSDate}.\n *\n * There\'s plenty others documented below. In addition, for more information on subtler topics like internationalization, time zones, alternative calendars, validity, and so on, see the external documentation.\n */\n\n\nvar DateTime = /*#__PURE__*/function () {\n  /**\n   * @access private\n   */\n  function DateTime(config) {\n    var zone = config.zone || Settings.defaultZone;\n    var invalid = config.invalid || (Number.isNaN(config.ts) ? new Invalid("invalid input") : null) || (!zone.isValid ? unsupportedZone(zone) : null);\n    /**\n     * @access private\n     */\n\n    this.ts = isUndefined(config.ts) ? Settings.now() : config.ts;\n    var c = null,\n        o = null;\n\n    if (!invalid) {\n      var unchanged = config.old && config.old.ts === this.ts && config.old.zone.equals(zone);\n\n      if (unchanged) {\n        var _ref2 = [config.old.c, config.old.o];\n        c = _ref2[0];\n        o = _ref2[1];\n      } else {\n        var ot = zone.offset(this.ts);\n        c = tsToObj(this.ts, ot);\n        invalid = Number.isNaN(c.year) ? new Invalid("invalid input") : null;\n        c = invalid ? null : c;\n        o = invalid ? null : ot;\n      }\n    }\n    /**\n     * @access private\n     */\n\n\n    this._zone = zone;\n    /**\n     * @access private\n     */\n\n    this.loc = config.loc || Locale.create();\n    /**\n     * @access private\n     */\n\n    this.invalid = invalid;\n    /**\n     * @access private\n     */\n\n    this.weekData = null;\n    /**\n     * @access private\n     */\n\n    this.c = c;\n    /**\n     * @access private\n     */\n\n    this.o = o;\n    /**\n     * @access private\n     */\n\n    this.isLuxonDateTime = true;\n  } // CONSTRUCT\n\n  /**\n   * Create a DateTime for the current instant, in the system\'s time zone.\n   *\n   * Use Settings to override these default values if needed.\n   * @example DateTime.now().toISO() //~> now in the ISO format\n   * @return {DateTime}\n   */\n\n\n  DateTime.now = function now() {\n    return new DateTime({});\n  }\n  /**\n   * Create a local DateTime\n   * @param {number} [year] - The calendar year. If omitted (as in, call `local()` with no arguments), the current time will be used\n   * @param {number} [month=1] - The month, 1-indexed\n   * @param {number} [day=1] - The day of the month, 1-indexed\n   * @param {number} [hour=0] - The hour of the day, in 24-hour time\n   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59\n   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59\n   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999\n   * @example DateTime.local()                            //~> now\n   * @example DateTime.local(2017)                        //~> 2017-01-01T00:00:00\n   * @example DateTime.local(2017, 3)                     //~> 2017-03-01T00:00:00\n   * @example DateTime.local(2017, 3, 12)                 //~> 2017-03-12T00:00:00\n   * @example DateTime.local(2017, 3, 12, 5)              //~> 2017-03-12T05:00:00\n   * @example DateTime.local(2017, 3, 12, 5, 45)          //~> 2017-03-12T05:45:00\n   * @example DateTime.local(2017, 3, 12, 5, 45, 10)      //~> 2017-03-12T05:45:10\n   * @example DateTime.local(2017, 3, 12, 5, 45, 10, 765) //~> 2017-03-12T05:45:10.765\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.local = function local(year, month, day, hour, minute, second, millisecond) {\n    if (isUndefined(year)) {\n      return new DateTime({});\n    } else {\n      return quickDT({\n        year: year,\n        month: month,\n        day: day,\n        hour: hour,\n        minute: minute,\n        second: second,\n        millisecond: millisecond\n      }, Settings.defaultZone);\n    }\n  }\n  /**\n   * Create a DateTime in UTC\n   * @param {number} [year] - The calendar year. If omitted (as in, call `utc()` with no arguments), the current time will be used\n   * @param {number} [month=1] - The month, 1-indexed\n   * @param {number} [day=1] - The day of the month\n   * @param {number} [hour=0] - The hour of the day, in 24-hour time\n   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59\n   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59\n   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999\n   * @example DateTime.utc()                            //~> now\n   * @example DateTime.utc(2017)                        //~> 2017-01-01T00:00:00Z\n   * @example DateTime.utc(2017, 3)                     //~> 2017-03-01T00:00:00Z\n   * @example DateTime.utc(2017, 3, 12)                 //~> 2017-03-12T00:00:00Z\n   * @example DateTime.utc(2017, 3, 12, 5)              //~> 2017-03-12T05:00:00Z\n   * @example DateTime.utc(2017, 3, 12, 5, 45)          //~> 2017-03-12T05:45:00Z\n   * @example DateTime.utc(2017, 3, 12, 5, 45, 10)      //~> 2017-03-12T05:45:10Z\n   * @example DateTime.utc(2017, 3, 12, 5, 45, 10, 765) //~> 2017-03-12T05:45:10.765Z\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.utc = function utc(year, month, day, hour, minute, second, millisecond) {\n    if (isUndefined(year)) {\n      return new DateTime({\n        ts: Settings.now(),\n        zone: FixedOffsetZone.utcInstance\n      });\n    } else {\n      return quickDT({\n        year: year,\n        month: month,\n        day: day,\n        hour: hour,\n        minute: minute,\n        second: second,\n        millisecond: millisecond\n      }, FixedOffsetZone.utcInstance);\n    }\n  }\n  /**\n   * Create a DateTime from a JavaScript Date object. Uses the default zone.\n   * @param {Date} date - a JavaScript Date object\n   * @param {Object} options - configuration options for the DateTime\n   * @param {string|Zone} [options.zone=\'local\'] - the zone to place the DateTime into\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromJSDate = function fromJSDate(date, options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    var ts = isDate(date) ? date.valueOf() : NaN;\n\n    if (Number.isNaN(ts)) {\n      return DateTime.invalid("invalid input");\n    }\n\n    var zoneToUse = normalizeZone(options.zone, Settings.defaultZone);\n\n    if (!zoneToUse.isValid) {\n      return DateTime.invalid(unsupportedZone(zoneToUse));\n    }\n\n    return new DateTime({\n      ts: ts,\n      zone: zoneToUse,\n      loc: Locale.fromObject(options)\n    });\n  }\n  /**\n   * Create a DateTime from a number of milliseconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.\n   * @param {number} milliseconds - a number of milliseconds since 1970 UTC\n   * @param {Object} options - configuration options for the DateTime\n   * @param {string|Zone} [options.zone=\'local\'] - the zone to place the DateTime into\n   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance\n   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromMillis = function fromMillis(milliseconds, options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    if (!isNumber(milliseconds)) {\n      throw new InvalidArgumentError("fromMillis requires a numerical input, but received a " + typeof milliseconds + " with value " + milliseconds);\n    } else if (milliseconds < -MAX_DATE || milliseconds > MAX_DATE) {\n      // this isn\'t perfect because because we can still end up out of range because of additional shifting, but it\'s a start\n      return DateTime.invalid("Timestamp out of range");\n    } else {\n      return new DateTime({\n        ts: milliseconds,\n        zone: normalizeZone(options.zone, Settings.defaultZone),\n        loc: Locale.fromObject(options)\n      });\n    }\n  }\n  /**\n   * Create a DateTime from a number of seconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.\n   * @param {number} seconds - a number of seconds since 1970 UTC\n   * @param {Object} options - configuration options for the DateTime\n   * @param {string|Zone} [options.zone=\'local\'] - the zone to place the DateTime into\n   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance\n   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromSeconds = function fromSeconds(seconds, options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    if (!isNumber(seconds)) {\n      throw new InvalidArgumentError("fromSeconds requires a numerical input");\n    } else {\n      return new DateTime({\n        ts: seconds * 1000,\n        zone: normalizeZone(options.zone, Settings.defaultZone),\n        loc: Locale.fromObject(options)\n      });\n    }\n  }\n  /**\n   * Create a DateTime from a JavaScript object with keys like \'year\' and \'hour\' with reasonable defaults.\n   * @param {Object} obj - the object to create the DateTime from\n   * @param {number} obj.year - a year, such as 1987\n   * @param {number} obj.month - a month, 1-12\n   * @param {number} obj.day - a day of the month, 1-31, depending on the month\n   * @param {number} obj.ordinal - day of the year, 1-365 or 366\n   * @param {number} obj.weekYear - an ISO week year\n   * @param {number} obj.weekNumber - an ISO week number, between 1 and 52 or 53, depending on the year\n   * @param {number} obj.weekday - an ISO weekday, 1-7, where 1 is Monday and 7 is Sunday\n   * @param {number} obj.hour - hour of the day, 0-23\n   * @param {number} obj.minute - minute of the hour, 0-59\n   * @param {number} obj.second - second of the minute, 0-59\n   * @param {number} obj.millisecond - millisecond of the second, 0-999\n   * @param {string|Zone} [obj.zone=\'local\'] - interpret the numbers in the context of a particular zone. Can take any value taken as the first argument to setZone()\n   * @param {string} [obj.locale=\'system\'s locale\'] - a locale to set on the resulting DateTime instance\n   * @param {string} obj.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} obj.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @example DateTime.fromObject({ year: 1982, month: 5, day: 25}).toISODate() //=> \'1982-05-25\'\n   * @example DateTime.fromObject({ year: 1982 }).toISODate() //=> \'1982-01-01\'\n   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }) //~> today at 10:26:06\n   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6, zone: \'utc\' }),\n   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6, zone: \'local\' })\n   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6, zone: \'America/New_York\' })\n   * @example DateTime.fromObject({ weekYear: 2016, weekNumber: 2, weekday: 3 }).toISODate() //=> \'2016-01-13\'\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromObject = function fromObject(obj) {\n    var zoneToUse = normalizeZone(obj.zone, Settings.defaultZone);\n\n    if (!zoneToUse.isValid) {\n      return DateTime.invalid(unsupportedZone(zoneToUse));\n    }\n\n    var tsNow = Settings.now(),\n        offsetProvis = zoneToUse.offset(tsNow),\n        normalized = normalizeObject(obj, normalizeUnit, ["zone", "locale", "outputCalendar", "numberingSystem"]),\n        containsOrdinal = !isUndefined(normalized.ordinal),\n        containsGregorYear = !isUndefined(normalized.year),\n        containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),\n        containsGregor = containsGregorYear || containsGregorMD,\n        definiteWeekDef = normalized.weekYear || normalized.weekNumber,\n        loc = Locale.fromObject(obj); // cases:\n    // just a weekday -> this week\'s instance of that weekday, no worries\n    // (gregorian data or ordinal) + (weekYear or weekNumber) -> error\n    // (gregorian month or day) + ordinal -> error\n    // otherwise just use weeks or ordinals or gregorian, depending on what\'s specified\n\n    if ((containsGregor || containsOrdinal) && definiteWeekDef) {\n      throw new ConflictingSpecificationError("Can\'t mix weekYear/weekNumber units with year/month/day or ordinals");\n    }\n\n    if (containsGregorMD && containsOrdinal) {\n      throw new ConflictingSpecificationError("Can\'t mix ordinal dates with month/day");\n    }\n\n    var useWeekData = definiteWeekDef || normalized.weekday && !containsGregor; // configure ourselves to deal with gregorian dates or week stuff\n\n    var units,\n        defaultValues,\n        objNow = tsToObj(tsNow, offsetProvis);\n\n    if (useWeekData) {\n      units = orderedWeekUnits;\n      defaultValues = defaultWeekUnitValues;\n      objNow = gregorianToWeek(objNow);\n    } else if (containsOrdinal) {\n      units = orderedOrdinalUnits;\n      defaultValues = defaultOrdinalUnitValues;\n      objNow = gregorianToOrdinal(objNow);\n    } else {\n      units = orderedUnits$1;\n      defaultValues = defaultUnitValues;\n    } // set default values for missing stuff\n\n\n    var foundFirst = false;\n\n    for (var _iterator3 = _createForOfIteratorHelperLoose(units), _step3; !(_step3 = _iterator3()).done;) {\n      var u = _step3.value;\n      var v = normalized[u];\n\n      if (!isUndefined(v)) {\n        foundFirst = true;\n      } else if (foundFirst) {\n        normalized[u] = defaultValues[u];\n      } else {\n        normalized[u] = objNow[u];\n      }\n    } // make sure the values we have are in range\n\n\n    var higherOrderInvalid = useWeekData ? hasInvalidWeekData(normalized) : containsOrdinal ? hasInvalidOrdinalData(normalized) : hasInvalidGregorianData(normalized),\n        invalid = higherOrderInvalid || hasInvalidTimeData(normalized);\n\n    if (invalid) {\n      return DateTime.invalid(invalid);\n    } // compute the actual time\n\n\n    var gregorian = useWeekData ? weekToGregorian(normalized) : containsOrdinal ? ordinalToGregorian(normalized) : normalized,\n        _objToTS2 = objToTS(gregorian, offsetProvis, zoneToUse),\n        tsFinal = _objToTS2[0],\n        offsetFinal = _objToTS2[1],\n        inst = new DateTime({\n      ts: tsFinal,\n      zone: zoneToUse,\n      o: offsetFinal,\n      loc: loc\n    }); // gregorian data + weekday serves only to validate\n\n\n    if (normalized.weekday && containsGregor && obj.weekday !== inst.weekday) {\n      return DateTime.invalid("mismatched weekday", "you can\'t specify both a weekday of " + normalized.weekday + " and a date of " + inst.toISO());\n    }\n\n    return inst;\n  }\n  /**\n   * Create a DateTime from an ISO 8601 string\n   * @param {string} text - the ISO string\n   * @param {Object} opts - options to affect the creation\n   * @param {string|Zone} [opts.zone=\'local\'] - use this zone if no offset is specified in the input string itself. Will also convert the time to this zone\n   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one\n   * @param {string} [opts.locale=\'system\'s locale\'] - a locale to set on the resulting DateTime instance\n   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @example DateTime.fromISO(\'2016-05-25T09:08:34.123\')\n   * @example DateTime.fromISO(\'2016-05-25T09:08:34.123+06:00\')\n   * @example DateTime.fromISO(\'2016-05-25T09:08:34.123+06:00\', {setZone: true})\n   * @example DateTime.fromISO(\'2016-05-25T09:08:34.123\', {zone: \'utc\'})\n   * @example DateTime.fromISO(\'2016-W05-4\')\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromISO = function fromISO(text, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var _parseISODate = parseISODate(text),\n        vals = _parseISODate[0],\n        parsedZone = _parseISODate[1];\n\n    return parseDataToDateTime(vals, parsedZone, opts, "ISO 8601", text);\n  }\n  /**\n   * Create a DateTime from an RFC 2822 string\n   * @param {string} text - the RFC 2822 string\n   * @param {Object} opts - options to affect the creation\n   * @param {string|Zone} [opts.zone=\'local\'] - convert the time to this zone. Since the offset is always specified in the string itself, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.\n   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one\n   * @param {string} [opts.locale=\'system\'s locale\'] - a locale to set on the resulting DateTime instance\n   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @example DateTime.fromRFC2822(\'25 Nov 2016 13:23:12 GMT\')\n   * @example DateTime.fromRFC2822(\'Fri, 25 Nov 2016 13:23:12 +0600\')\n   * @example DateTime.fromRFC2822(\'25 Nov 2016 13:23 Z\')\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromRFC2822 = function fromRFC2822(text, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var _parseRFC2822Date = parseRFC2822Date(text),\n        vals = _parseRFC2822Date[0],\n        parsedZone = _parseRFC2822Date[1];\n\n    return parseDataToDateTime(vals, parsedZone, opts, "RFC 2822", text);\n  }\n  /**\n   * Create a DateTime from an HTTP header date\n   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1\n   * @param {string} text - the HTTP header date\n   * @param {Object} opts - options to affect the creation\n   * @param {string|Zone} [opts.zone=\'local\'] - convert the time to this zone. Since HTTP dates are always in UTC, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.\n   * @param {boolean} [opts.setZone=false] - override the zone with the fixed-offset zone specified in the string. For HTTP dates, this is always UTC, so this option is equivalent to setting the `zone` option to \'utc\', but this option is included for consistency with similar methods.\n   * @param {string} [opts.locale=\'system\'s locale\'] - a locale to set on the resulting DateTime instance\n   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance\n   * @example DateTime.fromHTTP(\'Sun, 06 Nov 1994 08:49:37 GMT\')\n   * @example DateTime.fromHTTP(\'Sunday, 06-Nov-94 08:49:37 GMT\')\n   * @example DateTime.fromHTTP(\'Sun Nov  6 08:49:37 1994\')\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromHTTP = function fromHTTP(text, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var _parseHTTPDate = parseHTTPDate(text),\n        vals = _parseHTTPDate[0],\n        parsedZone = _parseHTTPDate[1];\n\n    return parseDataToDateTime(vals, parsedZone, opts, "HTTP", opts);\n  }\n  /**\n   * Create a DateTime from an input string and format string.\n   * Defaults to en-US if no locale has been specified, regardless of the system\'s locale.\n   * @see https://moment.github.io/luxon/docs/manual/parsing.html#table-of-tokens\n   * @param {string} text - the string to parse\n   * @param {string} fmt - the format the string is expected to be in (see the link below for the formats)\n   * @param {Object} opts - options to affect the creation\n   * @param {string|Zone} [opts.zone=\'local\'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone\n   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one\n   * @param {string} [opts.locale=\'en-US\'] - a locale string to use when parsing. Will also set the DateTime to this locale\n   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system\n   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromFormat = function fromFormat(text, fmt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (isUndefined(text) || isUndefined(fmt)) {\n      throw new InvalidArgumentError("fromFormat requires an input string and a format");\n    }\n\n    var _opts = opts,\n        _opts$locale = _opts.locale,\n        locale = _opts$locale === void 0 ? null : _opts$locale,\n        _opts$numberingSystem = _opts.numberingSystem,\n        numberingSystem = _opts$numberingSystem === void 0 ? null : _opts$numberingSystem,\n        localeToUse = Locale.fromOpts({\n      locale: locale,\n      numberingSystem: numberingSystem,\n      defaultToEN: true\n    }),\n        _parseFromTokens = parseFromTokens(localeToUse, text, fmt),\n        vals = _parseFromTokens[0],\n        parsedZone = _parseFromTokens[1],\n        invalid = _parseFromTokens[2];\n\n    if (invalid) {\n      return DateTime.invalid(invalid);\n    } else {\n      return parseDataToDateTime(vals, parsedZone, opts, "format " + fmt, text);\n    }\n  }\n  /**\n   * @deprecated use fromFormat instead\n   */\n  ;\n\n  DateTime.fromString = function fromString(text, fmt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return DateTime.fromFormat(text, fmt, opts);\n  }\n  /**\n   * Create a DateTime from a SQL date, time, or datetime\n   * Defaults to en-US if no locale has been specified, regardless of the system\'s locale\n   * @param {string} text - the string to parse\n   * @param {Object} opts - options to affect the creation\n   * @param {string|Zone} [opts.zone=\'local\'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone\n   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one\n   * @param {string} [opts.locale=\'en-US\'] - a locale string to use when parsing. Will also set the DateTime to this locale\n   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system\n   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance\n   * @example DateTime.fromSQL(\'2017-05-15\')\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34\')\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34.342\')\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34.342+06:00\')\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34.342 America/Los_Angeles\')\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34.342 America/Los_Angeles\', { setZone: true })\n   * @example DateTime.fromSQL(\'2017-05-15 09:12:34.342\', { zone: \'America/Los_Angeles\' })\n   * @example DateTime.fromSQL(\'09:12:34.342\')\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.fromSQL = function fromSQL(text, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var _parseSQL = parseSQL(text),\n        vals = _parseSQL[0],\n        parsedZone = _parseSQL[1];\n\n    return parseDataToDateTime(vals, parsedZone, opts, "SQL", text);\n  }\n  /**\n   * Create an invalid DateTime.\n   * @param {string} reason - simple string of why this DateTime is invalid. Should not contain parameters or anything else data-dependent\n   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information\n   * @return {DateTime}\n   */\n  ;\n\n  DateTime.invalid = function invalid(reason, explanation) {\n    if (explanation === void 0) {\n      explanation = null;\n    }\n\n    if (!reason) {\n      throw new InvalidArgumentError("need to specify a reason the DateTime is invalid");\n    }\n\n    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);\n\n    if (Settings.throwOnInvalid) {\n      throw new InvalidDateTimeError(invalid);\n    } else {\n      return new DateTime({\n        invalid: invalid\n      });\n    }\n  }\n  /**\n   * Check if an object is a DateTime. Works across context boundaries\n   * @param {object} o\n   * @return {boolean}\n   */\n  ;\n\n  DateTime.isDateTime = function isDateTime(o) {\n    return o && o.isLuxonDateTime || false;\n  } // INFO\n\n  /**\n   * Get the value of unit.\n   * @param {string} unit - a unit such as \'minute\' or \'day\'\n   * @example DateTime.local(2017, 7, 4).get(\'month\'); //=> 7\n   * @example DateTime.local(2017, 7, 4).get(\'day\'); //=> 4\n   * @return {number}\n   */\n  ;\n\n  var _proto = DateTime.prototype;\n\n  _proto.get = function get(unit) {\n    return this[unit];\n  }\n  /**\n   * Returns whether the DateTime is valid. Invalid DateTimes occur when:\n   * * The DateTime was created from invalid calendar information, such as the 13th month or February 30\n   * * The DateTime was created by an operation on another invalid date\n   * @type {boolean}\n   */\n  ;\n\n  /**\n   * Returns the resolved Intl options for this DateTime.\n   * This is useful in understanding the behavior of formatting methods\n   * @param {Object} opts - the same options as toLocaleString\n   * @return {Object}\n   */\n  _proto.resolvedLocaleOpts = function resolvedLocaleOpts(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    var _Formatter$create$res = Formatter.create(this.loc.clone(opts), opts).resolvedOptions(this),\n        locale = _Formatter$create$res.locale,\n        numberingSystem = _Formatter$create$res.numberingSystem,\n        calendar = _Formatter$create$res.calendar;\n\n    return {\n      locale: locale,\n      numberingSystem: numberingSystem,\n      outputCalendar: calendar\n    };\n  } // TRANSFORM\n\n  /**\n   * "Set" the DateTime\'s zone to UTC. Returns a newly-constructed DateTime.\n   *\n   * Equivalent to {@link setZone}(\'utc\')\n   * @param {number} [offset=0] - optionally, an offset from UTC in minutes\n   * @param {Object} [opts={}] - options to pass to `setZone()`\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.toUTC = function toUTC(offset, opts) {\n    if (offset === void 0) {\n      offset = 0;\n    }\n\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return this.setZone(FixedOffsetZone.instance(offset), opts);\n  }\n  /**\n   * "Set" the DateTime\'s zone to the host\'s local zone. Returns a newly-constructed DateTime.\n   *\n   * Equivalent to `setZone(\'local\')`\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.toLocal = function toLocal() {\n    return this.setZone(Settings.defaultZone);\n  }\n  /**\n   * "Set" the DateTime\'s zone to specified zone. Returns a newly-constructed DateTime.\n   *\n   * By default, the setter keeps the underlying time the same (as in, the same timestamp), but the new instance will report different local times and consider DSTs when making computations, as with {@link plus}. You may wish to use {@link toLocal} and {@link toUTC} which provide simple convenience wrappers for commonly used zones.\n   * @param {string|Zone} [zone=\'local\'] - a zone identifier. As a string, that can be any IANA zone supported by the host environment, or a fixed-offset name of the form \'UTC+3\', or the strings \'local\' or \'utc\'. You may also supply an instance of a {@link Zone} class.\n   * @param {Object} opts - options\n   * @param {boolean} [opts.keepLocalTime=false] - If true, adjust the underlying time so that the local time stays the same, but in the target zone. You should rarely need this.\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.setZone = function setZone(zone, _temp) {\n    var _ref3 = _temp === void 0 ? {} : _temp,\n        _ref3$keepLocalTime = _ref3.keepLocalTime,\n        keepLocalTime = _ref3$keepLocalTime === void 0 ? false : _ref3$keepLocalTime,\n        _ref3$keepCalendarTim = _ref3.keepCalendarTime,\n        keepCalendarTime = _ref3$keepCalendarTim === void 0 ? false : _ref3$keepCalendarTim;\n\n    zone = normalizeZone(zone, Settings.defaultZone);\n\n    if (zone.equals(this.zone)) {\n      return this;\n    } else if (!zone.isValid) {\n      return DateTime.invalid(unsupportedZone(zone));\n    } else {\n      var newTS = this.ts;\n\n      if (keepLocalTime || keepCalendarTime) {\n        var offsetGuess = zone.offset(this.ts);\n        var asObj = this.toObject();\n\n        var _objToTS3 = objToTS(asObj, offsetGuess, zone);\n\n        newTS = _objToTS3[0];\n      }\n\n      return clone$1(this, {\n        ts: newTS,\n        zone: zone\n      });\n    }\n  }\n  /**\n   * "Set" the locale, numberingSystem, or outputCalendar. Returns a newly-constructed DateTime.\n   * @param {Object} properties - the properties to set\n   * @example DateTime.local(2017, 5, 25).reconfigure({ locale: \'en-GB\' })\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.reconfigure = function reconfigure(_temp2) {\n    var _ref4 = _temp2 === void 0 ? {} : _temp2,\n        locale = _ref4.locale,\n        numberingSystem = _ref4.numberingSystem,\n        outputCalendar = _ref4.outputCalendar;\n\n    var loc = this.loc.clone({\n      locale: locale,\n      numberingSystem: numberingSystem,\n      outputCalendar: outputCalendar\n    });\n    return clone$1(this, {\n      loc: loc\n    });\n  }\n  /**\n   * "Set" the locale. Returns a newly-constructed DateTime.\n   * Just a convenient alias for reconfigure({ locale })\n   * @example DateTime.local(2017, 5, 25).setLocale(\'en-GB\')\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.setLocale = function setLocale(locale) {\n    return this.reconfigure({\n      locale: locale\n    });\n  }\n  /**\n   * "Set" the values of specified units. Returns a newly-constructed DateTime.\n   * You can only set units with this method; for "setting" metadata, see {@link reconfigure} and {@link setZone}.\n   * @param {Object} values - a mapping of units to numbers\n   * @example dt.set({ year: 2017 })\n   * @example dt.set({ hour: 8, minute: 30 })\n   * @example dt.set({ weekday: 5 })\n   * @example dt.set({ year: 2005, ordinal: 234 })\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.set = function set(values) {\n    if (!this.isValid) return this;\n    var normalized = normalizeObject(values, normalizeUnit, []),\n        settingWeekStuff = !isUndefined(normalized.weekYear) || !isUndefined(normalized.weekNumber) || !isUndefined(normalized.weekday);\n    var mixed;\n\n    if (settingWeekStuff) {\n      mixed = weekToGregorian(Object.assign(gregorianToWeek(this.c), normalized));\n    } else if (!isUndefined(normalized.ordinal)) {\n      mixed = ordinalToGregorian(Object.assign(gregorianToOrdinal(this.c), normalized));\n    } else {\n      mixed = Object.assign(this.toObject(), normalized); // if we didn\'t set the day but we ended up on an overflow date,\n      // use the last day of the right month\n\n      if (isUndefined(normalized.day)) {\n        mixed.day = Math.min(daysInMonth(mixed.year, mixed.month), mixed.day);\n      }\n    }\n\n    var _objToTS4 = objToTS(mixed, this.o, this.zone),\n        ts = _objToTS4[0],\n        o = _objToTS4[1];\n\n    return clone$1(this, {\n      ts: ts,\n      o: o\n    });\n  }\n  /**\n   * Add a period of time to this DateTime and return the resulting DateTime\n   *\n   * Adding hours, minutes, seconds, or milliseconds increases the timestamp by the right number of milliseconds. Adding days, months, or years shifts the calendar, accounting for DSTs and leap years along the way. Thus, `dt.plus({ hours: 24 })` may result in a different time than `dt.plus({ days: 1 })` if there\'s a DST shift in between.\n   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()\n   * @example DateTime.now().plus(123) //~> in 123 milliseconds\n   * @example DateTime.now().plus({ minutes: 15 }) //~> in 15 minutes\n   * @example DateTime.now().plus({ days: 1 }) //~> this time tomorrow\n   * @example DateTime.now().plus({ days: -1 }) //~> this time yesterday\n   * @example DateTime.now().plus({ hours: 3, minutes: 13 }) //~> in 3 hr, 13 min\n   * @example DateTime.now().plus(Duration.fromObject({ hours: 3, minutes: 13 })) //~> in 3 hr, 13 min\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.plus = function plus(duration) {\n    if (!this.isValid) return this;\n    var dur = friendlyDuration(duration);\n    return clone$1(this, adjustTime(this, dur));\n  }\n  /**\n   * Subtract a period of time to this DateTime and return the resulting DateTime\n   * See {@link plus}\n   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()\n   @return {DateTime}\n  */\n  ;\n\n  _proto.minus = function minus(duration) {\n    if (!this.isValid) return this;\n    var dur = friendlyDuration(duration).negate();\n    return clone$1(this, adjustTime(this, dur));\n  }\n  /**\n   * "Set" this DateTime to the beginning of a unit of time.\n   * @param {string} unit - The unit to go to the beginning of. Can be \'year\', \'quarter\', \'month\', \'week\', \'day\', \'hour\', \'minute\', \'second\', or \'millisecond\'.\n   * @example DateTime.local(2014, 3, 3).startOf(\'month\').toISODate(); //=> \'2014-03-01\'\n   * @example DateTime.local(2014, 3, 3).startOf(\'year\').toISODate(); //=> \'2014-01-01\'\n   * @example DateTime.local(2014, 3, 3).startOf(\'week\').toISODate(); //=> \'2014-03-03\', weeks always start on Mondays\n   * @example DateTime.local(2014, 3, 3, 5, 30).startOf(\'day\').toISOTime(); //=> \'00:00.000-05:00\'\n   * @example DateTime.local(2014, 3, 3, 5, 30).startOf(\'hour\').toISOTime(); //=> \'05:00:00.000-05:00\'\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.startOf = function startOf(unit) {\n    if (!this.isValid) return this;\n    var o = {},\n        normalizedUnit = Duration.normalizeUnit(unit);\n\n    switch (normalizedUnit) {\n      case "years":\n        o.month = 1;\n      // falls through\n\n      case "quarters":\n      case "months":\n        o.day = 1;\n      // falls through\n\n      case "weeks":\n      case "days":\n        o.hour = 0;\n      // falls through\n\n      case "hours":\n        o.minute = 0;\n      // falls through\n\n      case "minutes":\n        o.second = 0;\n      // falls through\n\n      case "seconds":\n        o.millisecond = 0;\n        break;\n      // no default, invalid units throw in normalizeUnit()\n    }\n\n    if (normalizedUnit === "weeks") {\n      o.weekday = 1;\n    }\n\n    if (normalizedUnit === "quarters") {\n      var q = Math.ceil(this.month / 3);\n      o.month = (q - 1) * 3 + 1;\n    }\n\n    return this.set(o);\n  }\n  /**\n   * "Set" this DateTime to the end (meaning the last millisecond) of a unit of time\n   * @param {string} unit - The unit to go to the end of. Can be \'year\', \'quarter\', \'month\', \'week\', \'day\', \'hour\', \'minute\', \'second\', or \'millisecond\'.\n   * @example DateTime.local(2014, 3, 3).endOf(\'month\').toISO(); //=> \'2014-03-31T23:59:59.999-05:00\'\n   * @example DateTime.local(2014, 3, 3).endOf(\'year\').toISO(); //=> \'2014-12-31T23:59:59.999-05:00\'\n   * @example DateTime.local(2014, 3, 3).endOf(\'week\').toISO(); // => \'2014-03-09T23:59:59.999-05:00\', weeks start on Mondays\n   * @example DateTime.local(2014, 3, 3, 5, 30).endOf(\'day\').toISO(); //=> \'2014-03-03T23:59:59.999-05:00\'\n   * @example DateTime.local(2014, 3, 3, 5, 30).endOf(\'hour\').toISO(); //=> \'2014-03-03T05:59:59.999-05:00\'\n   * @return {DateTime}\n   */\n  ;\n\n  _proto.endOf = function endOf(unit) {\n    var _this$plus;\n\n    return this.isValid ? this.plus((_this$plus = {}, _this$plus[unit] = 1, _this$plus)).startOf(unit).minus(1) : this;\n  } // OUTPUT\n\n  /**\n   * Returns a string representation of this DateTime formatted according to the specified format string.\n   * **You may not want this.** See {@link toLocaleString} for a more flexible formatting tool. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/docs/manual/formatting.html#table-of-tokens).\n   * Defaults to en-US if no locale has been specified, regardless of the system\'s locale.\n   * @see https://moment.github.io/luxon/docs/manual/formatting.html#table-of-tokens\n   * @param {string} fmt - the format string\n   * @param {Object} opts - opts to override the configuration options\n   * @example DateTime.now().toFormat(\'yyyy LLL dd\') //=> \'2017 Apr 22\'\n   * @example DateTime.now().setLocale(\'fr\').toFormat(\'yyyy LLL dd\') //=> \'2017 avr. 22\'\n   * @example DateTime.now().toFormat(\'yyyy LLL dd\', { locale: "fr" }) //=> \'2017 avr. 22\'\n   * @example DateTime.now().toFormat("HH \'hours and\' mm \'minutes\'") //=> \'20 hours and 55 minutes\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toFormat = function toFormat(fmt, opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return this.isValid ? Formatter.create(this.loc.redefaultToEN(opts)).formatDateTimeFromString(this, fmt) : INVALID$2;\n  }\n  /**\n   * Returns a localized string representing this date. Accepts the same options as the Intl.DateTimeFormat constructor and any presets defined by Luxon, such as `DateTime.DATE_FULL` or `DateTime.TIME_SIMPLE`.\n   * The exact behavior of this method is browser-specific, but in general it will return an appropriate representation\n   * of the DateTime in the assigned locale.\n   * Defaults to the system\'s locale if no locale has been specified\n   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat\n   * @param opts {Object} - Intl.DateTimeFormat constructor options and configuration options\n   * @example DateTime.now().toLocaleString(); //=> 4/20/2017\n   * @example DateTime.now().setLocale(\'en-gb\').toLocaleString(); //=> \'20/04/2017\'\n   * @example DateTime.now().toLocaleString({ locale: \'en-gb\' }); //=> \'20/04/2017\'\n   * @example DateTime.now().toLocaleString(DateTime.DATE_FULL); //=> \'April 20, 2017\'\n   * @example DateTime.now().toLocaleString(DateTime.TIME_SIMPLE); //=> \'11:32 AM\'\n   * @example DateTime.now().toLocaleString(DateTime.DATETIME_SHORT); //=> \'4/20/2017, 11:32 AM\'\n   * @example DateTime.now().toLocaleString({ weekday: \'long\', month: \'long\', day: \'2-digit\' }); //=> \'Thursday, April 20\'\n   * @example DateTime.now().toLocaleString({ weekday: \'short\', month: \'short\', day: \'2-digit\', hour: \'2-digit\', minute: \'2-digit\' }); //=> \'Thu, Apr 20, 11:27 AM\'\n   * @example DateTime.now().toLocaleString({ hour: \'2-digit\', minute: \'2-digit\', hour12: false }); //=> \'11:32\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toLocaleString = function toLocaleString(opts) {\n    if (opts === void 0) {\n      opts = DATE_SHORT;\n    }\n\n    return this.isValid ? Formatter.create(this.loc.clone(opts), opts).formatDateTime(this) : INVALID$2;\n  }\n  /**\n   * Returns an array of format "parts", meaning individual tokens along with metadata. This is allows callers to post-process individual sections of the formatted output.\n   * Defaults to the system\'s locale if no locale has been specified\n   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat/formatToParts\n   * @param opts {Object} - Intl.DateTimeFormat constructor options, same as `toLocaleString`.\n   * @example DateTime.now().toLocaleParts(); //=> [\n   *                                   //=>   { type: \'day\', value: \'25\' },\n   *                                   //=>   { type: \'literal\', value: \'/\' },\n   *                                   //=>   { type: \'month\', value: \'05\' },\n   *                                   //=>   { type: \'literal\', value: \'/\' },\n   *                                   //=>   { type: \'year\', value: \'1982\' }\n   *                                   //=> ]\n   */\n  ;\n\n  _proto.toLocaleParts = function toLocaleParts(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return this.isValid ? Formatter.create(this.loc.clone(opts), opts).formatDateTimeParts(this) : [];\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this DateTime\n   * @param {Object} opts - options\n   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they\'re 0\n   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they\'re 0\n   * @param {boolean} [opts.includeOffset=true] - include the offset, such as \'Z\' or \'-04:00\'\n   * @param {string} [opts.format=\'extended\'] - choose between the basic and extended format\n   * @example DateTime.utc(1982, 5, 25).toISO() //=> \'1982-05-25T00:00:00.000Z\'\n   * @example DateTime.now().toISO() //=> \'2017-04-22T20:47:05.335-04:00\'\n   * @example DateTime.now().toISO({ includeOffset: false }) //=> \'2017-04-22T20:47:05.335\'\n   * @example DateTime.now().toISO({ format: \'basic\' }) //=> \'20170422T204705.335-0400\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISO = function toISO(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid) {\n      return null;\n    }\n\n    return this.toISODate(opts) + "T" + this.toISOTime(opts);\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this DateTime\'s date component\n   * @param {Object} opts - options\n   * @param {string} [opts.format=\'extended\'] - choose between the basic and extended format\n   * @example DateTime.utc(1982, 5, 25).toISODate() //=> \'1982-05-25\'\n   * @example DateTime.utc(1982, 5, 25).toISODate({ format: \'basic\' }) //=> \'19820525\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISODate = function toISODate(_temp3) {\n    var _ref5 = _temp3 === void 0 ? {} : _temp3,\n        _ref5$format = _ref5.format,\n        format = _ref5$format === void 0 ? "extended" : _ref5$format;\n\n    var fmt = format === "basic" ? "yyyyMMdd" : "yyyy-MM-dd";\n\n    if (this.year > 9999) {\n      fmt = "+" + fmt;\n    }\n\n    return toTechFormat(this, fmt);\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this DateTime\'s week date\n   * @example DateTime.utc(1982, 5, 25).toISOWeekDate() //=> \'1982-W21-2\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISOWeekDate = function toISOWeekDate() {\n    return toTechFormat(this, "kkkk-\'W\'WW-c");\n  }\n  /**\n   * Returns an ISO 8601-compliant string representation of this DateTime\'s time component\n   * @param {Object} opts - options\n   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they\'re 0\n   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they\'re 0\n   * @param {boolean} [opts.includeOffset=true] - include the offset, such as \'Z\' or \'-04:00\'\n   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix\n   * @param {string} [opts.format=\'extended\'] - choose between the basic and extended format\n   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime() //=> \'07:34:19.361Z\'\n   * @example DateTime.utc().set({ hour: 7, minute: 34, seconds: 0, milliseconds: 0 }).toISOTime({ suppressSeconds: true }) //=> \'07:34Z\'\n   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ format: \'basic\' }) //=> \'073419.361Z\'\n   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ includePrefix: true }) //=> \'T07:34:19.361Z\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toISOTime = function toISOTime(_temp4) {\n    var _ref6 = _temp4 === void 0 ? {} : _temp4,\n        _ref6$suppressMillise = _ref6.suppressMilliseconds,\n        suppressMilliseconds = _ref6$suppressMillise === void 0 ? false : _ref6$suppressMillise,\n        _ref6$suppressSeconds = _ref6.suppressSeconds,\n        suppressSeconds = _ref6$suppressSeconds === void 0 ? false : _ref6$suppressSeconds,\n        _ref6$includeOffset = _ref6.includeOffset,\n        includeOffset = _ref6$includeOffset === void 0 ? true : _ref6$includeOffset,\n        _ref6$includePrefix = _ref6.includePrefix,\n        includePrefix = _ref6$includePrefix === void 0 ? false : _ref6$includePrefix,\n        _ref6$format = _ref6.format,\n        format = _ref6$format === void 0 ? "extended" : _ref6$format;\n\n    return toTechTimeFormat(this, {\n      suppressSeconds: suppressSeconds,\n      suppressMilliseconds: suppressMilliseconds,\n      includeOffset: includeOffset,\n      includePrefix: includePrefix,\n      format: format\n    });\n  }\n  /**\n   * Returns an RFC 2822-compatible string representation of this DateTime, always in UTC\n   * @example DateTime.utc(2014, 7, 13).toRFC2822() //=> \'Sun, 13 Jul 2014 00:00:00 +0000\'\n   * @example DateTime.local(2014, 7, 13).toRFC2822() //=> \'Sun, 13 Jul 2014 00:00:00 -0400\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toRFC2822 = function toRFC2822() {\n    return toTechFormat(this, "EEE, dd LLL yyyy HH:mm:ss ZZZ", false);\n  }\n  /**\n   * Returns a string representation of this DateTime appropriate for use in HTTP headers.\n   * Specifically, the string conforms to RFC 1123.\n   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1\n   * @example DateTime.utc(2014, 7, 13).toHTTP() //=> \'Sun, 13 Jul 2014 00:00:00 GMT\'\n   * @example DateTime.utc(2014, 7, 13, 19).toHTTP() //=> \'Sun, 13 Jul 2014 19:00:00 GMT\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toHTTP = function toHTTP() {\n    return toTechFormat(this.toUTC(), "EEE, dd LLL yyyy HH:mm:ss \'GMT\'");\n  }\n  /**\n   * Returns a string representation of this DateTime appropriate for use in SQL Date\n   * @example DateTime.utc(2014, 7, 13).toSQLDate() //=> \'2014-07-13\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toSQLDate = function toSQLDate() {\n    return toTechFormat(this, "yyyy-MM-dd");\n  }\n  /**\n   * Returns a string representation of this DateTime appropriate for use in SQL Time\n   * @param {Object} opts - options\n   * @param {boolean} [opts.includeZone=false] - include the zone, such as \'America/New_York\'. Overrides includeOffset.\n   * @param {boolean} [opts.includeOffset=true] - include the offset, such as \'Z\' or \'-04:00\'\n   * @example DateTime.utc().toSQL() //=> \'05:15:16.345\'\n   * @example DateTime.now().toSQL() //=> \'05:15:16.345 -04:00\'\n   * @example DateTime.now().toSQL({ includeOffset: false }) //=> \'05:15:16.345\'\n   * @example DateTime.now().toSQL({ includeZone: false }) //=> \'05:15:16.345 America/New_York\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toSQLTime = function toSQLTime(_temp5) {\n    var _ref7 = _temp5 === void 0 ? {} : _temp5,\n        _ref7$includeOffset = _ref7.includeOffset,\n        includeOffset = _ref7$includeOffset === void 0 ? true : _ref7$includeOffset,\n        _ref7$includeZone = _ref7.includeZone,\n        includeZone = _ref7$includeZone === void 0 ? false : _ref7$includeZone;\n\n    return toTechTimeFormat(this, {\n      includeOffset: includeOffset,\n      includeZone: includeZone,\n      spaceZone: true\n    });\n  }\n  /**\n   * Returns a string representation of this DateTime appropriate for use in SQL DateTime\n   * @param {Object} opts - options\n   * @param {boolean} [opts.includeZone=false] - include the zone, such as \'America/New_York\'. Overrides includeOffset.\n   * @param {boolean} [opts.includeOffset=true] - include the offset, such as \'Z\' or \'-04:00\'\n   * @example DateTime.utc(2014, 7, 13).toSQL() //=> \'2014-07-13 00:00:00.000 Z\'\n   * @example DateTime.local(2014, 7, 13).toSQL() //=> \'2014-07-13 00:00:00.000 -04:00\'\n   * @example DateTime.local(2014, 7, 13).toSQL({ includeOffset: false }) //=> \'2014-07-13 00:00:00.000\'\n   * @example DateTime.local(2014, 7, 13).toSQL({ includeZone: true }) //=> \'2014-07-13 00:00:00.000 America/New_York\'\n   * @return {string}\n   */\n  ;\n\n  _proto.toSQL = function toSQL(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid) {\n      return null;\n    }\n\n    return this.toSQLDate() + " " + this.toSQLTime(opts);\n  }\n  /**\n   * Returns a string representation of this DateTime appropriate for debugging\n   * @return {string}\n   */\n  ;\n\n  _proto.toString = function toString() {\n    return this.isValid ? this.toISO() : INVALID$2;\n  }\n  /**\n   * Returns the epoch milliseconds of this DateTime. Alias of {@link toMillis}\n   * @return {number}\n   */\n  ;\n\n  _proto.valueOf = function valueOf() {\n    return this.toMillis();\n  }\n  /**\n   * Returns the epoch milliseconds of this DateTime.\n   * @return {number}\n   */\n  ;\n\n  _proto.toMillis = function toMillis() {\n    return this.isValid ? this.ts : NaN;\n  }\n  /**\n   * Returns the epoch seconds of this DateTime.\n   * @return {number}\n   */\n  ;\n\n  _proto.toSeconds = function toSeconds() {\n    return this.isValid ? this.ts / 1000 : NaN;\n  }\n  /**\n   * Returns an ISO 8601 representation of this DateTime appropriate for use in JSON.\n   * @return {string}\n   */\n  ;\n\n  _proto.toJSON = function toJSON() {\n    return this.toISO();\n  }\n  /**\n   * Returns a BSON serializable equivalent to this DateTime.\n   * @return {Date}\n   */\n  ;\n\n  _proto.toBSON = function toBSON() {\n    return this.toJSDate();\n  }\n  /**\n   * Returns a JavaScript object with this DateTime\'s year, month, day, and so on.\n   * @param opts - options for generating the object\n   * @param {boolean} [opts.includeConfig=false] - include configuration attributes in the output\n   * @example DateTime.now().toObject() //=> { year: 2017, month: 4, day: 22, hour: 20, minute: 49, second: 42, millisecond: 268 }\n   * @return {Object}\n   */\n  ;\n\n  _proto.toObject = function toObject(opts) {\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid) return {};\n    var base = Object.assign({}, this.c);\n\n    if (opts.includeConfig) {\n      base.outputCalendar = this.outputCalendar;\n      base.numberingSystem = this.loc.numberingSystem;\n      base.locale = this.loc.locale;\n    }\n\n    return base;\n  }\n  /**\n   * Returns a JavaScript Date equivalent to this DateTime.\n   * @return {Date}\n   */\n  ;\n\n  _proto.toJSDate = function toJSDate() {\n    return new Date(this.isValid ? this.ts : NaN);\n  } // COMPARE\n\n  /**\n   * Return the difference between two DateTimes as a Duration.\n   * @param {DateTime} otherDateTime - the DateTime to compare this one to\n   * @param {string|string[]} [unit=[\'milliseconds\']] - the unit or array of units (such as \'hours\' or \'days\') to include in the duration.\n   * @param {Object} opts - options that affect the creation of the Duration\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @example\n   * var i1 = DateTime.fromISO(\'1982-05-25T09:45\'),\n   *     i2 = DateTime.fromISO(\'1983-10-14T10:30\');\n   * i2.diff(i1).toObject() //=> { milliseconds: 43807500000 }\n   * i2.diff(i1, \'hours\').toObject() //=> { hours: 12168.75 }\n   * i2.diff(i1, [\'months\', \'days\']).toObject() //=> { months: 16, days: 19.03125 }\n   * i2.diff(i1, [\'months\', \'days\', \'hours\']).toObject() //=> { months: 16, days: 19, hours: 0.75 }\n   * @return {Duration}\n   */\n  ;\n\n  _proto.diff = function diff(otherDateTime, unit, opts) {\n    if (unit === void 0) {\n      unit = "milliseconds";\n    }\n\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    if (!this.isValid || !otherDateTime.isValid) {\n      return Duration.invalid(this.invalid || otherDateTime.invalid, "created by diffing an invalid DateTime");\n    }\n\n    var durOpts = Object.assign({\n      locale: this.locale,\n      numberingSystem: this.numberingSystem\n    }, opts);\n\n    var units = maybeArray(unit).map(Duration.normalizeUnit),\n        otherIsLater = otherDateTime.valueOf() > this.valueOf(),\n        earlier = otherIsLater ? this : otherDateTime,\n        later = otherIsLater ? otherDateTime : this,\n        diffed = _diff(earlier, later, units, durOpts);\n\n    return otherIsLater ? diffed.negate() : diffed;\n  }\n  /**\n   * Return the difference between this DateTime and right now.\n   * See {@link diff}\n   * @param {string|string[]} [unit=[\'milliseconds\']] - the unit or units units (such as \'hours\' or \'days\') to include in the duration\n   * @param {Object} opts - options that affect the creation of the Duration\n   * @param {string} [opts.conversionAccuracy=\'casual\'] - the conversion system to use\n   * @return {Duration}\n   */\n  ;\n\n  _proto.diffNow = function diffNow(unit, opts) {\n    if (unit === void 0) {\n      unit = "milliseconds";\n    }\n\n    if (opts === void 0) {\n      opts = {};\n    }\n\n    return this.diff(DateTime.now(), unit, opts);\n  }\n  /**\n   * Return an Interval spanning between this DateTime and another DateTime\n   * @param {DateTime} otherDateTime - the other end point of the Interval\n   * @return {Interval}\n   */\n  ;\n\n  _proto.until = function until(otherDateTime) {\n    return this.isValid ? Interval.fromDateTimes(this, otherDateTime) : this;\n  }\n  /**\n   * Return whether this DateTime is in the same unit of time as another DateTime.\n   * Higher-order units must also be identical for this function to return `true`.\n   * Note that time zones are **ignored** in this comparison, which compares the **local** calendar time. Use {@link setZone} to convert one of the dates if needed.\n   * @param {DateTime} otherDateTime - the other DateTime\n   * @param {string} unit - the unit of time to check sameness on\n   * @example DateTime.now().hasSame(otherDT, \'day\'); //~> true if otherDT is in the same current calendar day\n   * @return {boolean}\n   */\n  ;\n\n  _proto.hasSame = function hasSame(otherDateTime, unit) {\n    if (!this.isValid) return false;\n    var inputMs = otherDateTime.valueOf();\n    var otherZoneDateTime = this.setZone(otherDateTime.zone, {\n      keepLocalTime: true\n    });\n    return otherZoneDateTime.startOf(unit) <= inputMs && inputMs <= otherZoneDateTime.endOf(unit);\n  }\n  /**\n   * Equality check\n   * Two DateTimes are equal iff they represent the same millisecond, have the same zone and location, and are both valid.\n   * To compare just the millisecond values, use `+dt1 === +dt2`.\n   * @param {DateTime} other - the other DateTime\n   * @return {boolean}\n   */\n  ;\n\n  _proto.equals = function equals(other) {\n    return this.isValid && other.isValid && this.valueOf() === other.valueOf() && this.zone.equals(other.zone) && this.loc.equals(other.loc);\n  }\n  /**\n   * Returns a string representation of a this time relative to now, such as "in two days". Can only internationalize if your\n   * platform supports Intl.RelativeTimeFormat. Rounds down by default.\n   * @param {Object} options - options that affect the output\n   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.\n   * @param {string} [options.style="long"] - the style of units, must be "long", "short", or "narrow"\n   * @param {string} options.unit - use a specific unit; if omitted, the method will pick the unit. Use one of "years", "quarters", "months", "weeks", "days", "hours", "minutes", or "seconds"\n   * @param {boolean} [options.round=true] - whether to round the numbers in the output.\n   * @param {number} [options.padding=0] - padding in milliseconds. This allows you to round up the result if it fits inside the threshold. Don\'t use in combination with {round: false} because the decimal output will include the padding.\n   * @param {string} options.locale - override the locale of this DateTime\n   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this\n   * @example DateTime.now().plus({ days: 1 }).toRelative() //=> "in 1 day"\n   * @example DateTime.now().setLocale("es").toRelative({ days: 1 }) //=> "dentro de 1 día"\n   * @example DateTime.now().plus({ days: 1 }).toRelative({ locale: "fr" }) //=> "dans 23 heures"\n   * @example DateTime.now().minus({ days: 2 }).toRelative() //=> "2 days ago"\n   * @example DateTime.now().minus({ days: 2 }).toRelative({ unit: "hours" }) //=> "48 hours ago"\n   * @example DateTime.now().minus({ hours: 36 }).toRelative({ round: false }) //=> "1.5 days ago"\n   */\n  ;\n\n  _proto.toRelative = function toRelative(options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    if (!this.isValid) return null;\n    var base = options.base || DateTime.fromObject({\n      zone: this.zone\n    }),\n        padding = options.padding ? this < base ? -options.padding : options.padding : 0;\n    return diffRelative(base, this.plus(padding), Object.assign(options, {\n      numeric: "always",\n      units: ["years", "months", "days", "hours", "minutes", "seconds"]\n    }));\n  }\n  /**\n   * Returns a string representation of this date relative to today, such as "yesterday" or "next month".\n   * Only internationalizes on platforms that supports Intl.RelativeTimeFormat.\n   * @param {Object} options - options that affect the output\n   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.\n   * @param {string} options.locale - override the locale of this DateTime\n   * @param {string} options.unit - use a specific unit; if omitted, the method will pick the unit. Use one of "years", "quarters", "months", "weeks", or "days"\n   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this\n   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar() //=> "tomorrow"\n   * @example DateTime.now().setLocale("es").plus({ days: 1 }).toRelative() //=> ""mañana"\n   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar({ locale: "fr" }) //=> "demain"\n   * @example DateTime.now().minus({ days: 2 }).toRelativeCalendar() //=> "2 days ago"\n   */\n  ;\n\n  _proto.toRelativeCalendar = function toRelativeCalendar(options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    if (!this.isValid) return null;\n    return diffRelative(options.base || DateTime.fromObject({\n      zone: this.zone\n    }), this, Object.assign(options, {\n      numeric: "auto",\n      units: ["years", "months", "days"],\n      calendary: true\n    }));\n  }\n  /**\n   * Return the min of several date times\n   * @param {...DateTime} dateTimes - the DateTimes from which to choose the minimum\n   * @return {DateTime} the min DateTime, or undefined if called with no argument\n   */\n  ;\n\n  DateTime.min = function min() {\n    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {\n      dateTimes[_key] = arguments[_key];\n    }\n\n    if (!dateTimes.every(DateTime.isDateTime)) {\n      throw new InvalidArgumentError("min requires all arguments be DateTimes");\n    }\n\n    return bestBy(dateTimes, function (i) {\n      return i.valueOf();\n    }, Math.min);\n  }\n  /**\n   * Return the max of several date times\n   * @param {...DateTime} dateTimes - the DateTimes from which to choose the maximum\n   * @return {DateTime} the max DateTime, or undefined if called with no argument\n   */\n  ;\n\n  DateTime.max = function max() {\n    for (var _len2 = arguments.length, dateTimes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n      dateTimes[_key2] = arguments[_key2];\n    }\n\n    if (!dateTimes.every(DateTime.isDateTime)) {\n      throw new InvalidArgumentError("max requires all arguments be DateTimes");\n    }\n\n    return bestBy(dateTimes, function (i) {\n      return i.valueOf();\n    }, Math.max);\n  } // MISC\n\n  /**\n   * Explain how a string would be parsed by fromFormat()\n   * @param {string} text - the string to parse\n   * @param {string} fmt - the format the string is expected to be in (see description)\n   * @param {Object} options - options taken by fromFormat()\n   * @return {Object}\n   */\n  ;\n\n  DateTime.fromFormatExplain = function fromFormatExplain(text, fmt, options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    var _options = options,\n        _options$locale = _options.locale,\n        locale = _options$locale === void 0 ? null : _options$locale,\n        _options$numberingSys = _options.numberingSystem,\n        numberingSystem = _options$numberingSys === void 0 ? null : _options$numberingSys,\n        localeToUse = Locale.fromOpts({\n      locale: locale,\n      numberingSystem: numberingSystem,\n      defaultToEN: true\n    });\n    return explainFromTokens(localeToUse, text, fmt);\n  }\n  /**\n   * @deprecated use fromFormatExplain instead\n   */\n  ;\n\n  DateTime.fromStringExplain = function fromStringExplain(text, fmt, options) {\n    if (options === void 0) {\n      options = {};\n    }\n\n    return DateTime.fromFormatExplain(text, fmt, options);\n  } // FORMAT PRESETS\n\n  /**\n   * {@link toLocaleString} format like 10/14/1983\n   * @type {Object}\n   */\n  ;\n\n  _createClass(DateTime, [{\n    key: "isValid",\n    get: function get() {\n      return this.invalid === null;\n    }\n    /**\n     * Returns an error code if this DateTime is invalid, or null if the DateTime is valid\n     * @type {string}\n     */\n\n  }, {\n    key: "invalidReason",\n    get: function get() {\n      return this.invalid ? this.invalid.reason : null;\n    }\n    /**\n     * Returns an explanation of why this DateTime became invalid, or null if the DateTime is valid\n     * @type {string}\n     */\n\n  }, {\n    key: "invalidExplanation",\n    get: function get() {\n      return this.invalid ? this.invalid.explanation : null;\n    }\n    /**\n     * Get the locale of a DateTime, such \'en-GB\'. The locale is used when formatting the DateTime\n     *\n     * @type {string}\n     */\n\n  }, {\n    key: "locale",\n    get: function get() {\n      return this.isValid ? this.loc.locale : null;\n    }\n    /**\n     * Get the numbering system of a DateTime, such \'beng\'. The numbering system is used when formatting the DateTime\n     *\n     * @type {string}\n     */\n\n  }, {\n    key: "numberingSystem",\n    get: function get() {\n      return this.isValid ? this.loc.numberingSystem : null;\n    }\n    /**\n     * Get the output calendar of a DateTime, such \'islamic\'. The output calendar is used when formatting the DateTime\n     *\n     * @type {string}\n     */\n\n  }, {\n    key: "outputCalendar",\n    get: function get() {\n      return this.isValid ? this.loc.outputCalendar : null;\n    }\n    /**\n     * Get the time zone associated with this DateTime.\n     * @type {Zone}\n     */\n\n  }, {\n    key: "zone",\n    get: function get() {\n      return this._zone;\n    }\n    /**\n     * Get the name of the time zone.\n     * @type {string}\n     */\n\n  }, {\n    key: "zoneName",\n    get: function get() {\n      return this.isValid ? this.zone.name : null;\n    }\n    /**\n     * Get the year\n     * @example DateTime.local(2017, 5, 25).year //=> 2017\n     * @type {number}\n     */\n\n  }, {\n    key: "year",\n    get: function get() {\n      return this.isValid ? this.c.year : NaN;\n    }\n    /**\n     * Get the quarter\n     * @example DateTime.local(2017, 5, 25).quarter //=> 2\n     * @type {number}\n     */\n\n  }, {\n    key: "quarter",\n    get: function get() {\n      return this.isValid ? Math.ceil(this.c.month / 3) : NaN;\n    }\n    /**\n     * Get the month (1-12).\n     * @example DateTime.local(2017, 5, 25).month //=> 5\n     * @type {number}\n     */\n\n  }, {\n    key: "month",\n    get: function get() {\n      return this.isValid ? this.c.month : NaN;\n    }\n    /**\n     * Get the day of the month (1-30ish).\n     * @example DateTime.local(2017, 5, 25).day //=> 25\n     * @type {number}\n     */\n\n  }, {\n    key: "day",\n    get: function get() {\n      return this.isValid ? this.c.day : NaN;\n    }\n    /**\n     * Get the hour of the day (0-23).\n     * @example DateTime.local(2017, 5, 25, 9).hour //=> 9\n     * @type {number}\n     */\n\n  }, {\n    key: "hour",\n    get: function get() {\n      return this.isValid ? this.c.hour : NaN;\n    }\n    /**\n     * Get the minute of the hour (0-59).\n     * @example DateTime.local(2017, 5, 25, 9, 30).minute //=> 30\n     * @type {number}\n     */\n\n  }, {\n    key: "minute",\n    get: function get() {\n      return this.isValid ? this.c.minute : NaN;\n    }\n    /**\n     * Get the second of the minute (0-59).\n     * @example DateTime.local(2017, 5, 25, 9, 30, 52).second //=> 52\n     * @type {number}\n     */\n\n  }, {\n    key: "second",\n    get: function get() {\n      return this.isValid ? this.c.second : NaN;\n    }\n    /**\n     * Get the millisecond of the second (0-999).\n     * @example DateTime.local(2017, 5, 25, 9, 30, 52, 654).millisecond //=> 654\n     * @type {number}\n     */\n\n  }, {\n    key: "millisecond",\n    get: function get() {\n      return this.isValid ? this.c.millisecond : NaN;\n    }\n    /**\n     * Get the week year\n     * @see https://en.wikipedia.org/wiki/ISO_week_date\n     * @example DateTime.local(2014, 11, 31).weekYear //=> 2015\n     * @type {number}\n     */\n\n  }, {\n    key: "weekYear",\n    get: function get() {\n      return this.isValid ? possiblyCachedWeekData(this).weekYear : NaN;\n    }\n    /**\n     * Get the week number of the week year (1-52ish).\n     * @see https://en.wikipedia.org/wiki/ISO_week_date\n     * @example DateTime.local(2017, 5, 25).weekNumber //=> 21\n     * @type {number}\n     */\n\n  }, {\n    key: "weekNumber",\n    get: function get() {\n      return this.isValid ? possiblyCachedWeekData(this).weekNumber : NaN;\n    }\n    /**\n     * Get the day of the week.\n     * 1 is Monday and 7 is Sunday\n     * @see https://en.wikipedia.org/wiki/ISO_week_date\n     * @example DateTime.local(2014, 11, 31).weekday //=> 4\n     * @type {number}\n     */\n\n  }, {\n    key: "weekday",\n    get: function get() {\n      return this.isValid ? possiblyCachedWeekData(this).weekday : NaN;\n    }\n    /**\n     * Get the ordinal (meaning the day of the year)\n     * @example DateTime.local(2017, 5, 25).ordinal //=> 145\n     * @type {number|DateTime}\n     */\n\n  }, {\n    key: "ordinal",\n    get: function get() {\n      return this.isValid ? gregorianToOrdinal(this.c).ordinal : NaN;\n    }\n    /**\n     * Get the human readable short month name, such as \'Oct\'.\n     * Defaults to the system\'s locale if no locale has been specified\n     * @example DateTime.local(2017, 10, 30).monthShort //=> Oct\n     * @type {string}\n     */\n\n  }, {\n    key: "monthShort",\n    get: function get() {\n      return this.isValid ? Info.months("short", {\n        locale: this.locale\n      })[this.month - 1] : null;\n    }\n    /**\n     * Get the human readable long month name, such as \'October\'.\n     * Defaults to the system\'s locale if no locale has been specified\n     * @example DateTime.local(2017, 10, 30).monthLong //=> October\n     * @type {string}\n     */\n\n  }, {\n    key: "monthLong",\n    get: function get() {\n      return this.isValid ? Info.months("long", {\n        locale: this.locale\n      })[this.month - 1] : null;\n    }\n    /**\n     * Get the human readable short weekday, such as \'Mon\'.\n     * Defaults to the system\'s locale if no locale has been specified\n     * @example DateTime.local(2017, 10, 30).weekdayShort //=> Mon\n     * @type {string}\n     */\n\n  }, {\n    key: "weekdayShort",\n    get: function get() {\n      return this.isValid ? Info.weekdays("short", {\n        locale: this.locale\n      })[this.weekday - 1] : null;\n    }\n    /**\n     * Get the human readable long weekday, such as \'Monday\'.\n     * Defaults to the system\'s locale if no locale has been specified\n     * @example DateTime.local(2017, 10, 30).weekdayLong //=> Monday\n     * @type {string}\n     */\n\n  }, {\n    key: "weekdayLong",\n    get: function get() {\n      return this.isValid ? Info.weekdays("long", {\n        locale: this.locale\n      })[this.weekday - 1] : null;\n    }\n    /**\n     * Get the UTC offset of this DateTime in minutes\n     * @example DateTime.now().offset //=> -240\n     * @example DateTime.utc().offset //=> 0\n     * @type {number}\n     */\n\n  }, {\n    key: "offset",\n    get: function get() {\n      return this.isValid ? +this.o : NaN;\n    }\n    /**\n     * Get the short human name for the zone\'s current offset, for example "EST" or "EDT".\n     * Defaults to the system\'s locale if no locale has been specified\n     * @type {string}\n     */\n\n  }, {\n    key: "offsetNameShort",\n    get: function get() {\n      if (this.isValid) {\n        return this.zone.offsetName(this.ts, {\n          format: "short",\n          locale: this.locale\n        });\n      } else {\n        return null;\n      }\n    }\n    /**\n     * Get the long human name for the zone\'s current offset, for example "Eastern Standard Time" or "Eastern Daylight Time".\n     * Defaults to the system\'s locale if no locale has been specified\n     * @type {string}\n     */\n\n  }, {\n    key: "offsetNameLong",\n    get: function get() {\n      if (this.isValid) {\n        return this.zone.offsetName(this.ts, {\n          format: "long",\n          locale: this.locale\n        });\n      } else {\n        return null;\n      }\n    }\n    /**\n     * Get whether this zone\'s offset ever changes, as in a DST.\n     * @type {boolean}\n     */\n\n  }, {\n    key: "isOffsetFixed",\n    get: function get() {\n      return this.isValid ? this.zone.universal : null;\n    }\n    /**\n     * Get whether the DateTime is in a DST.\n     * @type {boolean}\n     */\n\n  }, {\n    key: "isInDST",\n    get: function get() {\n      if (this.isOffsetFixed) {\n        return false;\n      } else {\n        return this.offset > this.set({\n          month: 1\n        }).offset || this.offset > this.set({\n          month: 5\n        }).offset;\n      }\n    }\n    /**\n     * Returns true if this DateTime is in a leap year, false otherwise\n     * @example DateTime.local(2016).isInLeapYear //=> true\n     * @example DateTime.local(2013).isInLeapYear //=> false\n     * @type {boolean}\n     */\n\n  }, {\n    key: "isInLeapYear",\n    get: function get() {\n      return isLeapYear(this.year);\n    }\n    /**\n     * Returns the number of days in this DateTime\'s month\n     * @example DateTime.local(2016, 2).daysInMonth //=> 29\n     * @example DateTime.local(2016, 3).daysInMonth //=> 31\n     * @type {number}\n     */\n\n  }, {\n    key: "daysInMonth",\n    get: function get() {\n      return daysInMonth(this.year, this.month);\n    }\n    /**\n     * Returns the number of days in this DateTime\'s year\n     * @example DateTime.local(2016).daysInYear //=> 366\n     * @example DateTime.local(2013).daysInYear //=> 365\n     * @type {number}\n     */\n\n  }, {\n    key: "daysInYear",\n    get: function get() {\n      return this.isValid ? daysInYear(this.year) : NaN;\n    }\n    /**\n     * Returns the number of weeks in this DateTime\'s year\n     * @see https://en.wikipedia.org/wiki/ISO_week_date\n     * @example DateTime.local(2004).weeksInWeekYear //=> 53\n     * @example DateTime.local(2013).weeksInWeekYear //=> 52\n     * @type {number}\n     */\n\n  }, {\n    key: "weeksInWeekYear",\n    get: function get() {\n      return this.isValid ? weeksInWeekYear(this.weekYear) : NaN;\n    }\n  }], [{\n    key: "DATE_SHORT",\n    get: function get() {\n      return DATE_SHORT;\n    }\n    /**\n     * {@link toLocaleString} format like \'Oct 14, 1983\'\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATE_MED",\n    get: function get() {\n      return DATE_MED;\n    }\n    /**\n     * {@link toLocaleString} format like \'Fri, Oct 14, 1983\'\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATE_MED_WITH_WEEKDAY",\n    get: function get() {\n      return DATE_MED_WITH_WEEKDAY;\n    }\n    /**\n     * {@link toLocaleString} format like \'October 14, 1983\'\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATE_FULL",\n    get: function get() {\n      return DATE_FULL;\n    }\n    /**\n     * {@link toLocaleString} format like \'Tuesday, October 14, 1983\'\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATE_HUGE",\n    get: function get() {\n      return DATE_HUGE;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_SIMPLE",\n    get: function get() {\n      return TIME_SIMPLE;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_WITH_SECONDS",\n    get: function get() {\n      return TIME_WITH_SECONDS;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23 AM EDT\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_WITH_SHORT_OFFSET",\n    get: function get() {\n      return TIME_WITH_SHORT_OFFSET;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23 AM Eastern Daylight Time\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_WITH_LONG_OFFSET",\n    get: function get() {\n      return TIME_WITH_LONG_OFFSET;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30\', always 24-hour.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_24_SIMPLE",\n    get: function get() {\n      return TIME_24_SIMPLE;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23\', always 24-hour.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_24_WITH_SECONDS",\n    get: function get() {\n      return TIME_24_WITH_SECONDS;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23 EDT\', always 24-hour.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_24_WITH_SHORT_OFFSET",\n    get: function get() {\n      return TIME_24_WITH_SHORT_OFFSET;\n    }\n    /**\n     * {@link toLocaleString} format like \'09:30:23 Eastern Daylight Time\', always 24-hour.\n     * @type {Object}\n     */\n\n  }, {\n    key: "TIME_24_WITH_LONG_OFFSET",\n    get: function get() {\n      return TIME_24_WITH_LONG_OFFSET;\n    }\n    /**\n     * {@link toLocaleString} format like \'10/14/1983, 9:30 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_SHORT",\n    get: function get() {\n      return DATETIME_SHORT;\n    }\n    /**\n     * {@link toLocaleString} format like \'10/14/1983, 9:30:33 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_SHORT_WITH_SECONDS",\n    get: function get() {\n      return DATETIME_SHORT_WITH_SECONDS;\n    }\n    /**\n     * {@link toLocaleString} format like \'Oct 14, 1983, 9:30 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_MED",\n    get: function get() {\n      return DATETIME_MED;\n    }\n    /**\n     * {@link toLocaleString} format like \'Oct 14, 1983, 9:30:33 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_MED_WITH_SECONDS",\n    get: function get() {\n      return DATETIME_MED_WITH_SECONDS;\n    }\n    /**\n     * {@link toLocaleString} format like \'Fri, 14 Oct 1983, 9:30 AM\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_MED_WITH_WEEKDAY",\n    get: function get() {\n      return DATETIME_MED_WITH_WEEKDAY;\n    }\n    /**\n     * {@link toLocaleString} format like \'October 14, 1983, 9:30 AM EDT\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_FULL",\n    get: function get() {\n      return DATETIME_FULL;\n    }\n    /**\n     * {@link toLocaleString} format like \'October 14, 1983, 9:30:33 AM EDT\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_FULL_WITH_SECONDS",\n    get: function get() {\n      return DATETIME_FULL_WITH_SECONDS;\n    }\n    /**\n     * {@link toLocaleString} format like \'Friday, October 14, 1983, 9:30 AM Eastern Daylight Time\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_HUGE",\n    get: function get() {\n      return DATETIME_HUGE;\n    }\n    /**\n     * {@link toLocaleString} format like \'Friday, October 14, 1983, 9:30:33 AM Eastern Daylight Time\'. Only 12-hour if the locale is.\n     * @type {Object}\n     */\n\n  }, {\n    key: "DATETIME_HUGE_WITH_SECONDS",\n    get: function get() {\n      return DATETIME_HUGE_WITH_SECONDS;\n    }\n  }]);\n\n  return DateTime;\n}();\nfunction friendlyDateTime(dateTimeish) {\n  if (DateTime.isDateTime(dateTimeish)) {\n    return dateTimeish;\n  } else if (dateTimeish && dateTimeish.valueOf && isNumber(dateTimeish.valueOf())) {\n    return DateTime.fromJSDate(dateTimeish);\n  } else if (dateTimeish && typeof dateTimeish === "object") {\n    return DateTime.fromObject(dateTimeish);\n  } else {\n    throw new InvalidArgumentError("Unknown datetime argument: " + dateTimeish + ", of type " + typeof dateTimeish);\n  }\n}\n\nvar VERSION = "1.26.0";\n\nexports.DateTime = DateTime;\nexports.Duration = Duration;\nexports.FixedOffsetZone = FixedOffsetZone;\nexports.IANAZone = IANAZone;\nexports.Info = Info;\nexports.Interval = Interval;\nexports.InvalidZone = InvalidZone;\nexports.LocalZone = LocalZone;\nexports.Settings = Settings;\nexports.VERSION = VERSION;\nexports.Zone = Zone;\n//# sourceMappingURL=luxon.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///481\n')}},__webpack_module_cache__={};function __webpack_require__(n){var t=__webpack_module_cache__[n];if(void 0!==t)return t.exports;var I=__webpack_module_cache__[n]={exports:{}};return __webpack_modules__[n].call(I.exports,I,I.exports,__webpack_require__),I.exports}var __webpack_exports__=__webpack_require__(922);Canopy=__webpack_exports__})();