# Generated by Django 4.1.3 on 2022-11-05 22:30

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("djf_surveys", "0009_auto_20220803_0927"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="answer",
            options={
                "ordering": ["question__ordering"],
                "verbose_name": "answer",
                "verbose_name_plural": "answers",
            },
        ),
        migrations.AlterModelOptions(
            name="question",
            options={
                "ordering": ["ordering"],
                "verbose_name": "question",
                "verbose_name_plural": "questions",
            },
        ),
        migrations.AlterModelOptions(
            name="survey",
            options={"verbose_name": "survey", "verbose_name_plural": "surveys"},
        ),
        migrations.AlterModelOptions(
            name="useranswer",
            options={
                "ordering": ["-updated_at"],
                "verbose_name": "user answer",
                "verbose_name_plural": "user answers",
            },
        ),
        migrations.AlterField(
            model_name="answer",
            name="id",
            field=models.BigAutoField(
                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
            ),
        ),
        migrations.AlterField(
            model_name="answer",
            name="question",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="answers",
                to="djf_surveys.question",
                verbose_name="question",
            ),
        ),
        migrations.AlterField(
            model_name="answer",
            name="user_answer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djf_surveys.useranswer",
                verbose_name="user answer",
            ),
        ),
        migrations.AlterField(
            model_name="answer",
            name="value",
            field=models.TextField(
                help_text="The value of the answer given by the user.",
                verbose_name="value",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="choices",
            field=models.TextField(
                blank=True,
                help_text="If type of field is radio, select, or multi select, fill in the options separated by commas. Ex: Male, Female.",
                null=True,
                verbose_name="choices",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="help_text",
            field=models.CharField(
                blank=True,
                help_text="You can add a help text in here.",
                max_length=200,
                null=True,
                verbose_name="help text",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="id",
            field=models.BigAutoField(
                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="key",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Unique key for this question, fill in the blank if you want to use for automatic generation.",
                max_length=225,
                unique=True,
                verbose_name="key",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="label",
            field=models.CharField(
                help_text="Enter your question in here.",
                max_length=500,
                verbose_name="label",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="ordering",
            field=models.PositiveIntegerField(
                default=0,
                help_text="Defines the question order within the surveys.",
                verbose_name="choices",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="required",
            field=models.BooleanField(
                default=True,
                help_text="If True, the user must provide an answer to this question.",
                verbose_name="required",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="survey",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="questions",
                to="djf_surveys.survey",
                verbose_name="survey",
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="type_field",
            field=models.PositiveSmallIntegerField(
                choices=[
                    (0, "Text"),
                    (1, "Number"),
                    (2, "Radio"),
                    (3, "Select"),
                    (4, "Multi Select"),
                    (5, "Text Area"),
                    (6, "URL"),
                    (7, "Email"),
                    (8, "Date"),
                    (9, "Rating"),
                ],
                verbose_name="type of input field",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="can_anonymous_user",
            field=models.BooleanField(
                default=False,
                help_text="If True, user without authentatication can submit.",
                verbose_name="anonymous submission",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="deletable",
            field=models.BooleanField(
                default=True,
                help_text="If False, user can't delete record.",
                verbose_name="deletable",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="description",
            field=models.TextField(default="", verbose_name="description"),
        ),
        migrations.AlterField(
            model_name="survey",
            name="duplicate_entry",
            field=models.BooleanField(
                default=False,
                help_text="If True, user can resubmit.",
                verbose_name="mutiple submissions",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="editable",
            field=models.BooleanField(
                default=True,
                help_text="If False, user can't edit record.",
                verbose_name="editable",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="id",
            field=models.BigAutoField(
                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="name",
            field=models.CharField(max_length=200, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="survey",
            name="private_response",
            field=models.BooleanField(
                default=False,
                help_text="If True, only admin and owner can access.",
                verbose_name="private response",
            ),
        ),
        migrations.AlterField(
            model_name="survey",
            name="slug",
            field=models.SlugField(default="", max_length=225, verbose_name="slug"),
        ),
        migrations.AlterField(
            model_name="useranswer",
            name="id",
            field=models.BigAutoField(
                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
            ),
        ),
        migrations.AlterField(
            model_name="useranswer",
            name="survey",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djf_surveys.survey",
                verbose_name="survey",
            ),
        ),
        migrations.AlterField(
            model_name="useranswer",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
                verbose_name="user",
            ),
        ),
    ]
