"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_a = props.stage) !== null && _a !== void 0 ? _a : (props.restApi instanceof restapi_1.RestApi
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1wYXRoLW1hcHBpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJiYXNlLXBhdGgtbWFwcGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBZ0Q7QUFFaEQsaUVBQTREO0FBRTVELHVDQUE4Qzs7Ozs7OztBQXlDOUMsTUFBYSxlQUFnQixTQUFRLGVBQVE7Ozs7SUFDM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjs7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLEtBQUssQ0FBQyxRQUFRLElBQUksQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUN6RCxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsdUJBQXVCLENBQUMsRUFBRTtnQkFDbEQsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRkFBcUYsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7YUFDeEg7U0FDRjtRQUVELDZFQUE2RTtRQUM3RSw0RUFBNEU7UUFDNUUsTUFBTSxLQUFLLFNBQUcsS0FBSyxDQUFDLEtBQUssbUNBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxZQUFZLGlCQUFPO1lBQzVELENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGVBQWU7WUFDL0IsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRWYsSUFBSSx5Q0FBa0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3ZDLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxVQUFVO1lBQ3ZDLFNBQVMsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVM7WUFDbEMsS0FBSyxFQUFFLEtBQUssSUFBSSxLQUFLLENBQUMsU0FBUztTQUNoQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUF2QkQsMENBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UsIFRva2VuIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkJhc2VQYXRoTWFwcGluZyB9IGZyb20gJy4vYXBpZ2F0ZXdheS5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSURvbWFpbk5hbWUgfSBmcm9tICcuL2RvbWFpbi1uYW1lJztcbmltcG9ydCB7IElSZXN0QXBpLCBSZXN0QXBpIH0gZnJvbSAnLi9yZXN0YXBpJztcbmltcG9ydCB7IFN0YWdlIH0gZnJvbSAnLi9zdGFnZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQmFzZVBhdGhNYXBwaW5nT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGJhc2VQYXRoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN0YWdlPzogU3RhZ2U7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQmFzZVBhdGhNYXBwaW5nUHJvcHMgZXh0ZW5kcyBCYXNlUGF0aE1hcHBpbmdPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZG9tYWluTmFtZTogSURvbWFpbk5hbWU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXN0QXBpOiBJUmVzdEFwaTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQmFzZVBhdGhNYXBwaW5nIGV4dGVuZHMgUmVzb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQmFzZVBhdGhNYXBwaW5nUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgaWYgKHByb3BzLmJhc2VQYXRoICYmICFUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMuYmFzZVBhdGgpKSB7XG4gICAgICBpZiAoIXByb3BzLmJhc2VQYXRoLm1hdGNoKC9eW2EtejAtOSRfLishKicoKS1dKyQvKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYEEgYmFzZSBwYXRoIG1heSBvbmx5IGNvbnRhaW4gbGV0dGVycywgbnVtYmVycywgYW5kIG9uZSBvZiBcIiQtXy4rISonKClcIiwgcmVjZWl2ZWQ6ICR7cHJvcHMuYmFzZVBhdGh9YCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gaWYgcmVzdEFwaSBpcyBhbiBvd25lZCBBUEkgYW5kIGl0IGhhcyBhIGRlcGxveW1lbnQgc3RhZ2UsIG1hcCBhbGwgcmVxdWVzdHNcbiAgICAvLyB0byB0aGF0IHN0YWdlLiBvdGhlcndpc2UsIHRoZSBzdGFnZSB3aWxsIGhhdmUgdG8gYmUgc3BlY2lmaWVkIGluIHRoZSBVUkwuXG4gICAgY29uc3Qgc3RhZ2UgPSBwcm9wcy5zdGFnZSA/PyAocHJvcHMucmVzdEFwaSBpbnN0YW5jZW9mIFJlc3RBcGlcbiAgICAgID8gcHJvcHMucmVzdEFwaS5kZXBsb3ltZW50U3RhZ2VcbiAgICAgIDogdW5kZWZpbmVkKTtcblxuICAgIG5ldyBDZm5CYXNlUGF0aE1hcHBpbmcodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgYmFzZVBhdGg6IHByb3BzLmJhc2VQYXRoLFxuICAgICAgZG9tYWluTmFtZTogcHJvcHMuZG9tYWluTmFtZS5kb21haW5OYW1lLFxuICAgICAgcmVzdEFwaUlkOiBwcm9wcy5yZXN0QXBpLnJlc3RBcGlJZCxcbiAgICAgIHN0YWdlOiBzdGFnZSAmJiBzdGFnZS5zdGFnZU5hbWUsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==