import * as acm from '@aws-cdk/aws-certificatemanager';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BasePathMapping, BasePathMappingOptions } from './base-path-mapping';
import { EndpointType, IRestApi } from './restapi';
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 */
export declare enum SecurityPolicy {
    /**
     * Cipher suite TLS 1.0.
     */
    TLS_1_0 = "TLS_1_0",
    /**
     * Cipher suite TLS 1.2.
     */
    TLS_1_2 = "TLS_1_2"
}
/**
 *
 */
export interface DomainNameOptions {
    /**
     * The custom domain name for your API.
     *
     * Uppercase letters are not supported.
     */
    readonly domainName: string;
    /**
     * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
     *
     * For "EDGE" domain names, the certificate
     * needs to be in the US East (N. Virginia) region.
     */
    readonly certificate: acm.ICertificate;
    /**
     * The type of endpoint for this DomainName.
     *
     * @default REGIONAL
     */
    readonly endpointType?: EndpointType;
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this domain name.
     *
     * @default SecurityPolicy.TLS_1_0
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
     */
    readonly securityPolicy?: SecurityPolicy;
}
/**
 *
 */
export interface DomainNameProps extends DomainNameOptions {
    /**
     * If specified, all requests to this domain will be mapped to the production deployment of this API.
     *
     * If you wish to map this domain to multiple APIs
     * with different base paths, don't specify this option and use
     * `addBasePathMapping`.
     *
     * @default - you will have to call `addBasePathMapping` to map this domain to
     * API endpoints.
     */
    readonly mapping?: IRestApi;
}
/**
 *
 */
export interface IDomainName extends IResource {
    /**
     * The domain name (e.g. `example.com`).
     *
     * @attribute DomainName
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @attribute DistributionDomainName,RegionalDomainName
     */
    readonly domainNameAliasDomainName: string;
    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @attribute DistributionHostedZoneId,RegionalHostedZoneId
     */
    readonly domainNameAliasHostedZoneId: string;
}
/**
 *
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * Imports an existing domain name.
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * The domain name (e.g. `example.com`).
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     */
    readonly domainNameAliasDomainName: string;
    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     */
    readonly domainNameAliasHostedZoneId: string;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
    /**
     * Maps this domain to an API endpoint.
     *
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage.
     * @param options Options for mapping to base path with or without a stage.
     */
    addBasePathMapping(targetApi: IRestApi, options?: BasePathMappingOptions): BasePathMapping;
}
/**
 *
 */
export interface DomainNameAttributes {
    /**
     * The domain name (e.g. `example.com`).
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     */
    readonly domainNameAliasTarget: string;
    /**
     * Thje Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     */
    readonly domainNameAliasHostedZoneId: string;
}
