#!/bin/bash
cat <<EOM
Libvirt/Ubuntu Installation Script
=====================================================================
This script installs Libvirt, Vagrant, and vagrant-libvirt plugin
on a Ubuntu system. The script was tested on Debian 11.3 and Ubuntu
20.04.

NOTE: the script is set to abort on first error. If the installation
completed you're probably OK even though you might have seen errors
during the installation process.
=====================================================================

EOM

# Add sudo / root check - ghostinthenet 20220418
SUDO=''
if [ "$UID" != "0" ]; then
 if [ -x "$(command -v sudo)" ]; then
  SUDO=sudo
 else
  echo 'Script requires root privileges.'
  exit 0
 fi
fi

if [[ -z "$FLAG_YES" ]]; then
  # Remove implied default of Y - ghostinthenet 20220418
  read -p "Are you sure you want to proceed [y/n] " -n 1 -r
  echo
  if ! [[ $REPLY =~ [Yy] ]]; then
   echo "Aborting..."
   exit 1
  fi
  FLAG_YES="Y"
fi
#
set -e
#
echo "Update the package list"
$SUDO apt-get $FLAG_QUIET update
#
echo
echo "Install common libraries and support software"
$SUDO apt-get install -y $FLAG_QUIET libxslt-dev libxml2-dev zlib1g-dev
$SUDO apt-get install -y $FLAG_QUIET ebtables dnsmasq-base sshpass tree jq bridge-utils
echo ".. common libraries installed"
echo
echo "Install libvirt packages"
$SUDO apt-get install -y $FLAG_QUIET libvirt-dev qemu qemu-kvm virtinst
$SUDO apt-get install -y $FLAG_QUIET libvirt-daemon-system libvirt-clients
echo ".. libvirt packages installed"
echo
echo "Install vagrant"
echo ".. setting up Vagrant repository"
set +e
$SUDO rm /etc/apt/trusted.gpg.d/hashicorp-security.gpg 2>/dev/null
$SUDO rm /etc/apt/sources.list.d/vagrant.list 2>/dev/null
set -e
# add-apt-repository has been deprecated, doesn't work on Debian 11 and will be removed from Ubuntu 22
# changed to new method - ghostinthenet - 20220417
curl -fsSL https://apt.releases.hashicorp.com/gpg | $SUDO gpg --dearmor -o /etc/apt/trusted.gpg.d/hashicorp-security.gpg
$SUDO sh -c 'echo "deb [arch=amd64] https://apt.releases.hashicorp.com $(lsb_release -cs) main" > /etc/apt/sources.list.d/vagrant.list'
$SUDO apt-get update
$SUDO apt-get install -y $FLAG_QUIET ruby-dev ruby-libvirt vagrant
set +e
PLUGIN_VER=$(vagrant plugin list|grep vagrant-libvirt|grep 0.4.1)
set -e
if [[ -z "$PLUGIN_VER" ]]; then
  vagrant plugin install vagrant-libvirt --plugin-version=0.4.1
else
  echo ".. libvirt-vagrant plugin already installed"
fi
echo ".. vagrant installed"
echo
set +e
G="$(groups $USER|grep libvirt)"
set -e
if [[ -z "$G" ]]; then
  echo "Add user $USER to libvirt group"
  $SUDO usermod -a -G libvirt $USER
  echo ".. You might need to log out and log in to start using netsim-tools with libvirt"
  echo
fi
echo "Create vagrant-libvirt virtual network"
set +e
NET_LIST=$($SUDO virsh net-list --all|grep vagrant-libvirt)
if [[ -n "$NET_LIST" ]]; then
  echo ".. removing existing vagrant-libvirt network"
  $SUDO virsh net-destroy vagrant-libvirt
  $SUDO virsh net-undefine vagrant-libvirt
fi
SCRIPT_DIR=$(dirname "${BASH_SOURCE[0]}")
set -e
$SUDO virsh net-define "$SCRIPT_DIR/../templates/provider/libvirt/vagrant-libvirt.xml"
echo ".. vagrant-libvirt network created"
$SUDO virsh net-start vagrant-libvirt
$SUDO virsh net-autostart vagrant-libvirt
