---
layout: page
title: Alpaca Forms in the Cloud
header: Alpaca Forms in the Cloud
group: navigation
sitemap:
  priority: 1.0
---
{% include JB/setup %}

<a href="https://www.cloudcms.com" target="_blank">Cloud CMS</a> provides a hosted cloud service for Alpaca Forms that
provides everything your organization needs to run Alpaca Forms on your own web sites.  Design your Forms in the cloud
and present them on your web site.  Form data is captured and stored on the Cloud CMS backend, letting you and your
team retrieve information and generate real-time reports.

Cloud CMS provides enterprise content management for your business applications.
In addition to forms management, <a href="https://www.cloudcms.com" target="_blank">Cloud CMS</a> provides
robust object and team-based security, storage,
<a href="#collaboration">team collaboration</a>,
<a href="#reports">reporting</a> and a
<a href="#form-builder">visual form designer</a>.  It offers a board and integrated set of features to
empower your organization and make it more productive.

Cloud CMS is available as a <a href="https://www.cloudcms.com/pricing.html" target="_blank">monthly subscription</a>.
You can <a href="https://www.cloudcms.com/trial.html">sign up for a free trial</a> to evaluate the product at any time.

<a name="hosting"></a>
## Cloud Hosting

Alpaca connects seamlessly to <a href="https://www.cloudcms.com" target="_blank">Cloud CMS</a> to load form information
(such as JSON schema, options and layout information) and then uses that to render right on your web site.  When
your customers complete the form, the form data is posted back to
<a href="https://www.cloudcms.com" target="_blank">Cloud CMS</a> and stored in a data list.  All of this data is
captured, including JSON fields and binary form attachments, allowing your team to query against it and generate
reports (such as PDF or CSV/Excel) at any time.

We offer several <a href="https://www.cloudcms.com/pricing.html" target="_blank">subscription plans</a>
that are cost-effective and scalable for your organization's needs.

<div class="row">
    <div class="col-md-12">
        <div class="cloud-image">
            <img src="/images/cloud/cloudcms.png" style="max-width: 600px">
        </div>
    </div>
</div>

<a name="reports"></a>
## Reports

Every time someone submits a form, the data is captured and stored within Cloud CMS, allowing you to browse it, find
it and gain real-time insight from it.  Cloud CMS provides your business users with an elegant and form-driven user
interface for managing the data capture from your web sites and mobile applications.

It's easy to export all of your form data to various formats including PDF, Excel and comma-separated values.
Template processors allow you to massage data into any format you'd like so as to generate text, HTML or PDF output.

<div class="row">
    <div class="col-md-12">
        <div class="cloud-image">
            <img src="/images/cloud/json.png" style="max-width: 800px">
        </div>
    </div>
</div>

<a name="collaboration"></a>
## Collaboration

Work together as one team within Cloud CMS.  Invite your team members into project workspaces and assign them roles to
play within the project so as to designate exactly who has rights to work with forms, form data, exports and more.
Customize the user interface to make your team more productive.

Cloud CMS is a fully-fledged, enterprise-class content management system that can not only handle the content
for your mobile/web applications, but also handles images, users, groups, push notifications, registration, workflow,
publishing and much more.

<div class="row">
    <div class="col-md-12">
        <div class="cloud-image">
            <img src="/images/cloud/collaboration.png" style="max-width: 600px">
        </div>
    </div>
</div>

<a name="form-builder"></a>
## Form Builder

Cloud CMS lets you visually design your forms.  For a given schema, you may manage one or more forms consisting of
layout and options information.  Instantly preview changes to your forms as you work on them and surface them into
your web pages using a simple plugin.

In addition, take advantage of role-based delegation of forms within the Cloud CMS user interface.  Provision forms
for your content workers based on their roles within your application.

<div class="row">
    <div class="col-md-12">
        <div class="cloud-image">
            <img src="/images/cloud/formbuilder.png" style="max-width: 600px">
        </div>
    </div>
</div>

<a name="plugin"></a>
## Run on any Web Site

With Cloud CMS, you define your forms in the cloud and then surface them inside of your web pages using a simple
JavaScript snippet.  You paste the JavaScript snippet into your pages and then reload.  That's all there is to it.

Alpaca snippets work with most popular web HTML5 sites including Wordpress, Drupal, Joomla, PHP, .NET, Node.js and
other web server technologies.