/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dep
extends Annotation
implements SentenceLevelAnnotation {
    private Term from;
    private Term to;
    private String rfunc;
    private String depcase;

    Dep(Term from, Term to, String rfunc) {
        this.from = from;
        this.to = to;
        this.rfunc = rfunc;
    }

    Dep(Dep dep, HashMap<String, Term> terms) {
        this.from = terms.get(dep.from.getId());
        if (this.from == null) {
            throw new IllegalStateException("Couldn't find the term when loading dep (" + dep.getFrom().getId() + ", " + dep.getTo().getId() + ")");
        }
        this.to = terms.get(dep.to.getId());
        if (this.to == null) {
            throw new IllegalStateException("Couldn't find the term when loading dep (" + dep.getFrom().getId() + ", " + dep.getTo().getId() + ")");
        }
        this.rfunc = dep.rfunc;
        this.depcase = dep.depcase;
    }

    public Term getFrom() {
        return this.from;
    }

    public void setFrom(Term term) {
        this.from = term;
    }

    public Term getTo() {
        return this.to;
    }

    public void setTo(Term term) {
        this.to = term;
    }

    public String getRfunc() {
        return this.rfunc;
    }

    public void setRfunc(String rfunc) {
        this.rfunc = rfunc;
    }

    public boolean hasCase() {
        return this.depcase != null;
    }

    public String getCase() {
        return this.depcase;
    }

    public void setCase(String depcase) {
        this.depcase = depcase;
    }

    public String getStr() {
        return this.rfunc + "(" + this.getFrom().getStr() + ", " + this.getTo().getStr() + ")";
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.getFrom());
        terms.add(this.getTo());
        referenced.put(KAFDocument.AnnotationType.TERM, terms);
        return referenced;
    }

    @Override
    public Integer getSent() {
        return this.from.getSent();
    }

    @Override
    public Integer getPara() {
        return this.from.getPara();
    }
}

