/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkedEntity
extends IdentifiableAnnotation {
    private String resource;
    private String reference;
    private double confidence;
    private Span<WF> mentions;

    LinkedEntity(String id) {
        super(id);
        this.mentions = new Span();
    }

    LinkedEntity(String id, Span<WF> mentions) {
        super(id);
        if (mentions.size() < 1) {
            throw new IllegalStateException("LinkedEntity must contain at least one reference span");
        }
        this.mentions = mentions;
    }

    LinkedEntity(LinkedEntity linkedEntity, HashMap<String, WF> WFs) {
        super(linkedEntity.getId());
        this.resource = linkedEntity.resource;
        this.reference = linkedEntity.reference;
        this.confidence = linkedEntity.confidence;
        String id = linkedEntity.getId();
        this.mentions = linkedEntity.getWFs();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public Span<WF> getSpan() {
        return this.mentions;
    }

    public String getSpanStr() {
        String str = "";
        for (WF wf : this.mentions.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + wf.getForm();
        }
        return str;
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        referenced.put(KAFDocument.AnnotationType.WF, this.getSpan().getTargets());
        return referenced;
    }

    public Span<WF> getWFs() {
        return this.mentions;
    }
}

