/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.Entity;
import ixa.kaflib.Feature;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Relational;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Relation
extends IdentifiableAnnotation
implements Serializable {
    private Relational from;
    private Relational to;
    private float confidence;

    Relation(String id, Relational from, Relational to) {
        super(id);
        this.id = id;
        this.from = from;
        this.to = to;
        this.confidence = -1.0f;
    }

    Relation(Relation relation, HashMap<String, Relational> relational) {
        super(relation.getId());
        this.id = relation.getId();
        if (relation.from != null) {
            this.from = relational.get(relation.from.getId());
            if (this.from == null) {
                throw new IllegalStateException("Couldn't find relational " + relation.from.getId() + " when copying " + relation.getId());
            }
        }
        if (relation.to != null) {
            this.to = relational.get(relation.to.getId());
            if (this.to == null) {
                throw new IllegalStateException("Couldn't find relational " + relation.to.getId() + " when copying " + relation.getId());
            }
        }
        this.confidence = relation.confidence;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Relational getFrom() {
        return this.from;
    }

    public void setFrom(Relational obj) {
        this.from = obj;
    }

    public Relational getTo() {
        return this.to;
    }

    public void setTo(Relational obj) {
        this.to = obj;
    }

    public boolean hasConfidence() {
        return this.confidence >= 0.0f;
    }

    public float getConfidence() {
        if (this.confidence < 0.0f) {
            return 1.0f;
        }
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        if (confidence < 0.0f || confidence > 1.0f) {
            throw new IllegalStateException("Confidence's value in a relation must be >=0 and <=1. [0, 1].");
        }
        this.confidence = confidence;
    }

    public String getStr() {
        String str = "(" + this.from.getStr() + ", " + this.to.getStr() + ")";
        if (this.hasConfidence()) {
            str = str + " [" + this.getConfidence() + "]";
        }
        return str;
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        ArrayList<Annotation> entities = new ArrayList<Annotation>();
        ArrayList<Annotation> properties = new ArrayList<Annotation>();
        ArrayList<Annotation> categories = new ArrayList<Annotation>();
        if (this.from instanceof Entity) {
            entities.add((Annotation)((Object)this.from));
        } else if (((Feature)this.from).isAProperty()) {
            properties.add((Annotation)((Object)this.from));
        } else {
            categories.add((Annotation)((Object)this.from));
        }
        if (this.to instanceof Entity) {
            entities.add((Annotation)((Object)this.to));
        } else if (((Feature)this.to).isAProperty()) {
            properties.add((Annotation)((Object)this.to));
        } else {
            categories.add((Annotation)((Object)this.to));
        }
        referenced.put(KAFDocument.AnnotationType.ENTITY, entities);
        referenced.put(KAFDocument.AnnotationType.PROPERTY, properties);
        referenced.put(KAFDocument.AnnotationType.CATEGORY, categories);
        return referenced;
    }
}

