/*
 * Decompiled with CFR 0.152.
 */
package ixa.pipe.dep.eu;

import ixa.kaflib.KAFDocument;
import ixa.kaflib.Term;
import ixa.kaflib.WF;
import ixa.pipe.dep.eu.Annotate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();

    public static void main(String[] args) throws Exception {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseCLI(String[] args) throws Exception {
        Namespace parsedArguments = null;
        ArgumentParser parser = ArgumentParsers.newArgumentParser("ixa-pipe-dep-eu-" + this.version + ".jar").description("ixa-pipe-dep-eu-" + this.version + " euskaraz idatzitako testuetarako" + " dependentzia etiketatzailea da. ixaKat tresna bat da (http://ixa2.si.ehu.es/ixakat/).\n");
        parser.addArgument("-b", "--baliabideak").required(true).help("Beharrezkoa da zehaztea deskargatutako baliabideen direktorioaren kokapena.");
        parser.addArgument("-c", "--conll").required(false).setDefault("Hutsa").help("Erabili aukera hau irteera CONLL formatuan ere gorde nahi bada. Zehaztu irteerako fitxategiaren kokapena.");
        try {
            parsedArguments = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.out.println("Exekutatu java -jar ixa-pipe-dep-eu-" + this.version + ".jar -help laguntza jasotzeko");
            System.exit(1);
        }
        String baliabideDir = parsedArguments.getString("baliabideak");
        String conllFitx = parsedArguments.getString("conll");
        BufferedReader stdInReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(stdInReader);
        String lang = kaf.getLang();
        KAFDocument.LinguisticProcessor lp = kaf.addLinguisticProcessor("deps", "ixa-pipe-dep-eu-" + lang, this.version + "-" + this.commit);
        lp.setBeginTimestamp();
        Annotate annotator = new Annotate(baliabideDir);
        try {
            List<WF> wordForms = kaf.getWFs();
            List<Term> terms = kaf.getTerms();
            if (!wordForms.isEmpty() && !terms.isEmpty()) {
                annotator.lortuDependentziakMate(kaf, conllFitx);
            }
        }
        catch (Exception e) {
            System.err.println("Dependentzi analisiak huts egin du: ");
            e.printStackTrace();
        }
        finally {
            lp.setEndTimestamp();
            w.write(kaf.toString());
            w.close();
        }
    }
}

