/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.LemmaSample;
import eus.ixa.ixa.pipe.lemma.LemmatizerContextGenerator;
import java.io.IOException;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class LemmaSampleSequenceStream
implements SequenceStream {
    private final ObjectStream<LemmaSample> samples;
    private final LemmatizerContextGenerator contextGenerator;

    public LemmaSampleSequenceStream(ObjectStream<LemmaSample> samples, LemmatizerContextGenerator contextGenerator) {
        this.samples = samples;
        this.contextGenerator = contextGenerator;
    }

    @Override
    public Sequence read() throws IOException {
        LemmaSample sample = this.samples.read();
        if (sample != null) {
            String[] sentence = sample.getTokens();
            String[] tags = sample.getTags();
            String[] preds = sample.getLemmas();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                String[] context = this.contextGenerator.getContext(i, sentence, tags, preds);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence<LemmaSample>(events, sample);
        }
        return null;
    }

    @Override
    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }
}

