/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma.train;

import eus.ixa.ixa.pipe.lemma.LemmaSample;
import eus.ixa.ixa.pipe.lemma.LemmaSampleStream;
import eus.ixa.ixa.pipe.lemma.LemmatizerEvaluationMonitor;
import eus.ixa.ixa.pipe.lemma.LemmatizerEvaluator;
import eus.ixa.ixa.pipe.lemma.LemmatizerFactory;
import eus.ixa.ixa.pipe.lemma.LemmatizerME;
import eus.ixa.ixa.pipe.lemma.LemmatizerModel;
import eus.ixa.ixa.pipe.lemma.train.LemmatizerTrainer;
import eus.ixa.ixa.pipe.pos.train.Flags;
import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import java.io.IOException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractLemmatizerTrainer
implements LemmatizerTrainer {
    private final String lang;
    private final ObjectStream<LemmaSample> trainSamples;
    private final ObjectStream<LemmaSample> testSamples;
    private LemmatizerFactory lemmatizerFactory;

    public AbstractLemmatizerTrainer(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        String trainData = Flags.getDataSet("TrainSet", params);
        String testData = Flags.getDataSet("TestSet", params);
        ObjectStream<String> trainStream = InputOutputUtils.readFileIntoMarkableStreamFactory(trainData);
        this.trainSamples = new LemmaSampleStream(trainStream);
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new LemmaSampleStream(testStream);
    }

    @Override
    public final LemmatizerModel train(TrainingParameters params) {
        if (this.getLemmatizerFactory() == null) {
            throw new IllegalStateException("Classes derived from AbstractLemmatizerTrainer must  create a LemmatizerFactory features!");
        }
        LemmatizerModel trainedModel = null;
        LemmatizerEvaluator lemmatizerEvaluator = null;
        try {
            trainedModel = LemmatizerME.train(this.lang, this.trainSamples, params, this.getLemmatizerFactory());
            LemmatizerME lemmatizer = new LemmatizerME(trainedModel);
            lemmatizerEvaluator = new LemmatizerEvaluator(lemmatizer, new LemmatizerEvaluationMonitor[0]);
            lemmatizerEvaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            System.err.println("IO error while loading training and test sets!");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Final result: " + lemmatizerEvaluator.getWordAccuracy());
        return trainedModel;
    }

    protected final LemmatizerFactory getLemmatizerFactory() {
        return this.lemmatizerFactory;
    }

    protected final void setLemmatizerFactory(LemmatizerFactory aLemmatizerFactory) {
        this.lemmatizerFactory = aLemmatizerFactory;
    }
}

