/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.dict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.Span;

public class MultiWordSample {
    private final String id;
    private final List<String> tokens;
    private final List<Span> names;
    public static final String DEFAULT_TYPE = "UNK";

    public MultiWordSample(String id, String[] sentence, Span[] multiwords) {
        this.id = id;
        if (sentence == null) {
            throw new IllegalArgumentException("sentence must not be null!");
        }
        if (multiwords == null) {
            multiwords = new Span[]{};
        }
        this.tokens = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        this.names = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(multiwords)));
    }

    public MultiWordSample(String[] sentence, Span[] names) {
        this(null, sentence, names);
    }

    public String getId() {
        return this.id;
    }

    public String[] getSentence() {
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    public Span[] getNames() {
        return this.names.toArray(new Span[this.names.size()]);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiWordSample) {
            MultiWordSample a = (MultiWordSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getNames(), a.getNames());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int tokenIndex = 0; tokenIndex < this.tokens.size(); ++tokenIndex) {
            for (Span name : this.names) {
                if (name.getStart() == tokenIndex) {
                    sb.append("<START:").append(name.getType()).append("> ");
                }
                if (name.getEnd() != tokenIndex) continue;
                sb.append("<END>").append(' ');
            }
            sb.append(this.tokens.get(tokenIndex)).append(' ');
        }
        if (this.tokens.size() > 1) {
            sb.setLength(sb.length() - 1);
        }
        for (Span name : this.names) {
            if (name.getEnd() != this.tokens.size()) continue;
            sb.append(' ').append("<END>");
        }
        String multiWordSample = sb.toString();
        return multiWordSample;
    }
}

