/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.eval;

import eus.ixa.ixa.pipe.pos.train.BaselineFactory;
import eus.ixa.ixa.pipe.pos.train.Flags;
import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerCrossValidator;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.EvaluationMonitor;

public class POSCrossValidator {
    private final String lang;
    private final ObjectStream<POSSample> trainSamples;
    private final int dictCutOff;
    private final int folds;
    private POSTaggerFactory posTaggerFactory;
    private final List<EvaluationMonitor<POSSample>> listeners = new LinkedList<EvaluationMonitor<POSSample>>();
    POSTaggerFineGrainedReportListener detailedListener;

    public POSCrossValidator(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        String trainData = Flags.getDataSet("TrainSet", params);
        ObjectStream<String> trainStream = InputOutputUtils.readFileIntoMarkableStreamFactory(trainData);
        this.trainSamples = new WordTagSampleStream(trainStream);
        this.dictCutOff = Flags.getAutoDictFeatures(params);
        this.folds = Flags.getFolds(params);
        this.createPOSFactory(params);
        this.getEvalListeners(params);
    }

    private void createPOSFactory(TrainingParameters params) {
        String featureSet = Flags.getFeatureSet(params);
        this.posTaggerFactory = featureSet.equalsIgnoreCase("Opennlp") ? new POSTaggerFactory() : new BaselineFactory();
    }

    private void getEvalListeners(TrainingParameters params) {
        if (params.getSettings().get("EvaluationType").equalsIgnoreCase("error")) {
            this.listeners.add(new POSEvaluationErrorListener());
        }
        if (params.getSettings().get("EvaluationType").equalsIgnoreCase("detailed")) {
            this.detailedListener = new POSTaggerFineGrainedReportListener();
            this.listeners.add(this.detailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void crossValidate(TrainingParameters params) {
        POSTaggerCrossValidator validator = null;
        try {
            validator = this.getPOSTaggerCrossValidator(params);
            validator.evaluate(this.trainSamples, this.folds);
        }
        catch (IOException e) {
            System.err.println("IO error while loading training set!");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                this.trainSamples.close();
            }
            catch (IOException e) {
                System.err.println("IO error with the train samples!");
            }
        }
        if (this.detailedListener == null) {
            System.out.println(validator.getWordAccuracy());
        } else {
            System.out.println(validator.getWordAccuracy());
        }
    }

    private POSTaggerCrossValidator getPOSTaggerCrossValidator(TrainingParameters params) {
        File dictPath = new File(Flags.getDictionaryFeatures(params));
        if (this.posTaggerFactory == null) {
            throw new IllegalStateException("You must create the POSTaggerFactory features!");
        }
        POSTaggerCrossValidator validator = null;
        validator = dictPath.getName().equals("off") ? (this.dictCutOff == -1 ? new POSTaggerCrossValidator(this.lang, params, null, null, null, this.posTaggerFactory.getClass().getName(), this.listeners.toArray(new POSTaggerEvaluationMonitor[this.listeners.size()])) : new POSTaggerCrossValidator(this.lang, params, null, null, this.dictCutOff, this.posTaggerFactory.getClass().getName(), this.listeners.toArray(new POSTaggerEvaluationMonitor[this.listeners.size()]))) : (this.dictCutOff == -1 ? new POSTaggerCrossValidator(this.lang, params, dictPath, null, null, this.posTaggerFactory.getClass().getName(), this.listeners.toArray(new POSTaggerEvaluationMonitor[this.listeners.size()])) : new POSTaggerCrossValidator(this.lang, params, dictPath, null, this.dictCutOff, this.posTaggerFactory.getClass().getName(), this.listeners.toArray(new POSTaggerEvaluationMonitor[this.listeners.size()])));
        return validator;
    }
}

