
# Copyright (c) 2023 Watsen Networks.  All Rights Reserved.

import sys,argparse
from .  import sztpd
from sztpd import __version__
def main(argv=None):A=argparse.ArgumentParser(prog='sztpd',formatter_class=argparse.RawDescriptionHelpFormatter,description='SZTPD implements the "bootstrap server" defined in RFC 8572.',epilog='\nExit status code: 0 on success, non-0 on error.  Error output goes to stderr.\n\nThe "cacert" argument is a filepath to a PEM file that contains one or more X.509\nCA certificates used to authenticate the RDBMS\'s TLS certificate.\n\nThe "key" and "cert" arguments are each a filepath to a PEM file that contains\nthe key and certificate that SZTPD should use to authenticate itself to the\nRDBMS.  These parameters must be specified together, and must be specified\nin conjunction with the "cacert" parameter.\n\nThe "database-url" argument has the form "<dialect>:<dialect-specific-path>".\nThree dialects are supported: "sqlite", "postgresql", and "mysql+pymysql".\nThe dialect-specific-path for each of these is described below.\n\nFor the "sqlite" dialect, <dialect-specific-path> follows the format\n"///<sqlite-path>", where <sqlite-path> can be one of:\n\n  :memory:    - an in-memory database (only useful for testing)\n  <filepath>  - an OS-specific filepath to a persisted database file\n\n  Examples:\n\n    $ sztpd sqlite:///:memory:                      (memory)\n    $ sztpd sqlite:///relative/path/to/sztpd.db     (unix)\n    $ sztpd sqlite:////absolute/path/to/sztpd.db    (unix)\n    $ sztpd sqlite:///C:\\path\\to\\sztpd.db           (windows)\n\nFor both the "postgresql" and "mysql+pymysql" dialects, <dialect-specific-path>\nfollows the format "//<user>[:<passwd>]@<host>:<port>/<database-name>".\n\n  Examples:\n\n    The following two examples assume the database is called "sztpd" and\n    that the database server listens on the loopback address with no TLS.\n\n      $ sztpd mysql+pymysql://user:pass@localhost:3306/sztpd\n      $ sztpd postgresql://user:pass@localhost:5432/sztpd\n\n\nPlease see the documentation for more information.\n');A.add_argument('-v','--version',help='show version number and exit.',action='version',version=__version__);A.add_argument('-C','--cacert',help='path to certificates used to authenticate the database (see below for details).');A.add_argument('-c','--cert',help='path to cert used to authenticate SZTPD to the database (see below for details).');A.add_argument('-k','--key',help='path to key used to authenticate SZTPD to the database (see below for details).');A.add_argument('database_url',help='see below for details.',metavar='database-url');B=A.parse_args();return sztpd.run(B.database_url,B.cacert,B.cert,B.key)
if __name__=='__main__':sys.exit(main())