import { aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface ManagedInstanceRoleProps {
    /**
     * The managed policies to apply to the role in addition to the default policies.
     *
     * @stability stable
     */
    readonly managedPolicies?: iam.ManagedPolicy[];
    /**
     * Should the role include directory service access with SSM.
     *
     * @stability stable
     */
    readonly domainJoinEnabled?: boolean;
    /**
     * Should the role include SSM management.
     *
     * By default if domainJoinEnabled is true then this role is always included.
     *
     * @stability stable
     */
    readonly ssmManagementEnabled?: boolean;
}
/**
 * @stability stable
 */
export declare class ManagedInstanceRole extends Construct {
    /**
     * @stability stable
     */
    readonly instanceProfile: iam.CfnInstanceProfile;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ManagedInstanceRoleProps);
}
