# TriCCo

TriCCo is a python library for computing connected components on an unstructured triangular grid. It is based on the mathematical method of cubulation, which allows one to map a 2-dimensional triangular grid to a 3-dimensional cubic grid. While the former is unstructured, the latter is structured and so existing connected-component labeling libraries can be used. Thus, by mapping the triangular grid to its cubic counterpart, one can compute connected components by using existing other libaries. TriCCo uses the library connected-components-3d (cc3d) for this.

TriCCo is distributed under the GNU General Public License v3.0.

## Repository structure

The repository is organized as follows:
* **tricco** contains the actual python code.
* **examples** contains two jupyter notebooks that illustrate the use of TriCCo for 2-d data on a single model level and for 3-d data on multiple model levels. The subdirectory data contains the grid and model output from the ICON atmosphere model that is needed to run the notebooks. The plots generated by the notebooks are included as separated pdf files. `find_radius.py` illustrates how the diagnostic output of `tricco.compute_cubulation` can be used to determine the search radius. `find_start.py` can be used to find the triangular cell closest to a given latitude-longitude position. Note that `find_start.py` is written for a grid from the ICON model.
* **benchmarks** contains scripts that were used to characterize the computational performance of TriCCo on the Mistral DKRZ supercomputer. 

## Installation

TriCCo is hosted at the gitlab service of Phaidra of University of Vienna, Austria. 

TriCCo is also available from pypi at https://pypi.org/project/tricco/ and can be installed via pip.

`pip install tricco`

## Authors

TriCCo has been developed by:
*  Aiko Voigt (University of Vienna, Austria)
*  Petra Schwer (Otto von Guericke University of Magdeburg, Germany)
*  Noam von Rotberg (Otto von Guericke University of Magdeburg, Germany)
*  Nicole Knopf (Karlsruhe Institute of Technology, Germany)


## Acknowledgements

The development of TriCCo was supported by funding from a YIN Award of the Young Investigator Network of Karlsruhe Institute of Technology, from the MathSEE Centre of Karlsruhe Institute of Technology, and from the German Ministry of Education and Research (BMBF) and FONA: Research for Sustainable Development under grant 01LK1509A.

TriCCo uses a couple of other python libraries, and we are very grateful to the communities of developers and maintainers of these libraries. The libraries are:
- numpy, https://numpy.org/
- xarray, http://xarray.pydata.org/
- cc3d, https://github.com/seung-lab/connected-components-3d
- networkx, https://networkx.org/

We are also grateful to the libraries matplotlib (https://matplotlib.org/) and plotly (https://plotly.com/) that are used in the example jupyter notebooks.
