"""Numerai main tournament metadata.

Convenience module defining some of the more static variables of the
Numerai main tournament.

The tournament is constantly evolving. Metadata from this module might
be outdated. Retrieving the most recent information using the `fetch_`
functions of the `nntm.datasets` module should be preferred.

References
----------

https://forum.numer.ai/t/super-massive-data-release-deep-dive/4053
https://forum.numer.ai/t/october-2021-updates/4384
"""

TARGET_NAMES_UNIQUE = [
    "target_nomi_20",
    "target_nomi_60",
    "target_jerome_20",
    "target_jerome_60",
    "target_janet_20",
    "target_janet_60",
    "target_ben_20",
    "target_ben_60",
    "target_alan_20",
    "target_alan_60",
    "target_paul_20",
    "target_paul_60",
    "target_george_20",
    "target_george_60",
    "target_william_20",
    "target_william_60",
    "target_arthur_20",
    "target_arthur_60",
    "target_thomas_20",
    "target_thomas_60",
]
TARGET_NAMES = ["target"] + TARGET_NAMES_UNIQUE

FEATURE_NAMES_LEGACY = [
    "feature_unco_terefah_thirster",
    "feature_enlightening_mirthful_laurencin",
    "feature_tarry_meet_chapel",
    "feature_himyarite_tetragonal_deceit",
    "feature_dovetailed_winy_hanaper",
    "feature_tortured_arsenical_arable",
    "feature_unamazed_tumular_photomicrograph",
    "feature_unsurveyed_boyish_aleph",
    "feature_phellogenetic_vibrational_jocelyn",
    "feature_seemlier_reorient_monandry",
    "feature_unmalleable_resistant_kingston",
    "feature_lordly_lamellicorn_buxtehude",
    "feature_antipodal_unable_thievery",
    "feature_hypersonic_volcanological_footwear",
    "feature_unspotted_practiced_gland",
    "feature_casuistic_barbarian_monochromy",
    "feature_torturesome_estimable_preferrer",
    "feature_unlawful_superintendent_brunet",
    "feature_multilinear_sharpened_mouse",
    "feature_padded_peripteral_pericranium",
    "feature_antisubmarine_foregoing_cryosurgery",
    "feature_spagyric_echt_alum",
    "feature_epidermic_scruffiest_prosperity",
    "feature_chaldean_vixenly_propylite",
    "feature_emmetropic_heraclitean_conducting",
    "feature_telephonic_shakable_bollock",
    "feature_unapplicable_jerkiest_klemperer",
    "feature_perceivable_gasiform_psammite",
    "feature_unrelieved_rawish_cement",
    "feature_casemated_ibsenian_grantee",
    "feature_fragrant_fifteen_brian",
    "feature_apomictical_motorized_vaporisation",
    "feature_hysteric_mechanized_recklinghausen",
    "feature_reduplicate_conoid_albite",
    "feature_softish_unseparated_caudex",
    "feature_faustian_unventilated_lackluster",
    "feature_greedier_favorable_enthymeme",
    "feature_rural_inquisitional_trotline",
    "feature_mined_game_curse",
    "feature_smoggy_niftiest_lunch",
    "feature_paramagnetic_complex_gish",
    "feature_chaotic_granitoid_theist",
    "feature_basaltic_arid_scallion",
    "feature_unrated_intact_balmoral",
    "feature_revealable_aeonian_elvira",
    "feature_desiderative_commiserative_epizoa",
    "feature_subdued_spiffier_kano",
    "feature_flavourful_seismic_erica",
    "feature_doggish_whacking_headscarf",
    "feature_palatalized_unsucceeded_induration",
    "feature_conceding_ingrate_tablespoonful",
    "feature_misanthropic_knurliest_freebooty",
    "feature_inhibited_snowiest_drawing",
    "feature_induplicate_hoarse_disbursement",
    "feature_uninclosed_handcrafted_springing",
    "feature_bleeding_arabesque_pneuma",
    "feature_incitant_trochoidal_oculist",
    "feature_cairned_fumiest_ordaining",
    "feature_huskiest_compartmental_jacquerie",
    "feature_endangered_unthreaded_firebrick",
    "feature_epicurean_fetal_seising",
    "feature_stylistic_honduran_comprador",
    "feature_hellenistic_scraggly_comfort",
    "feature_intrusive_effluent_hokkaido",
    "feature_unnetted_bay_premillennialist",
    "feature_tossing_denominative_threshing",
    "feature_vestmental_hoofed_transpose",
    "feature_unsurveyed_chopped_feldspathoid",
    "feature_undescribed_methylic_friday",
    "feature_chartered_conceptual_spitting",
    "feature_fustiest_voiced_janet",
    "feature_offshore_defamatory_catalog",
    "feature_jiggish_tritheist_probity",
    "feature_quinsied_increased_braincase",
    "feature_petitionary_evanescent_diallage",
    "feature_fleshly_bedimmed_enfacement",
    "feature_zarathustrian_albigensian_itch",
    "feature_uncompromising_fancy_kyle",
    "feature_seamier_jansenism_inflator",
    "feature_levigate_kindly_dyspareunia",
    "feature_ctenoid_moaning_fontainebleau",
    "feature_unliving_bit_bengaline",
    "feature_culinary_pro_offering",
    "feature_nebule_barmier_bibliomania",
    "feature_unlivable_morbific_traveling",
    "feature_peaty_vulgar_branchia",
    "feature_peculiar_sheenier_quintal",
    "feature_apostate_impercipient_knighthood",
    "feature_collective_stigmatic_handfasting",
    "feature_scenographical_dissentient_trek",
    "feature_unaimed_yonder_filmland",
    "feature_recidivism_petitory_methyltestosterone",
    "feature_unperfect_implemental_cellarage",
    "feature_incommensurable_diffused_curability",
    "feature_bloodied_twinkling_andante",
    "feature_more_hindoo_diageotropism",
    "feature_uncomplimentary_malignant_scoff",
    "feature_sorted_ignitable_sagitta",
    "feature_planar_unessential_bride",
    "feature_reminiscent_unpained_ukulele",
    "feature_whistleable_unbedimmed_chokey",
    "feature_reclaimed_fallibilist_turpentine",
    "feature_tittering_virgilian_decliner",
    "feature_travelled_semipermeable_perruquier",
    "feature_clerkish_flowing_chapati",
    "feature_oversea_permed_insulter",
    "feature_congenital_conched_perithecium",
    "feature_untouchable_unsolvable_agouti",
    "feature_grazed_blameful_desiderative",
    "feature_coordinated_undecipherable_gag",
    "feature_tranquilizing_abashed_glyceria",
    "feature_irresponsive_compositive_ramson",
    "feature_attuned_southward_heckle",
    "feature_supergene_legible_antarthritic",
    "feature_descendent_decanal_hon",
    "feature_encompassing_skeptical_salience",
    "feature_mazy_superrefined_punishment",
    "feature_whitened_remanent_blast",
    "feature_intercalative_helvetian_infirmarian",
    "feature_axillary_reluctant_shorty",
    "feature_liege_unexercised_ennoblement",
    "feature_caespitose_unverifiable_intent",
    "feature_hypothetic_distressing_endemic",
    "feature_calculating_unenchanted_microscopium",
    "feature_zymotic_varnished_mulga",
    "feature_headhunting_unsatisfied_phenomena",
    "feature_voltairean_consolidative_parallel",
    "feature_obeisant_vicarial_passibility",
    "feature_myographic_gawkier_timbale",
    "feature_diverticular_punjabi_matronship",
    "feature_impractical_endorsed_tide",
    "feature_pansophic_merino_pintado",
    "feature_quadratic_untouched_liberty",
    "feature_leaky_maroon_pyrometry",
    "feature_degenerate_officinal_feasibility",
    "feature_continuate_unprocurable_haversine",
    "feature_naval_edified_decarbonize",
    "feature_tonal_graptolitic_corsac",
    "feature_unbreakable_nosological_comedian",
    "feature_iconomatic_boozier_age",
    "feature_unsparred_scarabaeid_anthologist",
    "feature_unextinct_smectic_isa",
    "feature_hotfoot_behaviorist_terylene",
    "feature_crablike_panniered_gloating",
    "feature_untrimmed_monaxial_accompanist",
    "feature_unrequired_waxing_skeptic",
    "feature_buxom_curtained_sienna",
    "feature_uncertified_myrmecological_nagger",
    "feature_chopfallen_fasciate_orchidologist",
    "feature_publishable_apiarian_rollick",
    "feature_fumarolic_known_sharkskin",
    "feature_hawkish_domiciliary_duramen",
    "feature_agronomic_cryptal_advisor",
    "feature_lost_quirky_botel",
    "feature_unnourishing_indiscreet_occiput",
    "feature_galvanometric_sturdied_billingsgate",
    "feature_undisguised_whatever_gaul",
    "feature_generative_honorific_tughrik",
    "feature_venatic_intermetallic_darling",
    "feature_precooled_inoperable_credence",
    "feature_autodidactic_gnarlier_pericardium",
    "feature_glare_factional_assessment",
    "feature_peltate_okay_info",
    "feature_syrian_coital_counterproof",
    "feature_helpable_chanciest_fractionisation",
    "feature_ovular_powered_neckar",
    "feature_reconciling_dauby_database",
    "feature_roiling_trimeric_kurosawa",
    "feature_gossamer_placable_wycliffite",
    "feature_exacerbating_presentationism_apagoge",
    "feature_glyptic_unrubbed_holloway",
    "feature_centric_shaggier_cranko",
    "feature_atlantic_uveal_incommunicability",
    "feature_ruthenian_uncluttered_vocalizing",
    "feature_camphorated_spry_freemartin",
    "feature_built_reincarnate_sherbet",
    "feature_chelonian_pyknic_delphi",
    "feature_demure_groutiest_housedog",
    "feature_loyal_fishy_pith",
    "feature_accessorial_aroused_crochet",
    "feature_communicatory_unrecommended_velure",
    "feature_antipathetical_terrorful_ife",
    "feature_consecrate_legislative_cavitation",
    "feature_retinoscopy_flinty_wool",
    "feature_undetermined_idle_aftergrowth",
    "feature_uretic_seral_decoding",
    "feature_trim_axial_suffocation",
    "feature_questionable_diplex_caesarist",
    "feature_hypogastric_effectual_sunlight",
    "feature_severe_tricky_pinochle",
    "feature_methylated_necrophilic_serendipity",
    "feature_unmoved_alt_spoonerism",
    "feature_unsparing_moralistic_commissary",
    "feature_loricate_cryptocrystalline_ethnology",
    "feature_intended_involute_highbinder",
    "feature_intertwined_leeriest_suffragette",
    "feature_merovingian_tenebrism_hartshorn",
    "feature_rimmed_conditional_archipelago",
    "feature_irritant_euphuistic_weka",
    "feature_armoured_finable_skywriter",
    "feature_subglobular_unsalable_patzer",
    "feature_caecilian_unexperienced_ova",
    "feature_substandard_permissible_paresthesia",
    "feature_scenic_cormophytic_bilirubin",
    "feature_univalve_abdicant_distrail",
    "feature_vizierial_courtlier_hampton",
    "feature_acerb_venusian_piety",
    "feature_periscopic_thirteenth_cartage",
    "feature_resuscitative_communicable_brede",
    "feature_dispiriting_araeostyle_jersey",
    "feature_roasting_slaked_reposition",
    "feature_frequentative_participial_waft",
    "feature_euterpean_frazzled_williamsburg",
    "feature_kerygmatic_splashed_ziegfeld",
    "feature_nubblier_plosive_deepening",
    "feature_springlike_crackjaw_bheesty",
    "feature_hemispherical_unabsolved_aeolipile",
    "feature_synoptic_botryose_earthwork",
    "feature_mucky_loanable_gastrostomy",
    "feature_sudsy_polymeric_posteriority",
    "feature_strychnic_structuralist_chital",
    "feature_patristical_analysable_langouste",
    "feature_nucleophilic_uremic_endogen",
    "feature_highland_eocene_berean",
    "feature_reserved_cleanable_soldan",
    "feature_cerebrovascular_weeny_advocate",
    "feature_invalid_chromatographic_cornishman",
    "feature_groggy_undescried_geosphere",
    "feature_unbeaten_orological_dentin",
    "feature_dipped_sent_giuseppe",
    "feature_salian_suggested_ephemeron",
    "feature_maximal_unobserving_desalinisation",
    "feature_biannual_maleficent_thack",
    "feature_eruptive_seasoned_pharmacognosy",
    "feature_malacological_differential_defeated",
    "feature_massed_nonracial_ecclesiologist",
    "feature_calefactive_anapaestic_jerome",
    "feature_tribal_germinable_yarraman",
    "feature_stereotypic_ebracteate_louise",
    "feature_hexametric_ventricose_limnology",
    "feature_interdental_mongolian_anarchism",
    "feature_agile_unrespited_gaucho",
    "feature_unknown_reusable_cabbage",
    "feature_chuffier_analectic_conchiolin",
    "feature_altern_unnoticed_impregnation",
    "feature_hydrologic_cymric_nyctophobia",
    "feature_beady_unkind_barret",
    "feature_discrepant_ventral_shicker",
    "feature_sallowish_cognisant_romaunt",
    "feature_castrated_presented_quizzer",
    "feature_bushwhacking_unaligned_imperturbability",
    "feature_covalent_unreformed_frogbit",
    "feature_revitalizing_dashing_photomultiplier",
    "feature_flakiest_fleecy_novelese",
    "feature_refreshed_untombed_skinhead",
    "feature_scorbutic_intellectualism_mongoloid",
    "feature_commensurable_industrial_jungfrau",
    "feature_expressed_abhominable_pruning",
    "feature_extractable_serrulate_swing",
    "feature_instrumentalist_extrovert_cassini",
    "feature_alkaline_pistachio_sunstone",
    "feature_plexiform_won_elk",
    "feature_caressive_cognate_cubature",
    "feature_voltairean_dyslogistic_epagoge",
    "feature_leggiest_slaggiest_inez",
    "feature_whopping_eminent_attempter",
    "feature_sixteen_inbreed_are",
    "feature_designer_notchy_epiploon",
    "feature_croupiest_shaded_thermotropism",
    "feature_amygdaloidal_intersectional_canonry",
    "feature_busty_unfitted_keratotomy",
    "feature_log_unregenerate_babel",
    "feature_farcical_spinal_samantha",
    "feature_unburied_exponent_pace",
    "feature_dentilingual_removed_osmometer",
    "feature_arillate_nickelic_hemorrhage",
    "feature_restricted_aggregately_workmanship",
    "feature_ganoid_osiered_mineralogy",
    "feature_introvert_symphysial_assegai",
    "feature_sludgy_implemental_sicily",
    "feature_criticisable_authentical_deprecation",
    "feature_inhabited_pettier_veinlet",
    "feature_confiscatory_triennial_pelting",
    "feature_leisurable_dehortatory_pretoria",
    "feature_favoring_prescript_unorthodoxy",
    "feature_curling_aurorean_iseult",
    "feature_hibernating_soritic_croupe",
    "feature_spookiest_expedite_overnighter",
    "feature_foamy_undrilled_glaciology",
    "feature_uncurtailed_translucid_coccid",
    "feature_limitable_astable_physiology",
    "feature_assenting_darn_arthropod",
    "feature_terrific_epigamic_affectivity",
    "feature_inflexed_lamaism_crit",
    "feature_indentured_communicant_tulipomania",
    "feature_uncharged_unovercome_smolder",
    "feature_decent_solo_stickup",
    "feature_polaroid_squalliest_applause",
    "feature_interrogatory_isohyetal_atacamite",
    "feature_covalent_methodological_brash",
    "feature_undrossy_serpentiform_sack",
    "feature_faltering_tergal_tip",
    "feature_undirected_perdu_ylem",
    "feature_vulcanological_sepulchral_spean",
]

FEATURE_NAMES_SMALL = [
    "feature_unwonted_trusted_fixative",
    "feature_introvert_symphysial_assegai",
    "feature_jerkwater_eustatic_electrocardiograph",
    "feature_canalicular_peeling_lilienthal",
    "feature_unvaried_social_bangkok",
    "feature_crowning_frustrate_kampala",
    "feature_store_apteral_isocheim",
    "feature_haziest_lifelike_horseback",
    "feature_grandmotherly_circumnavigable_homonymity",
    "feature_assenting_darn_arthropod",
    "feature_beery_somatologic_elimination",
    "feature_cambial_bigoted_bacterioid",
    "feature_unaired_operose_lactoprotein",
    "feature_moralistic_heartier_typhoid",
    "feature_twisty_adequate_minutia",
    "feature_unsealed_suffixal_babar",
    "feature_planned_superimposed_bend",
    "feature_winsome_irreproachable_milkfish",
    "feature_flintier_enslaved_borsch",
    "feature_agile_unrespited_gaucho",
    "feature_glare_factional_assessment",
    "feature_slack_calefacient_tableau",
    "feature_undivorced_unsatisfying_praetorium",
    "feature_silver_handworked_scauper",
    "feature_communicatory_unrecommended_velure",
    "feature_stylistic_honduran_comprador",
    "feature_travelled_semipermeable_perruquier",
    "feature_bhutan_imagism_dolerite",
    "feature_lofty_acceptable_challenge",
    "feature_antichristian_slangiest_idyllist",
    "feature_apomictical_motorized_vaporisation",
    "feature_buxom_curtained_sienna",
    "feature_gullable_sanguine_incongruity",
    "feature_unforbidden_highbrow_kafir",
    "feature_chuffier_analectic_conchiolin",
    "feature_branched_dilatory_sunbelt",
    "feature_univalve_abdicant_distrail",
    "feature_exorbitant_myeloid_crinkle",
]

FEATURE_NAMES_MEDIUM = [
    "feature_dichasial_hammier_spawner",
    "feature_rheumy_epistemic_prancer",
    "feature_pert_performative_hormuz",
    "feature_hillier_unpitied_theobromine",
    "feature_perigean_bewitching_thruster",
    "feature_renegade_undomestic_milord",
    "feature_koranic_rude_corf",
    "feature_demisable_expiring_millepede",
    "feature_unscheduled_malignant_shingling",
    "feature_clawed_unwept_adaptability",
    "feature_rubblier_chlorotic_stogy",
    "feature_untumbled_histologic_inion",
    "feature_piffling_inflamed_jupiter",
    "feature_abstersive_emotional_misinterpreter",
    "feature_unluckiest_mulley_benzyl",
    "feature_escutcheoned_timocratic_kotwal",
    "feature_integrated_extroversive_ambivalence",
    "feature_vedic_mitral_swiz",
    "feature_reclaimed_fallibilist_turpentine",
    "feature_gone_honduran_worshipper",
    "feature_insociable_exultant_tatum",
    "feature_outdated_tapered_speciation",
    "feature_leggiest_slaggiest_inez",
    "feature_chaldean_vixenly_propylite",
    "feature_hysteric_mechanized_recklinghausen",
    "feature_glare_factional_assessment",
    "feature_highland_eocene_berean",
    "feature_seemlier_reorient_monandry",
    "feature_expressed_abhominable_pruning",
    "feature_castrated_presented_quizzer",
    "feature_restricted_aggregately_workmanship",
    "feature_scorbutic_intellectualism_mongoloid",
    "feature_telephonic_shakable_bollock",
    "feature_subglobular_unsalable_patzer",
    "feature_syrian_coital_counterproof",
    "feature_supergene_legible_antarthritic",
    "feature_hypothetic_distressing_endemic",
    "feature_torturesome_estimable_preferrer",
    "feature_greedier_favorable_enthymeme",
    "feature_decent_solo_stickup",
    "feature_unmalleable_resistant_kingston",
    "feature_seamier_jansenism_inflator",
    "feature_lordly_lamellicorn_buxtehude",
    "feature_mattery_past_moro",
    "feature_helpable_chanciest_fractionisation",
    "feature_spookiest_expedite_overnighter",
    "feature_culinary_pro_offering",
    "feature_ganoid_osiered_mineralogy",
    "feature_hotfoot_behaviorist_terylene",
    "feature_severe_tricky_pinochle",
    "feature_maximal_unobserving_desalinisation",
    "feature_voltairean_consolidative_parallel",
    "feature_unmoved_alt_spoonerism",
    "feature_tittering_virgilian_decliner",
    "feature_methylated_necrophilic_serendipity",
    "feature_calceolate_pudgy_armure",
    "feature_unsparing_moralistic_commissary",
    "feature_criticisable_authentical_deprecation",
    "feature_undetermined_idle_aftergrowth",
    "feature_antipathetical_terrorful_ife",
    "feature_caressive_cognate_cubature",
    "feature_crablike_panniered_gloating",
    "feature_exacerbating_presentationism_apagoge",
    "feature_epicurean_fetal_seising",
    "feature_casuistic_barbarian_monochromy",
    "feature_haematoid_runaway_nightjar",
    "feature_croupiest_shaded_thermotropism",
    "feature_zarathustrian_albigensian_itch",
    "feature_unsparred_scarabaeid_anthologist",
    "feature_unco_terefah_thirster",
    "feature_sallowish_cognisant_romaunt",
    "feature_grazed_blameful_desiderative",
    "feature_whitened_remanent_blast",
    "feature_introvert_symphysial_assegai",
    "feature_casemated_ibsenian_grantee",
    "feature_intertwined_leeriest_suffragette",
    "feature_built_reincarnate_sherbet",
    "feature_axillary_reluctant_shorty",
    "feature_descendent_decanal_hon",
    "feature_untrimmed_monaxial_accompanist",
    "feature_desiderative_commiserative_epizoa",
    "feature_subdued_spiffier_kano",
    "feature_affricative_bromic_raftsman",
    "feature_doggish_whacking_headscarf",
    "feature_congenital_conched_perithecium",
    "feature_terrific_epigamic_affectivity",
    "feature_enlightening_mirthful_laurencin",
    "feature_continuate_unprocurable_haversine",
    "feature_fustiest_voiced_janet",
    "feature_ovular_powered_neckar",
    "feature_questionable_diplex_caesarist",
    "feature_nubblier_plosive_deepening",
    "feature_revitalizing_dashing_photomultiplier",
    "feature_chafed_undenominational_backstitch",
    "feature_assenting_darn_arthropod",
    "feature_consecrate_legislative_cavitation",
    "feature_inhabited_pettier_veinlet",
    "feature_voltairean_dyslogistic_epagoge",
    "feature_log_unregenerate_babel",
    "feature_agile_unrespited_gaucho",
    "feature_whopping_eminent_attempter",
    "feature_travelled_semipermeable_perruquier",
    "feature_horizontal_snug_description",
    "feature_inhibited_snowiest_drawing",
    "feature_salian_suggested_ephemeron",
    "feature_diverticular_punjabi_matronship",
    "feature_reminiscent_unpained_ukulele",
    "feature_unsurveyed_chopped_feldspathoid",
    "feature_degenerate_officinal_feasibility",
    "feature_undrossy_serpentiform_sack",
    "feature_festering_controvertible_hostler",
    "feature_leukemic_paler_millikan",
    "feature_subapostolic_dungy_fermion",
    "feature_wale_planned_tolstoy",
    "feature_bifacial_hexastyle_hemialgia",
    "feature_revealable_aeonian_elvira",
    "feature_perceivable_gasiform_psammite",
    "feature_smugger_hydroponic_farnesol",
    "feature_apostate_impercipient_knighthood",
    "feature_unperfect_implemental_cellarage",
    "feature_stereotypic_ebracteate_louise",
    "feature_offshore_defamatory_catalog",
    "feature_tribal_germinable_yarraman",
    "feature_dispiriting_araeostyle_jersey",
    "feature_clerkish_flowing_chapati",
    "feature_venatic_intermetallic_darling",
    "feature_nebule_barmier_bibliomania",
    "feature_unknown_reusable_cabbage",
    "feature_planar_unessential_bride",
    "feature_irritant_euphuistic_weka",
    "feature_whistleable_unbedimmed_chokey",
    "feature_roiling_trimeric_kurosawa",
    "feature_loyal_fishy_pith",
    "feature_unlivable_morbific_traveling",
    "feature_untellable_penal_allegorization",
    "feature_coordinated_undecipherable_gag",
    "feature_congealed_lee_steek",
    "feature_intrusive_effluent_hokkaido",
    "feature_epidermic_scruffiest_prosperity",
    "feature_quadratic_untouched_liberty",
    "feature_hypogastric_effectual_sunlight",
    "feature_contused_festal_geochemistry",
    "feature_hexametric_ventricose_limnology",
    "feature_paramagnetic_complex_gish",
    "feature_chuffier_analectic_conchiolin",
    "feature_indefatigable_enterprising_calf",
    "feature_untouchable_unsolvable_agouti",
    "feature_reduplicate_conoid_albite",
    "feature_sixteen_inbreed_are",
    "feature_dovetailed_winy_hanaper",
    "feature_bushwhacking_unaligned_imperturbability",
    "feature_undescribed_methylic_friday",
    "feature_inflexed_lamaism_crit",
    "feature_calefactive_anapaestic_jerome",
    "feature_agronomic_cryptal_advisor",
    "feature_unbreakable_nosological_comedian",
    "feature_unmodernized_vasodilator_galenist",
    "feature_paraffinoid_irreplevisable_ombu",
    "feature_invalid_extortionary_titillation",
    "feature_fake_trident_agitator",
    "feature_wieldable_defiled_aperitive",
    "feature_contaminative_intrusive_tagrag",
    "feature_himyarite_tetragonal_deceit",
    "feature_tossing_denominative_threshing",
    "feature_dendritic_prothallium_sweeper",
    "feature_ruffianly_uncommercial_anatole",
    "feature_hellenistic_scraggly_comfort",
    "feature_squishiest_unsectarian_support",
    "feature_myographic_gawkier_timbale",
    "feature_faltering_tergal_tip",
    "feature_antisubmarine_foregoing_cryosurgery",
    "feature_altern_unnoticed_impregnation",
    "feature_foamy_undrilled_glaciology",
    "feature_appraisive_anagrammatical_tentacle",
    "feature_emmetropic_heraclitean_conducting",
    "feature_collective_stigmatic_handfasting",
    "feature_iridic_unpropertied_spline",
    "feature_farcical_spinal_samantha",
    "feature_urochordal_swallowed_curn",
    "feature_wombed_reverberatory_colourer",
    "feature_merovingian_tenebrism_hartshorn",
    "feature_stylistic_honduran_comprador",
    "feature_caecilian_unexperienced_ova",
    "feature_fumarolic_known_sharkskin",
    "feature_belgravian_salopian_sheugh",
    "feature_zymotic_varnished_mulga",
    "feature_learned_claustral_quiddity",
    "feature_brickier_heterostyled_scrutiny",
    "feature_unnetted_bay_premillennialist",
    "feature_uncurtailed_translucid_coccid",
    "feature_jiggish_tritheist_probity",
    "feature_groggy_undescried_geosphere",
    "feature_hawkish_domiciliary_duramen",
    "feature_base_ingrain_calligrapher",
    "feature_accessorial_aroused_crochet",
    "feature_fierier_goofier_follicle",
    "feature_unburied_exponent_pace",
    "feature_chelonian_pyknic_delphi",
    "feature_tarry_meet_chapel",
    "feature_generative_honorific_tughrik",
    "feature_smoggy_niftiest_lunch",
    "feature_coalier_typhoid_muntin",
    "feature_chopfallen_fasciate_orchidologist",
    "feature_euterpean_frazzled_williamsburg",
    "feature_quinsied_increased_braincase",
    "feature_unlawful_superintendent_brunet",
    "feature_naval_edified_decarbonize",
    "feature_scenic_cormophytic_bilirubin",
    "feature_unvaried_social_bangkok",
    "feature_fissirostral_multifoliate_chillon",
    "feature_gutta_exploitive_simpson",
    "feature_assertive_worsened_scarper",
    "feature_intersubjective_juristic_sagebrush",
    "feature_rowable_unshod_noise",
    "feature_volitional_ascensive_selfhood",
    "feature_barest_kempt_crowd",
    "feature_curtained_gushier_tranquilizer",
    "feature_intermontane_vertical_moo",
    "feature_isotopic_hymenial_starwort",
    "feature_inseminated_filarial_mesoderm",
    "feature_passerine_ultraist_neon",
    "feature_westering_immunosuppressive_crapaud",
    "feature_reported_slimy_rhapsody",
    "feature_juvenalian_paunchy_uniformitarianism",
    "feature_lipogrammatic_blowsier_seismometry",
    "feature_draconic_contractible_romper",
    "feature_indirect_concrete_canaille",
    "feature_puberulent_nondescript_laparoscope",
    "feature_unsurveyed_boyish_aleph",
    "feature_dismaying_chaldean_tallith",
    "feature_epitaxial_loathsome_essen",
    "feature_malagasy_abounding_circumciser",
    "feature_tortured_arsenical_arable",
    "feature_sludgy_implemental_sicily",
    "feature_uretic_seral_decoding",
    "feature_roasting_slaked_reposition",
    "feature_peculiar_sheenier_quintal",
    "feature_publishable_apiarian_rollick",
    "feature_interdental_mongolian_anarchism",
    "feature_reserved_cleanable_soldan",
    "feature_eruptive_seasoned_pharmacognosy",
    "feature_softish_unseparated_caudex",
    "feature_univalve_abdicant_distrail",
    "feature_levigate_kindly_dyspareunia",
    "feature_intercalative_helvetian_infirmarian",
    "feature_centric_shaggier_cranko",
    "feature_unliving_bit_bengaline",
    "feature_misanthropic_knurliest_freebooty",
    "feature_confiscatory_triennial_pelting",
    "feature_peltate_okay_info",
    "feature_reconciling_dauby_database",
    "feature_unspotted_practiced_gland",
    "feature_iconomatic_boozier_age",
    "feature_congenial_transmigrant_isobel",
    "feature_impractical_endorsed_tide",
    "feature_huskiest_compartmental_jacquerie",
    "feature_cairned_fumiest_ordaining",
    "feature_calculating_unenchanted_microscopium",
    "feature_mucky_loanable_gastrostomy",
    "feature_loricate_cryptocrystalline_ethnology",
    "feature_ctenoid_moaning_fontainebleau",
    "feature_armoured_finable_skywriter",
    "feature_intended_involute_highbinder",
    "feature_commensurable_industrial_jungfrau",
    "feature_spagyric_echt_alum",
    "feature_illiterate_stomachal_terpene",
    "feature_demure_groutiest_housedog",
    "feature_dentilingual_removed_osmometer",
    "feature_plexiform_won_elk",
    "feature_induplicate_hoarse_disbursement",
    "feature_vizierial_courtlier_hampton",
    "feature_lost_quirky_botel",
    "feature_hydrologic_cymric_nyctophobia",
    "feature_atlantic_uveal_incommunicability",
    "feature_incommensurable_diffused_curability",
    "feature_midget_noncognizable_plenary",
    "feature_unapplicable_jerkiest_klemperer",
    "feature_unamazed_tumular_photomicrograph",
    "feature_nucleophilic_uremic_endogen",
    "feature_unnourishing_indiscreet_occiput",
    "feature_hypersonic_volcanological_footwear",
    "feature_uncomplimentary_malignant_scoff",
    "feature_interrogatory_isohyetal_atacamite",
    "feature_invalid_chromatographic_cornishman",
    "feature_encompassing_skeptical_salience",
    "feature_beady_unkind_barret",
    "feature_gossamer_placable_wycliffite",
    "feature_flavourful_seismic_erica",
    "feature_petitionary_evanescent_diallage",
    "feature_leisurable_dehortatory_pretoria",
    "feature_chaotic_granitoid_theist",
    "feature_cerebrovascular_weeny_advocate",
    "feature_cyrenaic_unschooled_silurian",
    "feature_uninclosed_handcrafted_springing",
    "feature_indentured_communicant_tulipomania",
    "feature_synoptic_botryose_earthwork",
    "feature_acerb_venusian_piety",
    "feature_vestmental_hoofed_transpose",
    "feature_unrated_intact_balmoral",
    "feature_tonal_graptolitic_corsac",
    "feature_refreshed_untombed_skinhead",
    "feature_communicatory_unrecommended_velure",
    "feature_sudsy_polymeric_posteriority",
    "feature_inexpugnable_gleg_candelilla",
    "feature_headhunting_unsatisfied_phenomena",
    "feature_scenographical_dissentient_trek",
    "feature_trim_axial_suffocation",
    "feature_buxom_curtained_sienna",
    "feature_recidivism_petitory_methyltestosterone",
    "feature_irresponsive_compositive_ramson",
    "feature_more_hindoo_diageotropism",
    "feature_apomictical_motorized_vaporisation",
    "feature_seclusive_emendatory_plangency",
    "feature_discrepant_ventral_shicker",
    "feature_obeisant_vicarial_passibility",
    "feature_unrelieved_rawish_cement",
    "feature_strychnic_structuralist_chital",
    "feature_unaimed_yonder_filmland",
    "feature_designer_notchy_epiploon",
    "feature_favoring_prescript_unorthodoxy",
    "feature_cheering_protonemal_herd",
    "feature_conjugal_postvocalic_rowe",
    "feature_palmy_superfluid_argyrodite",
    "feature_outsized_admonishing_errantry",
    "feature_brawny_confocal_frail",
    "feature_arillate_nickelic_hemorrhage",
    "feature_bloodied_twinkling_andante",
    "feature_rusted_unassisting_menaquinone",
    "feature_biannual_maleficent_thack",
    "feature_extractable_serrulate_swing",
    "feature_covalent_methodological_brash",
    "feature_periscopic_thirteenth_cartage",
    "feature_tranquilizing_abashed_glyceria",
    "feature_faustian_unventilated_lackluster",
    "feature_frequentative_participial_waft",
    "feature_flakiest_fleecy_novelese",
    "feature_liege_unexercised_ennoblement",
    "feature_amygdaloidal_intersectional_canonry",
    "feature_rural_inquisitional_trotline",
    "feature_caespitose_unverifiable_intent",
    "feature_precooled_inoperable_credence",
    "feature_ruthenian_uncluttered_vocalizing",
    "feature_camphorated_spry_freemartin",
    "feature_mined_game_curse",
    "feature_amoebaean_wolfish_heeler",
    "feature_peaty_vulgar_branchia",
    "feature_ratlike_matrilinear_collapsability",
    "feature_attuned_southward_heckle",
    "feature_substandard_permissible_paresthesia",
    "feature_curling_aurorean_iseult",
    "feature_fleshly_bedimmed_enfacement",
    "feature_hendecagonal_deathly_stiver",
    "feature_massed_nonracial_ecclesiologist",
    "feature_instrumentalist_extrovert_cassini",
    "feature_patristical_analysable_langouste",
    "feature_gullable_sanguine_incongruity",
    "feature_phellogenetic_vibrational_jocelyn",
    "feature_autodidactic_gnarlier_pericardium",
    "feature_unbeaten_orological_dentin",
    "feature_resuscitative_communicable_brede",
    "feature_limitable_astable_physiology",
    "feature_chartered_conceptual_spitting",
    "feature_oversea_permed_insulter",
    "feature_busty_unfitted_keratotomy",
    "feature_alkaline_pistachio_sunstone",
    "feature_incitant_trochoidal_oculist",
    "feature_stelar_balmiest_pellitory",
    "feature_hypermetropic_unsighted_forsyth",
    "feature_calycled_living_birmingham",
    "feature_transmontane_clerkly_value",
    "feature_together_suppositive_aster",
    "feature_planned_superimposed_bend",
    "feature_undirected_perdu_ylem",
    "feature_antipodal_unable_thievery",
    "feature_scrobiculate_unexcitable_alder",
    "feature_apophthegmatical_catechetical_millet",
    "feature_fragrant_fifteen_brian",
    "feature_churrigueresque_talc_archaicism",
    "feature_uncompromising_fancy_kyle",
    "feature_retinoscopy_flinty_wool",
    "feature_pansophic_merino_pintado",
    "feature_galvanometric_sturdied_billingsgate",
    "feature_mazy_superrefined_punishment",
    "feature_aztecan_encomiastic_pitcherful",
    "feature_sorted_ignitable_sagitta",
    "feature_padded_peripteral_pericranium",
    "feature_trabeate_eutherian_valedictory",
    "feature_undisguised_whatever_gaul",
    "feature_migrant_reliable_chirurgery",
    "feature_permanent_cottony_ballpen",
    "feature_conceding_ingrate_tablespoonful",
    "feature_vulcanological_sepulchral_spean",
    "feature_unrequired_waxing_skeptic",
    "feature_hibernating_soritic_croupe",
    "feature_unstacked_trackable_blizzard",
    "feature_multilinear_sharpened_mouse",
    "feature_autarkic_constabulary_dukedom",
    "feature_christadelphian_euclidean_boon",
    "feature_covalent_unreformed_frogbit",
    "feature_basaltic_arid_scallion",
    "feature_uncharged_unovercome_smolder",
    "feature_leaky_maroon_pyrometry",
    "feature_polaroid_squalliest_applause",
    "feature_jerkwater_eustatic_electrocardiograph",
    "feature_malacological_differential_defeated",
    "feature_ambisexual_boiled_blunderer",
    "feature_endangered_unthreaded_firebrick",
    "feature_unextinct_smectic_isa",
    "feature_kerygmatic_splashed_ziegfeld",
    "feature_palatalized_unsucceeded_induration",
    "feature_springlike_crackjaw_bheesty",
    "feature_unweary_congolese_captain",
    "feature_uncertified_myrmecological_nagger",
    "feature_hemispherical_unabsolved_aeolipile",
    "feature_glyptic_unrubbed_holloway",
    "feature_rimmed_conditional_archipelago",
    "feature_bleeding_arabesque_pneuma",
    "feature_dipped_sent_giuseppe",
    "feature_undivorced_unsatisfying_praetorium",
    "feature_reclinate_cruciform_lilo",
]

COLUMN_NAMES_LEGACY = FEATURE_NAMES_LEGACY + TARGET_NAMES
COLUMN_NAMES_SMALL = FEATURE_NAMES_SMALL + TARGET_NAMES
COLUMN_NAMES_MEDIUM = FEATURE_NAMES_MEDIUM + TARGET_NAMES
