# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from arthur_client.api_bindings.models.infinite_resource_list_job import InfiniteResourceListJob
from arthur_client.api_bindings.models.job import Job
from arthur_client.api_bindings.models.job_dequeue_parameters import JobDequeueParameters
from arthur_client.api_bindings.models.job_errors import JobErrors
from arthur_client.api_bindings.models.job_kind import JobKind
from arthur_client.api_bindings.models.job_logs import JobLogs
from arthur_client.api_bindings.models.job_run import JobRun
from arthur_client.api_bindings.models.job_state import JobState
from arthur_client.api_bindings.models.job_trigger import JobTrigger
from arthur_client.api_bindings.models.jobs_batch import JobsBatch
from arthur_client.api_bindings.models.jobs_sort import JobsSort
from arthur_client.api_bindings.models.patch_job import PatchJob
from arthur_client.api_bindings.models.post_job_batch import PostJobBatch
from arthur_client.api_bindings.models.put_job_state import PutJobState
from arthur_client.api_bindings.models.resource_list_job_error import ResourceListJobError
from arthur_client.api_bindings.models.resource_list_job_log import ResourceListJobLog
from arthur_client.api_bindings.models.resource_list_job_run import ResourceListJobRun
from arthur_client.api_bindings.models.sort_order import SortOrder

from arthur_client.api_bindings.api_client import ApiClient, RequestSerialized
from arthur_client.api_bindings.api_response import ApiResponse
from arthur_client.api_bindings.rest import RESTResponseType


class JobsV1Api:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_job(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Get Job By Id

        Returns a single job by ID. Requires project_job_read permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_job_with_http_info(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Get Job By Id

        Returns a single job by ID. Requires project_job_read permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_job_without_preload_content(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Job By Id

        Returns a single job by ID. Requires project_job_read permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_job_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/jobs/{job_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_job_errors(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResourceListJobError:
        """Get Job Errors

        Get job errors. Requires project_job_read_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobError",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_job_errors_with_http_info(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResourceListJobError]:
        """Get Job Errors

        Get job errors. Requires project_job_read_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobError",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_job_errors_without_preload_content(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Job Errors

        Get job errors. Requires project_job_read_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobError",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_job_errors_serialize(
        self,
        job_id,
        job_run_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        if job_run_id is not None:
            _path_params['job_run_id'] = job_run_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/jobs/{job_id}/runs/{job_run_id}/errors',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_job_logs(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResourceListJobLog:
        """Get Job Logs

        Get job logs for a run. Requires project_job_read_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobLog",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_job_logs_with_http_info(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResourceListJobLog]:
        """Get Job Logs

        Get job logs for a run. Requires project_job_read_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobLog",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_job_logs_without_preload_content(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Job Logs

        Get job logs for a run. Requires project_job_read_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobLog",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_job_logs_serialize(
        self,
        job_id,
        job_run_id,
        order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        if job_run_id is not None:
            _path_params['job_run_id'] = job_run_id
        # process the query parameters
        if order is not None:
            
            _query_params.append(('order', order.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/jobs/{job_id}/runs/{job_run_id}/logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_job_runs(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResourceListJobRun:
        """Get Job Runs

        Get Job runs. Required project_job_read_runs permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_runs_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobRun",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_job_runs_with_http_info(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResourceListJobRun]:
        """Get Job Runs

        Get Job runs. Required project_job_read_runs permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_runs_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobRun",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_job_runs_without_preload_content(
        self,
        job_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Job Runs

        Get Job runs. Required project_job_read_runs permission.

        :param job_id: (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_job_runs_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceListJobRun",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_job_runs_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/jobs/{job_id}/runs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_jobs(
        self,
        project_id: StrictStr,
        sort: Annotated[Optional[JobsSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        duration_sec_greater_than: Annotated[Optional[StrictInt], Field(description="Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.")] = None,
        duration_sec_less_than: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.")] = None,
        started_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started before this timestamp. Optional.")] = None,
        started_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started after this timestamp. Optional.")] = None,
        queued_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued before this timestamp. Optional.")] = None,
        queued_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued after this timestamp. Optional.")] = None,
        ready_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready before this timestamp. Optional.")] = None,
        ready_before_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.")] = None,
        ready_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready after this timestamp. Optional.")] = None,
        ready_after_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.")] = None,
        finished_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished before this timestamp. Optional.")] = None,
        finished_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished after this timestamp. Optional.")] = None,
        kinds: Annotated[Optional[List[JobKind]], Field(description="Filter the results for the jobs of this kind. Optional.")] = None,
        exclude_kinds: Annotated[Optional[List[JobKind]], Field(description="Exclude jobs of these kinds. Takes precedence over kinds.")] = None,
        states: Annotated[Optional[List[JobState]], Field(description="Filter the results for jobs in these states. Optional.")] = None,
        error_count_above: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that had greater than or equal to this many errors. Optional.")] = None,
        data_plane_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that were ran on this dataplane. Optional.")] = None,
        schedule_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this schedule ID. Optional.")] = None,
        trigger_type: Annotated[Optional[JobTrigger], Field(description="Filter the results for the jobs that were started by this trigger type. Optional.")] = None,
        triggered_by_user_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.")] = None,
        triggered_by_user_email: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.")] = None,
        model_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.")] = None,
        nonce: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs that match a job nonce used to ensure exactly once execution.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InfiniteResourceListJob:
        """List Jobs

        Returns jobs in the project matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires project_list_jobs permission. Note: exclude_kinds takes precedence over kinds and will exclude jobs even if they are in kinds.

        :param project_id: (required)
        :type project_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: JobsSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param duration_sec_greater_than: Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.
        :type duration_sec_greater_than: int
        :param duration_sec_less_than: Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.
        :type duration_sec_less_than: int
        :param started_before: Filter the results for the jobs that started before this timestamp. Optional.
        :type started_before: datetime
        :param started_after: Filter the results for the jobs that started after this timestamp. Optional.
        :type started_after: datetime
        :param queued_before: Filter the results for the jobs that were queued before this timestamp. Optional.
        :type queued_before: datetime
        :param queued_after: Filter the results for the jobs that were queued after this timestamp. Optional.
        :type queued_after: datetime
        :param ready_before: Filter the results for the jobs that are ready before this timestamp. Optional.
        :type ready_before: datetime
        :param ready_before_current_time: When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.
        :type ready_before_current_time: bool
        :param ready_after: Filter the results for the jobs that are ready after this timestamp. Optional.
        :type ready_after: datetime
        :param ready_after_current_time: When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.
        :type ready_after_current_time: bool
        :param finished_before: Filter the results for the jobs that finished before this timestamp. Optional.
        :type finished_before: datetime
        :param finished_after: Filter the results for the jobs that finished after this timestamp. Optional.
        :type finished_after: datetime
        :param kinds: Filter the results for the jobs of this kind. Optional.
        :type kinds: List[JobKind]
        :param exclude_kinds: Exclude jobs of these kinds. Takes precedence over kinds.
        :type exclude_kinds: List[JobKind]
        :param states: Filter the results for jobs in these states. Optional.
        :type states: List[JobState]
        :param error_count_above: Filter the results for the jobs that had greater than or equal to this many errors. Optional.
        :type error_count_above: int
        :param data_plane_id: Filter the results for the jobs that were ran on this dataplane. Optional.
        :type data_plane_id: str
        :param schedule_id: Filter the results for jobs associated with this schedule ID. Optional.
        :type schedule_id: str
        :param trigger_type: Filter the results for the jobs that were started by this trigger type. Optional.
        :type trigger_type: JobTrigger
        :param triggered_by_user_id: Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_id: str
        :param triggered_by_user_email: Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_email: str
        :param model_id: Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.
        :type model_id: str
        :param nonce: Filter the results for jobs that match a job nonce used to ensure exactly once execution.
        :type nonce: str
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_jobs_serialize(
            project_id=project_id,
            sort=sort,
            order=order,
            duration_sec_greater_than=duration_sec_greater_than,
            duration_sec_less_than=duration_sec_less_than,
            started_before=started_before,
            started_after=started_after,
            queued_before=queued_before,
            queued_after=queued_after,
            ready_before=ready_before,
            ready_before_current_time=ready_before_current_time,
            ready_after=ready_after,
            ready_after_current_time=ready_after_current_time,
            finished_before=finished_before,
            finished_after=finished_after,
            kinds=kinds,
            exclude_kinds=exclude_kinds,
            states=states,
            error_count_above=error_count_above,
            data_plane_id=data_plane_id,
            schedule_id=schedule_id,
            trigger_type=trigger_type,
            triggered_by_user_id=triggered_by_user_id,
            triggered_by_user_email=triggered_by_user_email,
            model_id=model_id,
            nonce=nonce,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListJob",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_jobs_with_http_info(
        self,
        project_id: StrictStr,
        sort: Annotated[Optional[JobsSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        duration_sec_greater_than: Annotated[Optional[StrictInt], Field(description="Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.")] = None,
        duration_sec_less_than: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.")] = None,
        started_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started before this timestamp. Optional.")] = None,
        started_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started after this timestamp. Optional.")] = None,
        queued_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued before this timestamp. Optional.")] = None,
        queued_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued after this timestamp. Optional.")] = None,
        ready_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready before this timestamp. Optional.")] = None,
        ready_before_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.")] = None,
        ready_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready after this timestamp. Optional.")] = None,
        ready_after_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.")] = None,
        finished_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished before this timestamp. Optional.")] = None,
        finished_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished after this timestamp. Optional.")] = None,
        kinds: Annotated[Optional[List[JobKind]], Field(description="Filter the results for the jobs of this kind. Optional.")] = None,
        exclude_kinds: Annotated[Optional[List[JobKind]], Field(description="Exclude jobs of these kinds. Takes precedence over kinds.")] = None,
        states: Annotated[Optional[List[JobState]], Field(description="Filter the results for jobs in these states. Optional.")] = None,
        error_count_above: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that had greater than or equal to this many errors. Optional.")] = None,
        data_plane_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that were ran on this dataplane. Optional.")] = None,
        schedule_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this schedule ID. Optional.")] = None,
        trigger_type: Annotated[Optional[JobTrigger], Field(description="Filter the results for the jobs that were started by this trigger type. Optional.")] = None,
        triggered_by_user_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.")] = None,
        triggered_by_user_email: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.")] = None,
        model_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.")] = None,
        nonce: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs that match a job nonce used to ensure exactly once execution.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InfiniteResourceListJob]:
        """List Jobs

        Returns jobs in the project matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires project_list_jobs permission. Note: exclude_kinds takes precedence over kinds and will exclude jobs even if they are in kinds.

        :param project_id: (required)
        :type project_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: JobsSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param duration_sec_greater_than: Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.
        :type duration_sec_greater_than: int
        :param duration_sec_less_than: Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.
        :type duration_sec_less_than: int
        :param started_before: Filter the results for the jobs that started before this timestamp. Optional.
        :type started_before: datetime
        :param started_after: Filter the results for the jobs that started after this timestamp. Optional.
        :type started_after: datetime
        :param queued_before: Filter the results for the jobs that were queued before this timestamp. Optional.
        :type queued_before: datetime
        :param queued_after: Filter the results for the jobs that were queued after this timestamp. Optional.
        :type queued_after: datetime
        :param ready_before: Filter the results for the jobs that are ready before this timestamp. Optional.
        :type ready_before: datetime
        :param ready_before_current_time: When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.
        :type ready_before_current_time: bool
        :param ready_after: Filter the results for the jobs that are ready after this timestamp. Optional.
        :type ready_after: datetime
        :param ready_after_current_time: When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.
        :type ready_after_current_time: bool
        :param finished_before: Filter the results for the jobs that finished before this timestamp. Optional.
        :type finished_before: datetime
        :param finished_after: Filter the results for the jobs that finished after this timestamp. Optional.
        :type finished_after: datetime
        :param kinds: Filter the results for the jobs of this kind. Optional.
        :type kinds: List[JobKind]
        :param exclude_kinds: Exclude jobs of these kinds. Takes precedence over kinds.
        :type exclude_kinds: List[JobKind]
        :param states: Filter the results for jobs in these states. Optional.
        :type states: List[JobState]
        :param error_count_above: Filter the results for the jobs that had greater than or equal to this many errors. Optional.
        :type error_count_above: int
        :param data_plane_id: Filter the results for the jobs that were ran on this dataplane. Optional.
        :type data_plane_id: str
        :param schedule_id: Filter the results for jobs associated with this schedule ID. Optional.
        :type schedule_id: str
        :param trigger_type: Filter the results for the jobs that were started by this trigger type. Optional.
        :type trigger_type: JobTrigger
        :param triggered_by_user_id: Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_id: str
        :param triggered_by_user_email: Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_email: str
        :param model_id: Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.
        :type model_id: str
        :param nonce: Filter the results for jobs that match a job nonce used to ensure exactly once execution.
        :type nonce: str
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_jobs_serialize(
            project_id=project_id,
            sort=sort,
            order=order,
            duration_sec_greater_than=duration_sec_greater_than,
            duration_sec_less_than=duration_sec_less_than,
            started_before=started_before,
            started_after=started_after,
            queued_before=queued_before,
            queued_after=queued_after,
            ready_before=ready_before,
            ready_before_current_time=ready_before_current_time,
            ready_after=ready_after,
            ready_after_current_time=ready_after_current_time,
            finished_before=finished_before,
            finished_after=finished_after,
            kinds=kinds,
            exclude_kinds=exclude_kinds,
            states=states,
            error_count_above=error_count_above,
            data_plane_id=data_plane_id,
            schedule_id=schedule_id,
            trigger_type=trigger_type,
            triggered_by_user_id=triggered_by_user_id,
            triggered_by_user_email=triggered_by_user_email,
            model_id=model_id,
            nonce=nonce,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListJob",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_jobs_without_preload_content(
        self,
        project_id: StrictStr,
        sort: Annotated[Optional[JobsSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        duration_sec_greater_than: Annotated[Optional[StrictInt], Field(description="Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.")] = None,
        duration_sec_less_than: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.")] = None,
        started_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started before this timestamp. Optional.")] = None,
        started_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that started after this timestamp. Optional.")] = None,
        queued_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued before this timestamp. Optional.")] = None,
        queued_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that were queued after this timestamp. Optional.")] = None,
        ready_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready before this timestamp. Optional.")] = None,
        ready_before_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.")] = None,
        ready_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that are ready after this timestamp. Optional.")] = None,
        ready_after_current_time: Annotated[Optional[StrictBool], Field(description="When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.")] = None,
        finished_before: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished before this timestamp. Optional.")] = None,
        finished_after: Annotated[Optional[datetime], Field(description="Filter the results for the jobs that finished after this timestamp. Optional.")] = None,
        kinds: Annotated[Optional[List[JobKind]], Field(description="Filter the results for the jobs of this kind. Optional.")] = None,
        exclude_kinds: Annotated[Optional[List[JobKind]], Field(description="Exclude jobs of these kinds. Takes precedence over kinds.")] = None,
        states: Annotated[Optional[List[JobState]], Field(description="Filter the results for jobs in these states. Optional.")] = None,
        error_count_above: Annotated[Optional[StrictInt], Field(description="Filter the results for the jobs that had greater than or equal to this many errors. Optional.")] = None,
        data_plane_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that were ran on this dataplane. Optional.")] = None,
        schedule_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this schedule ID. Optional.")] = None,
        trigger_type: Annotated[Optional[JobTrigger], Field(description="Filter the results for the jobs that were started by this trigger type. Optional.")] = None,
        triggered_by_user_id: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.")] = None,
        triggered_by_user_email: Annotated[Optional[StrictStr], Field(description="Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.")] = None,
        model_id: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.")] = None,
        nonce: Annotated[Optional[StrictStr], Field(description="Filter the results for jobs that match a job nonce used to ensure exactly once execution.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Jobs

        Returns jobs in the project matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires project_list_jobs permission. Note: exclude_kinds takes precedence over kinds and will exclude jobs even if they are in kinds.

        :param project_id: (required)
        :type project_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: JobsSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param duration_sec_greater_than: Filter the results for jobs that ran for greater than or equal to this number of seconds. Optional.
        :type duration_sec_greater_than: int
        :param duration_sec_less_than: Filter the results for the jobs that ran for less than or equal to this number of seconds. Optional.
        :type duration_sec_less_than: int
        :param started_before: Filter the results for the jobs that started before this timestamp. Optional.
        :type started_before: datetime
        :param started_after: Filter the results for the jobs that started after this timestamp. Optional.
        :type started_after: datetime
        :param queued_before: Filter the results for the jobs that were queued before this timestamp. Optional.
        :type queued_before: datetime
        :param queued_after: Filter the results for the jobs that were queued after this timestamp. Optional.
        :type queued_after: datetime
        :param ready_before: Filter the results for the jobs that are ready before this timestamp. Optional.
        :type ready_before: datetime
        :param ready_before_current_time: When true, filters jobs ready before the current server time. Takes precedence over ready_before. Optional.
        :type ready_before_current_time: bool
        :param ready_after: Filter the results for the jobs that are ready after this timestamp. Optional.
        :type ready_after: datetime
        :param ready_after_current_time: When true, filters jobs ready after the current server time. Takes precedence over ready_after. Optional.
        :type ready_after_current_time: bool
        :param finished_before: Filter the results for the jobs that finished before this timestamp. Optional.
        :type finished_before: datetime
        :param finished_after: Filter the results for the jobs that finished after this timestamp. Optional.
        :type finished_after: datetime
        :param kinds: Filter the results for the jobs of this kind. Optional.
        :type kinds: List[JobKind]
        :param exclude_kinds: Exclude jobs of these kinds. Takes precedence over kinds.
        :type exclude_kinds: List[JobKind]
        :param states: Filter the results for jobs in these states. Optional.
        :type states: List[JobState]
        :param error_count_above: Filter the results for the jobs that had greater than or equal to this many errors. Optional.
        :type error_count_above: int
        :param data_plane_id: Filter the results for the jobs that were ran on this dataplane. Optional.
        :type data_plane_id: str
        :param schedule_id: Filter the results for jobs associated with this schedule ID. Optional.
        :type schedule_id: str
        :param trigger_type: Filter the results for the jobs that were started by this trigger type. Optional.
        :type trigger_type: JobTrigger
        :param triggered_by_user_id: Filter the results for the jobs that started by this user id. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_id: str
        :param triggered_by_user_email: Filter the results for the jobs that started by this user email. Only valid when trigger_type = 'user'. Optional.
        :type triggered_by_user_email: str
        :param model_id: Filter the results for jobs associated with this model ID. Includes jobs associated with datasets used by the model. Optional.
        :type model_id: str
        :param nonce: Filter the results for jobs that match a job nonce used to ensure exactly once execution.
        :type nonce: str
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_jobs_serialize(
            project_id=project_id,
            sort=sort,
            order=order,
            duration_sec_greater_than=duration_sec_greater_than,
            duration_sec_less_than=duration_sec_less_than,
            started_before=started_before,
            started_after=started_after,
            queued_before=queued_before,
            queued_after=queued_after,
            ready_before=ready_before,
            ready_before_current_time=ready_before_current_time,
            ready_after=ready_after,
            ready_after_current_time=ready_after_current_time,
            finished_before=finished_before,
            finished_after=finished_after,
            kinds=kinds,
            exclude_kinds=exclude_kinds,
            states=states,
            error_count_above=error_count_above,
            data_plane_id=data_plane_id,
            schedule_id=schedule_id,
            trigger_type=trigger_type,
            triggered_by_user_id=triggered_by_user_id,
            triggered_by_user_email=triggered_by_user_email,
            model_id=model_id,
            nonce=nonce,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListJob",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_jobs_serialize(
        self,
        project_id,
        sort,
        order,
        duration_sec_greater_than,
        duration_sec_less_than,
        started_before,
        started_after,
        queued_before,
        queued_after,
        ready_before,
        ready_before_current_time,
        ready_after,
        ready_after_current_time,
        finished_before,
        finished_after,
        kinds,
        exclude_kinds,
        states,
        error_count_above,
        data_plane_id,
        schedule_id,
        trigger_type,
        triggered_by_user_id,
        triggered_by_user_email,
        model_id,
        nonce,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'kinds': 'multi',
            'exclude_kinds': 'multi',
            'states': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params['project_id'] = project_id
        # process the query parameters
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if order is not None:
            
            _query_params.append(('order', order.value))
            
        if duration_sec_greater_than is not None:
            
            _query_params.append(('duration_sec_greater_than', duration_sec_greater_than))
            
        if duration_sec_less_than is not None:
            
            _query_params.append(('duration_sec_less_than', duration_sec_less_than))
            
        if started_before is not None:
            if isinstance(started_before, datetime):
                _query_params.append(
                    (
                        'started_before',
                        started_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_before', started_before))
            
        if started_after is not None:
            if isinstance(started_after, datetime):
                _query_params.append(
                    (
                        'started_after',
                        started_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started_after', started_after))
            
        if queued_before is not None:
            if isinstance(queued_before, datetime):
                _query_params.append(
                    (
                        'queued_before',
                        queued_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('queued_before', queued_before))
            
        if queued_after is not None:
            if isinstance(queued_after, datetime):
                _query_params.append(
                    (
                        'queued_after',
                        queued_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('queued_after', queued_after))
            
        if ready_before is not None:
            if isinstance(ready_before, datetime):
                _query_params.append(
                    (
                        'ready_before',
                        ready_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('ready_before', ready_before))
            
        if ready_before_current_time is not None:
            
            _query_params.append(('ready_before_current_time', ready_before_current_time))
            
        if ready_after is not None:
            if isinstance(ready_after, datetime):
                _query_params.append(
                    (
                        'ready_after',
                        ready_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('ready_after', ready_after))
            
        if ready_after_current_time is not None:
            
            _query_params.append(('ready_after_current_time', ready_after_current_time))
            
        if finished_before is not None:
            if isinstance(finished_before, datetime):
                _query_params.append(
                    (
                        'finished_before',
                        finished_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_before', finished_before))
            
        if finished_after is not None:
            if isinstance(finished_after, datetime):
                _query_params.append(
                    (
                        'finished_after',
                        finished_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('finished_after', finished_after))
            
        if kinds is not None:
            
            _query_params.append(('kinds', kinds))
            
        if exclude_kinds is not None:
            
            _query_params.append(('exclude_kinds', exclude_kinds))
            
        if states is not None:
            
            _query_params.append(('states', states))
            
        if error_count_above is not None:
            
            _query_params.append(('error_count_above', error_count_above))
            
        if data_plane_id is not None:
            
            _query_params.append(('data_plane_id', data_plane_id))
            
        if schedule_id is not None:
            
            _query_params.append(('schedule_id', schedule_id))
            
        if trigger_type is not None:
            
            _query_params.append(('trigger_type', trigger_type.value))
            
        if triggered_by_user_id is not None:
            
            _query_params.append(('triggered_by_user_id', triggered_by_user_id))
            
        if triggered_by_user_email is not None:
            
            _query_params.append(('triggered_by_user_email', triggered_by_user_email))
            
        if model_id is not None:
            
            _query_params.append(('model_id', model_id))
            
        if nonce is not None:
            
            _query_params.append(('nonce', nonce))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/projects/{project_id}/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_dequeue_job(
        self,
        data_plane_id: StrictStr,
        job_dequeue_parameters: JobDequeueParameters,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JobRun:
        """Dequeue Job

        Returns the next available job for processing from the data plane's job queue. Requires data_plane_jobs_dequeue_next permission.

        :param data_plane_id: (required)
        :type data_plane_id: str
        :param job_dequeue_parameters: (required)
        :type job_dequeue_parameters: JobDequeueParameters
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_dequeue_job_serialize(
            data_plane_id=data_plane_id,
            job_dequeue_parameters=job_dequeue_parameters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobRun",
            '500': "InternalServerError",
            '204': None,
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_dequeue_job_with_http_info(
        self,
        data_plane_id: StrictStr,
        job_dequeue_parameters: JobDequeueParameters,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JobRun]:
        """Dequeue Job

        Returns the next available job for processing from the data plane's job queue. Requires data_plane_jobs_dequeue_next permission.

        :param data_plane_id: (required)
        :type data_plane_id: str
        :param job_dequeue_parameters: (required)
        :type job_dequeue_parameters: JobDequeueParameters
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_dequeue_job_serialize(
            data_plane_id=data_plane_id,
            job_dequeue_parameters=job_dequeue_parameters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobRun",
            '500': "InternalServerError",
            '204': None,
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_dequeue_job_without_preload_content(
        self,
        data_plane_id: StrictStr,
        job_dequeue_parameters: JobDequeueParameters,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Dequeue Job

        Returns the next available job for processing from the data plane's job queue. Requires data_plane_jobs_dequeue_next permission.

        :param data_plane_id: (required)
        :type data_plane_id: str
        :param job_dequeue_parameters: (required)
        :type job_dequeue_parameters: JobDequeueParameters
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_dequeue_job_serialize(
            data_plane_id=data_plane_id,
            job_dequeue_parameters=job_dequeue_parameters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobRun",
            '500': "InternalServerError",
            '204': None,
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_dequeue_job_serialize(
        self,
        data_plane_id,
        job_dequeue_parameters,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if data_plane_id is not None:
            _path_params['data_plane_id'] = data_plane_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if job_dequeue_parameters is not None:
            _body_params = job_dequeue_parameters


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/data_planes/{data_plane_id}/jobs/next',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_job_errors(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        job_errors: JobErrors,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Append To Job Errors

        Append job errors. Requires project_job_append_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_errors: (required)
        :type job_errors: JobErrors
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_errors=job_errors,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_job_errors_with_http_info(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        job_errors: JobErrors,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Append To Job Errors

        Append job errors. Requires project_job_append_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_errors: (required)
        :type job_errors: JobErrors
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_errors=job_errors,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_job_errors_without_preload_content(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the errors. Should be formatted as a UUID.")],
        job_errors: JobErrors,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Append To Job Errors

        Append job errors. Requires project_job_append_errors permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the errors. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_errors: (required)
        :type job_errors: JobErrors
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_errors_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_errors=job_errors,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_job_errors_serialize(
        self,
        job_id,
        job_run_id,
        job_errors,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        if job_run_id is not None:
            _path_params['job_run_id'] = job_run_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if job_errors is not None:
            _body_params = job_errors


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/jobs/{job_id}/runs/{job_run_id}/errors',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_job_logs(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        job_logs: JobLogs,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Append To Job Logs

        Append job logs. Requires project_job_append_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_logs: (required)
        :type job_logs: JobLogs
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_logs=job_logs,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_job_logs_with_http_info(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        job_logs: JobLogs,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Append To Job Logs

        Append job logs. Requires project_job_append_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_logs: (required)
        :type job_logs: JobLogs
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_logs=job_logs,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_job_logs_without_preload_content(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="The job run associated with the logs. Should be formatted as a UUID.")],
        job_logs: JobLogs,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Append To Job Logs

        Append job logs. Requires project_job_append_logs permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: The job run associated with the logs. Should be formatted as a UUID. (required)
        :type job_run_id: str
        :param job_logs: (required)
        :type job_logs: JobLogs
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_job_logs_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            job_logs=job_logs,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_job_logs_serialize(
        self,
        job_id,
        job_run_id,
        job_logs,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        if job_run_id is not None:
            _path_params['job_run_id'] = job_run_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if job_logs is not None:
            _body_params = job_logs


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/jobs/{job_id}/runs/{job_run_id}/logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_submit_jobs_batch(
        self,
        project_id: StrictStr,
        post_job_batch: PostJobBatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JobsBatch:
        """Submit Jobs Batch

        Submit new jobs to run. Requires project_create_job permission.

        :param project_id: (required)
        :type project_id: str
        :param post_job_batch: (required)
        :type post_job_batch: PostJobBatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_submit_jobs_batch_serialize(
            project_id=project_id,
            post_job_batch=post_job_batch,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobsBatch",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_submit_jobs_batch_with_http_info(
        self,
        project_id: StrictStr,
        post_job_batch: PostJobBatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JobsBatch]:
        """Submit Jobs Batch

        Submit new jobs to run. Requires project_create_job permission.

        :param project_id: (required)
        :type project_id: str
        :param post_job_batch: (required)
        :type post_job_batch: PostJobBatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_submit_jobs_batch_serialize(
            project_id=project_id,
            post_job_batch=post_job_batch,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobsBatch",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_submit_jobs_batch_without_preload_content(
        self,
        project_id: StrictStr,
        post_job_batch: PostJobBatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Submit Jobs Batch

        Submit new jobs to run. Requires project_create_job permission.

        :param project_id: (required)
        :type project_id: str
        :param post_job_batch: (required)
        :type post_job_batch: PostJobBatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_submit_jobs_batch_serialize(
            project_id=project_id,
            post_job_batch=post_job_batch,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JobsBatch",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_submit_jobs_batch_serialize(
        self,
        project_id,
        post_job_batch,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params['project_id'] = project_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_job_batch is not None:
            _body_params = post_job_batch


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/projects/{project_id}/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_job_state(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="Job run ID associated with the state update.")],
        put_job_state: PutJobState,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Update Job State

        Update job state. Requires project_job_put_state permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: Job run ID associated with the state update. (required)
        :type job_run_id: str
        :param put_job_state: (required)
        :type put_job_state: PutJobState
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_job_state_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            put_job_state=put_job_state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_job_state_with_http_info(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="Job run ID associated with the state update.")],
        put_job_state: PutJobState,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Update Job State

        Update job state. Requires project_job_put_state permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: Job run ID associated with the state update. (required)
        :type job_run_id: str
        :param put_job_state: (required)
        :type put_job_state: PutJobState
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_job_state_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            put_job_state=put_job_state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_job_state_without_preload_content(
        self,
        job_id: StrictStr,
        job_run_id: Annotated[StrictStr, Field(description="Job run ID associated with the state update.")],
        put_job_state: PutJobState,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Job State

        Update job state. Requires project_job_put_state permission.

        :param job_id: (required)
        :type job_id: str
        :param job_run_id: Job run ID associated with the state update. (required)
        :type job_run_id: str
        :param put_job_state: (required)
        :type put_job_state: PutJobState
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_job_state_serialize(
            job_id=job_id,
            job_run_id=job_run_id,
            put_job_state=put_job_state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_job_state_serialize(
        self,
        job_id,
        job_run_id,
        put_job_state,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        if job_run_id is not None:
            
            _query_params.append(('job_run_id', job_run_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if put_job_state is not None:
            _body_params = put_job_state


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v1/jobs/{job_id}/state',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_job(
        self,
        job_id: StrictStr,
        patch_job: PatchJob,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Job:
        """Update Job By Id

        Updates a single job by ID. Requires project_job_update permission.

        :param job_id: (required)
        :type job_id: str
        :param patch_job: (required)
        :type patch_job: PatchJob
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_job_serialize(
            job_id=job_id,
            patch_job=patch_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_job_with_http_info(
        self,
        job_id: StrictStr,
        patch_job: PatchJob,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Job]:
        """Update Job By Id

        Updates a single job by ID. Requires project_job_update permission.

        :param job_id: (required)
        :type job_id: str
        :param patch_job: (required)
        :type patch_job: PatchJob
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_job_serialize(
            job_id=job_id,
            patch_job=patch_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_job_without_preload_content(
        self,
        job_id: StrictStr,
        patch_job: PatchJob,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Job By Id

        Updates a single job by ID. Requires project_job_update permission.

        :param job_id: (required)
        :type job_id: str
        :param patch_job: (required)
        :type patch_job: PatchJob
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_job_serialize(
            job_id=job_id,
            patch_job=patch_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_job_serialize(
        self,
        job_id,
        patch_job,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patch_job is not None:
            _body_params = patch_job


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v1/jobs/{job_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


