# Generated by Django 3.1.3 on 2020-12-03 19:33

from django.db import migrations

from vendor.models.choice import TermType

def term_type_update_value(apps, schema_editor):
    OfferModel = apps.get_model('vendor', 'Offer')

    for offer in OfferModel.objects.filter(terms__lt=100):
        if offer.terms == 0:
            offer.terms = TermType.PERPETUAL
        elif offer.terms == 10:
            offer.terms = TermType.SUBSCRIPTION
        elif offer.terms == 11:
            offer.terms = TermType.MONTHLY_SUBSCRIPTION
        elif offer.terms == 12:
            offer.terms = TermType.QUARTERLY_SUBSCRIPTION
        elif offer.terms == 13:
            offer.terms = TermType.SEMIANNUAL_SUBSCRIPTION
        elif offer.terms == 14:
            offer.terms = TermType.ANNUAL_SUBSCRIPTION
        elif offer.terms == 20:
            offer.terms = TermType.ONE_TIME_USE
        offer.save()

class Migration(migrations.Migration):

    dependencies = [
        ('vendor', '0013_auto_20201202_1759'),
    ]

    operations = [
        migrations.RunPython(term_type_update_value, reverse_code=migrations.RunPython.noop),
    ]
