# coding: utf-8
from __future__ import print_function, division, unicode_literals, absolute_import

executable = "anaddb"

#from abimkdocs.variables import ValueWithUnit, MultipleValue, Range
from abipy.abio.abivar_database.variables import ValueWithUnit, MultipleValue, Range, ValueWithConditions
ValueWithConditions = dict
Variable=dict

variables = [
Variable(
    abivarname="a2fsmear@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=2e-05,
    mnemonics="Alpha2F SMEARing factor",
    characteristics=['[[ENERGY]]'],
    added_in_version="before_v9",
    text=r"""
Smearing width for the Eliashberg $\\alpha^2$F function (similar to a phonon DOS),
which is sampled on a finite q and k grid. The Dirac delta functions in energy
are replaced by Gaussians of width **a2fsmear** (by default in Hartree).
""",
),

Variable(
    abivarname="alphon@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['nonlinear_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="ALign PHONon mode eigendisplacements",
    added_in_version="before_v9",
    text=r"""
In case **alphon** is set to 1, ANADDB will compute linear combinations of the
eigendisplacements of modes that are degenerate (twice or three times), in
order to align the mode effective charges along the cartesian axes. This
option is useful in the mode-by-mode decomposition of the electrooptic tensor,
and to compute the Raman susceptibilities of individual phonon modes. In case
of uniaxial crystals, the z-axis should be chosen along the optical axis.
""",
),

Variable(
    abivarname="asr@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_basic', 'PhononBands_basic'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="Acoustic Sum Rule",
    commentdefault="was 0 before v5.3",
    added_in_version="before_v9",
    text=r"""
Governs the imposition of the Acoustic Sum Rule (ASR).

  * 0 --> no ASR for interatomic force constants is imposed.
  * 1 or 2 --> the ASR for interatomic force constants is imposed by modifying
  the on-site interatomic force constants, in a symmetric way ( **asr** =2),
  or in the more general case, unconstrained way ( **asr** =1).

More detailed explanations: the total energy should be invariant under
translation of the crystal as a whole. This would guarantee that the three
lowest phonon modes at Gamma have zero frequency (Acoustic Sum Rule - ASR).
Unfortunately, the way the DDB is generated (presence of a discrete grid of
points for the evaluation of the exchange-correlation potential and energy)
slightly breaks the translational invariance. Well, in some pathological
cases, the breaking can be rather important.

Two quantities are affected: the interatomic forces (or dynamical matrices),
and the effective charges. The ASR for the effective charges is called the
charge neutrality sum rule, and will be dealt with by the variable
[[anaddb:chneut]]. The ASR for the interatomic forces can be restored, by
modifying the interatomic force of the atom on itself, (called self-IFC), as
soon as the dynamical matrix at Gamma is known. This quantity should be equal
to minus the sum of all interatomic forces generated by all others atoms
(action-reaction law!), which is determined by the dynamical matrix at Gamma.

So, if **asr** is non-zero, the correction to the self-force will be
determined, and the self-force will be imposed to be consistent with the ASR.
This correction will work if IFCs are computed ([[anaddb:ifcflag]]/=0), as
well as if the IFCs are not computed ([[anaddb:ifcflag]]==0). In both cases,
the phonon frequencies will not be the same as the ones determined by the
output of abinit, RF case. If you want to check that the DDB is correct, by
comparing phonon frequencies from abinit and anaddb, you should turn off both
**asr** and [[anaddb:chneut]].

Until now, we have not explained the difference between **asr** =1 and **asr**
=2. This is rather subtle. In some local low-symmetry cases (basically the
effective charges should be anisotropic), when the dipole-dipole contribution
is evaluated and subtracted, the ASR cannot be imposed without breaking the
symmetry of the on-site interatomic forces. That explains why two options are
given: the second case ( **asr** =2, sym) does not entirely impose the ASR,
but simply the part that keeps the on-site interatomic forces symmetric (which
means that the acoustic frequencies do not go to zero exactly), the first case
( **asr** =1, asym) imposes the ASR, but breaks the symmetry. **asr** =2 is to
be preferred for the analysis of the interatomic force constant in real space,
while **asr** =1 should be used to get the phonon band structure.

(NOTE: in order to confuse even more the situation, it seems that the acoustic
phonon frequencies generated by the code for both the sym and asym options are
exactly the same likely due to an extra symmetrisation in the
diagonalisation routine. Of course, when the matrix at Gamma has been
generated from IFCs coming from dynamical matrices none of which are Gamma,
the breaking of the ASR is rather severe. In order to clear the situation, one
should use a diagonalisation routine for non-hermitian matrices. So, at the
present status of understanding, one should always use the **asr** =2 option
).
""",
),

Variable(
    abivarname="atifc@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions=['[[anaddb:natifc]]'],
    defaultval=0,
    mnemonics="AToms for IFC analysis",
    added_in_version="before_v9",
    text=r"""
The actual numbers of the atoms for which the interatomic force constant have
to be written and eventually analysed.

WARNING: there will be an in-place change of meaning of atifc (this is
confusing, and should be taken away in one future version - sorry for this).
""",
),

#FIXME NOTE XG20170811: apparently no effective test for this input variable. Also,
# the description is strange ...!
Variable(
    abivarname="band_gap@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_expert'],
    dimensions="scalar",
    defaultval=999.0,
    mnemonics="BAND GAP",
    characteristics=['[[ENERGY]]'],
    added_in_version="before_v9",
    text=r"""
Allow setting the target band gap, in eV. ([[anaddb:elphflag]]=1).
""",
),

Variable(
    abivarname="brav@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="BRAVais",
    added_in_version="before_v9",
    text=r"""
Allows to specify the Bravais lattice of the crystal, in order to help to
generate a grid of special q points.

  * 1 --> all the lattices (including FCC, BCC and hexagonal)
  * 2 --> specific for Face Centered lattices
  * 3 --> specific for Body Centered lattices
  * 4 --> specific for the Hexagonal lattice

Note that in the latter case, the [[rprim]] of the unit cell has to be

  1.0 0.0 0.0
  -.5 sqrt(3)/2 0.0
  0.0 0.0 1.0

in order for the code to work properly.

Warning: the generation of q-points in anaddb is rather old-fashioned, and
should be replaced by routines used by the main abinit code.

Warning:
The value **brav** = -1 is also possible. It is used for backwards compatibility:
it corresponds to **brav** = 1, with the weights for the
interpolation of the phonon band structure determined by another (now obsolete) algorithm
than the default **brav** = 1 algorithm
based on Wigner-Seitz cells (new as v8.7). The default algorithm has a correct treatment of symmetries.
""",
),

Variable(
    abivarname="chneut@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Integer for CHarge NEUTrality treatment",
    added_in_version="before_v9",
    text=r"""
Set the treatment of the Charge Neutrality requirement for the effective charges.

  * chneut=0 --> no ASR for effective charges is imposed
  * chneut=1 --> the ASR for effective charges is imposed by giving to each atom
    an equal portion of the missing charge. See Eq.(48) in [[cite:Gonze1997a]].
  * chneut=2 --> the ASR for effective charges is imposed by giving to each atom a portion
    of the missing charge proportional to the screening charge already present.
    See Eq.(49) in [[cite:Gonze1997a]].

More detailed explanation: the sum of the effective charges in the unit cell
should be equal to zero. It is not the case in the DDB, and this sum rule is
sometimes strongly violated. In particular, this will make the lowest
frequencies at Gamma non-zero. There is no "best" way of imposing the ASR on effective charges.
""",
),

Variable(
    abivarname="dieflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="DIElectric FLAG",
    added_in_version="before_v9",
    text=r"""
Frequency-dependent dielectric tensor flag.

  * 0 --> No dielectric tensor is calculated.

  * 1 --> The frequency-dependent dielectric tensor is calculated.
  Requirements for preceding response-function DDB generation run: electric-field and full atomic-displacement responses.
  Set [[rfstrs]] = 1, 2, or 3 (preferably 3). Set [[rfatpol]] and [[rfdir]] to do a full calculation of phonons at Q=0.
  The frequencies are defined by the [[anaddb:nfreq]], [[anaddb:frmin]], [[anaddb:frmax]] variables.
  Also, the generalized Lyddane-Sachs-Teller relation will be used as an independent check of the dielectric tensor
  at zero frequency (this for the directions defined in the phonon list 2. See [[anaddb:nph2l]].

  * 2 --> Only the electronic dielectric tensor is calculated. It corresponds to a zero-frequency homogeneous field,
   with quenched atomic positions. For large band gap materials, this quantity is measurable because the
   highest phonon frequency is on the order of a few tenths of eV, and the band gap is larger than 5eV.
   Requirements for preceding response-function DDB generation: electric-field response.
   Set [[rfelfd]] = 1 or 3 (preferably 3). Note that the same information on the electronic dielectric tensor
   will be printed in the .out file of the [[rfelfd]] run.

  * 3 --> Compute and print the relaxed-ion dielectric tensor.
  Requirements for preceding response-function DDB generation run:
  electric-field and full atomic-displacement responses. Set [[rfstrs]] = 1, 2, or 3 (preferably 3).
  Set [[rfatpol]] and [[rfdir]] to do a full calculation of phonons at Q=0
  (needed because the inverse of force-constant tensor is required). Furthermore, in the anaddb input file
  the variable [[anaddb:nph2l]] must be nonzero in order to initiate computation of atomic displacements.
  If only the dielectric response is needed it is sufficient to set [[anaddb:nph2l]] to 1 and leave [[anaddb:qph2l]]
  at its default value (the Gamma point). Note that the relaxed-ion dielectric tensor computed here can also be obtained
  as the zero-frequency limit of the frequency-dependent dielectric tensor using input variables **dieflag** =1 and [[anaddb:frmin]]=0.0.
  (The results obtained using these two approaches should agree to good numerical precision.)
  The ability to compute and print the static dielectric tensor here is provided for completeness
  and consistency with the other tensor quantities that are computed in this section of the code.
  * 4 --> Calculate dielectric tensor of both relaxed ion and free stress.
  We need information of internal strain and elastic tensor (relaxed ion) in this computation.
  So please set: [[anaddb:elaflag]]=2,3,4 or 5 and [[anaddb:instrflag]]=1
""",
),

Variable(
    abivarname="dipdip@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="DIPole-DIPole interaction",
    added_in_version="before_v9",
    text=r"""
  * 0 --> the dipole-dipole interaction is not handled separately in the treatment of the interatomic forces.
    This option is available for testing purposes or if effective charge and/or dielectric tensor is not available
    in the derivative database. It gives results much less accurate than **dipdip** =1.
  * 1 --> the dipole-dipole interaction is subtracted from the dynamical matrices before Fourier transform,
    so that only the short-range part is handled in real space. Of course, it is reintroduced analytically
    when the phonon spectrum is interpolated, or if the interatomic force constants have to be analysed in real space.

The abinit input variable [[dipdip]] has a similar meaning.
""",
),

Variable(
    abivarname="dipquad@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['longwave_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="DIPole-QUADdrupole interaction",
    characteristics=['[[DEVELOP]]'],
    added_in_version="v9",
    text=r"""
  * 0 --> the dipole-quadrupole interaction is not handled separately in the treatment of the interatomic forces.
  * 1 --> the dipole-quadrupole interaction is subtracted from the dynamical matrices before Fourier transform,
    so that only the short-range part is handled in real space. Of course, it is reintroduced analytically
    when the phonon spectrum is interpolated. Requires a preceding generation of 3rd order DDB with a [[lw_qdrpl]] = 1
    or a [[lw_flexo]] = 1 or 2 run.

""",
),

Variable(
    abivarname="quadquad@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['longwave_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="QUADdrupole-QUADdrupole interaction",
    characteristics=['[[DEVELOP]]'],
    added_in_version="v9",
    text=r"""
  * 0 --> the quadrupole-quadrupole interaction is not handled separately in the treatment of the interatomic forces.
  * 1 --> the quadrupole-quadrupole interaction is subtracted from the dynamical matrices before Fourier transform,
    so that only the short-range part is handled in real space. Of course, it is reintroduced analytically
    when the phonon spectrum is interpolated. Requires a preceding generation of 3rd order DDB with a [[lw_qdrpl]] = 1
    or a [[lw_flexo]] = 1 or 2 run.

""",
),

Variable(
    abivarname="dosdeltae@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval="4.5E-06 Hartree = 1 cm$^{-1}$",
    mnemonics="DOS DELTA in Energy",
    added_in_version="before_v9",
    text=r"""
The input variable **dosdeltae** is used to define the step of the frequency
grid used to calculate the phonon density of states when [[anaddb:prtdos]] = 1.
""",
),

Variable(
    abivarname="dossmear@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval="4.5E-05 Hartree = 10 cm$^{-1}$",
    mnemonics="DOS SMEARing value",
    characteristics=['[[ENERGY]]'],
    added_in_version="before_v9",
    text=r"""
**dossmear** defines the gaussian broadening used to calculate the phonon
density of states when [[anaddb:prtdos]] = 1.
""",
),

Variable(
    abivarname="dossum@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="DOS SUM",
    added_in_version="before_v9",
    text=r"""
Set the flag to 1 to calculate the two phonon dos density of states. Sum and
Difference for the Gamma point. The DOS is converged and based on that, the
sum and difference are reported in the output file.
""",
),

Variable(
    abivarname="dostol@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0.25,
    mnemonics="DOS TOLerance",
    added_in_version="before_v9",
    text=r"""
The relative tolerance on the phonon density of state. This number will
determine when the series of grids with which the DOS is calculated can be
stopped, i.e. the mean of the relative change going from one grid to the next
bigger is smaller than **dostol**.
""",
),

Variable(
    abivarname="eivec@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful', 'PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="EIgenVECtors",
    added_in_version="before_v9",
    text=r"""
* 0 --> do not write the phonon eigenvectors;
* 1 or 2 --> write the phonon eigenvectors;
* 4 --> generate output files for band2eps (drawing tool for the phonon band structure);
""",
),

Variable(
    abivarname="elaflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Elastic_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="ELAstic tensor FLAG",
    added_in_version="before_v9",
    text=r"""
Flag for calculation of elastic and compliance tensors

  * 0 --> No elastic or compliance tensor will be calculated.
  * 1 --> Only clamped-ion elastic and compliance tensors will be calculated.
    Requirements for preceding response-function DDB generation run: Strain perturbation.
    Set [[rfstrs]] to 1, 2, or 3. Note that [[rfstrs]]=3 is recommended so that responses
    to both uniaxial and shear strains will be computed.
  * 2 --> Both relaxed- and clamped-ion elastic and compliance tensor will be calculated,
    but only the relaxed-ion quantities will be printed. The input variable [[anaddb:instrflag]] should also be set to 1,
    because the internal-strain tensor is needed to compute the relaxed-ion corrections.
    Requirements for preceding response-function DDB generation run:
    Strain and atomic-displacement responses at Q=0. Set [[rfstrs]] = 1, 2, or 3 (preferably 3).
    Set [[rfatpol]] and [[rfdir]] to do a full calculation of phonons at Q=0
    (needed because the inverse of force-constant tensor is required).
  * 3 --> Both relaxed and clamped-ion elastic and compliance tensors will be printed out.
   The input variable [[anaddb:instrflag]] should also be set to 1.
   Requirements for preceding response-function DDB generation run: Same as for **elaflag** =2.
  * 4 --> Calculate the elastic and compliance tensors (relaxed ion) at fixed displacement field,
    the relaxed-ion tensors at fixed electric field will be printed out too, for comparison.
    When **elaflag** =4, we need the information of internal strain and relaxed-ion dielectric tensor
    to build the whole tensor, so we need set [[anaddb:instrflag]]=1 and [[anaddb:dieflag]]=3 or 4 .
  * 5 --> Calculate the relaxed ion elastic and compliance tensors, considering the stress left inside cell.
    At the same time, bare relaxed ion tensors will still be printed out for comparison.
    In this calculation, stress tensor is needed to compute the correction term, so one is supposed
    to merge the first order derivative data base (DDB file) with the second order derivative data base (DDB file)
    into a new DDB file, which can contain both information. And the program will also check for the users.
""",
),

Variable(
    abivarname="elph_fermie@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0.0,
    mnemonics="ELectron-PHonon FERMI Energy",
    characteristics=['[[ENERGY]]'],
    added_in_version="before_v9",
    text=r"""
If non-zero, will fix artificially the value of the Fermi energy (e.g. for semiconductors),
in the electron-phonon case. Note that [[anaddb:elph_fermie]] and [[anaddb:ep_extrael]] should not be used at the same time.
([[anaddb:elphflag]]=1).
""",
),

Variable(
    abivarname="elphflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_compulsory', 'ElPhonTransport_compulsory'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="ELectron-PHonon FLAG",
    added_in_version="before_v9",
    text=r"""
If **elphflag** is 1, anaddb performs an analysis of the electron-phonon coupling.
""",
),

Variable(
    abivarname="elphsmear@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval="0.01 Hartree",
    mnemonics="ELectron-PHonon SMEARing factor",
    characteristics=['[[ENERGY]]'],
    added_in_version="before_v9",
    text=r"""
Smearing width for the Fermi surface integration (in Hartree by default).
""",
),

Variable(
    abivarname="enunit@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful', 'PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="ENergy UNITs",
    added_in_version="before_v9",
    text=r"""
Give the energy for the phonon frequency output (in the output file, not in
the console log file, for which Hartree units are used).

  * 0 --> Hartree and cm$^{-1}$;
  * 1 --> meV and Thz;
  * 2 --> Hartree, cm$^{-1}$, meV, Thz, and Kelvin.
""",
),

Variable(
    abivarname="ep_b_max@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron Phonon integration Band MAXimum",
    added_in_version="before_v9",
    text=r"""
When set, and [[anaddb:telphint]] is equal to 2, this variable determines the
k-point integration weights which are used in the electron-phonon part of the
code. Instead of weighting according to a distance from the Fermi surface, an
equal weight is given to all k-points, for all bands between
[[anaddb:ep_b_min]] and **ep_b_max**.
""",
),

Variable(
    abivarname="ep_b_min@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron Phonon integration Band MINimum",
    added_in_version="before_v9",
    text=r"""
As for [[anaddb:ep_b_max]], but **ep_b_min** is the lower bound on the band
integration, instead of the upper bound. See also [[anaddb:telphint]].
""",
),

Variable(
    abivarname="ep_extrael@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0.0,
    mnemonics="Electron-Phonon EXTRA ELectrons",
    added_in_version="before_v9",
    text=r"""
If non-zero, will fix artificially the number of extra electrons per unit cell
(positive for electron doping), according to a doped case. (e.g. for
semiconductors), in the electron-phonon case. This field can also be filled
with doping concentration, in the units of cm$^{-3}$ (negative for electron
doping). Note that **ep_extrael** and [[anaddb:elph_fermie]] should not be
used at the same time. ([[anaddb:elphflag]]=1).
""",
),

Variable(
    abivarname="ep_int_gkk@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron-Phonon INTerpolation of GKK",
    added_in_version="before_v9",
    text=r"""
This flag determines whether the interpolation of the electron-phonon matrix
elements over the coarse k-grid is done ( **ep_int_gkk** 1) before summing
with appropriate Fermi Surface weights. In this way, the two integration
weights are treated symmetrically.
""",
),

Variable(
    abivarname="ep_keepbands@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron-Phonon KEEP dependence on electron BANDS",
    added_in_version="before_v9",
    text=r"""
This flag determines whether the dependency of the electron-phonon matrix
elements on the electron band index is kept ( **ep_keepbands** 1), or whether
it is summed over immediately with appropriate Fermi Surface weights. For
transport calculations **ep_keepbands** must be set to 1.
""",
),

Variable(
    abivarname="ep_nqpt@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron Phonon Number of Q PoinTs",
    added_in_version="before_v9",
    text=r"""
In case a non-uniform grid of q-points is being used, for direct calculation
of the electron-phonon quantities without interpolation, this specifies the
number of q-points to be found in the GKK file, independently of the normal anaddb input (ngqpt)
""",
),

Variable(
    abivarname="ep_nspline@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=20,
    mnemonics="Electron Phonon Number for SPLINE interpolation",
    added_in_version="before_v9",
    text=r"""
The scale factor for cubic spline interpolation, only used in the relaxation
time approximation ([[anaddb:ifltransport]]=3).
""",
),

Variable(
    abivarname="ep_prt_yambo@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonInt_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Electron Phonon PRinTout YAMBO data",
    added_in_version="before_v9",
    text=r"""
For electron-phonon calculations, print out matrix elements for use by the yambo code.
""",
),

Variable(
    abivarname="ep_qptlist@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononWidth_useful'],
    dimensions=[3, '[[anaddb:ep_nqpt]]'],
    defaultval="(3*[[anaddb:ep_nqpt]])*0",
    mnemonics="Electron Phonon Q PoinT LIST",
    added_in_version="before_v9",
    text=r"""
In case a non-uniform grid of q-points is being used, for direct calculation
of the electron-phonon quantities without interpolation, this specifies the
q-points to be found in the GKK file, independently of the normal anaddb input
(ngqpt), in reduced coordinates of the reciprocal space lattice.
""",
),

Variable(
    abivarname="ep_scalprod@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="DO SCALar PRODuct for gkk matrix elements",
    added_in_version="before_v9",
    text=r"""
The input variable **ep_scalprod** is a flag determining whether the scalar
product of the electron-phonon matrix elements (gkk) with the phonon
displacement vectors is done before or after interpolation. Doing so before (
**ep_scalprod** 1) makes phonon linewidths smoother but introduces an error,
as the interpolated phonons and gkk are not diagonalized in the same basis.
Doing so afterwards ( **ep_scalprod** 0) eliminates the diagonalization error,
but sometimes gives small spikes in the phonon linewidths near band crossings
or high symmetry points. I do not know why...
""",
),

Variable(
    abivarname="flexoflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['longwave_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="FLEXOelectric tensor FLAG",
    characteristics=['[[DEVELOP]]'],
    added_in_version="v9",
    text=r"""
Flag for calculation of bulk flexoelectrics tensors

  * 0 --> No flexoelectric tensor is calculated.
  * 1 --> All the contributions to the bulk flexoelectric tensor (clamped-ion, mixed and lattice-mediated) and
          related quantities (piezoelectric and flexoelectric internal strain tensors and Lagrange elastic tensors)
          are calculated. Requires a preceding generation of 2nd and 3rd order DDB with a [[lw_flexo]] = 1 run.
  * 2 --> The clamped-ion flexoelectric tensor is printed. Requires a preceding generation of 2nd and 3rd order
          DDB with a [[lw_flexo]] = 1 or 2 run.
  * 3 --> The mixed flexoelectric tensor is calculated and printed along with the piezoelectric internal strain tensors.
          Requires a preceding generation of 2nd and 3rd order DDB with a [[lw_flexo]] = 1 or 3 run.
  * 4 --> The lattice-mediated flexoelectric tensor is calculated and printed along with the piezoelectric and flexoelectric
          internal strain tensors and the Lagrange elastic tensors.
          Requires a preceding generation of 2nd and 3rd order DDB with a [[lw_flexo]] = 1 or 4 run.
""",
),

Variable(
    abivarname="freeze_displ@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=0.0,
    mnemonics="FREEZE DISPLacement of phonons into supercells",
    added_in_version="before_v9",
    text=r"""
If different from zero, **freeze_displ** will be used as the amplitude of a
phonon displacement. For each q-point and mode in the [[anaddb:qph1l]] list, a
file will be created containing a supercell of atoms with the corresponding
phonon displacements frozen in. This is typically useful to freeze a soft
phonon mode, then let it relax in abinit afterwards.

**freeze_displ** is unitless, but has a physical meaning: it is related to the
Bose distribution $n_B$ and the frequency $\omega_{qs}$ of the phonon mode. At a given
temperature T, **freeze_displ** will give the mean square displacement of
atoms (along with the displacement vectors, which are in Bohr). In atomic
units **freeze_displ** = $\sqrt{(0.5 + n_B(\omega_{qs}/kT) / \omega_{qs}}$.
Typical values are 50-200 for a frequency of a few hundred cm$^{-1}$ and room temperature.
If all you want is to break the symmetry in the right direction, any reasonable value
(10-50) should be ok.

**WARNING**: this will create a _lot_ of files (3*natom*nph1l), so it should
be used with a small number [[anaddb:nph1l]] of q-points for interpolation.
""",
),

Variable(
    abivarname="frmax@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Phonons_useful'],
    dimensions="scalar",
    defaultval=10.0,
    mnemonics="FRequency MAXimum",
    added_in_version="before_v9",
    text=r"""
Value of the largest frequency for the frequency-dependent dielectric tensor, in Hartree.
""",
),

Variable(
    abivarname="frmin@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Phonons_useful'],
    dimensions="scalar",
    defaultval=0.0,
    mnemonics="FRequency MINimum",
    added_in_version="before_v9",
    text=r"""
Value of the lowest frequency for the frequency-dependent dielectric tensor, in Hartree.
""",
),

Variable(
    abivarname="gkqwrite@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonInt_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="GKk for input Q grid to be WRITtEn to disk",
    added_in_version="before_v9",
    text=r"""
Flag to write out the reciprocal space matrix elements to a disk file named
gkqfile. This reduces strongly the memory needed for an electron-phonon run.
""",
),

Variable(
    abivarname="gruns_ddbs@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Temperature_useful'],
    dimensions=['[[anaddb:gruns_nddbs]]'],
    defaultval="Empty",
    mnemonics="GRUNeiSen DDBS",
    added_in_version="before_v9",
    text=r"""
List of strings with the paths of the DDB files used for the calculation of
the Gruneisen parameters. Each string must be enclosed by quotation marks. The
number of DDB files is defined by [[anaddb:gruns_nddbs]] (possible values are:
3,5,7,9) The DDB files correspond to phonon calculations performed at
different volumes (usually ± 1% of the equilibrium volume). The DDB files must
be ordered according to the volume of the unit cell (the DDB with smallest
volume comes first) and the volume increment must be constant. The code
computes the derivative of the dynamical matrix wrt the volume using central finite difference.
""",
),

Variable(
    abivarname="gruns_nddbs@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Temperature_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="GRUNeiSen Number of DDB files",
    added_in_version="before_v9",
    text=r"""
This variable defines the number of DDB files (read from [[anaddb:gruns_ddbs]])
used for the calculation of the Gruneisen parameters.
""",
),

Variable(
    abivarname="iatfix@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions=['[[anaddb:natfix]]'],
    defaultval=0,
    mnemonics="Indices of the AToms that are FIXed",
    added_in_version="before_v9",
    text=r"""
Indices of the atoms that are fixed during a structural relaxation at
constrained polarization. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="iatprj_bs@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions=['[[anaddb:natprj_bs]]'],
    defaultval="0*'[[anaddb:natprj_bs]]'",
    mnemonics="Indices of the AToms for the PRoJection of the phonon Band Structure",
    added_in_version="before_v9",
    text=r"""
Indices of the atoms that are chosen for projection of the phonon
eigenvectors, giving a weighted phonon band structure file.
""",
),

Variable(
    abivarname="ifcana@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="IFC ANAlysis",
    added_in_version="before_v9",
    text=r"""
  * 0 --> no analysis of interatomic force constants;
  * 1 --> analysis of interatomic force constants.

If the analysis is activated, one get the trace of the matrices between pairs
of atoms, if [[anaddb:dipdip]] is 1, get also the trace of the short-range and
electrostatic part, and calculate the ratio with the full matrix; then define
a local coordinate reference (using the next-neighbour coordinates), and
express the interatomic force constant matrix between pairs of atoms in that
local coordinate reference (the first vector is along the bond; the second
vector is along the perpendicular force exerted on the generic atom by a
longitudinal displacement of the neighbouring atom - in case it does not
vanish; the third vector is perpendicular to the two other) also calculate
ratios with respect to the longitudinal force constant ( the (1,1) element of
the matrix in local coordinates).
""",
),

Variable(
    abivarname="ifcflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_compulsory'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Interatomic Force Constants FLAG",
    added_in_version="before_v9",
    text=r"""
  * 0 --> do all calculations directly from the DDB, without the use of the interatomic force constant.
  * 1 --> calculate and use the interatomic force constants for interpolating the phonon spectrum
    and dynamical matrices at every q wavevector, and eventually analyse the interatomic force constants,
    according to the informations given by [[anaddb:atifc]], [[anaddb:dipdip]], [[anaddb:ifcana]], [[anaddb:ifcout]],
    [[anaddb:natifc]], [[anaddb:nsphere]], [[anaddb:rifcsph]]

More detailed explanations: if the dynamical matrices are known on a regular
set of wavevectors, they can be used to get the interatomic forces, which are
simply their Fourier transform. When non-analyticities can been removed by the
use of effective charge at Gamma (option offered by putting [[anaddb:dipdip]] to 1),
the interatomic forces are known to decay rather fast (in real space).

The interatomic forces generated from a small set of dynamical matrices could
be of sufficient range to allow the remaining interatomic forces to be
neglected. This gives a practical way to interpolate the content of a small
set of dynamical matrices, because dynamical matrices can everywhere be
generated starting from this set of interatomic force constants. It is
suggested to always use **ifcflag** =1. The **ifcflag** =0 option is available
for checking purpose, and if there is not enough information in the DDB.
""",
),

Variable(
    abivarname="ifcout@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="IFC OUTput",
    added_in_version="before_v9",
    text=r"""
For each atom in the list [[anaddb:atifc]] (generic atoms), **ifcout** give
the number of neighbouring atoms for which the ifc's will be output (written)
and eventually analysed. The neighbouring atoms are selected by decreasing
distance with respect to the generic atom.
""",
),

Variable(
    abivarname="ifltransport@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="IFLag for TRANSPORT",
    added_in_version="before_v9",
    text=r"""
if **ifltransport** =1 (LOVA) or **ifltransport** =2 (non-LOVA), anaddb calculates the
transport properties: electrical and thermal resistivities from electron-
phonon interactions in the variational approach. If **ifltransport** =3, anaddb
calculates the k-dependent relaxation time. (needs [[anaddb:elphflag]] = 1)
""",
),

Variable(
    abivarname="instrflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Elastic_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="INternal STRain FLAG",
    added_in_version="before_v9",
    text=r"""
Internal strain tensor flag.

  * 0 --> No internal-strain calculation.
  * 1 --> Print out both force-response and displacement-response internal-strain tensor.
    Requirements for preceding response-function DDB generation run: Strain and full atomic-displacement responses.
    Set [[rfstrs]] = 1, 2, or 3 (preferably 3). Set [[rfatpol]] and [[rfdir]] to do a full calculation of phonons at Q=0.
""",
),

Variable(
    abivarname="istrfix@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions=['[[anaddb:nstrfix]]'],
    defaultval=0,
    mnemonics="Index of STRain FIXed",
    added_in_version="before_v9",
    text=r"""
Indices of the elements of the strain tensor that are fixed during a
structural relaxation at constrained polarisation:

  * 0 --> No elastic or compliance tensor will be calculated.
  * 1 --> Only clamped-ion elastic and compliance tensors will be calculated. Requirements for
    preceding response-function DDB generation run: Strain perturbation. Set [[rfstrs]] to 1, 2, or 3.
    Note that [[rfstrs]]>=3 is recommended so that responses to both uniaxial and shear strains will be computed.
  * 2 --> Both relaxed- and clamped-ion elastic and compliance tensor will be calculated, but only
    the relaxed-ion quantities will be printed. The input variable [[anaddb:instrflag]] should also be set to 1,
    because the internal-strain tensor is needed to compute the relaxed-ion corrections.
    Requirements for preceding response-function DDB generation run: Strain and atomic-displacement responses at Q=0.
    Set [[rfstrs]] = 1, 2, or 3 (preferably 3). Set [[rfatpol]] and [[rfdir]] to do a full calculation
    of phonons at Q=0 (needed because the inverse of force-constant tensor is required).
  * 3 --> Both relaxed and clamped-ion elastic and compliance tensors will be printed out.
    The input variable [[anaddb:instrflag]] should also be set to 1.
    Requirements for preceding response-function DDB generation run: Same as for [[anaddb:elaflag]]=2.
  * 4 --> Calculate the elastic and compliance tensors (relaxed ion) at fixed displacement field,
    the relaxed-ion tensors at fixed electric field will be printed out too, for comparison.
    When [[anaddb:elaflag]]=4, we need the information of internal strain and relaxed-ion dielectric tensor
    to build the whole tensor, so we need to set [[anaddb:instrflag]]=1 and [[anaddb:dieflag]]=3 or 4.
  * 5 --> Calculate the relaxed ion elastic and compliance tensors, considering the stress left inside cell.
    At the same time, bare relaxed ion tensors will still be printed out for comparison.
    In this calculation, stress tensor is needed to compute the correction term, so one supposed
    to merge the first order derivative data base (DDB file) with the second order derivative data base (DDB file)
    into a new DDB file, which can contain both information. And the program will also check for the users.

See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="kptrlatt@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_basic', 'PhononWidth_basic'],
    dimensions=[3, 3],
    defaultval="9*0",
    mnemonics="K PoinT Reciprocal LATTice",
    added_in_version="before_v9",
    text=r"""
Unnormalized lattice vectors for the k-point grid in reciprocal space (see
[[kptrlatt]] abinit variable definitionas well). Input needed in electron-phonon
calculations using nesting functions or tetrahedron integration.
""",
),

Variable(
    abivarname="kptrlatt_fine@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_expert'],
    dimensions=[3, 3],
    defaultval="9*0",
    mnemonics="K PoinT Reciprocal LATTice for FINE grid",
    added_in_version="before_v9",
    text=r"""
As kptrlatt above, but for a finer grid of k-points. Under development.
Does not work yet, as of |today|.
""",
),

Variable(
    abivarname="mustar@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0.1,
    mnemonics="MU STAR",
    added_in_version="before_v9",
    text=r"""
Average electron-electron interaction strength, for the computation of the
superconducting Tc using Mc-Millan's formula.
""",
),

Variable(
    abivarname="natfix@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of AToms FIXed",
    added_in_version="before_v9",
    text=r"""
Number of atoms that are fixed during a structural optimisation at constrained
polarization. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="natifc@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of AToms for IFC analysis",
    added_in_version="before_v9",
    text=r"""
Give the number of atoms for which IFCs are written and eventually analysed.
The list of these atoms is provided by [[anaddb:atifc]].
""",
),

Variable(
    abivarname="natprj_bs@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of AToms for PRoJection of the Band Structure",
    added_in_version="before_v9",
    text=r"""
Give the number of atoms for which atomic-projected phonon band structures
will be output. The list of these atoms is provided by [[anaddb:iatprj_bs]].
""",
),

Variable(
    abivarname="nchan@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=800,
    mnemonics="Number of CHANnels",
    added_in_version="before_v9",
    text=r"""
The number of channels of width 1 cm$^{-1}$ used in calculating the phonon density
of states through the histogram method, or, equivalently, the largest
frequency sampled. The first channel begins at 0.
""",
),

Variable(
    abivarname="ndivsm@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic', 'PhononWidth_useful'],
    dimensions="scalar",
    defaultval=20,
    mnemonics="Number of DIVisions for the SMallest segment",
    added_in_version="before_v9",
    text=r"""
This variable defines the number of divisions used to sample the smallest
segment of the q-path used for the phonon band structure. If ndivsm is
specified in the input file, the code will automatically generate the points
along the path using the coordinates given in the array [[anaddb:qpath]].
""",
),

Variable(
    abivarname="nfreq@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="Number of FREQuencies",
    added_in_version="before_v9",
    text=r"""
Number of frequencies wanted for the frequency-dependent dielectric tensor.
Should be positive. See [[anaddb:dieflag]]. The code will take **nfreq**
equidistant values from [[anaddb:frmin]] to [[anaddb:frmax]].
""",
),

Variable(
    abivarname="ng2qpt@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions=[3],
    defaultval="3*0",
    mnemonics="Number of Grids points for Q PoinTs (grid 2)",
    added_in_version="before_v9",
    text=r"""
The Monkhorst-Pack grid linear dimensions, for the finer of the series of fine grids.
Used for the integration of thermodynamical functions (Bose-Einstein distribution) or for the DOS.
""",
),

Variable(
    abivarname="ngqpt@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_basic', 'PhononBands_basic'],
    dimensions=[3],
    defaultval="3*0",
    mnemonics="Number of Grids points for Q PoinTs",
    added_in_version="before_v9",
    text=r"""
The Monkhorst-Pack grid linear dimensions (coarse grid).
Should correspond to the grid of points available in the DDB or to a sub-grid.
""",
),

Variable(
    abivarname="ngrids@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=4,
    mnemonics="Number of GRIDS",
    added_in_version="before_v9",
    text=r"""
This number define the series of grids that will be used for the estimation of
the phonon DOS. The coarsest will be tried first, then the next, ... then the
one described by [[anaddb:ng2qpt]]. The intermediate grids are defined for
igrid=1... **ngrids**, by the numbers ngqpt_igrid(ii)=(ng2qpt(ii)*igrid)/**ngrids**
""",
),

Variable(
    abivarname="nlflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['nonlinear_compulsory'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Non-Linear FLAG",
    added_in_version="before_v9",
    text=r"""
Non-linear properties flag.

  * 0 --> do not compute non-linear properties ;
  * 1 --> the electrooptic tensor, Raman susceptibilities and non-linear optical susceptibilities are calculated;
  * 2 --> only the non-linear optical susceptibilities and first-order changes of the dielectric tensor
    induced by an atomic displacement are calculated;
  * 3 --> only the non-linear optical susceptibility is calculated.
""",
),

Variable(
    abivarname="nph1l@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of PHonons in List 1",
    added_in_version="before_v9",
    text=r"""
The number of wavevectors in phonon list 1, used for interpolation of the
phonon frequencies. The values of these wavevectors will be specified by
[[anaddb:qph1l]]. The dynamical matrix for these wavevectors, obtained either
directly from the DDB - if [[anaddb:ifcflag]]=0 - or through the interatomic
forces interpolation - if [[anaddb:ifcflag]]=1 -), will be diagonalized, and
the corresponding eigenfrequencies will be printed.
""",
),

Variable(
    abivarname="nph2l@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of PHonons in List 2",
    added_in_version="before_v9",
    text=r"""
The number of wavevectors in phonon list 2, defining the directions along
which the non-analytical splitting of phonon frequencies at Gamma will be
calculated. The actual values of the wavevector directions will be specified
by [[anaddb:qph2l]]. These are actually all wavectors at Gamma, but obtained
by a limit along a different direction in the Brillouin-zone. It is important
to note that non-analyticities in the dynamical matrices are present at Gamma,
due to the long-range Coulomb forces. So, going to Gamma along different
directions can give different results.

The wavevectors in list 2 will be used to:

* generate and diagonalize a dynamical matrix, and print the corresponding eigenvalues.
* calculate the generalized Lyddane-Sachs-Teller relation. Note that if the
  three first numbers are zero, then the code will do a calculation at Gamma without non-analyticities.
""",
),

Variable(
    abivarname="nqpath@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic', 'PhononWidth_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of Q wavevectors defining a PATH",
    added_in_version="before_v9",
    text=r"""
Number of q-points in the array [[anaddb:qpath]] defining the path along which
the phonon band structure and phonon linewidths are interpolated.
""",
),

Variable(
    abivarname="nqshft@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="Number of Q SHiFTs",
    added_in_version="before_v9",
    text=r"""
The number of vector shifts of the simple Monkhorst and Pack grid, needed to
generate the coarse grid of q points (for the series of fine grids, the number
of shifts it is always taken to be 1). Usually, put it to 1. Use 2 if BCC
sampling (Warning: not BCC lattice, BCC *sampling*), and 4 for FCC sampling
(Warning: not FCC lattice, FCC *sampling*).
""",
),

Variable(
    abivarname="nsphere@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of atoms in SPHERe",
    added_in_version="before_v9",
    text=r"""
Number of atoms included in the cut-off sphere for interatomic force constant,
see also the alternative [[anaddb:rifcsph]]. If **nsphere** = 0: maximum
extent allowed by the grid. If **nsphere** = -1: the code analyzes different
values of nsphere and find the value that does not lead to unstable
frequencies in a small sphere around Gamma. The truncated IFCs are then used
for further post-processing. The results of the test are reported in the main
output file. This option is useful to obtain a initial guess of nsphere: the
value that leads to stable frequencies and gives linear dispersion for the
acoustic modes around Gamma is usually smaller that the one reported by nsphere -1.

This number defines the atoms for which the short range part of the
interatomic force constants, after imposition of the acoustic sum rule, will
not be put to zero. This option is available for testing purposes (evaluate
the range of the interatomic force constants), because the acoustic sum rule
will be violated if some atoms are no more included in the inverse Fourier Transform.
""",
),

Variable(
    abivarname="nstrfix@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Number of STRain components FIXed",
    added_in_version="before_v9",
    text=r"""
Number of strain component that are fixed during a structural optimisation at
constrained polarization. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="ntemper@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Temperature_basic'],
    dimensions="scalar",
    defaultval=10,
    mnemonics="Number of TEMPERatures",
    added_in_version="before_v9",
    text=r"""
Number of temperatures at which the thermodynamical quantities have to be
evaluated. Now also used for the output of transport quantities in electron-
phonon calculations. The full grid is specified with the [[anaddb:tempermin]]
and [[anaddb:temperinc]] variables. The default temperature grid goes from
100K to 1000K by step of 100K. For the largest temperatures, for most solids,
anharmonic effects not accounted in the harmonic approximation implemented in
anaddb will be important. For weakly bounded systems (e.g. Van der Waals
solids), such anharmonic effects might be important already at room temperature.
""",
),

Variable(
    abivarname="nwchan@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=10,
    mnemonics="Number of Widths of CHANnels",
    added_in_version="before_v9",
    text=r"""
The width of the largest channel used to sample the frequencies. The
code will generate different sets of channels, with decreasing widths (by step
of 1 cm$^{-1}$), from this channel width to 1, eventually. It considers to have
converged when the convergence criterion based on [[anaddb:dostol]] and
[[anaddb:thmtol]] have been fulfilled.
""",
),

Variable(
    abivarname="outboltztrap@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="OUTput files for BOLTZTRAP code",
    added_in_version="before_v9",
    text=r"""
If set to 1, the phonon frequencies on the [[anaddb:ngqpt]] grid are output in a format
legible by the BoltzTrap code, which does band interpolation and gets group
velocities. The output file will be appended _BTRAP
""",
),

Variable(
    abivarname="outscphon@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="OUTput files for Self Consistent PHONons",
    added_in_version="before_v9",
    text=r"""
If set to 1, the phonon frequency and eigenvector files needed for a Self
Consistent phonon run (as in [[cite:Souvatzis2008]]) will be output to
files appended _PHFRQ and _PHVEC. The third file needed is appended _PCINFO
for Primitive Cell INFOrmation.
""",
),

Variable(
    abivarname="piezoflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Elastic_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PIEZOelectric tensor FLAG",
    added_in_version="before_v9",
    text=r"""
Flag for calculation of piezoelectric tensors

  * 0 --> No piezoelectric tensor will be calculated.
  * 1 --> Only the clamped-ion piezoelectric tensor is computed and printed.
    Requirements for preceding response-function DDB generation run: Strain and electric-field responses.
    For the electric-field part, one needs results from a prior 'ddk perturbation' run.
    Note that even if only a limited number of piezoelectric tensor terms are wanted
    (as determined by [[rfstrs]] and [[rfdir]] in this calculation) it is necessary to set [[rfdir]] = 1 1 1
    in the d/dk calculation for most structures. The only obvious exception to this requirement
    is cases in which the primitive lattice vectors are all aligned with the cartesian axes.
    The code will omit terms in the output piezoelectric tensor for which the available d/dk set is incomplete.
    Thus: Set [[rfstrs]] to 1, 2, or 3 (preferably 3)
  * 2 --> Both relaxed- and clamped-ion elastic and compliance tensor will be calculated,
    but only the relaxed-ion quantities will be printed. The input variable [[anaddb:instrflag]]
    should also be set to 1, because the internal-strain tensor is needed to compute the relaxed-ion corrections.
    Requirements for preceding response-function DDB generation run: Strain, electric-field and full atomic-displacement
    responses at Q=0. Set [[rfstrs]] = 1, 2, or 3 (preferably 3). Set [[rfelfd]] = 3.
    Set [[rfatpol]] and <[[rfdir]] to do a full calculation of phonons at Q=0
    (needed because the inverse of force-constant tensor is required).
  * 3 --> Both relaxed and clamped-ion piezoelectric tensors will be printed out.
    The input variable [[anaddb:instrflag]] should also be set to 1.
    Requirements for preceding response-function DDB generation run: Same as for **piezoflag** =2.
  * 4 --> Calculate the piezoelectric d tensor (relaxed ion). In order to calculate the piezoelectric d tensor,
    we need information of internal strain and elastic tensor (relaxed ion).
    So we should set [[anaddb:elaflag]]= 2,3,4, or 5 and [[anaddb:instrflag]]=1.
    The subroutine will also do a check for you, and print warning message without stopping even if flags were not correctly set.
  * 5 --> Calculate the piezoelectric g tensor (relaxed ion). In this computation,
    we need information of internal strain, elastic tensor (relaxed ion) and dielectric tensor (relaxed ion).
    So we should set: [[anaddb:instrflag]]=1, [[anaddb:elaflag]]=2,3,4 or 5, [[anaddb:dieflag]]=3 or 4.
    The subroutine will also do a check for you, and print warning message without stopping even if flags were not correctly set.
  * 6 --> Calculate the piezoelectric h tensor (relaxed ion). In this calculation, we need information
    of internal strain and dielectric tensor (relaxed ion). So we need set: [[anaddb:instrflag]]=1
    and [[anaddb:dieflag]]=3 or 4. The subroutine will also do a check for you, and print warning message
    without stopping even if flags were not correctly set.
  * 7 --> calculate all the possible piezoelectric tensors, including e (clamped and relaxed ion), d, g and h tensors.
    The flags should be set to satisfy the above rules from 1 to 6.
""",
),

Variable(
    abivarname="polflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_compulsory'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="POLarization FLAG",
    added_in_version="before_v9",
    text=r"""
If activated, compute polarization in cartesian coordinates, and update
lattice constants and atomic positions in order to perform a structural
optimization at constrained polarization.

More detailed explanation: ANADDB can use the formalism described in
[[cite:Sai2002]], to perform structural relaxations under the
constraint that the polarization is equal to a value specified by the input
variable [[anaddb:targetpol]]. The user starts from a given configuration of a
crystal and performs a ground-state calculation of the Hellman-Feynman forces
and stresses and the Berry phase polarization as well as a linear response
calculation of the whole matrix of second-order energy derivatives with
respect to atomic displacement, strains and electric field.
In case **polflag** =1, ANADDB solves the linear system of equations (13) in
[[cite:Sai2002]], and computes new atomic positions (if [[anaddb:relaxat]]=1)
and lattice constant (if [[anaddb:relaxstr]]=1). Then, the user uses these
parameters to perform a new ground-state and linear-response calculation. This
must be repeated until convergence is reached. The user can also fix some
atomic positions, or strains, thanks to the input variables [[anaddb:natfix]],
[[anaddb:nstrfix]],[[anaddb:iatfix]],[[anaddb:istrfix]].
In case both [[anaddb:relaxat]] and [[anaddb:relaxstr]] are 0, while
**polflag** =1, ANADDB only computes the polarization in cartesian coordinates.

As described in [[cite:Sai2002]], it is important to use the finite
difference expression of the ddk ([[berryopt]]=2 or -2) in the linear response
calculation of the effective charges and the piezoelectric tensor.
""",
),

Variable(
    abivarname="prt_ifc@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the Interatomic Force Constants",
    added_in_version="before_v9",
    text=r"""
Flag to print out the Interatomic Force Constants in real space to a file.
The available options are:

  * 0 --> do nothing (IFC are printed to the log file);
  * 1 --> write out the IFC in file ifcinfo.out (the name is fixed) to be used by AI2PS from John Rehr's group
""",
),

Variable(
    abivarname="prtbltztrp@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT input files for BoLTZTRaP code.",
    added_in_version="before_v9",
    text=r"""
* 0 --> do not write the BoltzTraP input files;
* 1 --> write out the input files for BoLTZTRaP code.
""",
),

Variable(
    abivarname="prtddb@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the Derivative DataBase files",
    added_in_version="before_v9",
    text=r"""
Flag to print out the DDB file interpolated with the Interatomic Force Constants.

The available options are:

  * 0 --> no output of DDB;
  * 1 --> Interpolate the DDB and write out the DDB and DDB.nc files.
""",
),

Variable(
    abivarname="prtdos@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the phonon Density Of States",
    added_in_version="before_v9",
    text=r"""
The **prtdos** variable is used to calculate the phonon density of states,
PHDOS, by Fourier interpolating the interatomic force constants on the (dense)
q-mesh defined by [[anaddb:ng2qpt]]. Note that the variable [[anaddb:ifcflag]]
must be set to 1 since the interatomic force constants are supposed to be known.

The available options are:

  * 0 --> no output of PHDOS (default);
  * 1 --> calculate PHDOS using the gaussian method and the broadening defined by [[anaddb:dossmear]].
  * 2 --> calculate PHDOS using the tetrahedron method.

The step of the frequency grid employed to calculate the DOS can be defined
through the input variable [[anaddb:dosdeltae]].
""",
),

Variable(
    abivarname="prtfsurf@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the Fermi SURFace",
    added_in_version="before_v9",
    text=r"""
Only for electron-phonon calculations. The available options are:

  * 0 --> do not write the Fermi Surface;
  * 1 --> write out the Fermi Surface in the BXSF format used by [XCrySDen](http://www.xcrysden.org).

Further comments:

a) Only the eigenvalues for k-points inside the Irreducible Brillouin zone are
required. As a consequence it is possible to use [[kptopt]] =1 during the GS
calculation to reduce the computational effort.

b) Only unshifted k-grids that are orthogonal in reduced space are supported
by [XCrySDen](http://www.xcrysden.org). This implies that [[shiftk]] must be
set to (0,0,0) during the GS calculation with [[nshiftk]]=1. Furthermore if
[[kptrlatt]] is used to generate the k-grid, all the off-diagonal elements of
this array must be zero.
""",
),

Variable(
    abivarname="prtmbm@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['nonlinear_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT Mode-By-Mode decomposition of the electrooptic tensor",
    added_in_version="before_v9",
    text=r"""
  * 0 --> do not write the mode-by-mode decomposition of the electrooptic tensor;
  * 1 --> write out the contribution of the individual zone-center phonon modes to the electrooptic tensor.
""",
),

Variable(
    abivarname="prtnest@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the NESTing function",
    added_in_version="before_v9",
    text=r"""
Only for electron-phonon calculations. This input variable is used to
calculate the nesting function defined as:
$$
\chi_{nm}(q) = \sum_k\delta(\epsilon_{k,n}-\epsilon_F) \delta(\epsilon_{k+q,m}-\epsilon_F).
$$

The nesting factor is calculated for every point of the k-grid employed during the
previous GS calculation. The values are subsequently interpolated along the
trajectory in q space defined by [[anaddb:qpath]], and written in the _NEST
file using the X-Y format ( **prtnest** =1). It is also possible to analyze
the behavior of the function in the reciprocal unit cell saving the values in
the NEST_XSF file that can be read using [XCrySDen](http://www.xcrysden.org) (**prtnest** =2).

Note that in the present implementation what is really
printed to file is the "total nesting" defined as $\sum_{nm} \chi_{nm}(q)$.
Limitations: the k-grid defined by [[kptrlatt]] must be orthogonal in
reciprocal space, moreover off-diagonal elements are not allowed, i.e. [[kptrlatt]]
4 0 0 0 4 0 0 0 4 is fine while [[kptrlatt]] = 1 0 0 0 1 1 0 -1 1 will not work.

  * 0 --> do not write the nesting function;
  * 1 --> write only the nesting function along the q-path in the X-Y format;
  * 2 --> write out the nesting function both in the X-Y and in the XSF format.
""",
),

Variable(
    abivarname="prtphbands@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="PRinT PHonon BANDS",
    added_in_version="before_v9",
    text=r"""
Only if [[anaddb:ifcflag]]=1. This option specifies the file format for the
phonon band structure. Possible values:

  * 1 Write frequencies in xmgrace format. A file with extension `PHBANDS.agr` is produced.
     Use `xmgrace file_PHBANDS.agr` to visualize the data
  * 2 Write frequencies in gnuplot format. The code produces a `PHBANDS.dat` file with the eigenvalues
    and a `PHBANDS.gnuplot` script. Use `gnuplot file_PHBANDS.gnuplot` to visualize the phonon band structure.
""",
),

Variable(
    abivarname="prtsrlr@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT the Short-Range/Long-Range decomposition of phonon FREQuencies",
    added_in_version="before_v9",
    text=r"""
Only if [[anaddb:ifcflag]]=1. The available options are:

  * 0 --> do not write the SR/LR decomposition of phonon frequencies;
  * 1 --> write out the SR/LR decomposition of the square of phonon frequencies at each q-point specified in [[anaddb:qph1l]].

For details see [[cite:Ghosez1996]].
See also [[anaddb:ifcflag]], [[anaddb:ifcflag]] and [[anaddb:dipdip]].
""",
),

Variable(
    abivarname="prtvol@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful', 'PhononBands_useful', 'Temperature_useful', 'PhononWidth_useful', 'ElPhonTransport_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="PRinT VOLume",
    added_in_version="before_v9",
    text=r"""
Control the volume of printed output.
""",
),

Variable(
    abivarname="q1shft@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Phonons_useful', 'PhononBands_useful'],
    dimensions=['[[anaddb:nqshft]]'],
    defaultval=0,
    mnemonics="Q shifts for the grid number 1",
    added_in_version="before_v9",
    text=r"""
This vector gives the shifts needed to define the coarse q-point grid.

a) Case [[anaddb:nqshft]]=1 In general, 0.5 0.5 0.5 with the ngqpt's even will give
very economical grids. On the other hand, is it sometimes better for phonons to
have the Gamma point in the grid. In that case, 0.0 0.0 0.0 should be OK. For
the hexagonal lattice, the above mentioned quantities become 0.0 0.0 0.5 and
0.0 0.0 0.0 .

b) Case [[anaddb:nqshft]]=2 The two q1shft vectors must form a BCC lattice. For
example, use 0.0 0.0 0.0 and 0.5 0.5 0.5

c) Case [[anaddb:nqshft]]=4 The four q1shft vectors must form a FCC lattice. For
example, use 0.0 0.0 0.0, 0.0 0.5 0.5, 0.5 0.0 0.5, 0.5 0.5 0.0 or 0.5 0.5 0.5,
0.0 0.0 0.5, 0.0 0.5 0.0, 0.5 0.0 0.0 (the latter is referred to as shifted)

Further comments: by using this technique, it is possible to increase smoothly
the number of q-points, at least less abruptly than relying on series of grids
like (for the full cubic symmetry):

1x1x1 --> (0 0 0)
2x2x2 (shifted) --> (.25 .25 .25)
2x2x2 --> 1x1x1 + (.5 0 0) (.5 .5 0) (.5 .5 0)
4x4x4 --> 2x2x2 + (.25 0 0) (.25 .25 0) (.25 .5 0) (.25 .25 .25) (.25 .25 .5)
(.25 .5 .5)
...

with respectively 1, 1, 4 and 10 q-points, corresponding to a number of points
in the full BZ of 1, 8, 8 and 64. Indeed, the following grids are made
available:
1x1x1 with [[anaddb:nqshft]]=2 --> (0 0 0) (.5 .5 .5)
1x1x1 with [[anaddb:nqshft]]=4 --> (0 0 0) (.5 .5 0)
1x1x1 with [[anaddb:nqshft]]=4 (shifted) --> (.5 0 0) (.5 .5 .5)
2x2x2 with [[anaddb:nqshft]]=2 --> 2x2x2 + (.25 .25 .25)
2x2x2 with [[anaddb:nqshft]]=4 --> 2x2x2 + (.25 .25 0) (.25 .25 .5)
2x2x2 with [[anaddb:nqshft]]=4 (shifted) --> (.25 0 0) (.25 .25 .25) (.5 .5 .25) (.25 .5 0)
...

with respectively 2, 2, 2, 5, 6 and 4 q-points, corresponding to a number of
points in the full BZ of 2, 4, 4, 16, 32 and 32.

For a FCC lattice, it is possible to sample only the Gamma point by using a
1x1x1 BCC sampling ([[anaddb:nqshft]]=2).
""",
),

Variable(
    abivarname="q2shft@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions=[3],
    defaultval="3* 0",
    mnemonics="Q points SHiFTs for the grids 2",
    added_in_version="before_v9",
    text=r"""
Similar to [[anaddb:q1shft]], but for the series of fine grids.

Note that [[anaddb:nqshft]] for this series of grids corresponds to 1.
""",
),

Variable(
    abivarname="qgrid_type@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="Q GRID TYPE",
    added_in_version="before_v9",
    text=r"""
If **qgrid_type** is set to 1, the electron-phonon part of anaddb will use the
[[anaddb:ep_nqpt]] and [[anaddb:ep_qptlist]] variables to determine which
q-points to calculate the electron-phonon coupling for. This is an alternative
to a regular grid as in the rest of anaddb (using [[anaddb:ngqpt]]).
""",
),

Variable(
    abivarname="qpath@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_basic', 'PhononWidth_basic'],
    dimensions=[3, '[[anaddb:nqpath]]'],
    defaultval=0.0,
    mnemonics="Q wavevectors defining a PATH",
    added_in_version="before_v9",
    text=r"""
It is used to generate the path along which the phonon band structure and
phonon linewidths are interpolated. There are [[anaddb:nqpath]]-1 segments to
be defined, each of which starts from the end point of the previous one. The
number of divisions in each segment is automatically calculated inside the
code to respect the proportion between the segments. The same circuit is used
for the output of the nesting function if [[anaddb:prtnest]]=1.
""",
),

Variable(
    abivarname="qph1l@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_basic'],
    dimensions=[4, '[[anaddb:nph1l]]'],
    defaultval=0,
    mnemonics="Q for PHonon List 1",
    added_in_version="before_v9",
    text=r"""
List of [[anaddb:nph1l]] wavevectors, at which the phonon frequencies will be
interpolated. Defined by 4 numbers: the wavevector is made by the three first
numbers divided by the fourth one (a normalisation factor). The coordinates
are defined with respect to the unit vectors that spans the Brillouin zone.
Note that this set of axes can be non-orthogonal and not normed. The
normalisation factor makes easier the input of wavevector such as
(1/3,1/3,1/3), represented by 1.0 1.0 1.0 3.0 .
The internal representation of this array is as follows: for each wavevector,
the three first numbers are stored in the array qph1l(3,nph1l), while the
fourth is stored in the array qnrml1(nph1l).
""",
),

Variable(
    abivarname="qph2l@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_basic'],
    dimensions=[4, '[[anaddb:nph2l]]'],
    defaultval=0,
    mnemonics="PHonon List 2",
    added_in_version="before_v9",
    text=r"""
List of phonon wavevector _directions_ along which the non-analytical
correction to the Gamma-point phonon frequencies will be calculated (for
insulators). Four numbers, as for [[anaddb:qph1l]], but where the last one,
that correspond to the normalisation factor, is 0.0 For the anaddb code, this
has the meaning that the three previous values define a direction. The
direction is in CARTESIAN COORDINATES, unlike the non-Gamma wavevectors
defined in the first list of vectors...

Note that if the three first numbers are zero, then the code will do a
calculation at Gamma without non-analyticities.

Also note that the code automatically sets the imaginary part of the dynamical
matrix to zero. This is useful to compute the phonon frequencies when half of
the k-points has been used, by the virtue of the time-reversal symmetry (which
may induce parasitic imaginary parts...).
The internal representation of this array is as follows: for each wavevector,
the three first numbers are stored in the array qph2l(3,nph2l), while the
fourth is stored in the array qnrml2(nph2l).
""",
),

Variable(
    abivarname="qrefine@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononBands_expert'],
    dimensions=[3],
    defaultval=0,
    mnemonics="Q-point REFINEment order (experimental)",
    added_in_version="before_v9",
    text=r"""
If **qrefine** is superior to 1, attempts to initialize a first set of
dynamical matrices from the DDB file, with a q-point grid which is
[[anaddb:ngqpt]] divided by **qrefine** (e.g. ngqpt 4 4 2 qrefine 2 2 1 starts
with a 2x2x2 grid). The dynamical matrices are interpolated onto the full
[[anaddb:ngqpt]] grid and any additional information found in the DDB file is
imposed, before proceeding to normal band structure and other interpolations.
Should implement Gaal-Nagy's algorithm in [[cite:GaalNagy2006]].
""",
),

Variable(
    abivarname="ramansr@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['nonlinear_basic'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="RAMAN Sum-Rule",
    added_in_version="before_v9",
    text=r"""
Governs the imposition of the sum-rule on the Raman tensors.
As in the case of the Born effective charges, the first-order derivatives of
the linear dielectric susceptibility with respect to an atomic displacement
must vanish when they are summed over all atoms. This sum rule is broken in
most calculations. By putting **ramansr** equal to 1 or 2, this sum rule is
imposed by giving each atom a part of the discrepancy.

  * 0 --> no sum rule is imposed;
  * 1 --> impose the sum rule on the Raman tensors, giving each atom an equal part of the discrepancy;
  * 2 --> impose the sum rule on the Raman tensors, giving each atom a part of the discrepancy
    proportional to the magnitude of its contribution to the Raman tensor.

For the time being, **ramansr** =1 is the preferred choice.
""",
),

Variable(
    abivarname="relaxat@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="RELAXation of AToms",
    added_in_version="before_v9",
    text=r"""
If **relaxat** =1, relax atomic positions during a structural relaxation at
constrained polarization. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="relaxstr@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ConstrainedPol_useful'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="RELAXation of STRain",
    added_in_version="before_v9",
    text=r"""
If **relaxstr** =1, relax lattice constants (lengths/angles) during a
structural relaxation at constrained polarization. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="rfmeth@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_expert'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="Response-Function METHod",
    added_in_version="before_v9",
    text=r"""
Select a particular set of Data Blocks in the DDB. (PRESENTLY, ONLY OPTION 1 IS AVAILABLE)

  * 1 --> Blocks obtained by a non-stationary formulation.
  * 2 --> Blocks obtained by a stationary formulation.

For more detailed explanations, see [[help:abinit]]. If the information in the
DDB is available, always use the option 2. If not, you can try option 1, which is less accurate.
""",
),

Variable(
    abivarname="rifcsph@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions="scalar",
    defaultval="zero",
    mnemonics="Radius of the Interatomic Force Constant SPHere",
    added_in_version="before_v9",
    text=r"""
Cut-off radius for the sphere for interatomic force constant, see also the
alternative [[anaddb:nsphere]]. If **rifcsph** = 0: maximum extent allowed by the grid.

This number defines the atoms for which the short range part of the
interatomic force constants, after imposition of the acoustic sum rule, will
not be put to zero.
""",
),

Variable(
    abivarname="selectz@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="SeLECT Z",
    added_in_version="before_v9",
    text=r"""
Select some parts of the effective charge tensor. (This is done after the
application or non-application of the ASR for effective charges). The
transformed effective charges are then used for all the subsequent
calculations.

  * 0 --> The effective charge tensor is left as it is.
  * 1 --> For each atom, the effective charge tensor is made isotropic, by calculating the
    trace of the matrix, dividing it by 3, and using this number in a diagonal effective charge tensor.
  * 2 --> For each atom, the effective charge tensor is made symmetric, by simply averaging on symmetrical elements.

Note: this is for analysis the effect of anisotropy in the effective charge.
The result with non-zero **selectz** are unphysical.
""",
),

Variable(
    abivarname="symdynmat@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_useful', 'PhononBands_useful'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="SYMmetrize the DYNamical MATrix",
    commentdefault="(was 0 before v5.3)",
    added_in_version="before_v9",
    text=r"""
If **symdynmat** is equal to 1, the dynamical matrix is symmetrized before the diagonalization.
This is especially useful when the set of primitive vectors of the unit cell
and their opposite do not reflect the symmetries of the Bravais lattice
(typical case: body-centered tetragonal lattices ; FCC and BCC lattices might
be treated with the proper setting of the [[anaddb:brav]] variable), and the
interpolation procedure based on interatomic force constant is used: there are
some slight symmetry breaking effects. The latter can be bypassed by this additional symmetrization.
""",
),

Variable(
    abivarname="symgkq@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonInt_expert'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="SYMmetrize the GKk matrix elements for each Q",
    added_in_version="before_v9",
    text=r"""
If **symgkq** is equal to 1, the electron-phonon matrix elements are
symmetrized over the small group of the q-point they correspond to. This
should always be used, except for debugging or test purposes.
""",
),

Variable(
    abivarname="targetpol@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['ConstrainedPol_useful'],
    dimensions=[3],
    defaultval=0.0,
    mnemonics="TARGET POLarization",
    added_in_version="before_v9",
    text=r"""
Target value of the polarization in cartesian coordinates and in C/m$^2$. See [[anaddb:polflag]].
""",
),

Variable(
    abivarname="telphint@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['ElPhonTransport_basic', 'PhononWidth_basic'],
    dimensions="scalar",
    defaultval=1,
    mnemonics="Technique for ELectron-PHonon INTegration",
    added_in_version="before_v9",
    text=r"""
Flag controlling the Fermi surface integration technique used for electron-phonon quantities.

  * 0 = tetrahedron method (no adjustable parameter)
  * 1 = Gaussian smearing (see [[anaddb:elphsmear]])
  * 2 = uniformly weighted band window between [[anaddb:ep_b_min]] and [[anaddb:ep_b_max]], for all k-points
""",
),

Variable(
    abivarname="temperinc@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Temperature_basic'],
    dimensions="scalar",
    defaultval=100.0,
    mnemonics="TEMPERature INCrease",
    added_in_version="before_v9",
    text=r"""
Increment of the temperature in Kelvin, for thermodynamical and el-phon
transport properties. See the associated [[anaddb:tempermin]] and
[[anaddb:ntemper]] variables. The default temperature grid goes from 100K to
1000K by step of 100K. For the largest temperatures, for most solids,
anharmonic effects not accounted in the harmonic approximation implemented in
anaddb will be important. For weakly bounded systems (e.g. Van der Waals
solids), such anharmonic effects might be important already at room temperature.
""",
),

Variable(
    abivarname="tempermin@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Temperature_basic'],
    dimensions="scalar",
    defaultval=100.0,
    mnemonics="TEMPERature MINimum",
    added_in_version="before_v9",
    text=r"""
Lowest temperature (Kelvin) at which the thermodynamical quantities have to be
evaluated. Cannot be zero when [[anaddb:thmflag]] is 1.

The highest temperature is defined using [[anaddb:temperinc]] and
[[anaddb:ntemper]]. The default temperature grid goes from 100K to 1000K by
step of 100K. For the largest temperatures, for most solids, anharmonic
effects not accounted in the harmonic approximation implemented in anaddb will
be important. For weakly bounded systems (e.g. Van der Waals solids), such
anharmonic effects might be important already at room temperature.
""",
),

Variable(
    abivarname="thermal_supercell@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Phonons_expert'],
    dimensions=[3, 3],
    defaultval="(/(/0,0,0/),  (/0,0,0/),  (/0,0,0/)/)",
    mnemonics="THERMALized SUPERCELL lattice vectors",
    characteristics=['[[DEVELOP]]'],
    commentdefault="do not calculate any thermalized supercells",
    added_in_version="before_v9",
    text=r"""
Thermal_supercell defines the real space supercell in which a thermalized
atomic configuration should be produced, following the prescription of
[[cite:Zacharias2016]]. The displacements are chosen
for each phonon mode according to a temperature, and the displacements are
alternated in sign/direction to obtain maximal compensation of the linear
electron phonon coupling. In this way in [[cite:Zacharias2016]] dielectric properties at
finite T can be obtained from a single supercell calculation instead of lots
of MD and configuration averaging.

The supercell vectors are not constrained to be collinear with the normal
lattice vectors: this effect is obtained by using a diagonal
thermal_supercell. The lines of the matrix describe the linear combination of
the primitive cell lattice vectors yielding the supercell vectors, as for [[kptrlatt]].

For the moment this feature is under development and it looks like the
relative phases of the displacements are not fixed properly yet... (Aug 2017)
""",
),

Variable(
    abivarname="thmflag@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['Temperature_compulsory'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="THerMal FLAG",
    added_in_version="before_v9",
    text=r"""
Flag controlling the calculation of thermal quantities.

  * When **thmflag** == 1, the code will compute, using the histogram method:
    * the normalized phonon DOS
    * the phonon internal energy, free energy, entropy, constant volume heat capacity as a function of the temperature
    * the Debye-Waller factors (tensors) for each atom, as a function of the temperature
    * the mean-square velocity tensor for each atom, as a function of temperature
    * the "average frequency" as a function of the temperature
  * When **thmflag** == 2, all the phonon frequencies for the q points in the second grid are printed.
  * When **thmflag** == 3, 5 or 7, the thermal corrections to the electronic eigenvalues are calculated. If **thmflag** ==3, the list of phonon wavevector from the first list is used (with equal weight for all wavevectors in this list), while if **thmflag** ==5 or 7, the first grid of wavevectors is used, possibly folded to the irreducible Brillouin Zone if symmetry operations are present, or if they are recomputed (this happens for **thmflag** ==7).
  * When **thmflag** == 4 or 6, the temperature broadening (electron lifetime) of the electronic eigenvalues is calculated. If **thmflag** ==4, the list of phonon wavevector from the first list is used (with equal weight for all wavevectors in this list), while if **thmflag** ==6, the first grid of wavevectors is used, possibly folded to the irreducible Brillouin Zone if symmetry operations are present or if they are recomputed (this happens for **thmflag** ==8).

WARNING: The use of symmetries for the temperature dependence of the
eigenenergies is tricky ! It can only be valid for the k points that respect
the symmetries (i.e. the Gamma point), provided one also averages over the
degenerate states.

Input variables that may be needed if this flag is activated:
[[anaddb:dostol]], [[anaddb:nchan]], [[anaddb:ntemper]], [[anaddb:temperinc]],
[[anaddb:tempermin]], as well as the wavevector grid number 2 definition,
[[anaddb:ng2qpt]], [[anaddb:ngrids]], [[anaddb:q2shft]].
""",
),

Variable(
    abivarname="thmtol@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['Temperature_useful'],
    dimensions="scalar",
    defaultval=0.05,
    mnemonics="THerModynamic TOLerance",
    added_in_version="before_v9",
    text=r"""
The relative tolerance on the thermodynamical functions This number will
determine when the series of channel widths with which the DOS is calculated
can be stopped, i.e. the mean of the relative change going from one grid to
the next bigger is smaller than **thmtol**.
""",
),

Variable(
    abivarname="use_k_fine@anaddb",
    varset="anaddb",
    vartype="integer",
    topics=['PhononWidth_expert'],
    dimensions="scalar",
    defaultval=0,
    mnemonics="USE K-grid FINEr than the coarse k-grid",
    added_in_version="before_v9",
    text=r"""
When set, [[anaddb:kptrlatt_fine]] is suggested to be given. For the present
version, both eigenvalues (denser grid GKK, obtained from mrggkk with only the
GS WFK file) and electronic velocities(GKK files from DDK calculation) are
needed. Note that the coarse k-grid must be a subset of the fine k-grid.
""",
),

Variable(
    abivarname="vs_qrad_tolkms@anaddb",
    varset="anaddb",
    vartype="real",
    topics=['PhononBands_useful'],
    dimensions=[2],
    defaultval="2*0.0d0",
    mnemonics="Speed of Sound Q-radius, TOLerance KiloMeter/Second",
    added_in_version="before_v9",
    text=r"""
This variable activates the calculation of the speed of sound (requires
[[anaddb:ifcflag]] = 1). The first entry of the array defines the radius of
the small sphere around the Gamma point (Bohr$^{-1}$). The second entry gives the
absolute tolerance in kilometer/second. The speed of sound is evaluated by
performing a spherical average on the small sphere using Lebedev-Laikov grids
(typical values for q-radius: 0.1 Bohr$^{-1}$) The number of radial points is
increased until the integration converges twice withing the tolerance
specified by the user (typical values for tolkms: 0.05 km/s).

The default values will not work.
""",
),

# ABINIT 9
Variable(
    abivarname="ddb_filepath@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Control_useful'],
    dimensions="scalar",
    defaultval="",
    mnemonics="DDB PATH",
    added_in_version="9.0.0",
    text=r"""
This variable specifies the input DDB file when anaddb is invoked with the new syntax:

    anaddb t01.in > log 2> err

instead of the legacy mode based on the files file. Example:

    ddb_filepath = "out_DDB"

!!! important

    Shell variables e.g. $HOME or tilde syntax `~` for user home are not supported.
""",
),

Variable(
    abivarname="output_file@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Control_useful'],
    dimensions="scalar",
    defaultval="",
    mnemonics="OUTPUT FILE",
    added_in_version="9.0.0",
    text=r"""
This variable specifies the name of the output file when anaddb is invoked with the new syntax:

    anaddb t01.in > log 2> err

instead of the legacy mode based on the files file. Example:

    output = "t01.out"
""",
),

#Variable(
#    abivarname="md_output@anaddb",
#    varset="anaddb",
#    vartype="string",
#    topics=['Control_useful'],
#    dimensions="scalar",
#    defaultval="",
#    mnemonics="Molecular Dynamics OUTPUT",
#    text=r"""
#This variable specifies the name of the MD output file when anaddb is invoked with the new syntax:
#
#    anaddb t01.in > log 2> err
#
#instead of the legacy mode based on the files file.
#Note This variable is optional and used ...
#""",
#),

Variable(
    abivarname="gkk_filepath@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Control_useful'],
    dimensions="scalar",
    defaultval="",
    mnemonics="GKK PATH",
    added_in_version="9.0.0",
    text=r"""
This variable specifies the name of the GKK file when anaddb is invoked with the new syntax:

    anaddb t01.in > log 2> err

instead of the legacy mode based on the files file.
This variable is optional and used for performing EPH calculation with [[elphflag@anaddb]].
""",
),

Variable(
    abivarname="eph_prefix@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Control_useful'],
    dimensions="scalar",
    defaultval="",
    mnemonics="EPH PREFIX",
    added_in_version="9.0.0",
    text=r"""
This variable specifies the prefix for the elphon output files when anaddb is invoked with the new syntax:

    anaddb t01.in > log 2> err

instead of the legacy mode based on the files file.
This variable is optional and used for performing EPH calculation with [[elphflag@anaddb]].
""",
),

Variable(
    abivarname="ddk_filepath@anaddb",
    varset="anaddb",
    vartype="string",
    topics=['Control_useful'],
    dimensions="scalar",
    defaultval="",
    mnemonics="DDK PATH",
    added_in_version="9.0.0",
    text=r"""
This variable specifies the name of the input file from which the list of 3 files containing the matrix
elements of the velocity operator are obained

This option is needed when anaddb is invoked with the new syntax:

    anaddb t01.in > log 2> err

instead of the legacy mode based on the files file.
This variable is optional and used for performing transport calculations with [[elphflag@anaddb]].

Example:

    ddk_filepath = "t94.ddk"

where t94.ddk contains the list of file names.

    t90o_DS10_GKK4
    t90o_DS10_GKK5
    t90o_DS10_GKK6
""",
),

]
