![analysis domains encompassed by BESOS.](images/besos.png)


BESOS: Building and Energy Systems Optimization and Surrogate-modelling
=====

[![PyPI Latest Release](https://img.shields.io/pypi/v/besos.svg)](https://pypi.org/project/besos/)
[![PyPi Package format](https://img.shields.io/pypi/format/besos)](https://pypi.org/project/besos/)
[![PyPI Downloads](https://img.shields.io/pypi/dm/besos)](https://pypi.org/project/besos/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

[![Documentation](https://img.shields.io/readthedocs/besos)](https://besos.readthedocs.io/en/stable/)

[![pipeline status](https://gitlab.com/energyincities/besos/badges/master/pipeline.svg)](https://gitlab.com/energyincities/besos/-/commits/master)
[![Coverage](https://gitlab.com/energyincities/besos/badges/master/coverage.svg)](https://gitlab.com/energyincities/besos/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)

BESOS is a collection of modules for the simulation and optimization of buildings and urban energy systems. BESOS is designed to help researchers and practitioners to design more sustainable, district-integrated buildings. It integrates [EnergyPlus](https://energyplus.net/) and [EnergyHub](https://gitlab.com/energyincities/python-ehub) simulation software with optimization and machine learning functionality. this includes lots of help with 'surrogate modelling', where machine learning models are fitted to data generated by parametric runs of detailed simulation models. BESOS facilitates running large-scale parametric analyses of EnergyPlus or EnergyHub models with output in a pandas DataFrame and using this to train machine learning surrogate models with scikit-learn or TensorFlow. We provide access to commonly used optimization algorithms via existing optimization toolboxes.

Installing BESOS
------------
Ensure that you have Python 3.7+ and the corresponding version of pip.
```pip install besos[complete]```
(If you do not want to run the example notebooks, you can use `pip install besos`, which will
install with less dependencies.)

### Install Dependencies
We use third party software to run building models (`EnergyPlus`), to solve EnergyHub models (a MILP solver), and make use of Rbfopt (via `Bonmin`). To use this functionality you need to install the software for the corresponding the task. GLPK and Bonmin are optional, it is possible to use Besos without them.


#### Install Energyplus
Download EnergyPlus [here](https://energyplus.net/downloads). (`BESOS` is currently supporting versions from 8.8-9.3+).

**For windows**: After downloading the installation file, double click the setup file to start installing.
After setup is complete, navigate to your `System Properties` and in the `Advanced` tab, select `Environment Variables`.
 In either your `User Variables` or `System Variables` (Depending on your permissions), double click on `Path`
 and add the location of your `EnergyPlus` folder to the end of it.

**For linux**: Run the downloaded script, and accept the prompt to add symlinks.

#### Optional: MILP solver
[EnergyHub](https://gitlab.com/energyincities/python-ehub) modelling requires a linear programming solver that is supported by [PuLP](https://pypi.org/project/PuLP/), such as `GLPK`, `CPlex`, or `Gurobi`.

`GLPK` is free and open source. It can be found [here](https://www.gnu.org/software/glpk/).
If you are using a Debian based operating system, you can install GLPK with `sudo apt install glpk-utils`

#### Optional: Bonmin
`Bonmin` is required to use the `RBFopt` optimizer.
How to install `Bonmin` can be found [here](https://ampl.com/products/solvers/open-source/#bonmin).

### Running Example Notebooks
Examples of Besos' functionality are provided through example notebooks. The notebooks can be viewed as Python scripts or through a Jupyter notebook.

You can run notebooks from the [Besos platform](https://besos.uvic.ca/), which has the besos library and all dependencies pre-installed, or you can install Jupyter locally.

To run the notebooks you need [Juptyer](https://jupyter.org/) installed. Jupyter can be installed using: `pip install juptyer` and launched from the current directory with `jupyter notebook`.

Contributing and Support
------------
When creating gitlab issues, please search the existing
[gitlab issues](https://gitlab.com/energyincities/besos/-/issues)
to see if someone else has already made the same request.

### Feature Requests
To request a feature open a new issue with your feature request.

### Bug reports/Questions
If you have found a bug, please open a gitlab issue describing the bug.
Make sure to include steps to reproduce the bug. Ideally, include a small
bit of code that causes the bug. If the bug causes an error, please include
the traceback. If the bug causes the wrong behaviour, please mention what
besos should do in this situation.

### Code contributions

If you are making a new feature, first install besos locally, and make a feature branch off of dev.
(If you are fixing a bug branch off of the master branch.) Once you have written your code, test and format it, then submit a merge request.  
These steps are described in more detail below.

#### Development Installation
You will need python 3 and git installed in order to install besos.

Download the repo:
```
git clone https://gitlab.com/energyincities/besos.git
cd besos
git checkout dev
```
Set up a virtual environment (optional but recommended):
```
python3 -m venv venv
source venv/bin/activate
```
Install besos in editable mode, with development dependencies:
```
pip install -e .
pip install -r environments/requirements-dev.txt
pre-commit install
```

Install the libraries needed for Besos to run:

Install Bonmin.
Can be found [here](https://ampl.com/products/solvers/open-source/#bonmin).

Also install GLPK or another Pulp supporting solver.
Can be found [here](https://www.gnu.org/software/glpk/).
If you are using Debian, you can install GLPK with `sudo apt install glpk-utils`

#### Feature branches
To create an feature branch from dev, use
```
git checkout dev
git pull
git checkout -b <your-branch-name>
```

#### Testing and Formatting

You can run the tests using `pytest`, and format code using `black .`
(both from the besos root directory.) Tests and formatting will also be run automatically by
gitlab-ci on any merge request. Every month the master branch also runs all example notebooks.

### Design Notes

The primary purpose of these tools is to facilitate combining building
simulation tools, machine learning techniques, and optimisation algorithms.
It does not attempt to provide new tools in any of these domains.

Two dimensional data should be stored in or converted to a DataFrame
where possible, especially for user facing data.

Reasonable defaults should be available where possible.

There should be simple versions of core features available
which can be used out of the box.

Program Details
---------------

### Example notebooks
A good way to start is using the example notebooks.
They are described in the [examples overview](examples/ExamplesOverview.ipynb)
