"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ens_generated_1 = require("./ens.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return ens_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::ENS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::ENS::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new ens_generated_1.RosInstance(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            privateIpAddress: props.privateIpAddress,
            userData: props.userData,
            ipType: props.ipType,
            systemDiskSize: props.systemDiskSize,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            quantity: props.quantity,
            internetChargeType: props.internetChargeType,
            instanceName: props.instanceName,
            uniqueSuffix: props.uniqueSuffix,
            imageId: props.imageId,
            paymentType: props.paymentType,
            dataDiskSize: props.dataDiskSize,
            instanceType: props.instanceType,
            ensRegionId: props.ensRegionId,
            hostName: props.hostName,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrAutoRenew = rosInstance.attrAutoRenew;
        this.attrAutoRenewPeriod = rosInstance.attrAutoRenewPeriod;
        this.attrDataDiskSize = rosInstance.attrDataDiskSize;
        this.attrEnsRegionId = rosInstance.attrEnsRegionId;
        this.attrHostName = rosInstance.attrHostName;
        this.attrImageId = rosInstance.attrImageId;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrInstanceType = rosInstance.attrInstanceType;
        this.attrInternetChargeType = rosInstance.attrInternetChargeType;
        this.attrIpType = rosInstance.attrIpType;
        this.attrKeyPairName = rosInstance.attrKeyPairName;
        this.attrPaymentType = rosInstance.attrPaymentType;
        this.attrPeriod = rosInstance.attrPeriod;
        this.attrPrivateIpAddress = rosInstance.attrPrivateIpAddress;
        this.attrPrivateIps = rosInstance.attrPrivateIps;
        this.attrPublicIps = rosInstance.attrPublicIps;
        this.attrQuantity = rosInstance.attrQuantity;
        this.attrSystemDiskSize = rosInstance.attrSystemDiskSize;
        this.attrUniqueSuffix = rosInstance.attrUniqueSuffix;
        this.attrUserData = rosInstance.attrUserData;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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