# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['indata',
 'indata.dataio',
 'indata.exception',
 'indata.plot',
 'indata.table',
 'indata.utils']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.22.3,<2.0.0',
 'pandas>=1.4.2,<2.0.0',
 'plotly>=5.7.0,<6.0.0',
 'tabulate>=0.8.9,<0.9.0']

setup_kwargs = {
    'name': 'indata',
    'version': '1.0.1',
    'description': 'A tool in order to easily generate data quality reports from ABTs, visualize data and manipulate the ABT (analytics base table)',
    'long_description': '[![Author][contributors-shield]][contributors-url]\n[![Apache 2.0 License][license-shield]][license-url]\n![Version][version-shield]\n![example workflow](https://github.com/RaphSku/indata/actions/workflows/ci.yml/badge.svg)\n[![InData CD](https://github.com/RaphSku/indata/actions/workflows/cd.yml/badge.svg)](https://github.com/RaphSku/indata/actions/workflows/cd.yml)\n\n# indata\nInData is a concise project which enables the user to generate data quality reports with ease and also other data exploration and data visualization tools are available\n\n### Goal\nInData should primarily enable the fast generation of data quality reports for continous and categorical features. Additionally, data visualisation tools are integrated which can help to find patterns faster in data.\n\n### How to install it\n1. `pip install indata`\n\n### How to use it\nIf you want to have more insight into how this library works, then I would advise you to look at the numerous unit tests and see how it is used there.\nFor quick starters, you will have to undertake the following steps in order to use this library:\n\n1. You have to specify where your data is via\n\n```python\ndataset    = load.DataSet("./data.csv")\n```\n\n2. Then you have to load the data into the Dataloader\n\n```python\ndataloader = load.DataLoader(dataset)\n```\n\n3. Now you can create an instance of a DataQualityTable\n\n```python\nanalytics_table = dqt.DataQualityTable(dataloader)\n```\n\n4. (optional) You can have a look at the columns and their specifications\n\n```python \nanalytics_table.print_header_infos()\n```\n\n5. Define which columns in your data refer to continuous and which to categorical features\n\n```python \ncontinuous_features  = ["Popularity", "Vote_Count", "Vote_Average"]\ncategorical_features = ["Release_Date", "Title", "Overview", "Original_Language", "Genre", "Poster_Url"]\n```\n\n6. Now you are ready to create the data quality report/table for the continuous and categorical features. If you only want the respective table for either categorical features or continuous features, then just pass an empty list to this method:\n\n```python\ndqt_cont, dqt_catg = analytics_table.create_table(continuous_features = continuous_features,\n                                                  categorical_features = categorical_features,\n                                                  store_json_dir = "./dqt")\n```\n\n### Results\nIn this case, I want to show some results which I got when using this library on a movie dataset which contains different movie titles and their popularity.\n\nWe get the following data quality report for the continuous features of that dataset:\n```json\n{\n    "Count": {\n        "Popularity": 9827,\n        "Vote_Count": 9827,\n        "Vote_Average": 9827\n    },\n    "Miss. %": {\n        "Popularity": 0.1016570093,\n        "Vote_Count": 0.1016570093,\n        "Vote_Average": 0.1016570093\n    },\n    "Card.": {\n        "Popularity": 8160,\n        "Vote_Count": 3267,\n        "Vote_Average": 75\n    },\n    "Min": {\n        "Popularity": 7.1,\n        "Vote_Count": 7.1,\n        "Vote_Average": 7.1\n    },\n    "1st Qrt.": {\n        "Popularity": 16.1275,\n        "Vote_Count": 16.1275,\n        "Vote_Average": 16.1275\n    },\n    "mean": {\n        "Popularity": 40.3205699603,\n        "Vote_Count": 40.3205699603,\n        "Vote_Average": 40.3205699603\n    },\n    "median": {\n        "Popularity": 21.191,\n        "Vote_Count": 21.191,\n        "Vote_Average": 21.191\n    },\n    "3rd Qrt.": {\n        "Popularity": 35.1745,\n        "Vote_Count": 35.1745,\n        "Vote_Average": 35.1745\n    },\n    "Max": {\n        "Popularity": 5083.954,\n        "Vote_Count": 5083.954,\n        "Vote_Average": 5083.954\n    },\n    "Std. Dev.": {\n        "Popularity": 108.8743077303,\n        "Vote_Count": 108.8743077303,\n        "Vote_Average": 108.8743077303\n    }\n}\n```\n\nAnd a data quality report for the categorical features:\n```json\n{\n    "Count": {\n        "Release_Date": 9837,\n        "Title": 9828,\n        "Overview": 9828,\n        "Original_Language": 9827,\n        "Genre": 9826,\n        "Poster_Url": 9826\n    },\n    "Miss. %": {\n        "Release_Date": 0.0,\n        "Title": 0.0914913083,\n        "Overview": 0.0914913083,\n        "Original_Language": 0.1016570093,\n        "Genre": 0.1118227102,\n        "Poster_Url": 0.1118227102\n    },\n    "Card.": {\n        "Release_Date": 5903,\n        "Title": 9514,\n        "Overview": 9823,\n        "Original_Language": 44,\n        "Genre": 2337,\n        "Poster_Url": 9826\n    },\n    "Mode": {\n        "Release_Date": "2022-03-10",\n        "Title": "Beauty and the Beast",\n        "Overview": "Dr. Raichi is one of the only survivors of the Tuffles, a race that once lived on Planet Plant before the coming of the Saiyans. The Saiyans not only massacred the entire Tuffle race, but also stole their technology and conquered the planet, renaming it Planet Vegeta in honor of their king. Raichi managed to escape with a capsule and found refuge on the Dark Planet, a world at the end of the universe. His only wish is to eradicate the last remaining Saiyans.",\n        "Original_Language": "en",\n        "Genre": "Drama",\n        "Poster_Url": "https:\\/\\/image.tmdb.org\\/t\\/p\\/original\\/1g0dhYtq4irTY1GPXvft6k4YLjm.jpg"\n    },\n    "Mode Freq.": {\n        "Release_Date": 16,\n        "Title": 4,\n        "Overview": 2,\n        "Original_Language": 7569,\n        "Genre": 466,\n        "Poster_Url": 1\n    },\n    "Mode Freq. %": {\n        "Release_Date": 0.1626512148,\n        "Title": 0.0407000407,\n        "Overview": 0.0203500204,\n        "Original_Language": 77.0224890608,\n        "Genre": 4.7425198453,\n        "Poster_Url": 0.0101770812\n    },\n    "2nd Mode": {\n        "Release_Date": "2022-03-09",\n        "Title": "Alice in Wonderland",\n        "Overview": "Wilbur the pig is scared of the end of the season, because he knows that come that time, he will end up on the dinner table. He hatches a plan with Charlotte, a spider that lives in his pen, to ensure that this will never happen.",\n        "Original_Language": "ja",\n        "Genre": "Comedy",\n        "Poster_Url": "https:\\/\\/image.tmdb.org\\/t\\/p\\/original\\/deOzvJHnSSl8FI1HEJjPGgOsS9U.jpg"\n    },\n    "2nd Mode Freq.": {\n        "Release_Date": 15,\n        "Title": 4,\n        "Overview": 2,\n        "Original_Language": 645,\n        "Genre": 403,\n        "Poster_Url": 1\n    },\n    "2nd Mode Freq. %": {\n        "Release_Date": 0.1524855139,\n        "Title": 0.0407000407,\n        "Overview": 0.0203500204,\n        "Original_Language": 6.5635494047,\n        "Genre": 4.1013637289,\n        "Poster_Url": 0.0101770812\n    }\n}\n```\n\nFurthermore, when using the visualisation tools from this package, then these plots will be stored as `html` files in the directory you specified, it is stored as html files such that you can inspect the plot in more detail, thus it is an interactive plot.\n  \n[contributors-url]: https://github.com/RaphSku\n[license-url]: https://github.com/RaphSku/indata/blob/main/LICENSE\n\n[contributors-shield]: https://img.shields.io/badge/Author-RaphSku-orange?style=plastic&labelColor=black\n[license-shield]: https://img.shields.io/badge/License-Apache%202.0-informational?style=plastic&labelColor=black\n[version-shield]: https://img.shields.io/badge/Version-1.0.0-red?style=plastic&labelColor=black\n',
    'author': 'RapSku',
    'author_email': 'rapsku.dev@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/RaphSku/indata',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
