A python library for getting Load Shedding schedules from Eskom.

## Example

Get a list of supported proivders
```py
providers = list(Provider)
```

Select and instantiate a `provider`
```py
provider = Provider.ESKOM()
```

Call `get_areas`, `get_schedule` or `get_stage` passing in the instantiated `provider`.
```py 
stage = get_stage(Provider.ESKOM())
```

```py
search = "Milnerton"

logging.log(logging.INFO, f"Searching for: {search}")

areas = get_areas(provider, search_text=search, max_results=25)

logging.log(logging.INFO, f"Found: {areas}".format(
    areas=",".join([str(area) for area in areas])
))
```

```py
area = areas[0]
schedule = get_schedule(provider, area=area, stage=Stage.STAGE_2)

logging.log(logging.INFO, f"Schedule for {area.name} ({area.id}): {schedule}")
...
```

## Output

A list of tuples containing `(start, end)` times is returned.

```py
Searching for: Milnerton
Found: [Suburb(1058852, Milnerton, City of Cape Town, Western Cape, 703), Suburb(1058853, Milnerton Golf Course, City of Cape Town, Western Cape, 0), Suburb(1058854, Milnerton Outlying, City of Cape Town, Western Cape, 0), Suburb(1058855, Milnerton Ridge, City of Cape Town, Western Cape, 703), Suburb(1058856, Milnerton SP, City of Cape Town, Western Cape, 2812), Suburb(1069144, Milnerton SP 1, City of Cape Town, Western Cape, 3515), Suburb(1069145, Milnerton SP 2, City of Cape Town, Western Cape, 703)]
Schedule for Milnerton (1058852): [['2022-07-02T00:00:00+00:00', '2022-07-02T02:30:00+00:00'], ['2022-07-03T00:00:00+00:00', '2022-07-03T02:30:00+00:00'], ['2022-07-03T08:00:00+00:00', '2022-07-03T10:30:00+00:00'], ['2022-07-04T08:00:00+00:00', '2022-07-04T10:30:00+00:00'], ['2022-07-04T16:00:00+00:00', '2022-07-04T18:30:00+00:00'], ['2022-07-05T14:00:00+00:00', '2022-07-05T16:30:00+00:00'], ['2022-07-05T22:00:00+00:00', '2022-07-06T00:30:00+00:00'], ['2022-07-06T22:00:00+00:00', '2022-07-07T00:30:00+00:00'], ['2022-07-07T06:00:00+00:00', '2022-07-07T08:30:00+00:00'], ['2022-07-08T06:00:00+00:00', '2022-07-08T08:30:00+00:00'], ['2022-07-08T14:00:00+00:00', '2022-07-08T16:30:00+00:00'], ['2022-07-09T12:00:00+00:00', '2022-07-09T14:30:00+00:00'], ['2022-07-09T20:00:00+00:00', '2022-07-09T22:30:00+00:00'], ['2022-07-10T20:00:00+00:00', '2022-07-10T22:30:00+00:00'], ['2022-07-11T04:00:00+00:00', '2022-07-11T06:30:00+00:00'], ['2022-07-12T04:00:00+00:00', '2022-07-12T06:30:00+00:00'], ['2022-07-12T12:00:00+00:00', '2022-07-12T14:30:00+00:00'], ['2022-07-13T10:00:00+00:00', '2022-07-13T12:30:00+00:00'], ['2022-07-13T18:00:00+00:00', '2022-07-13T20:30:00+00:00'], ['2022-07-14T18:00:00+00:00', '2022-07-14T20:30:00+00:00'], ['2022-07-15T02:00:00+00:00', '2022-07-15T04:30:00+00:00'], ['2022-07-16T02:00:00+00:00', '2022-07-16T04:30:00+00:00'], ['2022-07-16T10:00:00+00:00', '2022-07-16T12:30:00+00:00'], ['2022-07-17T08:00:00+00:00', '2022-07-17T10:30:00+00:00'], ['2022-07-17T16:00:00+00:00', '2022-07-17T18:30:00+00:00'], ['2022-07-18T16:00:00+00:00', '2022-07-18T18:30:00+00:00'], ['2022-07-19T00:00:00+00:00', '2022-07-19T02:30:00+00:00'], ['2022-07-20T00:00:00+00:00', '2022-07-20T02:30:00+00:00'], ['2022-07-20T08:00:00+00:00', '2022-07-20T10:30:00+00:00'], ['2022-07-21T06:00:00+00:00', '2022-07-21T08:30:00+00:00'], ['2022-07-21T14:00:00+00:00', '2022-07-21T16:30:00+00:00'], ['2022-07-22T14:00:00+00:00', '2022-07-22T16:30:00+00:00'], ['2022-07-22T22:00:00+00:00', '2022-07-23T00:30:00+00:00'], ['2022-07-23T22:00:00+00:00', '2022-07-24T00:30:00+00:00'], ['2022-07-24T06:00:00+00:00', '2022-07-24T08:30:00+00:00'], ['2022-07-25T04:00:00+00:00', '2022-07-25T06:30:00+00:00'], ['2022-07-25T12:00:00+00:00', '2022-07-25T14:30:00+00:00'], ['2022-07-26T12:00:00+00:00', '2022-07-26T14:30:00+00:00'], ['2022-07-26T20:00:00+00:00', '2022-07-26T22:30:00+00:00'], ['2022-07-27T20:00:00+00:00', '2022-07-27T22:30:00+00:00'], ['2022-07-28T04:00:00+00:00', '2022-07-28T06:30:00+00:00'], ['2022-07-29T02:00:00+00:00', '2022-07-29T04:30:00+00:00'], ['2022-07-29T10:00:00+00:00', '2022-07-29T12:30:00+00:00'], ['2022-07-30T10:00:00+00:00', '2022-07-30T12:30:00+00:00'], ['2022-07-30T18:00:00+00:00', '2022-07-30T20:30:00+00:00']]
```
